/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.info.QuiverInfo;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.PetLeveling;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class PlayerStats {
    public static final String HEALTH = "health";
    public static final String DEFENCE = "defence";
    public static final String STRENGTH = "strength";
    public static final String INTELLIGENCE = "intelligence";
    public static final String CRIT_CHANCE = "crit_chance";
    public static final String CRIT_DAMAGE = "crit_damage";
    public static final String BONUS_ATTACK_SPEED = "bonus_attack_speed";
    public static final String ABILITY_DAMAGE = "ability_damage";
    public static final String TRUE_DEFENSE = "true_defense";
    public static final String FEROCITY = "ferocity";
    public static final String HEALTH_REGEN = "health_regen";
    public static final String VITALITY = "vitality";
    public static final String MENDING = "mending";
    public static final String SWING_RANGE = "swing_range";
    public static final String MINING_SPEED = "mining_speed";
    public static final String MINING_FORTUNE = "mining_fortune";
    public static final String FARMING_FORTUNE = "farming_fortune";
    public static final String FORAGING_FORTUNE = "foraging_fortune";
    public static final String BREAKING_POWER = "breaking_power";
    public static final String PRISTINE = "pristine";
    public static final String WHEAT_FORTUNE = "wheat_fortune";
    public static final String CARROT_FORTUNE = "carrot_fortune";
    public static final String POTATO_FORTUNE = "potato_fortune";
    public static final String PUMPKIN_FORTUNE = "pumpkin_fortune";
    public static final String MELON_FORTUNE = "melon_fortune";
    public static final String MUSHROOM_FORTUNE = "mushroom_fortune";
    public static final String CACTUS_FORTUNE = "cactus_fortune";
    public static final String SUGAR_CANE_FORTUNE = "sugar_cane_fortune";
    public static final String NETHER_WART_FORTUNE = "nether_wart_fortune";
    public static final String COCOA_BEANS_FORTUNE = "cocoa_beans_fortune";
    public static final String COMBAT_WISDOM = "combat_wisdom";
    public static final String MINING_WISDOM = "mining_wisdom";
    public static final String FARMING_WISDOM = "farming_wisdom";
    public static final String FORAGING_WISDOM = "foraging_wisdom";
    public static final String FISHING_WISDOM = "fishing_wisdom";
    public static final String ENCHANTING_WISDOM = "enchanting_wisdom";
    public static final String ALCHEMY_WISDOM = "alchemy_wisdom";
    public static final String CARPENTRY_WISDOM = "carpentry_wisdom";
    public static final String RUNECRAFTING_WISDOM = "runecrafting_wisdom";
    public static final String SOCIAL_WISDOM = "social_wisdom";
    public static final String TAMING_WISDOM = "taming_wisdom";
    public static final String SPEED = "speed";
    public static final String MAGIC_FIND = "magic_find";
    public static final String PET_LUCK = "pet_luck";
    public static final String SEA_CREATURE_CHANCE = "sea_creature_chance";
    public static final String DOUBLE_HOOK_CHANCE = "double_hook_chance";
    public static final String FISHING_SPEED = "fishing_speed";
    public static final String COLD_RESISTANCE = "cold_resistance";
    public static final String BONUS_PEST_CHANCE = "bonus_pest_chance";
    public static final String[] defaultStatNames = new String[]{"health", "defence", "strength", "intelligence", "crit_chance", "crit_damage", "bonus_attack_speed", "ability_damage", "true_defense", "ferocity", "health_regen", "vitality", "mending", "swing_range", "mining_speed", "mining_fortune", "farming_fortune", "foraging_fortune", "breaking_power", "pristine", "wheat_fortune", "carrot_fortune", "potato_fortune", "pumpkin_fortune", "melon_fortune", "mushroom_fortune", "cactus_fortune", "sugar_cane_fortune", "nether_wart_fortune", "cocoa_beans_fortune", "combat_wisdom", "mining_wisdom", "farming_wisdom", "foraging_wisdom", "fishing_wisdom", "enchanting_wisdom", "alchemy_wisdom", "carpentry_wisdom", "runecrafting_wisdom", "social_wisdom", "taming_wisdom", "speed", "magic_find", "pet_luck", "sea_creature_chance", "double_hook_chance", "fishing_speed", "cold_resistance", "bonus_pest_chance"};
    public static final String[] defaultStatNamesPretty = new String[]{EnumChatFormatting.RED + "\u2764 Health", EnumChatFormatting.GREEN + "\u2748 Defence", EnumChatFormatting.RED + "\u2741 Strength", EnumChatFormatting.AQUA + "\u270e Intelligence", EnumChatFormatting.BLUE + "\u2623 Crit Chance", EnumChatFormatting.BLUE + "\u2620 Crit Damage", EnumChatFormatting.YELLOW + "\u2694 Bonus Attack Speed", EnumChatFormatting.RED + "\u0e51 Ability Damage", EnumChatFormatting.WHITE + "\u2742 True Defense", EnumChatFormatting.RED + "\u2afd Ferocity", EnumChatFormatting.RED + "\u2763 Health Regen", EnumChatFormatting.DARK_RED + "\u2668 Vitality", EnumChatFormatting.GREEN + "\u2604 Mending", EnumChatFormatting.YELLOW + "\u24c8 Swing Range", EnumChatFormatting.GOLD + "\u2e15 Mining Speed", EnumChatFormatting.GOLD + "\u2618 Mining Fortune", EnumChatFormatting.GOLD + "\u2618 Farming Fortune", EnumChatFormatting.GOLD + "\u2618 Foraging Fortune", EnumChatFormatting.DARK_GREEN + "\u24c5 Breaking Power", EnumChatFormatting.DARK_PURPLE + "\u2727 Pristine", EnumChatFormatting.GOLD + "\u2618 Wheat Fortune", EnumChatFormatting.GOLD + "\u2618 Carrot Fortune", EnumChatFormatting.GOLD + "\u2618 Potato Fortune", EnumChatFormatting.GOLD + "\u2618 Pumpkin Fortune", EnumChatFormatting.GOLD + "\u2618 Melon Fortune", EnumChatFormatting.GOLD + "\u2618 Mushroom Fortune", EnumChatFormatting.GOLD + "\u2618 Cactus Fortune", EnumChatFormatting.GOLD + "\u2618 Sugar Cane Fortune", EnumChatFormatting.GOLD + "\u2618 Nether Wart Fortune", EnumChatFormatting.GOLD + "\u2618 Cocoa Beans Fortune", EnumChatFormatting.DARK_AQUA + "\u262f Combat Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Mining Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Farming Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Foraging Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Fishing Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Enchanting Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Alchemy Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Carpentry Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Runecrafting Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Social Wisdom", EnumChatFormatting.DARK_AQUA + "\u262f Taming Wisdom", EnumChatFormatting.WHITE + "\u2726 Speed", EnumChatFormatting.AQUA + "\u272f Magic Find", EnumChatFormatting.LIGHT_PURPLE + "\u2663 Pet Luck", EnumChatFormatting.DARK_AQUA + "\u03b1 Sea Creature Chance", EnumChatFormatting.BLUE + "\u2693 Double Hook Chance", EnumChatFormatting.AQUA + "\u2602 Fishing Speed", EnumChatFormatting.AQUA + "\u2744 Cold Resistance", EnumChatFormatting.DARK_GREEN + "\u0d60 Bonus Pest Chance"};
    public static final HashMap<String, Pattern> STAT_PATTERN_MAP = new HashMap<String, Pattern>(){
        {
            this.put(PlayerStats.HEALTH, Pattern.compile("^Health: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.DEFENCE, Pattern.compile("^Defence: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.STRENGTH, Pattern.compile("^Strength: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.INTELLIGENCE, Pattern.compile("^Intelligence: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.CRIT_CHANCE, Pattern.compile("^Crit Chance: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.CRIT_DAMAGE, Pattern.compile("^Crit Damage: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.BONUS_ATTACK_SPEED, Pattern.compile("^Bonus Attack Speed: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.ABILITY_DAMAGE, Pattern.compile("^Ability Damage: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.TRUE_DEFENSE, Pattern.compile("^True Defense: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.FEROCITY, Pattern.compile("^Ferocity: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.HEALTH_REGEN, Pattern.compile("^Health Regen: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.VITALITY, Pattern.compile("^Vitality: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.MENDING, Pattern.compile("^Mending: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.SWING_RANGE, Pattern.compile("^Swing Range: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.MINING_SPEED, Pattern.compile("^Mining Speed: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.MINING_FORTUNE, Pattern.compile("^Mining Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.FARMING_FORTUNE, Pattern.compile("^Farming Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.FORAGING_FORTUNE, Pattern.compile("^Foraging Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.BREAKING_POWER, Pattern.compile("^Breaking Power: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.PRISTINE, Pattern.compile("^Pristine: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.WHEAT_FORTUNE, Pattern.compile("^Wheat Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.CARROT_FORTUNE, Pattern.compile("^Carrot Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.POTATO_FORTUNE, Pattern.compile("^Potato Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.PUMPKIN_FORTUNE, Pattern.compile("^Pumpkin Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.MELON_FORTUNE, Pattern.compile("^Melon Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.MUSHROOM_FORTUNE, Pattern.compile("^Mushroom Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.CACTUS_FORTUNE, Pattern.compile("^Cactus Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.SUGAR_CANE_FORTUNE, Pattern.compile("^Sugar Cane Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.NETHER_WART_FORTUNE, Pattern.compile("^Nether Wart Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.COCOA_BEANS_FORTUNE, Pattern.compile("^Cocoa Beans Fortune: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.COMBAT_WISDOM, Pattern.compile("^Combat Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.MINING_WISDOM, Pattern.compile("^Mining Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.FARMING_WISDOM, Pattern.compile("^Farming Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.FORAGING_WISDOM, Pattern.compile("^Foraging Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.FISHING_WISDOM, Pattern.compile("^Fishing Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.ENCHANTING_WISDOM, Pattern.compile("^Enchanting Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.ALCHEMY_WISDOM, Pattern.compile("^Alchemy Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.CARPENTRY_WISDOM, Pattern.compile("^Carpentry Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.RUNECRAFTING_WISDOM, Pattern.compile("^Runecrafting Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.SOCIAL_WISDOM, Pattern.compile("^Social Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.TAMING_WISDOM, Pattern.compile("^Taming Wisdom: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.SPEED, Pattern.compile("^Speed: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.MAGIC_FIND, Pattern.compile("^Magic Find: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.PET_LUCK, Pattern.compile("^Pet Luck: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.SEA_CREATURE_CHANCE, Pattern.compile("^Sea Creature Chance: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.DOUBLE_HOOK_CHANCE, Pattern.compile("^Double Hook Chance: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.FISHING_SPEED, Pattern.compile("^Fishing Speed: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.COLD_RESISTANCE, Pattern.compile("^Cold Resistance: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
            this.put(PlayerStats.BONUS_PEST_CHANCE, Pattern.compile("^Bonus Pest Chance: ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?"));
        }
    };
    public static final String STAT_PATTERN_END = ": ((?:\\+|-)([0-9]+(\\.[0-9]+)?))%?";

    public static Stats getBaseStats() {
        JsonObject misc = Constants.MISC;
        if (misc == null) {
            return null;
        }
        Stats stats = new Stats(new Stats[0]);
        for (String statName : defaultStatNames) {
            stats.addStat(statName, Utils.getElementAsFloat(Utils.getElement(misc, "base_stats." + statName), 0.0f));
        }
        return stats;
    }

    private static Stats getFairyBonus(int fairyExchanges) {
        Stats bonus = new Stats(new Stats[0]);
        bonus.addStat(SPEED, fairyExchanges / 10);
        for (int i = 0; i < fairyExchanges; ++i) {
            bonus.addStat(STRENGTH, (i + 1) % 5 == 0 ? 2.0f : 1.0f);
            bonus.addStat(DEFENCE, (i + 1) % 5 == 0 ? 2.0f : 1.0f);
            bonus.addStat(HEALTH, 3 + i / 2);
        }
        return bonus;
    }

    private static Stats getSkillBonus(Map<String, ProfileViewer.Level> skyblockInfo) {
        JsonObject bonuses = Constants.BONUSES;
        if (bonuses == null) {
            return null;
        }
        Stats skillBonus = new Stats(new Stats[0]);
        for (Map.Entry<String, ProfileViewer.Level> entry : skyblockInfo.entrySet()) {
            JsonElement element = Utils.getElement(bonuses, "bonus_stats." + entry.getKey());
            if (element == null || !element.isJsonObject()) continue;
            JsonObject skillStatMap = element.getAsJsonObject();
            Stats currentBonus = new Stats(new Stats[0]);
            int i = 1;
            while ((float)i <= entry.getValue().level) {
                if (skillStatMap.has("" + i)) {
                    currentBonus = new Stats(new Stats[0]);
                    for (Map.Entry<String, JsonElement> entry2 : skillStatMap.get("" + i).getAsJsonObject().entrySet()) {
                        currentBonus.addStat(entry2.getKey(), entry2.getValue().getAsFloat());
                    }
                }
                skillBonus.add(currentBonus);
                ++i;
            }
        }
        return skillBonus;
    }

    public static int getPetScore(JsonObject profile) {
        JsonObject bonuses = Constants.BONUSES;
        if (bonuses == null) {
            Utils.showOutdatedRepoNotification("bonuses.json");
            return 0;
        }
        JsonElement petsElement = Utils.getElement(profile, "pets");
        if (petsElement == null) {
            return 0;
        }
        JsonArray pets = petsElement.getAsJsonArray();
        HashMap<String, String> highestRarityMap = new HashMap<String, String>();
        for (int i = 0; i < pets.size(); ++i) {
            JsonObject pet = pets.get(i).getAsJsonObject();
            highestRarityMap.put(pet.get("type").getAsString(), pet.get("tier").getAsString());
        }
        int petScore = 0;
        for (String value : highestRarityMap.values()) {
            petScore = (int)((float)petScore + Utils.getElementAsFloat(Utils.getElement(bonuses, "pet_value." + value.toUpperCase(Locale.ROOT)), 0.0f));
        }
        return petScore;
    }

    private static Stats getTamingBonus(JsonObject profile) {
        JsonObject bonuses = Constants.BONUSES;
        if (bonuses == null) {
            return null;
        }
        JsonElement petRewardsElement = Utils.getElement(bonuses, "pet_rewards");
        if (petRewardsElement == null) {
            return null;
        }
        JsonObject petRewards = petRewardsElement.getAsJsonObject();
        int petScore = PlayerStats.getPetScore(profile);
        Stats petBonus = new Stats(new Stats[0]);
        for (int i = 0; i <= petScore; ++i) {
            if (!petRewards.has("" + i)) continue;
            petBonus = new Stats(new Stats[0]);
            for (Map.Entry<String, JsonElement> entry : petRewards.get("" + i).getAsJsonObject().entrySet()) {
                petBonus.addStat(entry.getKey(), entry.getValue().getAsFloat());
            }
        }
        return petBonus;
    }

    private static float harpBonus(JsonObject profile) {
        String talk_to_melody = Utils.getElementAsString(Utils.getElement(profile, "objectives.talk_to_melody.status"), "INCOMPLETE");
        if (talk_to_melody.equalsIgnoreCase("COMPLETE")) {
            return 26.0f;
        }
        return 0.0f;
    }

    private static float hotmFortune(JsonObject profile, Map<String, ProfileViewer.Level> skyblockInfo) {
        int miningLevelFortune = (int)(4.0f * (float)Math.floor(skyblockInfo.get((Object)"mining").level));
        int miningFortuneStat = Utils.getElementAsInt(Utils.getElement(profile, "mining_core.nodes.mining_fortune"), 0) * 5;
        int miningFortune2Stat = Utils.getElementAsInt(Utils.getElement(profile, "mining_core.nodes.mining_fortune_2"), 0) * 5;
        return miningFortuneStat + miningFortune2Stat + miningLevelFortune;
    }

    private static float hotmSpeed(JsonObject profile) {
        int miningSpeedStat = Utils.getElementAsInt(Utils.getElement(profile, "mining_core.nodes.mining_speed"), 0) * 20;
        int miningSpeed2Stat = Utils.getElementAsInt(Utils.getElement(profile, "mining_core.nodes.mining_speed_2"), 0) * 40;
        return miningSpeedStat + miningSpeed2Stat;
    }

    public static Stats getPassiveBonuses(Map<String, ProfileViewer.Level> skyblockInfo, JsonObject profile) {
        Stats passiveBonuses = new Stats(new Stats[0]);
        Stats fairyBonus = PlayerStats.getFairyBonus((int)Utils.getElementAsFloat(Utils.getElement(profile, "fairy_soul.fairy_exchanges"), 0.0f));
        Stats skillBonus = PlayerStats.getSkillBonus(skyblockInfo);
        Stats petBonus = PlayerStats.getTamingBonus(profile);
        if (skillBonus == null || petBonus == null) {
            return null;
        }
        passiveBonuses.add(fairyBonus);
        passiveBonuses.add(skillBonus);
        passiveBonuses.addStat(INTELLIGENCE, PlayerStats.harpBonus(profile));
        passiveBonuses.add(petBonus);
        return passiveBonuses;
    }

    public static Stats getHOTMBonuses(Map<String, ProfileViewer.Level> skyblockInfo, JsonObject profile) {
        Stats hotmBonuses = new Stats(new Stats[0]);
        hotmBonuses.addStat(MINING_FORTUNE, PlayerStats.hotmFortune(profile, skyblockInfo));
        hotmBonuses.addStat(MINING_SPEED, PlayerStats.hotmSpeed(profile));
        return hotmBonuses;
    }

    private static String getFullset(JsonArray armor, int ignore) {
        String fullset = null;
        for (int i = 0; i < armor.size(); ++i) {
            if (i == ignore) continue;
            JsonElement itemElement = armor.get(i);
            if (itemElement == null || !itemElement.isJsonObject()) {
                fullset = null;
                break;
            }
            JsonObject item = itemElement.getAsJsonObject();
            String internalname = item.get("internalname").getAsString();
            Object[] split = internalname.split("_");
            split[split.length - 1] = "";
            String armorname = StringUtils.join((Object[])split, (String)"_");
            if (fullset == null) {
                fullset = armorname;
                continue;
            }
            if (fullset.equalsIgnoreCase(armorname)) continue;
            fullset = null;
            break;
        }
        return fullset;
    }

    private static Stats getSetBonuses(Stats stats, Map<String, JsonArray> inventoryInfo, Map<String, ProfileViewer.Level> skyblockInfo, JsonObject profile) {
        JsonObject chestplate;
        JsonElement chestplateElement;
        JsonArray armor = inventoryInfo.get("inv_armor");
        Stats bonuses = new Stats(new Stats[0]);
        String fullset = PlayerStats.getFullset(armor, -1);
        if (fullset != null) {
            switch (fullset) {
                case "LAPIS_ARMOR_": {
                    bonuses.addStat(HEALTH, 60.0f);
                    break;
                }
                case "FAIRY_": {
                    bonuses.addStat(HEALTH, Utils.getElementAsFloat(Utils.getElement(profile, "fairy_souls_collected"), 0.0f));
                    break;
                }
                case "SPEEDSTER_": {
                    bonuses.addStat(SPEED, 20.0f);
                    break;
                }
                case "YOUNG_DRAGON_": {
                    bonuses.addStat(SPEED, 70.0f);
                    break;
                }
                case "MASTIFF_": {
                    bonuses.addStat(HEALTH, 50 * Math.round(stats.get(CRIT_DAMAGE)));
                    break;
                }
                case "ANGLER_": {
                    bonuses.addStat(HEALTH, 10.0f * (float)Math.floor(skyblockInfo.get((Object)"fishing").level));
                    bonuses.addStat(SEA_CREATURE_CHANCE, 4.0f);
                    break;
                }
                case "ARMOR_OF_MAGMA_": {
                    int bonus = (int)Math.min(200.0, Math.floor(Utils.getElementAsFloat(Utils.getElement(profile, "stats.kills_magma_cube"), 0.0f) / 10.0f));
                    bonuses.addStat(HEALTH, bonus);
                    bonuses.addStat(INTELLIGENCE, bonus);
                }
                case "OLD_DRAGON_": {
                    bonuses.addStat(HEALTH, 200.0f);
                    bonuses.addStat(DEFENCE, 40.0f);
                }
            }
        }
        if ((chestplateElement = armor.get(2)) != null && chestplateElement.isJsonObject() && (chestplate = chestplateElement.getAsJsonObject()).get("internalname").getAsString().equals("OBSIDIAN_CHESTPLATE")) {
            JsonArray inventory = inventoryInfo.get("inv_contents");
            for (int i = 0; i < inventory.size(); ++i) {
                JsonObject item;
                JsonElement itemElement = inventory.get(i);
                if (itemElement == null || !itemElement.isJsonObject() || !(item = itemElement.getAsJsonObject()).get("internalname").getAsString().equals("OBSIDIAN")) continue;
                int count = 1;
                if (item.has("count")) {
                    count = item.get("count").getAsInt();
                }
                bonuses.addStat(SPEED, count / 20);
            }
        }
        return bonuses;
    }

    private static Stats getStatForItem(String internalname, JsonObject item, JsonArray lore) {
        Stats stats = new Stats(new Stats[0]);
        for (int i = 0; i < lore.size(); ++i) {
            String line = lore.get(i).getAsString();
            for (Map.Entry<String, Pattern> entry : STAT_PATTERN_MAP.entrySet()) {
                Matcher matcher = entry.getValue().matcher(Utils.cleanColour(line));
                if (!matcher.find()) continue;
                int bonus = Integer.parseInt(matcher.group(1));
                stats.addStat(entry.getKey(), bonus);
            }
        }
        if (internalname.equals("DAY_CRYSTAL") || internalname.equals("NIGHT_CRYSTAL")) {
            stats.addStat(STRENGTH, 2.5f);
            stats.addStat(DEFENCE, 2.5f);
        }
        if (internalname.equals("NEW_YEAR_CAKE_BAG") && item.has("item_contents")) {
            JsonArray bytesArr = item.get("item_contents").getAsJsonArray();
            byte[] bytes = new byte[bytesArr.size()];
            for (int i = 0; i < bytesArr.size(); ++i) {
                bytes[i] = bytesArr.get(i).getAsByte();
            }
            try {
                NBTTagCompound contents_nbt = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
                NBTTagList items2 = contents_nbt.func_150295_c("i", 10);
                HashSet<Integer> cakes = new HashSet<Integer>();
                for (int j = 0; j < items2.func_74745_c(); ++j) {
                    NBTTagCompound ea;
                    NBTTagCompound nbt;
                    if (items2.func_150305_b(j).func_150296_c().size() <= 0 || (nbt = items2.func_150305_b(j).func_74775_l("tag")) == null || !nbt.func_150297_b("ExtraAttributes", 10) || !(ea = nbt.func_74775_l("ExtraAttributes")).func_74764_b("new_years_cake")) continue;
                    cakes.add(ea.func_74762_e("new_years_cake"));
                }
                stats.addStat(HEALTH, cakes.size());
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return stats;
            }
        }
        return stats;
    }

    private static Stats getItemBonuses(boolean talismanOnly, JsonArray ... inventories) {
        JsonObject misc = Constants.MISC;
        if (misc == null) {
            return null;
        }
        JsonElement talisman_upgrades_element = misc.get("talisman_upgrades");
        if (talisman_upgrades_element == null) {
            return null;
        }
        JsonObject talisman_upgrades = talisman_upgrades_element.getAsJsonObject();
        HashMap<String, Stats> itemBonuses = new HashMap<String, Stats>();
        for (JsonArray inventory : inventories) {
            for (int i = 0; i < inventory.size(); ++i) {
                JsonObject item;
                String internalname;
                JsonElement itemElement = inventory.get(i);
                if (itemElement == null || !itemElement.isJsonObject() || itemBonuses.containsKey(internalname = (item = itemElement.getAsJsonObject()).get("internalname").getAsString()) || talismanOnly && Utils.checkItemType(item.get("lore").getAsJsonArray(), true, "ACCESSORY", "HATCESSORY") < 0) continue;
                Stats itemBonus = PlayerStats.getStatForItem(internalname, item, item.get("lore").getAsJsonArray());
                itemBonuses.put(internalname, itemBonus);
                block2: for (Map.Entry<String, JsonElement> talisman_upgrades_item : talisman_upgrades.entrySet()) {
                    JsonArray upgrades = talisman_upgrades_item.getValue().getAsJsonArray();
                    for (int j = 0; j < upgrades.size(); ++j) {
                        String upgrade = upgrades.get(j).getAsString();
                        if (!upgrade.equals(internalname)) continue;
                        itemBonuses.put(talisman_upgrades_item.getKey(), new Stats(new Stats[0]));
                        continue block2;
                    }
                }
            }
        }
        Stats itemBonusesStats = new Stats(new Stats[0]);
        for (Stats stats : itemBonuses.values()) {
            itemBonusesStats.add(stats);
        }
        return itemBonusesStats;
    }

    public static Stats getPetStatBonuses(JsonObject petsInfo) {
        JsonObject pet;
        JsonObject petsJson = Constants.PETS;
        JsonObject petnums = Constants.PETNUMS;
        if (petsJson == null || petnums == null) {
            return new Stats(new Stats[0]);
        }
        if (petsInfo != null && petsInfo.has("active_pet") && petsInfo.get("active_pet") != null && petsInfo.get("active_pet").isJsonObject() && (pet = petsInfo.get("active_pet").getAsJsonObject()).has("type") && pet.get("type") != null && pet.has("tier") && pet.get("tier") != null && pet.has("exp") && pet.get("exp") != null) {
            String petname = pet.get("type").getAsString();
            String tier = pet.get("tier").getAsString();
            String heldItem = Utils.getElementAsString(pet.get("heldItem"), null);
            if (!petnums.has(petname)) {
                return new Stats(new Stats[0]);
            }
            String tierNum = GuiProfileViewer.RARITY_TO_NUM.get(tier);
            float exp2 = pet.get("exp").getAsFloat();
            if (tierNum == null) {
                return new Stats(new Stats[0]);
            }
            if (pet.has("heldItem") && !pet.get("heldItem").isJsonNull() && pet.get("heldItem").getAsString().equals("PET_ITEM_TIER_BOOST")) {
                tierNum = "" + (Integer.parseInt(tierNum) + 1);
            }
            PetLeveling.PetLevel levelObj = PetLeveling.getPetLevelingForPet(petname, PetInfoOverlay.Rarity.valueOf(tier)).getPetLevel(exp2);
            float level = levelObj.getCurrentLevel();
            float currentLevelRequirement = levelObj.getExpRequiredForNextLevel();
            float maxXP = levelObj.getMaxLevel();
            pet.addProperty("level", Float.valueOf(level));
            pet.addProperty("currentLevelRequirement", Float.valueOf(currentLevelRequirement));
            pet.addProperty("maxXP", Float.valueOf(maxXP));
            JsonObject petItem = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(petname + ";" + tierNum);
            if (petItem == null) {
                return new Stats(new Stats[0]);
            }
            Stats stats = new Stats(new Stats[0]);
            JsonObject petInfo = petnums.get(petname).getAsJsonObject();
            if (petInfo.has(tier)) {
                JsonObject petInfoTier = petInfo.get(tier).getAsJsonObject();
                if (petInfoTier == null || !petInfoTier.has("1") || !petInfoTier.has("100")) {
                    return new Stats(new Stats[0]);
                }
                JsonObject min2 = petInfoTier.get("1").getAsJsonObject();
                JsonObject max2 = petInfoTier.get("100").getAsJsonObject();
                float minMix = (100.0f - level) / 99.0f;
                float maxMix = (level - 1.0f) / 99.0f;
                for (Map.Entry<String, JsonElement> entry : max2.get("statNums").getAsJsonObject().entrySet()) {
                    float statMax = entry.getValue().getAsFloat();
                    float statMin = min2.get("statNums").getAsJsonObject().get(entry.getKey()).getAsFloat();
                    float val = statMin * minMix + statMax * maxMix;
                    stats.addStat(entry.getKey().toLowerCase(Locale.ROOT), (int)Math.floor(val));
                }
            }
            if (heldItem != null) {
                HashMap<String, Float> petStatBoots = GuiProfileViewer.PET_STAT_BOOSTS.get(heldItem);
                HashMap<String, Float> petStatBootsMult = GuiProfileViewer.PET_STAT_BOOSTS_MULT.get(heldItem);
                if (petStatBoots != null) {
                    for (Map.Entry<String, Float> entryBoost : petStatBoots.entrySet()) {
                        String key = entryBoost.getKey().toLowerCase(Locale.ROOT);
                        try {
                            stats.addStat(key, entryBoost.getValue().floatValue());
                        }
                        catch (Exception exception) {}
                    }
                }
                if (petStatBootsMult != null) {
                    for (Map.Entry<String, Float> entryBoost : petStatBootsMult.entrySet()) {
                        String key = entryBoost.getKey().toLowerCase(Locale.ROOT);
                        try {
                            stats.scale(key, entryBoost.getValue().floatValue());
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            return stats;
        }
        return new Stats(new Stats[0]);
    }

    private static float getStatMult(Map<String, JsonArray> inventoryInfo) {
        float mult = 1.0f;
        JsonArray armor = inventoryInfo.get("inv_armor");
        String fullset = PlayerStats.getFullset(armor, -1);
        if (fullset != null && fullset.equals("SUPERIOR_DRAGON_")) {
            mult *= 1.05f;
        }
        for (int i = 0; i < armor.size(); ++i) {
            JsonObject item;
            String reforge;
            JsonElement itemElement = armor.get(i);
            if (itemElement == null || !itemElement.isJsonObject() || !(reforge = Utils.getElementAsString(Utils.getElement(item = itemElement.getAsJsonObject(), "ExtraAttributes.modifier"), "")).equals("renowned")) continue;
            mult *= 1.01f;
        }
        return mult;
    }

    /*
     * WARNING - void declaration
     */
    private static void applyLimits(Stats stats, Map<String, JsonArray> inventoryInfo) {
        JsonArray armor = inventoryInfo.get("inv_armor");
        String fullset = PlayerStats.getFullset(armor, 3);
        if (fullset != null) {
            void var5_9;
            String string = fullset;
            int n = -1;
            switch (string.hashCode()) {
                case -1844621898: {
                    if (!string.equals("CHEAP_TUXEDO_")) break;
                    boolean bl = false;
                    break;
                }
                case -2101350992: {
                    if (!string.equals("FANCY_TUXEDO_")) break;
                    boolean bl = true;
                    break;
                }
                case 311878565: {
                    if (!string.equals("ELEGANT_TUXEDO_")) break;
                    int n2 = 2;
                }
            }
            switch (var5_9) {
                case 0: {
                    stats.statsJson.add(HEALTH, new JsonPrimitive(Float.valueOf(Math.min(75.0f, stats.get(HEALTH)))));
                }
                case 1: {
                    stats.statsJson.add(HEALTH, new JsonPrimitive(Float.valueOf(Math.min(150.0f, stats.get(HEALTH)))));
                }
                case 2: {
                    stats.statsJson.add(HEALTH, new JsonPrimitive(Float.valueOf(Math.min(250.0f, stats.get(HEALTH)))));
                }
            }
        }
        for (Map.Entry entry : stats.statsJson.entrySet()) {
            if (((String)entry.getKey()).equals(CRIT_DAMAGE) || ((String)entry.getKey()).equals(INTELLIGENCE) || ((String)entry.getKey()).equals(BONUS_ATTACK_SPEED)) continue;
            stats.statsJson.add((String)entry.getKey(), new JsonPrimitive(Float.valueOf(Math.max(0.0f, ((JsonElement)entry.getValue()).getAsFloat()))));
        }
    }

    public static Stats getStats(Map<String, ProfileViewer.Level> levelingInfo, Map<String, JsonArray> inventoryInfo, JsonObject petsInfo, JsonObject profile) {
        if (levelingInfo == null || inventoryInfo == null || profile == null) {
            return null;
        }
        JsonArray armor = inventoryInfo.get("inv_armor");
        JsonArray inventory = inventoryInfo.get("inv_contents");
        JsonArray talisman_bag = inventoryInfo.get("talisman_bag");
        Stats passiveBonuses = PlayerStats.getPassiveBonuses(levelingInfo, profile);
        Stats hotmBonuses = PlayerStats.getHOTMBonuses(levelingInfo, profile);
        Stats armorBonuses = PlayerStats.getItemBonuses(false, armor);
        Stats talismanBonuses = PlayerStats.getItemBonuses(true, inventory, talisman_bag);
        if (passiveBonuses == null || armorBonuses == null || talismanBonuses == null) {
            return null;
        }
        Stats stats = PlayerStats.getBaseStats();
        if (stats == null) {
            return null;
        }
        Stats petBonus = PlayerStats.getPetStatBonuses(petsInfo);
        stats = stats.add(passiveBonuses).add(armorBonuses).add(talismanBonuses).add(petBonus).add(hotmBonuses);
        stats.add(PlayerStats.getSetBonuses(stats, inventoryInfo, levelingInfo, profile));
        stats.scaleAll(PlayerStats.getStatMult(inventoryInfo));
        PlayerStats.applyLimits(stats, inventoryInfo);
        return stats;
    }

    @Nullable
    public static String getSelectedMagicalPower(JsonObject profileInfo2) {
        String abs2 = "accessory_bag_storage";
        if (!(profileInfo2 != null && profileInfo2.has(abs2) && profileInfo2.get(abs2).isJsonObject() && profileInfo2.get(abs2).getAsJsonObject().has("selected_power"))) {
            return null;
        }
        String selectedPower = profileInfo2.get(abs2).getAsJsonObject().get("selected_power").getAsString();
        return selectedPower.substring(0, 1).toUpperCase(Locale.ROOT) + selectedPower.substring(1);
    }

    @Nullable
    public static QuiverInfo getQuiverInfo(Map<String, JsonArray> inventoryInfo, JsonObject profileInfo2) {
        if (inventoryInfo == null || !inventoryInfo.containsKey("quiver")) {
            return null;
        }
        QuiverInfo quiverInfo = new QuiverInfo();
        quiverInfo.arrows = new HashMap<String, Integer>();
        JsonArray quiver = inventoryInfo.get("quiver");
        for (JsonElement quiverEntry : quiver) {
            JsonObject stack;
            if (quiverEntry == null || quiverEntry.isJsonNull() || !quiverEntry.isJsonObject() || !(stack = quiverEntry.getAsJsonObject()).has("internalname") || !stack.has("count")) continue;
            String internalName = stack.get("internalname").getAsString();
            int count = stack.get("count").getAsInt();
            quiverInfo.arrows.computeIfPresent(internalName, (key, existing) -> existing + count);
            quiverInfo.arrows.putIfAbsent(internalName, count);
        }
        quiverInfo.selectedArrow = Utils.getElementAsString(Utils.getElement(profileInfo2, "item_data.favorite_arrow"), null);
        return quiverInfo;
    }

    public static class Stats {
        JsonObject statsJson = new JsonObject();

        public Stats(Stats ... statses) {
            for (Stats stats : statses) {
                this.add(stats);
            }
        }

        public int size() {
            return this.statsJson.entrySet().size();
        }

        public float get(String statName) {
            if (this.statsJson.has(statName)) {
                return this.statsJson.get(statName).getAsFloat();
            }
            return 0.0f;
        }

        public Stats add(Stats stats) {
            for (Map.Entry<String, JsonElement> statEntry : stats.statsJson.entrySet()) {
                if (!statEntry.getValue().isJsonPrimitive() || !((JsonPrimitive)statEntry.getValue()).isNumber()) continue;
                if (!this.statsJson.has(statEntry.getKey())) {
                    this.statsJson.add(statEntry.getKey(), statEntry.getValue());
                    continue;
                }
                JsonPrimitive e2 = this.statsJson.get(statEntry.getKey()).getAsJsonPrimitive();
                float statNum = e2.getAsFloat() + statEntry.getValue().getAsFloat();
                this.statsJson.add(statEntry.getKey(), new JsonPrimitive(Float.valueOf(statNum)));
            }
            return this;
        }

        public void scale(String statName, float scale) {
            if (this.statsJson.has(statName)) {
                this.statsJson.add(statName, new JsonPrimitive(Float.valueOf(this.statsJson.get(statName).getAsFloat() * scale)));
            }
        }

        public void scaleAll(float scale) {
            for (Map.Entry<String, JsonElement> statEntry : this.statsJson.entrySet()) {
                this.statsJson.add(statEntry.getKey(), new JsonPrimitive(Float.valueOf(statEntry.getValue().getAsFloat() * scale)));
            }
        }

        public void addStat(String statName, float amount) {
            if (!this.statsJson.has(statName)) {
                this.statsJson.add(statName, new JsonPrimitive(Float.valueOf(amount)));
            } else {
                JsonPrimitive e2 = this.statsJson.get(statName).getAsJsonPrimitive();
                this.statsJson.add(statName, new JsonPrimitive(Float.valueOf(e2.getAsFloat() + amount)));
            }
        }
    }
}

