/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpUtils;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.overlays.TextTabOverlay;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.boss.BossStatus;

public class PowderGrindingOverlay
extends TextTabOverlay {
    private static final Pattern POWDER_PATTERN = Pattern.compile(" {4}(Mithril|Gemstone) Powder x([0-9]+(?:,\\d+)*)");
    private static final Pattern EVENT_PATTERN = Pattern.compile("PASSIVE EVENT (.+) RUNNING FOR \\d{2}:\\d{2}");
    public int chestCount = 0;
    public int openedChestCount = 0;
    public int mithrilPowderFound = 0;
    public float lastMithrilPowderFound = 0.0f;
    public float lastMithrilPowderAverage = 0.0f;
    public int gemstonePowderFound = 0;
    public float lastGemstonePowderFound = 0.0f;
    public float lastGemstonePowderAverage = 0.0f;
    public MiningEvent miningEvent = MiningEvent.UNKNOWN;
    private long lastUpdate = -1L;

    public PowderGrindingOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    private float interp(float now, float last) {
        float interp = now;
        if (last >= 0.0f && last != now) {
            float factor = (float)(System.currentTimeMillis() - this.lastUpdate) / 1000.0f;
            factor = LerpUtils.clampZeroOne(factor);
            interp = last + (now - last) * factor;
        }
        return interp;
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.mining.powderGrindingTrackerEnabled;
    }

    @Override
    public void update() {
        if (this.isEnabled()) {
            this.lastUpdate = System.currentTimeMillis();
            this.lastMithrilPowderFound = this.mithrilPowderFound;
            this.lastMithrilPowderAverage = this.openedChestCount > 0 ? 1.0f * (float)this.mithrilPowderFound / (float)this.openedChestCount : 0.0f;
            this.lastGemstonePowderFound = this.gemstonePowderFound;
            this.lastGemstonePowderAverage = this.openedChestCount > 0 ? 1.0f * (float)this.gemstonePowderFound / (float)this.openedChestCount : 0.0f;
            Matcher matcher = EVENT_PATTERN.matcher(BossStatus.field_82827_c == null ? "" : Utils.cleanColour(BossStatus.field_82827_c));
            if (matcher.matches()) {
                switch (matcher.group(1)) {
                    case "2X POWDER": {
                        this.miningEvent = MiningEvent.DOUBLE_POWDER;
                        break;
                    }
                    case "BETTER TOGETHER": {
                        this.miningEvent = MiningEvent.BETTER_TOGETHER;
                        break;
                    }
                    case "GONE WITH THE WIND": {
                        this.miningEvent = MiningEvent.GONE_WITH_THE_WIND;
                        break;
                    }
                    default: {
                        this.miningEvent = MiningEvent.UNKNOWN;
                    }
                }
            }
        } else {
            this.overlayStrings = null;
        }
    }

    @Override
    public void updateFrequent() {
        this.overlayStrings = null;
        if (!NotEnoughUpdates.INSTANCE.config.mining.powderGrindingTrackerEnabled) {
            return;
        }
        String location = SBInfo.getInstance().getLocation();
        if (location == null) {
            return;
        }
        if (location.equals("crystal_hollows")) {
            this.overlayStrings = new ArrayList();
            for (int index : NotEnoughUpdates.INSTANCE.config.mining.powderGrindingTrackerText) {
                NumberFormat format2 = NumberFormat.getIntegerInstance();
                switch (index) {
                    case 0: {
                        this.overlayStrings.add("\u00a73Chests Found: \u00a7a" + format2.format(this.chestCount));
                        break;
                    }
                    case 1: {
                        this.overlayStrings.add("\u00a73Opened Chests: \u00a7a" + format2.format(this.openedChestCount));
                        break;
                    }
                    case 2: {
                        this.overlayStrings.add("\u00a73Unopened Chests: \u00a7c" + format2.format(this.chestCount - this.openedChestCount));
                        break;
                    }
                    case 3: {
                        this.overlayStrings.add("\u00a73Mithril Powder Found: \u00a72" + format2.format(this.interp(this.mithrilPowderFound, this.lastMithrilPowderFound)));
                        break;
                    }
                    case 4: {
                        this.overlayStrings.add("\u00a73Average Mithril Powder/Chest: \u00a72" + format2.format(this.interp(this.openedChestCount > 0 ? 1.0f * (float)this.mithrilPowderFound / (float)this.openedChestCount : 0.0f, this.lastMithrilPowderAverage)));
                        break;
                    }
                    case 5: {
                        this.overlayStrings.add("\u00a73Gemstone Powder Found: \u00a7d" + format2.format(this.interp(this.gemstonePowderFound, this.lastGemstonePowderFound)));
                        break;
                    }
                    case 6: {
                        this.overlayStrings.add("\u00a73Average Gemstone Powder/Chest: \u00a7d" + format2.format(this.interp(this.openedChestCount > 0 ? 1.0f * (float)this.gemstonePowderFound / (float)this.openedChestCount : 0.0f, this.lastGemstonePowderAverage)));
                    }
                }
            }
        }
        if (this.overlayStrings != null && this.overlayStrings.isEmpty()) {
            this.overlayStrings = null;
        }
    }

    public void onMessage(String message) {
        if (message.equals("You uncovered a treasure chest!")) {
            ++this.chestCount;
        } else if (message.equals("  LOOT CHEST COLLECTED ")) {
            ++this.chestCount;
            ++this.openedChestCount;
        } else if (message.equals("  CHEST LOCKPICKED ")) {
            ++this.openedChestCount;
        } else {
            Matcher matcher = POWDER_PATTERN.matcher(message);
            if (matcher.matches()) {
                String rawNumber = matcher.group(2).replace(",", "");
                try {
                    int amount = Integer.parseInt(rawNumber);
                    String type2 = matcher.group(1);
                    if (type2.equals("Mithril")) {
                        this.mithrilPowderFound += this.miningEvent == MiningEvent.DOUBLE_POWDER ? amount * 2 : amount;
                    } else if (type2.equals("Gemstone")) {
                        this.gemstonePowderFound += this.miningEvent == MiningEvent.DOUBLE_POWDER ? amount * 2 : amount;
                    }
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public void load() {
        NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (profileSpecific == null) {
            return;
        }
        this.chestCount = profileSpecific.chestCount;
        this.openedChestCount = profileSpecific.openedChestCount;
        this.mithrilPowderFound = profileSpecific.mithrilPowderFound;
        this.gemstonePowderFound = profileSpecific.gemstonePowderFound;
    }

    public void save() {
        NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (profileSpecific == null) {
            return;
        }
        profileSpecific.chestCount = this.chestCount;
        profileSpecific.openedChestCount = this.openedChestCount;
        profileSpecific.mithrilPowderFound = this.mithrilPowderFound;
        profileSpecific.gemstonePowderFound = this.gemstonePowderFound;
    }

    public void reset() {
        this.chestCount = 0;
        this.openedChestCount = 0;
        this.mithrilPowderFound = 0;
        this.gemstonePowderFound = 0;
    }

    public static enum MiningEvent {
        UNKNOWN,
        DOUBLE_POWDER,
        BETTER_TOGETHER,
        GONE_WITH_THE_WIND;

    }
}

