/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpUtils;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.XPInformation;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class MiningSkillOverlay
extends TextOverlay {
    private long lastUpdate = -1L;
    private int compactLast = -1;
    private int compact = -1;
    private int compactTier = -1;
    private String compactTierAmount = "1";
    private float minedPerSecondLast = 0.0f;
    private float minedPerSecond = 0.0f;
    private final LinkedList<Integer> compactQueue = new LinkedList();
    private XPInformation.SkillInfo skillInfo = null;
    private XPInformation.SkillInfo skillInfoLast = null;
    private float lastTotalXp = -1.0f;
    private boolean isMining = false;
    private final LinkedList<Float> xpGainQueue = new LinkedList();
    private float xpGainHourLast = -1.0f;
    private float xpGainHour = -1.0f;
    private int xpGainTimer = 0;
    private final String skillType = "Mining";

    public MiningSkillOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    private float interp(float now, float last) {
        float interp = now;
        if (last >= 0.0f && last != now) {
            float factor = (float)(System.currentTimeMillis() - this.lastUpdate) / 1000.0f;
            factor = LerpUtils.clampZeroOne(factor);
            interp = last + (now - last) * factor;
        }
        return interp;
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.skillOverlays.miningSkillOverlay;
    }

    @Override
    public void update() {
        NBTTagCompound ea;
        NBTTagCompound tag;
        if (!this.isEnabled()) {
            this.compact = -1;
            this.overlayStrings = null;
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        this.compactLast = this.compact;
        this.xpGainHourLast = this.xpGainHour;
        this.compact = -1;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (stack != null && stack.func_77942_o() && (tag = stack.func_77978_p()).func_150297_b("ExtraAttributes", 10) && (ea = tag.func_74775_l("ExtraAttributes")).func_150297_b("compact_blocks", 99)) {
            this.compact = ea.func_74762_e("compact_blocks");
            this.compactQueue.add(0, this.compact);
        }
        if (this.compact < 100) {
            this.compactTier = 1;
        } else if (this.compact < 500) {
            this.compactTier = 2;
        } else if (this.compact < 1500) {
            this.compactTier = 3;
        } else if (this.compact < 5000) {
            this.compactTier = 4;
        } else if (this.compact < 15000) {
            this.compactTier = 5;
        } else if (this.compact < 50000) {
            this.compactTier = 6;
        } else if (this.compact < 150000) {
            this.compactTier = 7;
        } else if (this.compact < 500000) {
            this.compactTier = 8;
        } else if (this.compact < 1000000) {
            this.compactTier = 9;
        } else if (this.compact > 1000000) {
            this.compactTier = 10;
        }
        switch (this.compactTier) {
            case 1: {
                this.compactTierAmount = "100";
                break;
            }
            case 2: {
                this.compactTierAmount = "500";
                break;
            }
            case 3: {
                this.compactTierAmount = "1,500";
                break;
            }
            case 4: {
                this.compactTierAmount = "5,000";
                break;
            }
            case 5: {
                this.compactTierAmount = "15,000";
                break;
            }
            case 6: {
                this.compactTierAmount = "50,000";
                break;
            }
            case 7: {
                this.compactTierAmount = "150,000";
                break;
            }
            case 8: {
                this.compactTierAmount = "500,000";
                break;
            }
            case 9: {
                this.compactTierAmount = "1,000,000";
                break;
            }
            case 10: {
                this.compactTierAmount = "Maxed";
            }
        }
        String internalname = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(stack);
        this.skillInfoLast = this.skillInfo;
        List<Integer> s = NotEnoughUpdates.INSTANCE.config.skillOverlays.miningText;
        this.skillInfo = XPInformation.getInstance().getSkillInfo("Mining", s.contains(2) || s.contains(3) || s.contains(4) || s.contains(5) || s.contains(7));
        if (this.skillInfo != null) {
            float totalXp = (float)this.skillInfo.totalXp;
            if (this.lastTotalXp > 0.0f) {
                float f;
                Iterator iterator;
                float totalGain;
                float delta = totalXp - this.lastTotalXp;
                if (delta > 0.0f && delta < 1000.0f) {
                    this.xpGainTimer = NotEnoughUpdates.INSTANCE.config.skillOverlays.miningPauseTimer;
                    this.xpGainQueue.add(0, Float.valueOf(delta));
                    while (this.xpGainQueue.size() > 30) {
                        this.xpGainQueue.removeLast();
                    }
                    totalGain = 0.0f;
                    iterator = this.xpGainQueue.iterator();
                    while (iterator.hasNext()) {
                        f = ((Float)iterator.next()).floatValue();
                        totalGain += f;
                    }
                    this.xpGainHour = totalGain * 3600.0f / (float)this.xpGainQueue.size();
                    this.isMining = true;
                } else if (this.xpGainTimer > 0) {
                    --this.xpGainTimer;
                    this.xpGainQueue.add(0, Float.valueOf(0.0f));
                    while (this.xpGainQueue.size() > 30) {
                        this.xpGainQueue.removeLast();
                    }
                    totalGain = 0.0f;
                    iterator = this.xpGainQueue.iterator();
                    while (iterator.hasNext()) {
                        f = ((Float)iterator.next()).floatValue();
                        totalGain += f;
                    }
                    this.xpGainHour = totalGain * 3600.0f / (float)this.xpGainQueue.size();
                    this.isMining = true;
                } else if (delta <= 0.0f) {
                    this.isMining = false;
                }
            }
            this.lastTotalXp = totalXp;
        }
        while (this.compactQueue.size() >= 4) {
            this.compactQueue.removeLast();
        }
        if (this.compactQueue.isEmpty()) {
            this.minedPerSecond = -1.0f;
            this.minedPerSecondLast = 0.0f;
        } else {
            this.minedPerSecondLast = this.minedPerSecond;
            int last = this.compactQueue.getLast();
            int first = this.compactQueue.getFirst();
            this.minedPerSecond = (float)(first - last) / 3.0f;
        }
        this.overlayStrings = this.compact != -1 ? new ArrayList() : null;
    }

    @Override
    public void updateFrequent() {
        super.updateFrequent();
        if (this.compact < 0) {
            this.overlayStrings = null;
        } else {
            int counterInterp;
            HashMap<Integer, String> lineMap = new HashMap<Integer, String>();
            this.overlayStrings = new ArrayList();
            NumberFormat format2 = NumberFormat.getIntegerInstance();
            if (this.compact >= 0) {
                counterInterp = (int)this.interp(this.compact, this.compactLast);
                lineMap.put(0, EnumChatFormatting.AQUA + "Compact: " + EnumChatFormatting.YELLOW + format2.format(counterInterp));
            }
            if (this.compact >= 0) {
                if (this.minedPerSecondLast == this.minedPerSecond && this.minedPerSecond <= 0.0f) {
                    lineMap.put(1, EnumChatFormatting.AQUA + "Blocks/m: " + EnumChatFormatting.YELLOW + "N/A");
                } else {
                    float cpsInterp = this.interp(this.minedPerSecond, this.minedPerSecondLast);
                    lineMap.put(1, EnumChatFormatting.AQUA + "Blocks/m: " + EnumChatFormatting.YELLOW + String.format("%,.2f", Float.valueOf(cpsInterp * 60.0f)));
                }
            }
            if (this.compactTier <= 9) {
                counterInterp = (int)this.interp(this.compact, this.compactLast);
                lineMap.put(8, EnumChatFormatting.AQUA + "Compact Progress: " + EnumChatFormatting.YELLOW + format2.format(counterInterp) + "/" + this.compactTierAmount);
            }
            if (this.compactTier == 10) {
                lineMap.put(8, EnumChatFormatting.AQUA + "Compact Progress: " + EnumChatFormatting.RED + this.compactTierAmount);
            }
            float xpInterp = this.xpGainHour;
            if (this.xpGainHourLast == this.xpGainHour && this.xpGainHour <= 0.0f) {
                lineMap.put(5, EnumChatFormatting.AQUA + "XP/h: " + EnumChatFormatting.YELLOW + "N/A");
            } else {
                xpInterp = this.interp(this.xpGainHour, this.xpGainHourLast);
                lineMap.put(5, EnumChatFormatting.AQUA + "XP/h: " + EnumChatFormatting.YELLOW + format2.format(xpInterp) + (this.isMining ? "" : EnumChatFormatting.RED + " (PAUSED)"));
            }
            if (this.skillInfo != null && this.skillInfo.level < 60) {
                StringBuilder levelStr = new StringBuilder(EnumChatFormatting.AQUA + "Mining: ");
                levelStr.append(EnumChatFormatting.YELLOW).append(this.skillInfo.level).append(EnumChatFormatting.GRAY).append(" [");
                float progress = (float)(this.skillInfo.currentXp / this.skillInfo.currentXpMax);
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    progress = this.interp(progress, (float)(this.skillInfoLast.currentXp / this.skillInfoLast.currentXpMax));
                }
                float lines = 25.0f;
                int i = 0;
                while ((float)i < lines) {
                    if ((float)i / lines < progress) {
                        levelStr.append(EnumChatFormatting.YELLOW);
                    } else {
                        levelStr.append(EnumChatFormatting.DARK_GRAY);
                    }
                    levelStr.append('|');
                    ++i;
                }
                levelStr.append(EnumChatFormatting.GRAY).append("] ").append(EnumChatFormatting.YELLOW).append((int)(progress * 100.0f)).append("%");
                int current = (int)this.skillInfo.currentXp;
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    current = (int)this.interp(current, (float)this.skillInfoLast.currentXp);
                }
                int remaining = (int)(this.skillInfo.currentXpMax - this.skillInfo.currentXp);
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    remaining = (int)this.interp(remaining, (int)(this.skillInfoLast.currentXpMax - this.skillInfoLast.currentXp));
                }
                lineMap.put(2, levelStr.toString());
                lineMap.put(3, EnumChatFormatting.AQUA + "Current XP: " + EnumChatFormatting.YELLOW + format2.format(current));
                if (remaining < 0) {
                    lineMap.put(4, EnumChatFormatting.AQUA + "Remaining XP: " + EnumChatFormatting.YELLOW + "MAXED!");
                    lineMap.put(7, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + "MAXED!");
                } else {
                    lineMap.put(4, EnumChatFormatting.AQUA + "Remaining XP: " + EnumChatFormatting.YELLOW + format2.format(remaining));
                    if (this.xpGainHour < 1000.0f) {
                        lineMap.put(7, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + "N/A");
                    } else {
                        lineMap.put(7, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + Utils.prettyTime((long)remaining * 1000L * 60L * 60L / (long)xpInterp));
                    }
                }
            }
            if (this.skillInfo != null && this.skillInfo.level == 60) {
                int current = (int)this.skillInfo.currentXp;
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    current = (int)this.interp(current, (float)this.skillInfoLast.currentXp);
                }
                lineMap.put(2, EnumChatFormatting.AQUA + "Mining: " + EnumChatFormatting.YELLOW + "60 " + EnumChatFormatting.RED + "(Maxed)");
                lineMap.put(3, EnumChatFormatting.AQUA + "Current XP: " + EnumChatFormatting.YELLOW + format2.format(current));
            }
            float yaw = Minecraft.func_71410_x().field_71439_g.field_70759_as;
            if ((yaw %= 360.0f) < 0.0f) {
                yaw += 360.0f;
            }
            if (yaw > 180.0f) {
                yaw -= 360.0f;
            }
            lineMap.put(6, EnumChatFormatting.AQUA + "Yaw: " + EnumChatFormatting.YELLOW + String.format("%.2f", Float.valueOf(yaw)) + EnumChatFormatting.BOLD + "\u1d52");
            for (int strIndex : NotEnoughUpdates.INSTANCE.config.skillOverlays.miningText) {
                if (lineMap.get(strIndex) == null) continue;
                this.overlayStrings.add(lineMap.get(strIndex));
            }
            if (this.overlayStrings != null && this.overlayStrings.isEmpty()) {
                this.overlayStrings = null;
            }
        }
    }
}

