/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.ButtonExclusionZoneEvent;
import io.github.moulberry.notenoughupdates.events.GuiInventoryBackgroundDrawnEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.miscgui.GuiInvButtonEditor;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class EquipmentOverlay {
    public static EquipmentOverlay INSTANCE = new EquipmentOverlay();
    private static final ResourceLocation ARMOR_DISPLAY = new ResourceLocation("notenoughupdates:armordisplay/armordisplay.png");
    private static final ResourceLocation ARMOR_DISPLAY_GREY = new ResourceLocation("notenoughupdates:armordisplay/armordisplay_grey.png");
    private static final ResourceLocation ARMOR_DISPLAY_DARK = new ResourceLocation("notenoughupdates:armordisplay/armordisplay_phq_dark.png");
    private static final ResourceLocation ARMOR_DISPLAY_FSR = new ResourceLocation("notenoughupdates:armordisplay/armordisplay_fsr.png");
    private static final ResourceLocation ARMOR_DISPLAY_TRANSPARENT = new ResourceLocation("notenoughupdates:armordisplay/armordisplay_transparent.png");
    private static final ResourceLocation ARMOR_DISPLAY_TRANSPARENT_PET = new ResourceLocation("notenoughupdates:armordisplay/armordisplay_transparent_pet.png");
    private static final ResourceLocation QUESTION_MARK = new ResourceLocation("notenoughupdates:pv_unknown.png");
    private static final ResourceLocation PET_DISPLAY = new ResourceLocation("notenoughupdates:petdisplay/petdisplaysolo.png");
    private static final ResourceLocation PET_DISPLAY_GREY = new ResourceLocation("notenoughupdates:petdisplay/petdisplaysolo_dark.png");
    private static final ResourceLocation PET_DISPLAY_DARK = new ResourceLocation("notenoughupdates:petdisplay/petdisplaysolo_phqdark.png");
    private static final ResourceLocation PET_DISPLAY_FSR = new ResourceLocation("notenoughupdates:petdisplay/petdisplaysolo_fsr.png");
    private static final ResourceLocation PET_DISPLAY_TRANSPARENT = new ResourceLocation("notenoughupdates:petdisplay/petdisplaysolo_transparent.png");
    private static final ResourceLocation PET_ARMOR_DISPLAY = new ResourceLocation("notenoughupdates:petdisplay/petdisplayarmor.png");
    private static final ResourceLocation PET_ARMOR_DISPLAY_GREY = new ResourceLocation("notenoughupdates:petdisplay/petdisplayarmor_dark.png");
    private static final ResourceLocation PET_ARMOR_DISPLAY_DARK = new ResourceLocation("notenoughupdates:petdisplay/petdisplayarmor_phqdark.png");
    private static final ResourceLocation PET_ARMOR_DISPLAY_FSR = new ResourceLocation("notenoughupdates:petdisplay/petdisplayarmor_fsr.png");
    private static final ResourceLocation PET_ARMOR_DISPLAY_TRANSPARENT = new ResourceLocation("notenoughupdates:petdisplay/petdisplayarmor_transparent.png");
    public static final int EQUIPMENT_SLOT_OFFSET_Y = 8;
    public static final int ARMOR_OVERLAY_OVERHAND_WIDTH = 24;
    public static final int ARMOR_OVERLAY_HEIGHT = 86;
    public static final int ARMOR_OVERLAY_WIDTH = 31;
    static final int PET_OVERLAY_HEIGHT = 32;
    static final int PET_OVERLAY_WIDTH = 31;
    public static final int PET_OVERLAY_OFFSET_Y = 72;
    public boolean shouldRenderPets;
    public boolean shouldRenderArmorHud;
    public ItemStack petStack;
    private Map<String, Map<Integer, ItemStack>> profileCache = new HashMap<String, Map<Integer, ItemStack>>();
    private final Map<ItemStack, Integer> itemsToAdd = new HashMap<ItemStack, Integer>();
    private boolean wardrobeOpen = false;
    public ItemStack slot1 = null;
    public ItemStack slot2 = null;
    public ItemStack slot3 = null;
    public ItemStack slot4 = null;
    private String lastProfile;

    public ResourceLocation getCustomEquipmentTexture(boolean isPetRendering) {
        switch (NotEnoughUpdates.INSTANCE.config.customArmour.colourStyle) {
            case 0: {
                return ARMOR_DISPLAY;
            }
            case 1: {
                return ARMOR_DISPLAY_GREY;
            }
            case 2: {
                return ARMOR_DISPLAY_DARK;
            }
            case 3: {
                return NotEnoughUpdates.INSTANCE.config.petOverlay.colourStyle == 3 && isPetRendering ? ARMOR_DISPLAY_TRANSPARENT_PET : ARMOR_DISPLAY_TRANSPARENT;
            }
            case 4: {
                return ARMOR_DISPLAY_FSR;
            }
        }
        return null;
    }

    public ResourceLocation getCustomPetTexture(boolean isArmorRendering) {
        switch (NotEnoughUpdates.INSTANCE.config.petOverlay.colourStyle) {
            case 0: {
                return isArmorRendering ? PET_ARMOR_DISPLAY : PET_DISPLAY;
            }
            case 1: {
                return isArmorRendering ? PET_ARMOR_DISPLAY_GREY : PET_DISPLAY_GREY;
            }
            case 2: {
                return isArmorRendering ? PET_ARMOR_DISPLAY_DARK : PET_DISPLAY_DARK;
            }
            case 3: {
                return isArmorRendering ? PET_ARMOR_DISPLAY_TRANSPARENT : PET_DISPLAY_TRANSPARENT;
            }
            case 4: {
                return isArmorRendering ? PET_ARMOR_DISPLAY_FSR : PET_DISPLAY_FSR;
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onButtonExclusionZones(ButtonExclusionZoneEvent event) {
        if (EquipmentOverlay.isRenderingArmorHud()) {
            event.blockArea(new Rectangle(event.getGuiBaseRect().getRight() - 200, event.getGuiBaseRect().getTop(), 50, 84), ButtonExclusionZoneEvent.PushDirection.TOWARDS_LEFT);
        }
        if (EquipmentOverlay.isRenderingPetHud()) {
            event.blockArea(new Rectangle(event.getGuiBaseRect().getRight() - 200, event.getGuiBaseRect().getTop() + 60, 50, 60), ButtonExclusionZoneEvent.PushDirection.TOWARDS_LEFT);
        }
    }

    @SubscribeEvent
    public void onGuiTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.side != Side.CLIENT) {
            return;
        }
        this.updateGuiInfo(Minecraft.func_71410_x().field_71462_r);
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent event) {
        this.updateGuiInfo(event.gui);
    }

    @SubscribeEvent
    public void onRenderGuiPost(GuiInventoryBackgroundDrawnEvent event) {
        if (!(event.getContainer() instanceof GuiInventory)) {
            return;
        }
        GuiInventory inventory = (GuiInventory)event.getContainer();
        this.renderGuis(inventory);
    }

    public void renderGuis(GuiInventory inventory) {
        int width = Utils.peekGuiScale().func_78326_a();
        int height = Utils.peekGuiScale().func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        this.renderHudBackground((GuiScreen)inventory);
        if (this.shouldRenderArmorHud) {
            this.renderEquipmentGui(inventory, mouseX, mouseY, width, height);
        }
        if (this.shouldRenderPets) {
            this.renderPets(inventory, mouseX, mouseY, width, height);
        }
    }

    public void renderHudBackground(GuiScreen inventory) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AccessorGuiContainer container = (AccessorGuiContainer)inventory;
        int overlayLeft = container.getGuiLeft() - 24;
        int overlayTop = container.getGuiTop();
        if (this.shouldRenderArmorHud) {
            ResourceLocation equipmentTexture = this.getCustomEquipmentTexture(this.shouldRenderPets);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(equipmentTexture);
            Utils.drawTexturedRect(overlayLeft, overlayTop, 31.0f, 86.0f, 9728);
        }
        if (this.shouldRenderPets) {
            ResourceLocation customPetTexture = this.getCustomPetTexture(this.shouldRenderArmorHud);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(customPetTexture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(overlayLeft, overlayTop + 72, 31.0f, 32.0f, 9728);
        }
        GlStateManager.func_179144_i((int)0);
    }

    public void renderEquipmentGui(GuiInventory guiScreen, int mouseX, int mouseY, int width, int height) {
        AccessorGuiContainer container = (AccessorGuiContainer)guiScreen;
        int overlayLeft = container.getGuiLeft() - 24;
        int overlayTop = container.getGuiTop();
        ArrayList tooltipToDisplay = new ArrayList();
        this.drawSlot(this.slot1, overlayLeft + 8, overlayTop + 8, mouseX, mouseY, tooltipToDisplay);
        this.drawSlot(this.slot2, overlayLeft + 8, overlayTop + 8 + 18, mouseX, mouseY, tooltipToDisplay);
        this.drawSlot(this.slot3, overlayLeft + 8, overlayTop + 8 + 36, mouseX, mouseY, tooltipToDisplay);
        this.drawSlot(this.slot4, overlayLeft + 8, overlayTop + 8 + 54, mouseX, mouseY, tooltipToDisplay);
        if (this.slot1 == null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(QUESTION_MARK);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < 4; ++i) {
                Utils.drawTexturedRect(overlayLeft + 8, overlayTop + 8 + 18 * i, 16.0f, 16.0f, 9728);
            }
            tooltipToDisplay = Lists.newArrayList((Object[])new String[]{EnumChatFormatting.RED + "Warning", EnumChatFormatting.GREEN + "You need to open /equipment", EnumChatFormatting.GREEN + "to cache your armour"});
            if (Utils.isWithinRect(mouseX, mouseY, overlayLeft + 8, overlayTop + 8, 16, 70) && NotEnoughUpdates.INSTANCE.config.customArmour.sendWardrobeCommand && Mouse.getEventButtonState() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null) {
                NotEnoughUpdates.INSTANCE.trySendCommand("/equipment");
            }
        }
        if (!tooltipToDisplay.isEmpty() && Utils.isWithinRect(mouseX, mouseY, overlayLeft, overlayTop, 24, 86)) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX - this.calculateTooltipXOffset(tooltipToDisplay), mouseY, width, height, -1);
        }
    }

    private ItemStack getRepoPetStack() {
        NEUManager manager = NotEnoughUpdates.INSTANCE.manager;
        PetInfoOverlay.Pet currentPet = PetInfoOverlay.getCurrentPet();
        if (currentPet == null) {
            return null;
        }
        ItemStack item = ItemUtils.createPetItemstackFromPetInfo(currentPet);
        if ((item = ItemUtils.petToolTipXPExtendPetOverlay(item)) != null) {
            return item;
        }
        item = manager.createItem(currentPet.getPetId(true));
        return item;
    }

    private void updateGuiInfo(GuiScreen screen) {
        if (this.getWardrobeSlot(10) != null) {
            this.slot1 = this.getWardrobeSlot(10);
            this.slot2 = this.getWardrobeSlot(19);
            this.slot3 = this.getWardrobeSlot(28);
            this.slot4 = this.getWardrobeSlot(37);
        }
        if ((screen instanceof GuiChest || screen instanceof GuiInventory) && NotEnoughUpdates.INSTANCE.config.petOverlay.petInvDisplay) {
            this.petStack = this.getRepoPetStack();
        }
        if (!(screen instanceof GuiInventory) && !(screen instanceof GuiInvButtonEditor) || !NotEnoughUpdates.INSTANCE.config.misc.hidePotionEffect || !NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            this.shouldRenderArmorHud = false;
            this.shouldRenderPets = false;
            return;
        }
        this.shouldRenderPets = NotEnoughUpdates.INSTANCE.config.petOverlay.petInvDisplay && this.petStack != null;
        this.shouldRenderArmorHud = NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud;
    }

    private void drawSlot(ItemStack stack, int x, int y, int mouseX, int mouseY, List<String> tooltip) {
        if (stack == null) {
            return;
        }
        Utils.drawItemStack(stack, x, y, true);
        if (Utils.isWithinRect(mouseX, mouseY, x, y, 16, 16)) {
            Utils.drawHoverOverlay(x, y);
            List tt = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            if (this.shouldShowEquipmentTooltip(tt)) {
                tooltip.addAll(tt);
            }
            if (NotEnoughUpdates.INSTANCE.config.customArmour.sendWardrobeCommand && Mouse.getEventButtonState()) {
                NotEnoughUpdates.INSTANCE.trySendCommand("/equipment");
            }
        }
    }

    public void renderPets(GuiInventory inventory, int mouseX, int mouseY, int width, int height) {
        ItemUtils.getOrCreateTag(this.petStack).func_74757_a("NEUHIDEPETTOOLTIP", NotEnoughUpdates.INSTANCE.config.petOverlay.hidePetTooltip);
        ItemStack petInfo = this.petStack;
        AccessorGuiContainer container = (AccessorGuiContainer)inventory;
        int overlayLeft = container.getGuiLeft() - 24;
        int overlayTop = container.getGuiTop() + 72;
        GlStateManager.func_179144_i((int)0);
        Utils.drawItemStack(petInfo, overlayLeft + 8, overlayTop + 8, true);
        if (Utils.isWithinRect(mouseX, mouseY, overlayLeft + 8, overlayTop + 8, 16, 16)) {
            if (NotEnoughUpdates.INSTANCE.config.petOverlay.sendPetsCommand && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null && Mouse.getEventButtonState()) {
                NotEnoughUpdates.INSTANCE.trySendCommand("/pets");
            }
            Utils.drawHoverOverlay(overlayLeft + 8, overlayTop + 8);
            List tooltipToDisplay = petInfo.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            Utils.drawHoveringText(tooltipToDisplay, mouseX - this.calculateTooltipXOffset(tooltipToDisplay), mouseY, width, height, -1);
        }
    }

    @SubscribeEvent
    public void onClickItem(PlayerInteractEvent event) {
        int slot;
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR || Minecraft.func_71410_x().field_71439_g.func_70694_bm() == null) {
            return;
        }
        ItemStack heldItem = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        List<String> heldItemLore = ItemUtils.getLore(heldItem);
        if (heldItemLore.isEmpty()) {
            return;
        }
        String itemType = Objects.requireNonNull(StringUtils.substringAfterLast((String)heldItemLore.get(heldItemLore.size() - 1), (String)" "), "null");
        if (!Arrays.asList("NECKLACE", "CLOAK", "BELT", "GLOVES", "BRACELET").contains(itemType)) {
            return;
        }
        NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (profileSpecific == null) {
            return;
        }
        switch (itemType) {
            case "NECKLACE": {
                slot = 10;
                break;
            }
            case "CLOAK": {
                slot = 19;
                break;
            }
            case "BELT": {
                slot = 28;
                break;
            }
            case "GLOVES": 
            case "BRACELET": {
                slot = 37;
                break;
            }
            default: {
                return;
            }
        }
        JsonObject currentEquipment = profileSpecific.savedEquipment.get(slot);
        if (currentEquipment == null) {
            return;
        }
        ItemStack itemInSlot = NotEnoughUpdates.INSTANCE.manager.jsonToStack(currentEquipment.getAsJsonObject(), false);
        if (itemInSlot != null && itemInSlot.func_82833_r().contains("Empty")) {
            this.itemsToAdd.put(heldItem, slot);
        }
    }

    @SubscribeEvent
    public void onReceiveChatMessage(ClientChatReceivedEvent event) {
        if (event.type == 2 || !event.message.func_150260_c().startsWith("You equipped a ") || this.itemsToAdd.isEmpty()) {
            return;
        }
        for (ItemStack item : this.itemsToAdd.keySet()) {
            if (!event.message.func_150260_c().contains(Utils.cleanColour(item.func_82833_r()))) continue;
            NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
            if (profileSpecific == null) {
                return;
            }
            profileSpecific.savedEquipment.put(this.itemsToAdd.get(item), this.enrichItemStack(item));
            this.profileCache.get(SBInfo.getInstance().currentProfile).put(this.itemsToAdd.get(item), item);
            this.itemsToAdd.remove(item);
            return;
        }
    }

    private ItemStack getWardrobeSlot(int armourSlot) {
        NEUConfig.HiddenProfileSpecific profileSpecific;
        if (SBInfo.getInstance().currentProfile == null) {
            return null;
        }
        if (!Objects.equals(SBInfo.getInstance().currentProfile, this.lastProfile)) {
            this.lastProfile = SBInfo.getInstance().currentProfile;
            this.slot1 = null;
            this.slot2 = null;
            this.slot3 = null;
            this.slot4 = null;
        }
        if ((profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific()) == null) {
            return null;
        }
        this.profileCache.putIfAbsent(this.lastProfile, new HashMap());
        Map<Integer, ItemStack> cache = this.profileCache.get(this.lastProfile);
        if (this.isInNamedGui("Your Equipment")) {
            ItemStack itemStack = this.getChestSlotsAsItemStack(armourSlot);
            if (itemStack != null) {
                profileSpecific.savedEquipment.put(armourSlot, this.enrichItemStack(itemStack));
                cache.put(armourSlot, itemStack);
                return itemStack;
            }
        } else if (profileSpecific.savedEquipment.containsKey(armourSlot)) {
            if (cache.containsKey(armourSlot)) {
                return cache.get(armourSlot);
            }
            JsonObject jsonObject = profileSpecific.savedEquipment.get(armourSlot);
            if (jsonObject != null) {
                ItemStack result2 = NotEnoughUpdates.INSTANCE.manager.jsonToStack(jsonObject.getAsJsonObject(), false);
                cache.put(armourSlot, result2);
                return result2;
            }
        }
        return null;
    }

    private JsonObject enrichItemStack(ItemStack itemStack) {
        JsonObject itemToSave = NotEnoughUpdates.INSTANCE.manager.getJsonForItem(itemStack);
        if (!itemToSave.has("internalname")) {
            itemToSave.add("internalname", new JsonPrimitive("_"));
        }
        return itemToSave;
    }

    private boolean isInNamedGui(String guiName) {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen instanceof GuiChest) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            String containerName = lower2.func_145748_c_().func_150260_c();
            this.wardrobeOpen = containerName.contains(guiName);
        }
        if (guiScreen instanceof GuiInventory) {
            this.wardrobeOpen = false;
        }
        return this.wardrobeOpen;
    }

    private ItemStack getChestSlotsAsItemStack(int slot) {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen instanceof GuiChest) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            return chest.field_147002_h.func_75139_a(slot).func_75211_c();
        }
        return null;
    }

    public static boolean isRenderingArmorHud() {
        return EquipmentOverlay.INSTANCE.shouldRenderArmorHud;
    }

    public static boolean isRenderingPetHud() {
        return EquipmentOverlay.INSTANCE.shouldRenderPets;
    }

    private boolean shouldShowEquipmentTooltip(List<String> toolTip) {
        return !toolTip.get(0).equals("\u00a7o\u00a77Empty Equipment Slot\u00a7r");
    }

    private int calculateTooltipXOffset(List<String> tooltipToDisplay) {
        int offset = 0;
        if (tooltipToDisplay != null) {
            for (String line : tooltipToDisplay) {
                int lineWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(line);
                if (lineWidth <= offset) continue;
                offset = lineWidth;
            }
        }
        return offset + 20;
    }

    public void renderPreviewArmorHud() {
        if (!NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud || !(Minecraft.func_71410_x().field_71462_r instanceof GuiInvButtonEditor)) {
            return;
        }
        GuiInvButtonEditor container = (GuiInvButtonEditor)Minecraft.func_71410_x().field_71462_r;
        int overlayLeft = container.getGuiLeft() - 24;
        int overlayTop = container.getGuiTop();
        ResourceLocation equipmentTexture = this.getCustomEquipmentTexture(this.shouldRenderPets);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(equipmentTexture);
        Utils.drawTexturedRect(overlayLeft, overlayTop, 31.0f, 86.0f, 9728);
    }

    public void renderPreviewPetInvHud() {
        if (!NotEnoughUpdates.INSTANCE.config.petOverlay.petInvDisplay || !(Minecraft.func_71410_x().field_71462_r instanceof GuiInvButtonEditor)) {
            return;
        }
        GuiInvButtonEditor container = (GuiInvButtonEditor)Minecraft.func_71410_x().field_71462_r;
        int overlayLeft = container.getGuiLeft() - 24;
        int overlayTop = container.getGuiTop() + 72;
        ResourceLocation petHudTexture = this.getCustomPetTexture(this.shouldRenderArmorHud);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(petHudTexture);
        Utils.drawTexturedRect(overlayLeft, overlayTop, 31.0f, 32.0f, 9728);
    }
}

