/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpUtils;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.XPInformation;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class CombatSkillOverlay
extends TextOverlay {
    private long lastUpdate = -1L;
    private int killLast = -1;
    private int kill = -1;
    private int championTier = -1;
    private String championTierAmount = "1";
    private int championXp = -1;
    private int championXpLast = -1;
    private final LinkedList<Integer> killQueue = new LinkedList();
    private boolean hasToxophilite = false;
    private XPInformation.SkillInfo skillInfo = null;
    private XPInformation.SkillInfo skillInfoLast = null;
    private float lastTotalXp = -1.0f;
    private boolean isKilling = false;
    private final LinkedList<Float> xpGainQueue = new LinkedList();
    private float xpGainHourLast = -1.0f;
    private float xpGainHour = -1.0f;
    private int xpGainTimer = 0;
    private final String skillType = "Combat";

    public CombatSkillOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    private float interp(float now, float last) {
        float interp = now;
        if (last >= 0.0f && last != now) {
            float factor = (float)(System.currentTimeMillis() - this.lastUpdate) / 1000.0f;
            factor = LerpUtils.clampZeroOne(factor);
            interp = last + (now - last) * factor;
        }
        return interp;
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.skillOverlays.combatSkillOverlay;
    }

    @Override
    public void update() {
        NBTTagCompound tag;
        if (!this.isEnabled()) {
            this.kill = -1;
            this.championXp = -1;
            this.overlayStrings = null;
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        this.killLast = this.kill;
        this.championXpLast = this.championXp;
        this.xpGainHourLast = this.xpGainHour;
        this.kill = -1;
        this.championXp = -1;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (stack != null && stack.func_77942_o() && (tag = stack.func_77978_p()).func_150297_b("ExtraAttributes", 10)) {
            NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
            if (ea.func_150297_b("stats_book", 99)) {
                this.kill = ea.func_74762_e("stats_book");
                this.killQueue.add(0, this.kill);
            }
            this.hasToxophilite = false;
            if (ea.func_150297_b("champion_combat_xp", 99)) {
                this.championXp = (int)ea.func_74769_h("champion_combat_xp");
            } else if (ea.func_150297_b("toxophilite_combat_xp", 99)) {
                this.championXp = (int)ea.func_74769_h("toxophilite_combat_xp");
                this.hasToxophilite = true;
            }
        }
        if (this.championXp < 50000) {
            this.championTier = 1;
        } else if (this.championXp < 100000) {
            this.championTier = 2;
        } else if (this.championXp < 250000) {
            this.championTier = 3;
        } else if (this.championXp < 500000) {
            this.championTier = 4;
        } else if (this.championXp < 1000000) {
            this.championTier = 5;
        } else if (this.championXp < 1500000) {
            this.championTier = 6;
        } else if (this.championXp < 2000000) {
            this.championTier = 7;
        } else if (this.championXp < 2500000) {
            this.championTier = 8;
        } else if (this.championXp < 3000000) {
            this.championTier = 9;
        } else if (this.championXp > 3000000) {
            this.championTier = 10;
        }
        switch (this.championTier) {
            case 1: {
                this.championTierAmount = "50,000";
                break;
            }
            case 2: {
                this.championTierAmount = "100,000";
                break;
            }
            case 3: {
                this.championTierAmount = "250,000";
                break;
            }
            case 4: {
                this.championTierAmount = "500,000";
                break;
            }
            case 5: {
                this.championTierAmount = "1,000,000";
                break;
            }
            case 6: {
                this.championTierAmount = "1,500,000";
                break;
            }
            case 7: {
                this.championTierAmount = "2,000,000";
                break;
            }
            case 8: {
                this.championTierAmount = "2,500,000";
                break;
            }
            case 9: {
                this.championTierAmount = "3,000,000";
                break;
            }
            case 10: {
                this.championTierAmount = "Maxed";
            }
        }
        this.skillInfoLast = this.skillInfo;
        List<Integer> s = NotEnoughUpdates.INSTANCE.config.skillOverlays.combatText;
        this.skillInfo = XPInformation.getInstance().getSkillInfo("Combat", s.contains(1) || s.contains(2) || s.contains(3) || s.contains(4));
        if (this.skillInfo != null) {
            float totalXp = (float)this.skillInfo.totalXp;
            if (this.lastTotalXp > 0.0f) {
                float f;
                Iterator iterator;
                float totalGain;
                float delta = totalXp - this.lastTotalXp;
                if (delta > 0.0f && delta < 1000.0f) {
                    this.xpGainTimer = NotEnoughUpdates.INSTANCE.config.skillOverlays.combatPauseTimer;
                    this.xpGainQueue.add(0, Float.valueOf(delta));
                    while (this.xpGainQueue.size() > 30) {
                        this.xpGainQueue.removeLast();
                    }
                    totalGain = 0.0f;
                    iterator = this.xpGainQueue.iterator();
                    while (iterator.hasNext()) {
                        f = ((Float)iterator.next()).floatValue();
                        totalGain += f;
                    }
                    this.xpGainHour = totalGain * 3600.0f / (float)this.xpGainQueue.size();
                    this.isKilling = true;
                } else if (this.xpGainTimer > 0) {
                    --this.xpGainTimer;
                    this.xpGainQueue.add(0, Float.valueOf(0.0f));
                    while (this.xpGainQueue.size() > 30) {
                        this.xpGainQueue.removeLast();
                    }
                    totalGain = 0.0f;
                    iterator = this.xpGainQueue.iterator();
                    while (iterator.hasNext()) {
                        f = ((Float)iterator.next()).floatValue();
                        totalGain += f;
                    }
                    this.xpGainHour = totalGain * 3600.0f / (float)this.xpGainQueue.size();
                    this.isKilling = true;
                } else if (delta <= 0.0f) {
                    this.isKilling = false;
                }
            }
            this.lastTotalXp = totalXp;
        }
        while (this.killQueue.size() >= 4) {
            this.killQueue.removeLast();
        }
        this.overlayStrings = this.kill != -1 || this.championXp != -1 ? new ArrayList() : null;
    }

    @Override
    public void updateFrequent() {
        super.updateFrequent();
        if (this.kill < 0 && this.championXp < 0 && !NotEnoughUpdates.INSTANCE.config.skillOverlays.alwaysShowCombatOverlay) {
            this.overlayStrings = null;
        } else {
            int counterInterp;
            HashMap<Integer, String> lineMap = new HashMap<Integer, String>();
            this.overlayStrings = new ArrayList();
            NumberFormat format2 = NumberFormat.getIntegerInstance();
            if (this.kill >= 0) {
                int counterInterp2 = (int)this.interp(this.kill, this.killLast);
                lineMap.put(0, EnumChatFormatting.AQUA + "Kills: " + EnumChatFormatting.YELLOW + format2.format(counterInterp2));
            }
            String enchantText = "Champion: ";
            if (this.hasToxophilite) {
                enchantText = "Toxophilite: ";
            }
            if (this.championTier <= 9 && this.championXp >= 0) {
                counterInterp = (int)this.interp(this.championXp, this.championXpLast);
                lineMap.put(6, EnumChatFormatting.AQUA + enchantText + EnumChatFormatting.YELLOW + format2.format(counterInterp) + "/" + this.championTierAmount);
            }
            if (this.championTier == 10) {
                counterInterp = (int)this.interp(this.championXp, this.championXpLast);
                lineMap.put(6, EnumChatFormatting.AQUA + enchantText + EnumChatFormatting.YELLOW + format2.format(counterInterp) + " " + EnumChatFormatting.RED + this.championTierAmount);
            }
            float xpInterp = this.xpGainHour;
            if (this.xpGainHourLast == this.xpGainHour && this.xpGainHour <= 0.0f) {
                lineMap.put(4, EnumChatFormatting.AQUA + "XP/h: " + EnumChatFormatting.YELLOW + "N/A");
            } else {
                xpInterp = this.interp(this.xpGainHour, this.xpGainHourLast);
                lineMap.put(4, EnumChatFormatting.AQUA + "XP/h: " + EnumChatFormatting.YELLOW + format2.format(xpInterp) + (this.isKilling ? "" : EnumChatFormatting.RED + " (PAUSED)"));
            }
            if (this.skillInfo != null && this.skillInfo.level < 60) {
                StringBuilder levelStr = new StringBuilder(EnumChatFormatting.AQUA + "Combat: ");
                levelStr.append(EnumChatFormatting.YELLOW).append(this.skillInfo.level).append(EnumChatFormatting.GRAY).append(" [");
                float progress = (float)(this.skillInfo.currentXp / this.skillInfo.currentXpMax);
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    progress = this.interp(progress, (float)(this.skillInfoLast.currentXp / this.skillInfoLast.currentXpMax));
                }
                float lines = 25.0f;
                int i = 0;
                while ((float)i < lines) {
                    if ((float)i / lines < progress) {
                        levelStr.append(EnumChatFormatting.YELLOW);
                    } else {
                        levelStr.append(EnumChatFormatting.DARK_GRAY);
                    }
                    levelStr.append('|');
                    ++i;
                }
                levelStr.append(EnumChatFormatting.GRAY).append("] ").append(EnumChatFormatting.YELLOW).append((int)(progress * 100.0f)).append("%");
                int current = (int)this.skillInfo.currentXp;
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    current = (int)this.interp(current, (float)this.skillInfoLast.currentXp);
                }
                int remaining = (int)(this.skillInfo.currentXpMax - this.skillInfo.currentXp);
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    remaining = (int)this.interp(remaining, (int)(this.skillInfoLast.currentXpMax - this.skillInfoLast.currentXp));
                }
                lineMap.put(1, levelStr.toString());
                lineMap.put(2, EnumChatFormatting.AQUA + "Current XP: " + EnumChatFormatting.YELLOW + format2.format(current));
                if (remaining < 0) {
                    lineMap.put(3, EnumChatFormatting.AQUA + "Remaining XP: " + EnumChatFormatting.YELLOW + "MAXED!");
                    lineMap.put(5, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + "MAXED!");
                } else {
                    lineMap.put(3, EnumChatFormatting.AQUA + "Remaining XP: " + EnumChatFormatting.YELLOW + format2.format(remaining));
                    if (this.xpGainHour < 1000.0f) {
                        lineMap.put(5, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + "N/A");
                    } else {
                        lineMap.put(5, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + Utils.prettyTime((long)remaining * 1000L * 60L * 60L / (long)xpInterp));
                    }
                }
            }
            if (this.skillInfo != null && this.skillInfo.level == 60) {
                int current = (int)this.skillInfo.currentXp;
                if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                    current = (int)this.interp(current, (float)this.skillInfoLast.currentXp);
                }
                lineMap.put(1, EnumChatFormatting.AQUA + "Combat: " + EnumChatFormatting.YELLOW + "60 " + EnumChatFormatting.RED + "(Maxed)");
                lineMap.put(2, EnumChatFormatting.AQUA + "Current XP: " + EnumChatFormatting.YELLOW + format2.format(current));
            }
            for (int strIndex : NotEnoughUpdates.INSTANCE.config.skillOverlays.combatText) {
                if (lineMap.get(strIndex) == null) continue;
                this.overlayStrings.add(lineMap.get(strIndex));
            }
            if (this.overlayStrings != null && this.overlayStrings.isEmpty()) {
                this.overlayStrings = null;
            }
        }
    }
}

