/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.CookieWarning;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiEditSign;
import io.github.moulberry.notenoughupdates.overlays.SearchOverlayScreen;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BazaarSearchOverlay
extends SearchOverlayScreen {
    private static final Comparator<String> salesComparator = (o1, o2) -> {
        int sales2;
        boolean auc2Invalid;
        JsonObject bazaarInfo1 = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo((String)o1);
        JsonObject bazaarInfo2 = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo((String)o2);
        boolean auc1Invalid = bazaarInfo1 == null || !bazaarInfo1.has("curr_sell");
        boolean bl = auc2Invalid = bazaarInfo2 == null || !bazaarInfo2.has("curr_sell");
        if (auc1Invalid && auc2Invalid) {
            return o1.compareTo((String)o2);
        }
        if (auc1Invalid) {
            return 1;
        }
        if (auc2Invalid) {
            return -1;
        }
        int sales1 = bazaarInfo1.get("curr_sell").getAsInt();
        if (sales1 == (sales2 = bazaarInfo2.get("curr_sell").getAsInt())) {
            return o1.compareTo((String)o2);
        }
        if (sales1 > sales2) {
            return -1;
        }
        return 1;
    };

    public BazaarSearchOverlay() {
        super(new TileEntitySign());
    }

    public BazaarSearchOverlay(TileEntitySign tes) {
        super(tes);
        this.tileSign = tes;
        this.guiType = SearchOverlayScreen.GuiType.BAZAAR;
    }

    public static boolean shouldReplace() {
        return Minecraft.func_71410_x().field_71462_r instanceof BazaarSearchOverlay;
    }

    public static boolean isinBzSign() {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return false;
        }
        if (!NotEnoughUpdates.INSTANCE.config.bazaarTweaks.enableSearchOverlay) {
            return false;
        }
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiEditSign)) {
            if (!NotEnoughUpdates.INSTANCE.config.bazaarTweaks.keepPreviousSearch) {
                searchString = "";
            }
            return false;
        }
        String lastContainer = Utils.getLastOpenChestName();
        if (!lastContainer.startsWith("Bazaar \u279c ")) {
            return false;
        }
        TileEntitySign tes = ((AccessorGuiEditSign)Minecraft.func_71410_x().field_71462_r).getTileSign();
        if (tes == null) {
            return false;
        }
        if (tes.func_174877_v().func_177956_o() != 0) {
            return false;
        }
        if (!tes.field_145915_a[2].func_150260_c().equals("^^^^^^^^^^^^^^^")) {
            return false;
        }
        return tes.field_145915_a[3].func_150260_c().equals("Enter query");
    }

    @SubscribeEvent
    public void onSlotClick(SlotClickEvent event) {
        if (!this.enableSearchOverlay()) {
            return;
        }
        if (this.disableClientSideGUI()) {
            return;
        }
        ItemStack stack = event.slot.func_75211_c();
        if (event.clickedButton == 1 && event.clickType == 0 && stack != null) {
            String clearLine;
            List<String> lore = ItemUtils.getLore(stack);
            String string = clearLine = lore.size() > 4 ? lore.get(4) : null;
            if (clearLine != null && clearLine.equals("\u00a7bRight-Click to clear!")) {
                return;
            }
        }
        if (!CookieWarning.hasActiveBoosterCookie()) {
            return;
        }
        if (!Utils.getOpenChestName().startsWith("Bazaar \u279c")) {
            return;
        }
        if (event.slot.field_75222_d == 45 && stack != null && stack.func_82837_s() && stack.func_77973_b() == Items.field_151155_ap && stack.func_82833_r().equals("\u00a7aSearch")) {
            event.setCanceled(true);
            Minecraft.func_71410_x().field_71462_r = null;
            NotEnoughUpdates.INSTANCE.openGui = new BazaarSearchOverlay();
        }
    }

    @SubscribeEvent
    public void onSignDrawn(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!BazaarSearchOverlay.isinBzSign() || !(event.gui instanceof GuiEditSign) || event.gui instanceof SearchOverlayScreen) {
            return;
        }
        GuiEditSign guiEditSign = (GuiEditSign)event.gui;
        TileEntitySign tileSign = ((AccessorGuiEditSign)guiEditSign).getTileSign();
        if (tileSign != null) {
            event.setCanceled(true);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new BazaarSearchOverlay(tileSign));
        }
    }

    @Override
    public Comparator<String> getSearchComparator() {
        return salesComparator;
    }

    @Override
    public boolean enableSearchOverlay() {
        return NotEnoughUpdates.INSTANCE.config.bazaarTweaks.enableSearchOverlay;
    }

    @Override
    public ArrayList<String> previousSearches() {
        return NotEnoughUpdates.INSTANCE.config.hidden.previousBazaarSearches;
    }

    @Override
    public int searchHistorySize() {
        return NotEnoughUpdates.INSTANCE.config.bazaarTweaks.bzSearchHistorySize;
    }

    @Override
    public boolean showPastSearches() {
        return NotEnoughUpdates.INSTANCE.config.bazaarTweaks.showPastSearches;
    }

    @Override
    public boolean escFullClose() {
        return NotEnoughUpdates.INSTANCE.config.bazaarTweaks.escFullClose;
    }

    @Override
    public boolean keepPreviousSearch() {
        return NotEnoughUpdates.INSTANCE.config.bazaarTweaks.keepPreviousSearch;
    }

    @Override
    public SearchOverlayScreen.GuiType currentGuiType() {
        return SearchOverlayScreen.GuiType.BAZAAR;
    }
}

