/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.mixins;

import io.github.moulberry.notenoughupdates.NEUOverlay;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.ChromaColour;
import io.github.moulberry.notenoughupdates.listener.RenderListener;
import io.github.moulberry.notenoughupdates.miscfeatures.ItemCooldowns;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizationUtils;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizeManager;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderItem.class})
public abstract class MixinRenderItem {
    private static String customEnchGlint = null;

    private static void func_181565_a(WorldRenderer w, int x, int y, float width, int height, int r, int g, int b, int a) {
        w.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        w.func_181662_b((double)x, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        w.func_181662_b((double)x, (double)(y + height), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        w.func_181662_b((double)((float)x + width), (double)(y + height), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        w.func_181662_b((double)((float)x + width), (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Redirect(method={"renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/resources/model/IBakedModel;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasEffect()Z"))
    public boolean renderItem_hasEffect(ItemStack stack) {
        ItemCustomizeManager.ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data != null) {
            customEnchGlint = data.customGlintColour;
            if (data.overrideEnchantGlint) {
                return data.enchantGlintValue;
            }
        } else {
            customEnchGlint = null;
        }
        return stack.func_77962_s();
    }

    @Redirect(method={"renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/resources/model/IBakedModel;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/tileentity/TileEntityItemStackRenderer;renderByItem(Lnet/minecraft/item/ItemStack;)V"))
    public void renderItem_renderByItem(TileEntityItemStackRenderer tileEntityItemStackRenderer, ItemStack stack) {
        GL11.glPushMatrix();
        tileEntityItemStackRenderer.func_179022_a(stack);
        GL11.glPopMatrix();
        ItemCustomizeManager.ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data != null && data.overrideEnchantGlint && data.enchantGlintValue) {
            ItemCustomizeManager.renderEffectHook(data.customGlintColour, color -> {
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
                GlStateManager.func_179152_a((float)0.125f, (float)0.125f, (float)0.125f);
                GlStateManager.func_179128_n((int)5888);
                GL11.glPushMatrix();
                ItemCustomizeManager.disableTextureBinding = true;
                tileEntityItemStackRenderer.func_179022_a(stack);
                ItemCustomizeManager.disableTextureBinding = false;
                GL11.glPopMatrix();
            });
        }
    }

    @Redirect(method={"renderQuads"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;getColorFromItemStack(Lnet/minecraft/item/ItemStack;I)I"))
    public int renderItem_renderByItem(Item item, ItemStack stack, int renderPass) {
        if (renderPass == 0) {
            ItemCustomizeManager.ItemData data = ItemCustomizeManager.getDataForItem(stack);
            if (data != null && data.animatedLeatherColours != null && data.animatedDyeTicks > 0 && ItemCustomizeManager.shouldRenderLeatherColour(stack)) {
                return ItemCustomizationUtils.getAnimatedDyeColour(data.animatedLeatherColours, data.animatedDyeTicks, data.dyeMode);
            }
            if (data != null && data.customLeatherColour != null && ItemCustomizeManager.shouldRenderLeatherColour(stack)) {
                return ChromaColour.specialToChromaRGB(data.customLeatherColour);
            }
        }
        return item.func_82790_a(stack, renderPass);
    }

    @Inject(method={"renderEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderEffect(IBakedModel model, CallbackInfo ci) {
        if (ItemCustomizeManager.renderEffectHook(customEnchGlint, color -> this.func_175035_a(model, (int)color))) {
            ci.cancel();
        }
    }

    @Shadow
    abstract void func_175035_a(IBakedModel var1, int var2);

    @Inject(method={"renderItemIntoGUI"}, at={@At(value="HEAD")})
    public void renderItemHead(ItemStack stack, int x, int y, CallbackInfo ci) {
        if (NotEnoughUpdates.INSTANCE.overlay.searchMode && RenderListener.drawingGuiScreen && NotEnoughUpdates.INSTANCE.isOnSkyblock() && !(Minecraft.func_71410_x().field_71462_r instanceof GuiProfileViewer)) {
            boolean matches = false;
            GuiTextField textField = NEUOverlay.getTextField();
            if (textField.func_146179_b().trim().isEmpty()) {
                matches = true;
            } else if (stack != null) {
                for (String search : textField.func_146179_b().split("\\|")) {
                    matches |= NotEnoughUpdates.INSTANCE.manager.doesStackMatchSearch(stack, search.trim());
                }
            }
            if (matches) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(100.0f + Minecraft.func_71410_x().func_175599_af().field_77023_b));
                GlStateManager.func_179132_a((boolean)false);
                Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)NEUOverlay.overlayColourLight);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179121_F();
            }
        }
    }

    @Inject(method={"renderItemIntoGUI"}, at={@At(value="RETURN")})
    public void renderItemReturn(ItemStack stack, int x, int y, CallbackInfo ci) {
        if (stack != null && stack.field_77994_a != 1) {
            return;
        }
        if (NotEnoughUpdates.INSTANCE.overlay.searchMode && RenderListener.drawingGuiScreen && NotEnoughUpdates.INSTANCE.isOnSkyblock() && !(Minecraft.func_71410_x().field_71462_r instanceof GuiProfileViewer)) {
            boolean matches = false;
            GuiTextField textField = NEUOverlay.getTextField();
            if (textField.func_146179_b().trim().isEmpty()) {
                matches = true;
            } else if (stack != null) {
                for (String search : textField.func_146179_b().split("\\|")) {
                    matches |= NotEnoughUpdates.INSTANCE.manager.doesStackMatchSearch(stack, search.trim());
                }
            }
            if (!matches) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(110.0f + Minecraft.func_71410_x().func_175599_af().field_77023_b));
                Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)NEUOverlay.overlayColourDark);
                GlStateManager.func_179121_F();
            }
        }
    }

    @Inject(method={"renderItemOverlayIntoGUI"}, at={@At(value="RETURN")})
    public void renderItemOverlayIntoGUI(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, String text, CallbackInfo ci) {
        if (stack != null && stack.field_77994_a != 1 && NotEnoughUpdates.INSTANCE.overlay.searchMode && RenderListener.drawingGuiScreen && NotEnoughUpdates.INSTANCE.isOnSkyblock() && !(Minecraft.func_71410_x().field_71462_r instanceof GuiProfileViewer)) {
            boolean matches = false;
            GuiTextField textField = NEUOverlay.getTextField();
            if (textField.func_146179_b().trim().isEmpty()) {
                matches = true;
            } else {
                for (String search : textField.func_146179_b().split("\\|")) {
                    matches |= NotEnoughUpdates.INSTANCE.manager.doesStackMatchSearch(stack, search.trim());
                }
            }
            if (!matches) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(110.0f + Minecraft.func_71410_x().func_175599_af().field_77023_b));
                GlStateManager.func_179097_i();
                Gui.func_73734_a((int)xPosition, (int)yPosition, (int)(xPosition + 16), (int)(yPosition + 16), (int)NEUOverlay.overlayColourDark);
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
            }
        }
        if (stack == null) {
            return;
        }
        float damageOverride = ItemCooldowns.getDurabilityOverride(stack);
        if (damageOverride >= 0.0f) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            if (NotEnoughUpdates.INSTANCE.config.itemOverlays.oldCooldowns) {
                float barX = 13.0f - damageOverride * 13.0f;
                int col = (int)Math.round(255.0 - (double)damageOverride * 255.0);
                GlStateManager.func_179090_x();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                Tessellator tessellator = Tessellator.func_178181_a();
                WorldRenderer worldrenderer = tessellator.func_178180_c();
                MixinRenderItem.func_181565_a(worldrenderer, xPosition + 2, yPosition + 13, 13.0f, 2, 0, 0, 0, 255);
                MixinRenderItem.func_181565_a(worldrenderer, xPosition + 2, yPosition + 13, 12.0f, 1, (255 - col) / 4, 64, 0, 255);
                MixinRenderItem.func_181565_a(worldrenderer, xPosition + 2, yPosition + 13, barX, 1, 255 - col, col, 0, 255);
                GlStateManager.func_179141_d();
                GlStateManager.func_179098_w();
            } else {
                GlStateManager.func_179141_d();
                Utils.drawRect(xPosition, (float)yPosition + 16.0f * (1.0f - damageOverride), xPosition + 16, yPosition + 16, Integer.MAX_VALUE);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
    }

    @Redirect(method={"renderItemOverlayIntoGUI"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;showDurabilityBar(Lnet/minecraft/item/ItemStack;)Z"))
    public boolean renderItemOverlayIntoGUI_showDurabilityBar(Item instance, ItemStack stack) {
        if (ItemCustomizeManager.hasCustomItem(stack)) {
            return false;
        }
        return stack.func_77973_b().showDurabilityBar(stack);
    }
}

