/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.mixins;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.ChromaColour;
import io.github.moulberry.notenoughupdates.miscfeatures.DefaultArmorColour;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizationUtils;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizeManager;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LayerArmorBase.class})
public abstract class MixinLayerArmorBase<T extends ModelBase> {
    private static String customEnchGlint = null;

    @Redirect(method={"renderLayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasEffect()Z"))
    public boolean renderItem_hasEffect(ItemStack stack) {
        ItemCustomizeManager.ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data != null) {
            customEnchGlint = data.customGlintColour;
            if (data.overrideEnchantGlint) {
                return data.enchantGlintValue;
            }
        } else {
            customEnchGlint = null;
        }
        return stack.func_77962_s();
    }

    @Inject(method={"renderGlint"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderGlint(EntityLivingBase entitylivingbaseIn, T modelbaseIn, float p_177183_3_, float p_177183_4_, float partialTicks, float p_177183_6_, float p_177183_7_, float p_177183_8_, float scale, CallbackInfo ci) {
        float existed = (float)entitylivingbaseIn.field_70173_aa + partialTicks;
        if (ItemCustomizeManager.render3DGlint(customEnchGlint, existed, () -> modelbaseIn.func_78088_a((Entity)entitylivingbaseIn, p_177183_3_, p_177183_4_, p_177183_6_, p_177183_7_, p_177183_8_, scale))) {
            ci.cancel();
        }
    }

    @Redirect(method={"renderLayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemArmor;getColor(Lnet/minecraft/item/ItemStack;)I"))
    public int renderItem_getColor(ItemArmor item, ItemStack stack) {
        if (NotEnoughUpdates.INSTANCE.config.misc.defaultArmorColour) {
            return DefaultArmorColour.getDefaultArmorColour(item, stack);
        }
        ItemCustomizeManager.ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data != null && data.animatedLeatherColours != null && data.animatedDyeTicks > 0 && ItemCustomizeManager.shouldRenderLeatherColour(stack)) {
            return ItemCustomizationUtils.getAnimatedDyeColour(data.animatedLeatherColours, data.animatedDyeTicks, data.dyeMode);
        }
        if (data != null && data.customLeatherColour != null && ItemCustomizeManager.shouldRenderLeatherColour(stack)) {
            return ChromaColour.specialToChromaRGB(data.customLeatherColour);
        }
        return item.func_82814_b(stack);
    }

    @Redirect(method={"renderLayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/LayerArmorBase;getCurrentArmor(Lnet/minecraft/entity/EntityLivingBase;I)Lnet/minecraft/item/ItemStack;"))
    public ItemStack renderItem_getCurrentArmor(LayerArmorBase<?> instance, EntityLivingBase entitylivingbaseIn, int armorSlot) {
        return ItemCustomizeManager.useCustomArmour(instance, entitylivingbaseIn, armorSlot);
    }
}

