/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.CraftingSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.MinionSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.NpcSource;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MinionHelperPriceCalculation {
    private final MinionHelperManager manager;
    private final Map<String, String> upgradeCostFormatCache = new HashMap<String, String>();
    private final Map<String, String> fullCostFormatCache = new HashMap<String, String>();

    public MinionHelperPriceCalculation(MinionHelperManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        this.resetCache();
    }

    public void resetCache() {
        this.upgradeCostFormatCache.clear();
        this.fullCostFormatCache.clear();
    }

    public String calculateUpgradeCostsFormat(Minion minion, boolean upgradeOnly) {
        MinionSource source = minion.getMinionSource();
        if (source == null) {
            return "\u00a7c?";
        }
        String internalName = minion.getInternalName();
        if (upgradeOnly) {
            if (this.upgradeCostFormatCache.containsKey(internalName)) {
                return this.upgradeCostFormatCache.get(internalName);
            }
        } else if (this.fullCostFormatCache.containsKey(internalName)) {
            return this.fullCostFormatCache.get(internalName);
        }
        if (upgradeOnly && minion.getCustomSource() != null) {
            return minion.getCustomSource().getSourceName();
        }
        double costs = this.calculateUpgradeCosts(minion, upgradeOnly);
        String result2 = this.formatCoins(costs, !upgradeOnly ? "\u00a7o" : "");
        if (source instanceof NpcSource) {
            int amount;
            ArrayListMultimap<String, Integer> items2 = ((NpcSource)source).getItems();
            if (items2.containsKey((Object)"SKYBLOCK_PELT")) {
                amount = (Integer)items2.get((Object)"SKYBLOCK_PELT").get(0);
                result2 = result2 + " \u00a78+ \u00a75" + amount + " Pelts";
            }
            if (items2.containsKey((Object)"SKYBLOCK_NORTH_STAR")) {
                amount = (Integer)items2.get((Object)"SKYBLOCK_NORTH_STAR").get(0);
                result2 = result2 + " \u00a78+ \u00a7d" + amount + " North Stars";
            }
        }
        if (upgradeOnly) {
            this.upgradeCostFormatCache.put(internalName, result2);
        } else {
            this.fullCostFormatCache.put(internalName, result2);
        }
        return result2;
    }

    public double calculateUpgradeCosts(Minion minion, boolean upgradeOnly) {
        MinionSource source = minion.getMinionSource();
        if (upgradeOnly && minion.getCustomSource() != null) {
            return 0.0;
        }
        if (source instanceof CraftingSource) {
            CraftingSource craftingSource = (CraftingSource)source;
            return this.getCosts(minion, upgradeOnly, craftingSource.getItems());
        }
        if (source instanceof NpcSource) {
            NpcSource npcSource = (NpcSource)source;
            double upgradeCost = this.getCosts(minion, upgradeOnly, npcSource.getItems());
            long coins = npcSource.getCoins();
            return upgradeCost += (double)coins;
        }
        return 0.0;
    }

    private double getCosts(Minion minion, boolean upgradeOnly, ArrayListMultimap<String, Integer> items2) {
        Minion parent;
        double upgradeCost = 0.0;
        for (Map.Entry entry : items2.entries()) {
            String internalName = (String)entry.getKey();
            if (internalName.equals("SKYBLOCK_PELT")) continue;
            double price = this.getPrice(internalName);
            int amount = (Integer)entry.getValue();
            upgradeCost += price * (double)amount;
        }
        if (!upgradeOnly && (parent = minion.getParent()) != null) {
            upgradeCost += this.calculateUpgradeCosts(parent, false);
        }
        return upgradeCost;
    }

    public double getPrice(String internalName) {
        if (internalName.contains("_GENERATOR_")) {
            return this.calculateUpgradeCosts(this.manager.getMinionById(internalName), false);
        }
        JsonObject bazaarInfo = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo(internalName);
        if (bazaarInfo != null) {
            String bazaarMode = this.manager.getOverlay().isUseInstantBuyPrice() ? "curr_buy" : "curr_sell";
            if (!bazaarInfo.has(bazaarMode)) {
                if (bazaarMode.equals("curr_buy")) {
                    bazaarMode = "curr_sell";
                    if (!bazaarInfo.has(bazaarMode)) {
                        System.err.println(bazaarMode + " does not exist for '" + internalName + "'");
                        return 0.0;
                    }
                } else {
                    System.err.println(bazaarMode + " does not exist for '" + internalName + "'");
                    return 0.0;
                }
            }
            return bazaarInfo.get(bazaarMode).getAsDouble();
        }
        double avgBinPrice = NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAvgBin(internalName);
        if (avgBinPrice >= 1.0) {
            return avgBinPrice;
        }
        JsonObject auctionInfo = NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAuctionInfo(internalName);
        if (auctionInfo == null) {
            return 1.0;
        }
        return auctionInfo.get("price").getAsFloat() / auctionInfo.get("count").getAsFloat();
    }

    public String formatCoins(double coins) {
        return this.formatCoins(coins, "");
    }

    public String formatCoins(double coins, String extraFormat) {
        int i = coins < 3.0 ? 1 : 0;
        String format2 = Utils.shortNumberFormat(coins, i);
        return "\u00a76" + extraFormat + format2 + " coins";
    }
}

