/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.ProfileDataLoadedEvent;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.ApiData;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MinionHelperApiLoader {
    private final MinionHelperManager manager;
    private boolean collectionApiEnabled = true;
    private boolean readyToUse = false;
    private ApiData apiData = null;
    private boolean notifyNoCollectionApi = false;
    private boolean invalidApiKey = true;

    public MinionHelperApiLoader(MinionHelperManager manager) {
        this.manager = manager;
    }

    private String getUuid() {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer == null) {
            return null;
        }
        String debugPlayerUuid = this.manager.getDebugPlayerUuid();
        if (debugPlayerUuid != null) {
            return debugPlayerUuid;
        }
        return thePlayer.func_110124_au().toString().replace("-", "");
    }

    @SubscribeEvent
    public void onApiDataLoaded(ProfileDataLoadedEvent event) {
        JsonObject data = event.getData();
        if (data == null) {
            this.invalidApiKey = true;
            return;
        }
        this.invalidApiKey = false;
        if (!data.has("success") || !data.get("success").getAsBoolean()) {
            return;
        }
        JsonArray profiles = data.getAsJsonArray("profiles");
        for (JsonElement element : profiles) {
            JsonObject profile = element.getAsJsonObject();
            String profileName = profile.get("cute_name").getAsString();
            JsonObject members = profile.getAsJsonObject("members");
            JsonObject player = members.getAsJsonObject(this.getUuid());
            String debugProfileName = this.manager.getDebugProfileName();
            String currentProfile = debugProfileName != null ? debugProfileName : SBInfo.getInstance().currentProfile;
            if (!profileName.equals(currentProfile)) continue;
            this.readData(player, members);
            return;
        }
    }

    private void readData(JsonObject player, JsonObject members) {
        int magesReputation = 0;
        int barbariansReputation = 0;
        if (player.has("nether_island_player_data")) {
            JsonObject netherData = player.getAsJsonObject("nether_island_player_data");
            if (netherData.has("mages_reputation")) {
                magesReputation = netherData.get("mages_reputation").getAsInt();
            }
            if (netherData.has("barbarians_reputation")) {
                barbariansReputation = netherData.get("barbarians_reputation").getAsInt();
            }
        }
        this.apiData = new ApiData(this.getCollections(player), this.getSlayers(player), magesReputation, barbariansReputation, !this.collectionApiEnabled, this.loadCraftedMinions(members), this.loadPeltCount(player));
        this.manager.reloadData();
        this.readyToUse = true;
    }

    private int loadPeltCount(JsonObject player) {
        int localPelts = this.manager.getLocalPelts();
        if (localPelts != -1) {
            return localPelts;
        }
        return Utils.getElementAsInt(Utils.getElement(player, "quests.trapper_quest.pelt_count"), 0);
    }

    private Map<String, Integer> getSlayers(JsonObject player) {
        JsonObject slayerLeveling = Constants.LEVELING.getAsJsonObject("slayer_xp");
        HashMap<String, Integer> slayerTier = new HashMap<String, Integer>();
        JsonObject slayerBosses = Utils.getElementOrDefault(player, "slayer.slayer_bosses", new JsonObject()).getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : slayerBosses.entrySet()) {
            JsonElement element;
            int needForLevel;
            String name = entry.getKey();
            JsonObject slayerEntry = entry.getValue().getAsJsonObject();
            if (!slayerEntry.has("xp")) continue;
            long xp = slayerEntry.get("xp").getAsLong();
            int tier = 0;
            Iterator<JsonElement> iterator = slayerLeveling.getAsJsonArray(name).iterator();
            while (iterator.hasNext() && xp >= (long)(needForLevel = (element = iterator.next()).getAsInt())) {
                ++tier;
            }
            slayerTier.put(name, tier);
        }
        return slayerTier;
    }

    private Map<String, Integer> getCollections(JsonObject player) {
        HashMap<String, Integer> highestCollectionTier = new HashMap<String, Integer>();
        JsonElement collectionTiers = Utils.getElement(player, "player_data.unlocked_coll_tiers");
        if (collectionTiers != null) {
            for (JsonElement element : collectionTiers.getAsJsonArray()) {
                String text = element.getAsString();
                String[] split = text.split("_");
                int level = Integer.parseInt(split[split.length - 1]);
                String name = StringUtils.removeLastWord(text, "_");
                LinkedHashMap<String, ItemStack> collectionMap = ProfileViewer.getCollectionToCollectionDisplayMap();
                if (collectionMap.containsKey(name)) {
                    ItemStack itemStack = collectionMap.get(name);
                    String displayName = itemStack.func_82833_r();
                    name = Utils.cleanColour(displayName);
                    name = this.manager.formatInternalName(name);
                } else {
                    if (name.equals("SAND:1")) {
                        name = "RED_SAND";
                    }
                    if (name.equals("MYCEL")) {
                        name = "MYCELIUM";
                    }
                }
                level = Math.max(highestCollectionTier.getOrDefault(name, 0), level);
                highestCollectionTier.put(name, level);
            }
            if (!this.collectionApiEnabled) {
                Utils.addChatMessage("\u00a7e[NEU Minion Helper] Collection API detected!");
            }
            this.collectionApiEnabled = true;
        } else {
            if (this.collectionApiEnabled) {
                this.notifyNoCollectionApi = true;
            }
            this.collectionApiEnabled = false;
        }
        return highestCollectionTier;
    }

    private List<String> loadCraftedMinions(JsonObject members) {
        ArrayList<String> craftedMinions = new ArrayList<String>();
        for (Map.Entry<String, JsonElement> entry : members.entrySet()) {
            JsonObject value = entry.getValue().getAsJsonObject();
            for (JsonElement e2 : Utils.getElementOrDefault(value, "player_data.crafted_generators", new JsonArray()).getAsJsonArray()) {
                String rawGenerator = e2.getAsString();
                String[] split = rawGenerator.split("_");
                String tier = split[split.length - 1];
                String name = rawGenerator.substring(0, rawGenerator.length() - tier.length() - 1);
                String internalName = name + "_GENERATOR_" + tier;
                craftedMinions.add(internalName);
            }
        }
        return craftedMinions;
    }

    public void setDirty() {
        this.readyToUse = false;
    }

    public void prepareProfileSwitch() {
        this.readyToUse = false;
    }

    public void onProfileSwitch() {
        this.apiData = null;
        this.collectionApiEnabled = true;
    }

    public boolean isCollectionApiDisabled() {
        return this.apiData != null && this.apiData.isCollectionApiDisabled();
    }

    public void resetData() {
        this.apiData = null;
    }

    public void setNotifyNoCollectionApi(boolean notifyNoCollectionApi) {
        this.notifyNoCollectionApi = notifyNoCollectionApi;
    }

    public boolean isReadyToUse() {
        return this.readyToUse;
    }

    public ApiData getApiData() {
        return this.apiData;
    }

    public boolean isNotifyNoCollectionApi() {
        return this.notifyNoCollectionApi;
    }

    public boolean isInvalidApiKey() {
        return this.invalidApiKey;
    }
}

