/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.world;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.world.GenericBlockHighlighter;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.network.play.server.S22PacketMultiBlockChange;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CrystalHollowChestHighlighter
extends GenericBlockHighlighter {
    public static CopyOnWriteArrayList<BlockPos> markedBlocks = new CopyOnWriteArrayList();

    public static void processBlockChangePacket(S23PacketBlockChange packetIn) {
        BlockPos pos = packetIn.func_179827_b();
        if (packetIn.field_148883_d == null) {
            return;
        }
        CrystalHollowChestHighlighter.checkForChest(pos, packetIn.field_148883_d);
    }

    public static void processMultiBlockChangePacket(S22PacketMultiBlockChange packetIn) {
        for (S22PacketMultiBlockChange.BlockUpdateData blockChanged : packetIn.func_179844_a()) {
            BlockPos pos = blockChanged.func_180090_a();
            CrystalHollowChestHighlighter.checkForChest(pos, blockChanged.func_180088_c());
        }
    }

    public static void checkForChest(BlockPos pos, IBlockState blockState) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (world == null || player == null) {
            return;
        }
        IBlockState oldState = world.func_180495_p(pos);
        if ((oldState.func_177230_c() == Blocks.field_150350_a || oldState.func_177230_c() == Blocks.field_150348_b) && blockState.func_177230_c() == Blocks.field_150486_ae && player.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0).func_72318_a(new Vec3((Vec3i)pos))) {
            markedBlocks.add(pos);
        }
    }

    @Override
    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        markedBlocks.forEach(this::tryRegisterInterest);
        ArrayList blockToRemove = new ArrayList();
        this.highlightedBlocks.forEach(it -> {
            if (Minecraft.func_71410_x().field_71441_e.func_180495_p(it).func_177230_c() != Blocks.field_150486_ae) {
                blockToRemove.add(it);
            }
        });
        blockToRemove.forEach(this.highlightedBlocks::remove);
        blockToRemove.forEach(markedBlocks::remove);
    }

    @SubscribeEvent
    public void onBlockInteraction(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            markedBlocks.remove(event.pos);
            this.highlightedBlocks.remove(event.pos);
        }
    }

    @Override
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return;
        }
        for (BlockPos blockPos : this.highlightedBlocks) {
            RenderUtils.renderBoundingBox(blockPos, this.getColor(blockPos), event.partialTicks, false);
        }
    }

    @Override
    protected boolean isEnabled() {
        return "crystal_hollows".equals(SBInfo.getInstance().getLocation()) && NotEnoughUpdates.INSTANCE.config.world.highlightCrystalHollowChests;
    }

    @Override
    protected boolean isValidHighlightSpot(BlockPos key) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return false;
        }
        Block b = w.func_180495_p(key).func_177230_c();
        return b == Blocks.field_150486_ae;
    }

    @Override
    protected int getColor(BlockPos blockPos) {
        return SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.world.crystalHollowChestColor);
    }
}

