/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial;

import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistTaskQueue;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistTutorial;
import io.github.moulberry.notenoughupdates.util.KotlinStringUtilsKt;
import io.github.moulberry.notenoughupdates.util.TabListUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/tablisttutorial/TablistAPI;", "", "()V", "lastWidgetEnabled", "Lio/github/moulberry/notenoughupdates/miscfeatures/tablisttutorial/TablistAPI$WidgetNames;", "getLastWidgetEnabled", "()Lio/github/moulberry/notenoughupdates/miscfeatures/tablisttutorial/TablistAPI$WidgetNames;", "setLastWidgetEnabled", "(Lio/github/moulberry/notenoughupdates/miscfeatures/tablisttutorial/TablistAPI$WidgetNames;)V", "lastWorldSwitch", "", "getOptionalWidgetLines", "", "", "widgetName", "getWidgetLines", "getWidgetLinesInRegion", "widget", "Lio/github/moulberry/notenoughupdates/miscfeatures/tablisttutorial/TablistTutorial$TabListWidget;", "addToQueue", "", "showNotification", "getWidgetLinesWithoutNotification", "onWorldSwitch", "", "event", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "WidgetNames", "NotEnoughUpdates"})
public final class TablistAPI {
    @NotNull
    public static final TablistAPI INSTANCE = new TablistAPI();
    private static long lastWorldSwitch;
    @Nullable
    private static WidgetNames lastWidgetEnabled;

    private TablistAPI() {
    }

    @Nullable
    public final WidgetNames getLastWidgetEnabled() {
        return lastWidgetEnabled;
    }

    public final void setLastWidgetEnabled(@Nullable WidgetNames widgetNames) {
        lastWidgetEnabled = widgetNames;
    }

    @SubscribeEvent
    public final void onWorldSwitch(@NotNull EntityJoinWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.entity, (Object)Minecraft.func_71410_x().field_71439_g)) {
            lastWorldSwitch = System.nanoTime();
        }
    }

    @JvmStatic
    @NotNull
    public static final List<String> getWidgetLinesInRegion(@NotNull TablistTutorial.TabListWidget widget, boolean addToQueue, boolean showNotification) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Regex regex = widget.getWidgetName().getRegex();
        if (regex == null) {
            regex = Regex.Companion.fromLiteral("" + (Object)((Object)widget.getWidgetName()) + ':');
        }
        Regex regex2 = regex;
        List list = new ArrayList();
        boolean sawReset = false;
        for (String entry : TabListUtils.getTabList()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            if (StringsKt.contains$default((CharSequence)entry, (CharSequence)"\u00a7r", (boolean)false, (int)2, null)) {
                sawReset = true;
            }
            if (!((Collection)list).isEmpty()) {
                if (Intrinsics.areEqual((Object)entry, (Object)"\u00a7r") || StringsKt.startsWith$default((String)entry, (String)"\u00a7r\u00a7", (boolean)false, (int)2, null)) break;
                if (Intrinsics.areEqual((Object)entry, (Object)"\u00a7r               \u00a7r\u00a73\u00a7lInfo\u00a7r")) continue;
                list.add(entry);
                continue;
            }
            if (!regex2.matches((CharSequence)KotlinStringUtilsKt.stripControlCodes(entry))) continue;
            list.add(entry);
        }
        if (addToQueue && list.isEmpty() && sawReset && System.nanoTime() - lastWorldSwitch > 10000000000L) {
            if (widget.getWidgetName() != lastWidgetEnabled) {
                TablistTaskQueue.INSTANCE.addToQueue(widget, showNotification);
            }
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final List<String> getWidgetLines(@NotNull WidgetNames widgetName) {
        Intrinsics.checkNotNullParameter((Object)((Object)widgetName), (String)"widgetName");
        return TablistAPI.getWidgetLinesInRegion(new TablistTutorial.TabListWidget("CURRENT_REGION", widgetName), true, true);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getWidgetLinesWithoutNotification(@NotNull WidgetNames widgetName) {
        Intrinsics.checkNotNullParameter((Object)((Object)widgetName), (String)"widgetName");
        return TablistAPI.getWidgetLinesInRegion(new TablistTutorial.TabListWidget("CURRENT_REGION", widgetName), true, false);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getOptionalWidgetLines(@NotNull WidgetNames widgetName) {
        Intrinsics.checkNotNullParameter((Object)((Object)widgetName), (String)"widgetName");
        return TablistAPI.getWidgetLinesInRegion(new TablistTutorial.TabListWidget("CURRENT_REGION", widgetName), false, false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/tablisttutorial/TablistAPI$WidgetNames;", "", "regex", "Lkotlin/text/Regex;", "(Ljava/lang/String;ILkotlin/text/Regex;)V", "getRegex", "()Lkotlin/text/Regex;", "toString", "", "COMMISSIONS", "SKILLS", "DUNGEON_SKILLS", "TRAPPER", "FORGE", "POWDER", "PROFILE", "ACTIVE_EFFECTS", "COOKIE_BUFF", "PET", "NotEnoughUpdates"})
    public static final class WidgetNames
    extends Enum<WidgetNames> {
        @Nullable
        private final Regex regex;
        public static final /* enum */ WidgetNames COMMISSIONS = new WidgetNames(null);
        public static final /* enum */ WidgetNames SKILLS = new WidgetNames(new Regex("Skills:( .*)?"));
        public static final /* enum */ WidgetNames DUNGEON_SKILLS = new WidgetNames(new Regex("Skills: (.*)"));
        public static final /* enum */ WidgetNames TRAPPER = new WidgetNames(null);
        public static final /* enum */ WidgetNames FORGE = new WidgetNames(new Regex("Forges:( \\(\\d/\\d\\))?"));
        public static final /* enum */ WidgetNames POWDER = new WidgetNames(Regex.Companion.fromLiteral("Powders:"));
        public static final /* enum */ WidgetNames PROFILE = new WidgetNames(new Regex("Profile: ([A-Za-z]+)( .*)?"));
        public static final /* enum */ WidgetNames ACTIVE_EFFECTS = new WidgetNames(new Regex("Active Effects(: \\(\\d+\\))?"));
        public static final /* enum */ WidgetNames COOKIE_BUFF = new WidgetNames(new Regex("Cookie Buff"));
        public static final /* enum */ WidgetNames PET = new WidgetNames(null);
        private static final /* synthetic */ WidgetNames[] $VALUES;

        private WidgetNames(Regex regex) {
            this.regex = regex;
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @NotNull
        public String toString() {
            String string = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String[] stringArray = new String[]{"_"};
            return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null);
        }

        public static WidgetNames[] values() {
            return (WidgetNames[])$VALUES.clone();
        }

        public static WidgetNames valueOf(String value) {
            return Enum.valueOf(WidgetNames.class, value);
        }

        static {
            $VALUES = widgetNamesArray = new WidgetNames[]{WidgetNames.COMMISSIONS, WidgetNames.SKILLS, WidgetNames.DUNGEON_SKILLS, WidgetNames.TRAPPER, WidgetNames.FORGE, WidgetNames.POWDER, WidgetNames.PROFILE, WidgetNames.ACTIVE_EFFECTS, WidgetNames.COOKIE_BUFF, WidgetNames.PET};
        }
    }
}

