/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.Category;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.FamilyData;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.Mob;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.MobKillData;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.MobLevelData;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.KotlinNumberUtilsKt;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004H\u0002J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0007J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001e2\u0006\u0010\b\u001a\u00020\tH\u0007J`\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00052\"\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070#j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0007`$2\"\u0010%\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070#j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0007`$H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/BestiaryData;", "", "()V", "categoriesToParse", "", "", "calculateBestiarySkyblockXp", "", "profileInfo", "Lcom/google/gson/JsonObject;", "calculateFamilyData", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/FamilyData;", "mobs", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/Mob;", "calculateFamilyDataOfSubcategories", "subCategories", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/Category;", "calculateLevel", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/MobLevelData;", "bracket", "kills", "", "cap", "calculateTotalBestiaryTiers", "computedCategories", "countTotalLevels", "category", "hasMigrated", "", "parseBestiaryData", "", "parseCategory", "categoryData", "categoryId", "killsMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "deathsMap", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nBestiaryData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BestiaryData.kt\nio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/BestiaryData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1855#2,2:286\n1855#2,2:288\n1549#2:290\n1620#2,3:291\n1549#2:294\n1620#2,3:295\n1549#2:298\n1620#2,3:299\n*S KotlinDebug\n*F\n+ 1 BestiaryData.kt\nio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/bestiary/BestiaryData\n*L\n59#1:286,2\n91#1:288,2\n187#1:290\n187#1:291,3\n206#1:294\n206#1:295,3\n228#1:298\n228#1:299,3\n*E\n"})
public final class BestiaryData {
    @NotNull
    public static final BestiaryData INSTANCE = new BestiaryData();
    @NotNull
    private static final List<String> categoriesToParse;

    private BestiaryData() {
    }

    @JvmStatic
    public static final int calculateTotalBestiaryTiers(@NotNull List<Category> computedCategories) {
        Intrinsics.checkNotNullParameter(computedCategories, (String)"computedCategories");
        double tiers = 0.0;
        Iterable $this$forEach$iv = computedCategories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Category it = (Category)element$iv;
            boolean bl = false;
            tiers += (double)INSTANCE.countTotalLevels(it);
        }
        return (int)tiers;
    }

    @JvmStatic
    public static final int calculateBestiarySkyblockXp(@NotNull JsonObject profileInfo2) {
        Intrinsics.checkNotNullParameter((Object)profileInfo2, (String)"profileInfo");
        int totalTiers = BestiaryData.calculateTotalBestiaryTiers(BestiaryData.parseBestiaryData(profileInfo2));
        int skyblockXp = 0;
        JsonObject jsonObject = Constants.SBLEVELS.getAsJsonObject("slaying_task");
        if (jsonObject == null) {
            return 0;
        }
        JsonObject slayingTask = jsonObject;
        JsonElement jsonElement = slayingTask.get("bestiary_family_xp");
        if (jsonElement == null) {
            return 0;
        }
        int xpPerTier = jsonElement.getAsInt();
        int xpPerMilestone = slayingTask.get("bestiary_milestone_xp").getAsInt();
        int maxXp = slayingTask.get("bestiary_progress").getAsInt();
        skyblockXp += totalTiers * xpPerTier;
        int milestones = totalTiers / 100;
        return Math.min(skyblockXp += milestones * xpPerMilestone, maxXp);
    }

    private final int countTotalLevels(Category category) {
        int levels = 0;
        for (Mob mob : category.getMobs()) {
            levels += mob.getMobLevelData().getLevel();
        }
        Iterable $this$forEach$iv = category.getSubCategories();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Category it = (Category)element$iv;
            boolean bl = false;
            levels += INSTANCE.countTotalLevels(it);
        }
        return levels;
    }

    public final boolean hasMigrated(@NotNull JsonObject profileInfo2) {
        Intrinsics.checkNotNullParameter((Object)profileInfo2, (String)"profileInfo");
        JsonObject jsonObject = profileInfo2.getAsJsonObject("bestiary");
        if (jsonObject == null) {
            return false;
        }
        JsonObject bestiaryObject = jsonObject;
        return bestiaryObject.has("migration") ? bestiaryObject.get("migration").getAsBoolean() : true;
    }

    @JvmStatic
    @NotNull
    public static final List<Category> parseBestiaryData(@NotNull JsonObject profileInfo2) {
        Map map2;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)profileInfo2, (String)"profileInfo");
        if (!INSTANCE.hasMigrated(profileInfo2) || Constants.BESTIARY == null) {
            return new ArrayList();
        }
        List parsedCategories = new ArrayList();
        JsonObject jsonObject = profileInfo2.getAsJsonObject("bestiary");
        Intrinsics.checkNotNull((Object)jsonObject);
        JsonObject jsonObject2 = jsonObject.getAsJsonObject("kills");
        if (jsonObject2 == null) {
            return new ArrayList();
        }
        JsonObject apiKills = jsonObject2;
        JsonObject jsonObject3 = profileInfo2.getAsJsonObject("bestiary").getAsJsonObject("deaths");
        if (jsonObject3 == null) {
            return new ArrayList();
        }
        JsonObject apiDeaths = jsonObject3;
        HashMap<String, Integer> killsMap = new HashMap<String, Integer>();
        for (Map.Entry<String, JsonElement> entry : apiKills.entrySet()) {
            if (Intrinsics.areEqual((Object)entry.getKey(), (Object)"last_killed_mob")) continue;
            Map map3 = killsMap;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"entry.key");
            String string = entry.getValue().getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.value.asString");
            Integer n2 = StringsKt.toIntOrNull((String)string);
            n = n2 != null ? n2 : -1;
            map3.put(map2, n);
        }
        HashMap<String, Integer> deathsMap = new HashMap<String, Integer>();
        for (Map.Entry<String, JsonElement> entry : apiDeaths.entrySet()) {
            map2 = deathsMap;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"entry.key");
            String string = entry.getValue().getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.value.asString");
            Integer n3 = StringsKt.toIntOrNull((String)string);
            Integer n4 = n3 != null ? n3 : -1;
            map2.put(n, n4);
        }
        for (String categoryId : categoriesToParse) {
            JsonObject categoryData = Constants.BESTIARY.getAsJsonObject(categoryId);
            if (categoryData != null) {
                parsedCategories.add(INSTANCE.parseCategory(categoryData, categoryId, killsMap, deathsMap));
                continue;
            }
            Utils.showOutdatedRepoNotification("bestiary.json missing or outdated");
        }
        return parsedCategories;
    }

    /*
     * WARNING - void declaration
     */
    private final Category parseCategory(JsonObject categoryData, String categoryId, HashMap<String, Integer> killsMap, HashMap<String, Integer> deathsMap) {
        Collection collection;
        ItemStack categoryIcon;
        String categoryName = categoryData.get("name").getAsString();
        List computedMobs = new ArrayList();
        JsonObject categoryIconData = categoryData.get("icon").getAsJsonObject();
        ItemStack itemStack = categoryIcon = categoryIconData.has("skullOwner") ? Utils.createSkull(categoryName, categoryIconData.get("skullOwner").getAsString(), categoryIconData.get("texture").getAsString()) : ItemUtils.createItemStackFromId(categoryIconData.get("item").getAsString(), categoryName);
        if (categoryData.has("hasSubcategories")) {
            List subCategories = new ArrayList();
            String[] stringArray = new String[]{"name", "icon", "hasSubcategories"};
            List reserved = CollectionsKt.listOf((Object[])stringArray);
            for (Map.Entry entry : categoryData.entrySet()) {
                if (reserved.contains(entry.getKey())) continue;
                JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"entry.value.asJsonObject");
                subCategories.add(this.parseCategory(jsonObject, categoryId + '_' + (String)entry.getKey(), killsMap, deathsMap));
            }
            Intrinsics.checkNotNullExpressionValue((Object)categoryName, (String)"categoryName");
            Intrinsics.checkNotNullExpressionValue((Object)categoryIcon, (String)"categoryIcon");
            return new Category(categoryId, categoryName, categoryIcon, CollectionsKt.emptyList(), subCategories, this.calculateFamilyDataOfSubcategories(subCategories));
        }
        JsonArray jsonArray = categoryData.get("mobs").getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"categoryData[\"mobs\"].asJsonArray");
        Iterable $this$map$iv = jsonArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAsJsonObject());
        }
        List categoryMobs = (List)destination$iv$iv;
        for (JsonObject mobData : categoryMobs) {
            void $this$mapTo$iv$iv2;
            String string = mobData.get("name").getAsString();
            ItemStack mobIcon = mobData.has("skullOwner") ? Utils.createSkull(string, mobData.get("skullOwner").getAsString(), mobData.get("texture").getAsString()) : ItemUtils.createItemStackFromId(mobData.get("item").getAsString(), string);
            double cap = mobData.get("cap").getAsDouble();
            int bracket = mobData.get("bracket").getAsInt();
            double kills = 0.0;
            double deaths = 0.0;
            JsonArray jsonArray2 = mobData.get("mobs").getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray2, (String)"mobData[\"mobs\"].asJsonArray");
            Iterable $this$map$iv2 = jsonArray2;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getAsString());
            }
            List mobsArray = (List)destination$iv$iv2;
            for (String s : mobsArray) {
                Integer n = killsMap.getOrDefault(s, 0);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"killsMap.getOrDefault(s, 0)");
                kills += ((Number)n).doubleValue();
                Integer n2 = deathsMap.getOrDefault(s, 0);
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"deathsMap.getOrDefault(s, 0)");
                deaths += ((Number)n2).doubleValue();
            }
            MobLevelData levelData = this.calculateLevel(bracket, kills, cap);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mobName");
            Intrinsics.checkNotNullExpressionValue((Object)mobIcon, (String)"mobIcon");
            computedMobs.add(new Mob(string, mobIcon, kills, deaths, levelData));
        }
        Intrinsics.checkNotNullExpressionValue((Object)categoryName, (String)"categoryName");
        Intrinsics.checkNotNullExpressionValue((Object)categoryIcon, (String)"categoryIcon");
        return new Category(categoryId, categoryName, categoryIcon, computedMobs, CollectionsKt.emptyList(), this.calculateFamilyData(computedMobs));
    }

    /*
     * WARNING - void declaration
     */
    private final MobLevelData calculateLevel(int bracket, double kills, double cap) {
        double d;
        void $this$mapTo$iv$iv;
        JsonArray jsonArray = Constants.BESTIARY.get("brackets").getAsJsonObject().get(String.valueOf(bracket)).getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"Constants.BESTIARY[\"brac\u2026t.toString()].asJsonArray");
        Iterable $this$map$iv = jsonArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAsDouble());
        }
        List bracketData = (List)destination$iv$iv;
        boolean maxLevel = false;
        double progress = 0.0;
        double effKills = 0.0;
        double effReq = 0.0;
        if (kills >= cap) {
            maxLevel = true;
            d = cap;
        } else {
            d = kills;
        }
        double effectiveKills = d;
        double totalProgress = KotlinNumberUtilsKt.roundToDecimals(effectiveKills / cap * (double)100, 1);
        int level = 0;
        Iterator iterator = bracketData.iterator();
        while (iterator.hasNext()) {
            double requiredKills = ((Number)iterator.next()).doubleValue();
            if (effectiveKills >= requiredKills) {
                ++level;
                continue;
            }
            int prevTierKills = level != 0 ? (int)((Number)bracketData.get(RangesKt.coerceAtLeast((int)(level - 1), (int)0))).doubleValue() : 0;
            effKills = kills - (double)prevTierKills;
            effReq = requiredKills - (double)prevTierKills;
            progress = KotlinNumberUtilsKt.roundToDecimals(effKills / effReq * (double)100, 1);
            break;
        }
        return new MobLevelData(level, maxLevel, progress, totalProgress, new MobKillData(effKills, effReq, effectiveKills, cap));
    }

    private final FamilyData calculateFamilyData(List<Mob> mobs) {
        int found = 0;
        int completed = 0;
        for (Mob mob : mobs) {
            if (mob.getKills() > 0.0) {
                ++found;
            }
            if (!mob.getMobLevelData().getMaxLevel()) continue;
            ++completed;
        }
        return new FamilyData(found, completed, mobs.size());
    }

    private final FamilyData calculateFamilyDataOfSubcategories(List<Category> subCategories) {
        int found = 0;
        int completed = 0;
        int total = 0;
        for (Category category : subCategories) {
            FamilyData data = category.getFamilyData();
            found += data.getFound();
            completed += data.getCompleted();
            total += data.getTotal();
        }
        return new FamilyData(found, completed, total);
    }

    static {
        Object[] objectArray = new String[]{"dynamic", "hub", "farming_1", "garden", "combat_1", "combat_3", "crimson_isle", "mining_2", "mining_3", "crystal_hollows", "foraging_1", "spooky_festival", "mythological_creatures", "jerry", "kuudra", "catacombs", "fishing"};
        categoriesToParse = CollectionsKt.listOf((Object[])objectArray);
    }
}

