/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.entityviewer;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.EntityViewerModifier;
import io.github.moulberry.notenoughupdates.util.Utils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class EquipmentModifier
extends EntityViewerModifier {
    private ItemStack createItem(String item) {
        NEUManager manager = NotEnoughUpdates.INSTANCE.manager;
        String[] split = item.split("#");
        if (split.length == 2) {
            switch (split[0].intern()) {
                case "SKULL": {
                    return Utils.createSkull("Placeholder Skull", "00000000-0000-0000-0000-000000000000", split[1]);
                }
                case "LEATHER_LEGGINGS": {
                    return this.coloredLeatherArmor(Items.field_151026_S, split[1]);
                }
                case "LEATHER_HELMET": {
                    return this.coloredLeatherArmor(Items.field_151024_Q, split[1]);
                }
                case "LEATHER_CHESTPLATE": {
                    return this.coloredLeatherArmor(Items.field_151027_R, split[1]);
                }
                case "LEATHER_BOOTS": {
                    return this.coloredLeatherArmor(Items.field_151021_T, split[1]);
                }
            }
            throw new RuntimeException("Unknown leather piece: " + item);
        }
        return manager.createItem(item);
    }

    private ItemStack coloredLeatherArmor(ItemArmor item, String colorHex) {
        ItemStack is = new ItemStack((Item)item);
        item.func_82813_b(is, Integer.parseInt(colorHex, 16));
        return is;
    }

    @Override
    public EntityLivingBase applyModifier(EntityLivingBase base, JsonObject info) {
        if (info.has("hand")) {
            this.setCurrentItemOrArmor(base, 0, this.createItem(info.get("hand").getAsString()));
        }
        if (info.has("helmet")) {
            this.setCurrentItemOrArmor(base, 4, this.createItem(info.get("helmet").getAsString()));
        }
        if (info.has("chestplate")) {
            this.setCurrentItemOrArmor(base, 3, this.createItem(info.get("chestplate").getAsString()));
        }
        if (info.has("leggings")) {
            this.setCurrentItemOrArmor(base, 2, this.createItem(info.get("leggings").getAsString()));
        }
        if (info.has("feet")) {
            this.setCurrentItemOrArmor(base, 1, this.createItem(info.get("feet").getAsString()));
        }
        return base;
    }

    public void setCurrentItemOrArmor(EntityLivingBase entity, int slot, ItemStack itemStack) {
        if (entity instanceof EntityPlayer) {
            EquipmentModifier.setPlayerCurrentItemOrArmor((EntityPlayer)entity, slot, itemStack);
        } else {
            entity.func_70062_b(slot, itemStack);
        }
    }

    public static void setPlayerCurrentItemOrArmor(EntityPlayer player, int slot, ItemStack itemStack) {
        if (slot == 0) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = itemStack;
        } else {
            player.field_71071_by.field_70460_b[slot - 1] = itemStack;
        }
    }
}

