/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.entityviewer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.AgeModifier;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.ChargedModifier;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.EntityViewerModifier;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.EquipmentModifier;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.GUIClientPlayer;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.HorseModifier;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.InvisibleModifier;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.NameModifier;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.RidingModifier;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.SkinModifier;
import io.github.moulberry.notenoughupdates.miscfeatures.entityviewer.WitherModifier;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class EntityViewer
extends GuiScreen {
    public static Map<String, Supplier<? extends EntityLivingBase>> validEntities = new HashMap<String, Supplier<? extends EntityLivingBase>>(){
        {
            this.put("Zombie", () -> new EntityZombie(null));
            this.put("Chicken", () -> new EntityChicken(null));
            this.put("Slime", () -> new EntitySlime(null));
            this.put("Wolf", () -> new EntityWolf(null));
            this.put("Skeleton", () -> new EntitySkeleton(null));
            this.put("Creeper", () -> new EntityCreeper(null));
            this.put("Ocelot", () -> new EntityOcelot(null));
            this.put("Blaze", () -> new EntityBlaze(null));
            this.put("Rabbit", () -> new EntityRabbit(null));
            this.put("Sheep", () -> new EntitySheep(null));
            this.put("Horse", () -> new EntityHorse(null));
            this.put("Eisengolem", () -> new EntityIronGolem(null));
            this.put("Silverfish", () -> new EntitySilverfish(null));
            this.put("Witch", () -> new EntityWitch(null));
            this.put("Endermite", () -> new EntityEndermite(null));
            this.put("Snowman", () -> new EntitySnowman(null));
            this.put("Villager", () -> new EntityVillager(null));
            this.put("Guardian", () -> new EntityGuardian(null));
            this.put("ArmorStand", () -> new EntityArmorStand(null));
            this.put("Squid", () -> new EntitySquid(null));
            this.put("Bat", () -> new EntityBat(null));
            this.put("Spider", () -> new EntitySpider(null));
            this.put("CaveSpider", () -> new EntityCaveSpider(null));
            this.put("Pigman", () -> new EntityPigZombie(null));
            this.put("Ghast", () -> new EntityGhast(null));
            this.put("MagmaCube", () -> new EntityMagmaCube(null));
            this.put("Wither", () -> new EntityWither(null));
            this.put("Enderman", () -> new EntityEnderman(null));
            this.put("Mooshroom", () -> new EntityMooshroom(null));
            this.put("WitherSkeleton", () -> {
                EntitySkeleton skeleton = new EntitySkeleton(null);
                skeleton.func_82201_a(1);
                return skeleton;
            });
            this.put("Cow", () -> new EntityCow(null));
            this.put("Dragon", () -> new EntityDragon(null));
            this.put("Player", () -> new GUIClientPlayer());
            this.put("Pig", () -> new EntityPig(null));
            this.put("Giant", () -> new EntityGiantZombie(null));
        }
    };
    public static Map<String, EntityViewerModifier> validModifiers = new HashMap<String, EntityViewerModifier>(){
        {
            this.put("playerdata", new SkinModifier());
            this.put("equipment", new EquipmentModifier());
            this.put("riding", new RidingModifier());
            this.put("charged", new ChargedModifier());
            this.put("witherdata", new WitherModifier());
            this.put("invisible", new InvisibleModifier());
            this.put("age", new AgeModifier());
            this.put("horse", new HorseModifier());
            this.put("name", new NameModifier());
        }
    };
    public int guiLeft = 0;
    public int guiTop = 0;
    public int xSize = 176;
    public int ySize = 166;
    private final String label;
    private final EntityLivingBase entity;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("notenoughupdates", "textures/gui/entity_viewer.png");

    public EntityViewer(String label, EntityLivingBase entity) {
        this.label = label;
        this.entity = entity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EntityLivingBase constructEntity(ResourceLocation resourceLocation) {
        Gson gson = NotEnoughUpdates.INSTANCE.manager.gson;
        try (InputStreamReader is = new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b(), StandardCharsets.UTF_8);){
            EntityLivingBase entityLivingBase = EntityViewer.constructEntity(gson.fromJson((Reader)is, JsonObject.class));
            return entityLivingBase;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static EntityLivingBase constructEntity(JsonObject info) {
        List<JsonObject> modifiers = info.has("modifiers") ? StreamSupport.stream(info.get("modifiers").getAsJsonArray().spliterator(), false).map(JsonElement::getAsJsonObject).collect(Collectors.toList()) : Collections.emptyList();
        return EntityViewer.constructEntity(info.get("entity").getAsString(), modifiers);
    }

    public static EntityLivingBase constructEntity(String string, String[] modifiers) {
        Gson gson = NotEnoughUpdates.INSTANCE.manager.gson;
        return EntityViewer.constructEntity(string, Arrays.stream(modifiers).map(it -> gson.fromJson((String)it, JsonObject.class)).collect(Collectors.toList()));
    }

    public static EntityLivingBase constructEntity(String string, List<JsonObject> modifiers) {
        Supplier<? extends EntityLivingBase> aClass = validEntities.get(string);
        if (aClass == null) {
            System.err.println("Could not find entity of type: " + string);
            return null;
        }
        try {
            JsonObject modifier;
            String type2;
            EntityViewerModifier entityViewerModifier;
            EntityLivingBase entity = aClass.get();
            Iterator<JsonObject> iterator = modifiers.iterator();
            while (iterator.hasNext() && (entity = (entityViewerModifier = validModifiers.get(type2 = (modifier = iterator.next()).get("type").getAsString())).applyModifier(entity, modifier)) != null) {
            }
            return entity;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        Utils.drawStringScaledMaxWidth(this.label, this.guiLeft + 10, this.guiTop + 10, false, 100, 0xFF00FF);
        EntityViewer.renderEntity(this.entity, this.guiLeft + 90, this.guiTop + 75, mouseX, mouseY);
    }

    public static void renderEntity(EntityLivingBase entity, int posX, int posY, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scale = 30;
        float bottomOffset = 0.0f;
        EntityLivingBase stack = entity;
        while (true) {
            if (stack instanceof EntityDragon) {
                if (Keyboard.isKeyDown((int)57)) {
                    scale = 35;
                    bottomOffset = 0.0f;
                } else {
                    scale = 10;
                    bottomOffset = 2.0f;
                }
            } else if (stack instanceof EntityWither) {
                scale = 20;
            } else if (stack instanceof EntityGhast) {
                scale = 8;
                bottomOffset = 4.0f;
            } else if (stack instanceof EntityGiantZombie) {
                scale = 8;
                bottomOffset = -2.0f;
            }
            stack.field_70173_aa = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
            EntityViewer.drawEntityOnScreen(posX, (int)((float)posY - bottomOffset * (float)scale), scale, posX - mouseX, (int)((float)posY - stack.func_70047_e() * (float)scale - (float)mouseY), stack);
            bottomOffset = (float)((double)bottomOffset + stack.func_70042_X());
            if (!(stack.field_70153_n instanceof EntityLivingBase)) break;
            stack = (EntityLivingBase)stack.field_70153_n;
        }
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float g = ent.field_70177_z;
        float h = ent.field_70125_A;
        float i = ent.field_70758_at;
        float j = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)(ent instanceof EntityDragon ? 45.0f : -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(ent instanceof EntityDragon ? (float)Math.atan(mouseY / 40.0f) * 20.0f : -((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.func_178631_a(180.0f);
        renderManager.func_178633_a(false);
        renderManager.func_147940_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        renderManager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = g;
        ent.field_70125_A = h;
        ent.field_70758_at = i;
        ent.field_70759_as = j;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }
}

