/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.ProfileDataLoadedEvent;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewerUtils;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PowerStoneStatsDisplay {
    private static PowerStoneStatsDisplay instance = null;
    private boolean dirty = true;

    public static PowerStoneStatsDisplay getInstance() {
        if (instance == null) {
            instance = new PowerStoneStatsDisplay();
        }
        return instance;
    }

    @SubscribeEvent
    public void onProfileDataLoaded(ProfileDataLoadedEvent event) {
        JsonObject profileInfo2 = event.getProfileInfo();
        if (profileInfo2 == null) {
            return;
        }
        JsonArray inventoryInfo = ProfileViewerUtils.readInventoryInfo(profileInfo2, "talisman_bag");
        if (inventoryInfo == null) {
            return;
        }
        NEUConfig.HiddenProfileSpecific configProfileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (configProfileSpecific == null) {
            return;
        }
        configProfileSpecific.magicalPower = ProfileViewerUtils.getMagicalPower(inventoryInfo, profileInfo2);
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (!NotEnoughUpdates.INSTANCE.config.tooltipTweaks.powerStoneStats) {
            return;
        }
        if (!this.dirty) {
            return;
        }
        if (!Utils.getOpenChestName().equals("Your Bags")) {
            return;
        }
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        Container openContainer = p.field_71070_bA;
        for (Slot slot : openContainer.field_75151_b) {
            String displayName;
            ItemStack stack = slot.func_75211_c();
            if (stack == null || !"\u00a7aAccessory Bag".equals(displayName = stack.func_82833_r())) continue;
            this.dirty = false;
            for (String line : ItemUtils.getLore(stack)) {
                if (!line.startsWith("\u00a77Magical Power: ")) continue;
                String rawNumber = line.split("\u00a76")[1].replace(",", "");
                NEUConfig.HiddenProfileSpecific configProfileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
                if (configProfileSpecific == null) {
                    return;
                }
                configProfileSpecific.magicalPower = Integer.parseInt(rawNumber);
            }
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui != null) {
            this.dirty = true;
        }
    }

    @SubscribeEvent
    public void onItemTooltipLow(ItemTooltipEvent event) {
        if (!NotEnoughUpdates.INSTANCE.config.tooltipTweaks.powerStoneStats) {
            return;
        }
        ItemStack itemStack = event.itemStack;
        if (itemStack == null) {
            return;
        }
        List<String> lore = ItemUtils.getLore(itemStack);
        boolean isPowerStone = false;
        for (String line : lore) {
            if (!line.equals("\u00a78Power Stone")) continue;
            isPowerStone = true;
            break;
        }
        if (!isPowerStone) {
            return;
        }
        NEUConfig.HiddenProfileSpecific configProfileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (configProfileSpecific == null) {
            return;
        }
        int magicalPower = configProfileSpecific.magicalPower;
        if (magicalPower < 1) {
            return;
        }
        double scaledMagicalPower = this.scalePower(magicalPower);
        double scaledCurrentPower = 0.0;
        int index = 0;
        boolean foundMagicalPower = false;
        for (String line : new LinkedList<String>(lore)) {
            ++index;
            if ((line = line.replace("\u00a7k", "")).startsWith("\u00a77At ")) {
                String rawNumber = StringUtils.substringBetween(StringUtils.cleanColour(line), "At ", " Magical");
                if (rawNumber == null) {
                    return;
                }
                if (rawNumber.equals("mmm")) {
                    return;
                }
                try {
                    scaledCurrentPower = this.scalePower(StringUtils.cleanAndParseInt(rawNumber));
                }
                catch (NumberFormatException ignored) {
                    return;
                }
                event.toolTip.set(index, "\u00a77At \u00a76" + StringUtils.formatNumber(magicalPower) + " Magical Power\u00a77:");
                foundMagicalPower = true;
                continue;
            }
            if (!foundMagicalPower) continue;
            String cleanLine = StringUtils.cleanColour(line);
            if (cleanLine.equals("")) break;
            for (String operator : new String[]{"+", "-"}) {
                double currentStat;
                if (!cleanLine.startsWith(operator)) continue;
                String rawStat = StringUtils.cleanColour(StringUtils.substringBetween(line, operator, " "));
                try {
                    currentStat = 0.0 + (double)StringUtils.cleanAndParseInt(rawStat.substring(0, rawStat.length() - 1));
                }
                catch (NumberFormatException ignored) {
                    continue;
                }
                double realStat = currentStat / scaledCurrentPower * scaledMagicalPower;
                String format2 = StringUtils.formatNumber(Math.round(realStat));
                format2 = format2 + rawStat.substring(rawStat.length() - 1);
                event.toolTip.set(index, line.replace(rawStat, format2));
            }
        }
    }

    private double scalePower(int magicalPower) {
        return Math.pow(29.97 * Math.log(0.0019 * (double)magicalPower + 1.0), 1.2);
    }
}

