/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.util.ReverseWorldRenderer;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class NullzeeSphere {
    public static boolean enabled = false;
    public static float size = 20.0f;
    public static BlockPos centerPos = new BlockPos(0, 0, 0);
    public static ReverseWorldRenderer overlayVBO = null;
    long lastUpdate = 0L;
    private static double posLastUpdateX;
    private static double posLastUpdateY;
    private static double posLastUpdateZ;

    public ReverseWorldRenderer getOverlayVBO() {
        if (overlayVBO != null) {
            return overlayVBO;
        }
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (p == null) {
            return null;
        }
        Set<BlockPos> circleOffsets = this.getCircleOffsets(size);
        ReverseWorldRenderer worldRenderer = new ReverseWorldRenderer(196 * circleOffsets.size());
        worldRenderer.begin(7, DefaultVertexFormats.field_181706_f);
        String col = SpecialColour.special(0, 180, -26368);
        for (BlockPos offset : circleOffsets) {
            BlockPos overlayPos = new BlockPos(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
            AxisAlignedBB bb = new AxisAlignedBB((double)overlayPos.func_177958_n(), (double)overlayPos.func_177956_o(), (double)overlayPos.func_177952_p(), (double)(overlayPos.func_177958_n() + 1), (double)(overlayPos.func_177956_o() + 1), (double)(overlayPos.func_177952_p() + 1)).func_72314_b((double)0.001f, (double)0.001f, (double)0.001f);
            NullzeeSphere.uploadFilledBoundingBox(bb, 1.0f, col, worldRenderer);
        }
        overlayVBO = worldRenderer;
        return overlayVBO;
    }

    public Set<BlockPos> getCircleOffsets(float radius) {
        HashSet<BlockPos> circleOffsets = new HashSet<BlockPos>();
        int radiusI = (int)Math.ceil(radius) + 1;
        for (int x = -radiusI; x <= radiusI; ++x) {
            for (int y = -radiusI; y <= radiusI; ++y) {
                for (int z = -radiusI; z <= radiusI; ++z) {
                    float distSq = x * x + y * y + z * z;
                    if (!((double)distSq >= ((double)radius - 0.5) * ((double)radius - 0.5)) || !((double)distSq <= ((double)radius + 0.5) * ((double)radius + 0.5))) continue;
                    circleOffsets.add(new BlockPos(x, y, z));
                }
            }
        }
        return circleOffsets;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!enabled) {
            return;
        }
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (p == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            double dX = p.field_70165_t - posLastUpdateX;
            double dY = p.field_70163_u - posLastUpdateY;
            double dZ = p.field_70161_v - posLastUpdateZ;
            if (dX * dX + dY * dY + dZ * dZ < 1.0) {
                return;
            }
            posLastUpdateX = p.field_70165_t;
            posLastUpdateY = p.field_70163_u;
            posLastUpdateZ = p.field_70161_v;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUpdate < 250L) {
                return;
            }
            this.lastUpdate = currentTime;
            ReverseWorldRenderer worldRenderer = this.getOverlayVBO();
            if (worldRenderer != null) {
                worldRenderer.setTranslation(0.0, 0.0, 0.0);
                worldRenderer.sortVertexData((float)p.field_70165_t - (float)centerPos.func_177958_n(), (float)p.field_70163_u - (float)centerPos.func_177956_o(), (float)p.field_70161_v - (float)centerPos.func_177952_p());
            }
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (!enabled) {
            return;
        }
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)event.partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)event.partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)event.partialTicks;
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        GlStateManager.func_179137_b((double)(-viewerX), (double)(-viewerY), (double)(-viewerZ));
        GL11.glPolygonOffset((float)5.0f, (float)5.0f);
        ReverseWorldRenderer worldRenderer = this.getOverlayVBO();
        if (worldRenderer != null && worldRenderer.getVertexCount() > 0) {
            VertexFormatElement vertexformatelement;
            int index;
            GlStateManager.func_179109_b((float)centerPos.func_177958_n(), (float)centerPos.func_177956_o(), (float)centerPos.func_177952_p());
            VertexFormat vertexformat = worldRenderer.getVertexFormat();
            int stride = vertexformat.func_177338_f();
            ByteBuffer bytebuffer = worldRenderer.getByteBuffer();
            List list = vertexformat.func_177343_g();
            for (index = 0; index < list.size(); ++index) {
                vertexformatelement = (VertexFormatElement)list.get(index);
                vertexformatelement.func_177375_c().preDraw(vertexformat, index, stride, bytebuffer);
            }
            GL11.glDrawArrays((int)worldRenderer.getDrawMode(), (int)0, (int)worldRenderer.getVertexCount());
            for (index = 0; index < list.size(); ++index) {
                vertexformatelement = (VertexFormatElement)list.get(index);
                vertexformatelement.func_177375_c().postDraw(vertexformat, index, stride, bytebuffer);
            }
            GlStateManager.func_179109_b((float)(-centerPos.func_177958_n()), (float)(-centerPos.func_177956_o()), (float)(-centerPos.func_177952_p()));
        }
        GL11.glPolygonOffset((float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)viewerX, (double)viewerY, (double)viewerZ);
        GlStateManager.func_179098_w();
    }

    public static void uploadFilledBoundingBox(AxisAlignedBB p_181561_0_, float alpha, String special, ReverseWorldRenderer worldrenderer) {
        Color c = new Color(SpecialColour.specialToChromaRGB(special), true);
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
    }
}

