/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.render.TextRenderUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.CustomItemEffects;
import io.github.moulberry.notenoughupdates.overlays.MiningOverlay;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Map;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MiningStuff {
    private static BlockPos overlayLoc = null;
    private static long titaniumNotifMillis = 0L;
    private static Minecraft mc;

    public MiningStuff() {
        mc = Minecraft.func_71410_x();
    }

    public static void processBlockChangePacket(S23PacketBlockChange packetIn) {
        if (!NotEnoughUpdates.INSTANCE.config.mining.titaniumAlert) {
            return;
        }
        IBlockState state = packetIn.func_180728_a();
        if (SBInfo.getInstance().getLocation() != null && SBInfo.getInstance().getLocation().startsWith("mining_") && state.func_177230_c() == Blocks.field_150348_b && state.func_177229_b((IProperty)BlockStone.field_176247_a) == BlockStone.EnumType.DIORITE_SMOOTH) {
            for (Map.Entry<String, Float> entry : MiningOverlay.commissionProgress.entrySet()) {
                String s = entry.getKey();
                if (!s.contains("Titanium")) continue;
                if (entry.getValue().floatValue() == 1.0f) {
                    return;
                }
                BlockPos pos = packetIn.func_179827_b();
                IBlockState existingBlock = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
                if (existingBlock == null) {
                    return;
                }
                if (existingBlock.func_177230_c() == Blocks.field_150348_b && existingBlock.func_177229_b((IProperty)BlockStone.field_176247_a) == BlockStone.EnumType.DIORITE_SMOOTH) {
                    return;
                }
                if (!MiningStuff.checkIfAnyIsAir(MiningStuff.getAttachedBlocks(pos)) && NotEnoughUpdates.INSTANCE.config.mining.titaniumAlertMustBeVisible) {
                    return;
                }
                BlockPos player = Minecraft.func_71410_x().field_71439_g.func_180425_c();
                double distSq = pos.func_177951_i((Vec3i)player);
                if (distSq < 144.0) {
                    titaniumNotifMillis = System.currentTimeMillis();
                }
                return;
            }
        }
    }

    private static BlockPos[] getAttachedBlocks(BlockPos block) {
        BlockPos[] blocks = new BlockPos[]{new BlockPos(block.func_177958_n() - 1, block.func_177956_o(), block.func_177952_p()), new BlockPos(block.func_177958_n() + 1, block.func_177956_o(), block.func_177952_p()), new BlockPos(block.func_177958_n(), block.func_177956_o() - 1, block.func_177952_p()), new BlockPos(block.func_177958_n(), block.func_177956_o() + 1, block.func_177952_p()), new BlockPos(block.func_177958_n(), block.func_177956_o(), block.func_177952_p() - 1), new BlockPos(block.func_177958_n(), block.func_177956_o(), block.func_177952_p() + 1)};
        return blocks;
    }

    private static boolean checkIfAnyIsAir(BlockPos[] blocks) {
        for (BlockPos block : blocks) {
            if (!(MiningStuff.mc.field_71441_e.func_180495_p(block).func_177230_c() instanceof BlockAir)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (!NotEnoughUpdates.INSTANCE.config.mining.titaniumAlert) {
            return;
        }
        if (titaniumNotifMillis <= 0L) {
            return;
        }
        int delta = (int)(System.currentTimeMillis() - titaniumNotifMillis);
        int notifLen = 5000;
        int fadeLen = 500;
        if (delta > 0 && delta < notifLen && event.type == RenderGameOverlayEvent.ElementType.ALL) {
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(width / 2), (float)(height / 2), (float)0.0f);
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)4.0f);
            int colour1 = 204;
            int colour2 = 255;
            double factor = (Math.sin((double)(delta * 2) * Math.PI / 1000.0) + 1.0) / 2.0;
            int colour = (int)((double)colour1 * factor + (double)colour2 * (1.0 - factor));
            int alpha = 255;
            if (delta < fadeLen) {
                alpha = delta * 255 / fadeLen;
            } else if (delta > notifLen - fadeLen) {
                alpha = (notifLen - delta) * 255 / fadeLen;
            }
            if (alpha > 10) {
                TextRenderUtils.drawStringCenteredScaledMaxWidth("Titanium has spawned nearby!", 0.0f, 0.0f, true, width / 4 - 20, colour | colour << 8 | colour << 16 | alpha << 24);
            }
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void renderWorldLast(RenderWorldLastEvent event) {
        if (overlayLoc == null) {
            return;
        }
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)event.partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)event.partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)event.partialTicks;
        AxisAlignedBB bb = new AxisAlignedBB((double)overlayLoc.func_177958_n() - viewerX, (double)overlayLoc.func_177956_o() - viewerY, (double)overlayLoc.func_177952_p() - viewerZ, (double)(overlayLoc.func_177958_n() + 1) - viewerX, (double)(overlayLoc.func_177956_o() + 1) - viewerY, (double)(overlayLoc.func_177952_p() + 1) - viewerZ).func_72314_b((double)0.01f, (double)0.01f, (double)0.01f);
        GlStateManager.func_179129_p();
        CustomItemEffects.drawFilledBoundingBox(bb, 1.0f, SpecialColour.special(0, 100, 0xFF0000));
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
    }

    @SubscribeEvent
    public void onLoadWorld(WorldEvent.Load event) {
        overlayLoc = null;
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (!NotEnoughUpdates.INSTANCE.config.mining.puzzlerSolver) {
            overlayLoc = null;
            return;
        }
        if (event.message.func_150254_d().startsWith("\u00a7e[NPC] \u00a7dPuzzler") && event.message.func_150260_c().contains(":")) {
            String clean = Utils.cleanColour(event.message.func_150260_c());
            clean = clean.split(":")[1].trim();
            BlockPos pos = new BlockPos(181, 195, 135);
            for (int i = 0; i < clean.length(); ++i) {
                char c = clean.charAt(i);
                if (c == '\u25c0') {
                    pos = pos.func_177982_a(1, 0, 0);
                    continue;
                }
                if (c == '\u25b2') {
                    pos = pos.func_177982_a(0, 0, 1);
                    continue;
                }
                if (c == '\u25bc') {
                    pos = pos.func_177982_a(0, 0, -1);
                    continue;
                }
                if (c == '\u25b6') {
                    pos = pos.func_177982_a(-1, 0, 0);
                    continue;
                }
                return;
            }
            overlayLoc = pos;
        }
    }
}

