/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ItemCooldowns {
    private static final Pattern COOLDOWN_LORE = Pattern.compile("\\u00a78Cooldown: \\u00a7a(\\d+)s");
    private static final Pattern PICKAXE_ABILITY_ACTIVATION = Pattern.compile("\\u00a7r\\u00a7aYou used your \\u00a7r\\u00a7..+ \\u00a7r\\u00a7aPickaxe Ability!\\u00a7r");
    private static final Pattern BONZO_ABILITY_ACTIVATION = Pattern.compile("\\u00a7r\\u00a7aYour \\u00a7r\\u00a7[9|5](\\u269A )*Bonzo's Mask \\u00a7r\\u00a7asaved your life!\\u00a7r");
    private static final Pattern SPIRIT_ABILITY_ACTIVATION = Pattern.compile("\\u00a7r\\u00a76Second Wind Activated\\u00a7r\\u00a7a! \\u00a7r\\u00a7aYour Spirit Mask saved your life!\\u00a7r");
    private static final Pattern SPRAYONATOR_ACTIVATION = Pattern.compile("\u00a7r\u00a7a\u00a7lSPRAYONATOR! \u00a7r\u00a77You sprayed \u00a7r\u00a7aPlot \u00a7r\u00a77- \u00a7r\u00a7b.* \u00a7r\u00a77with \u00a7r\u00a7a.*\u00a7r\u00a77!\u00a7r");
    private static final Map<ItemStack, Float> durabilityOverrideMap = new HashMap<ItemStack, Float>();
    public static long pickaxeUseCooldownMillisRemaining = -1L;
    private static long treecapitatorCooldownMillisRemaining = -1L;
    private static long bonzomaskCooldownMillisRemaining = -1L;
    private static long spiritMaskCooldownMillisRemaining = -1L;
    private static long sprayonatorCooldownMillisRemaining = -1L;
    private static long grappleCooldownMillisRemaining = -1L;
    public static boolean firstLoad = true;
    public static long firstLoadMillis = 0L;
    private static long lastMillis = 0L;
    public static long pickaxeCooldown = -1L;
    private static long bonzoMaskCooldown = -1L;
    private static long spiritMaskCooldown = -1L;
    private static long sprayonatorCooldown = -1L;
    private static long grappleCooldown = 2000L;
    private static HashSet<String> grappleSetIds = new HashSet<String>(){
        {
            this.add("BAT_PERSON_BOOTS");
            this.add("BAT_PERSON_LEGGINGS");
            this.add("BAT_PERSON_CHESTPLATE");
            this.add("BAT_PERSON_HELMET");
        }
    };
    public static TreeMap<Long, BlockData> blocksClicked = new TreeMap();
    private static int tickCounter = 0;

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            Long key;
            if (tickCounter++ >= 200) {
                tickCounter = 0;
                pickaxeCooldown = -1L;
                bonzoMaskCooldown = -1L;
                spiritMaskCooldown = -1L;
                sprayonatorCooldown = -1L;
            }
            long currentTime = System.currentTimeMillis();
            if (firstLoad) {
                firstLoadMillis = currentTime;
                firstLoad = false;
            }
            while ((key = blocksClicked.floorKey(currentTime - 1500L)) != null) {
                blocksClicked.remove(key);
            }
            long millisDelta = currentTime - lastMillis;
            lastMillis = currentTime;
            durabilityOverrideMap.clear();
            if (pickaxeUseCooldownMillisRemaining >= 0L) {
                pickaxeUseCooldownMillisRemaining -= millisDelta;
            }
            if (treecapitatorCooldownMillisRemaining >= 0L) {
                treecapitatorCooldownMillisRemaining -= millisDelta;
            }
            if (bonzomaskCooldownMillisRemaining >= 0L) {
                bonzomaskCooldownMillisRemaining -= millisDelta;
            }
            if (spiritMaskCooldownMillisRemaining >= 0L) {
                spiritMaskCooldownMillisRemaining -= millisDelta;
            }
            if (sprayonatorCooldownMillisRemaining >= 0L) {
                sprayonatorCooldownMillisRemaining -= millisDelta;
            }
            if (grappleCooldownMillisRemaining >= 0L) {
                grappleCooldownMillisRemaining -= millisDelta;
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        blocksClicked.clear();
        if (pickaxeCooldown > 0L) {
            pickaxeUseCooldownMillisRemaining = 60000L;
        }
        pickaxeCooldown = -1L;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
            String internalname = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(held).resolveInternalName();
            if (internalname != null && grappleCooldownMillisRemaining < 0L && internalname.equals("GRAPPLING_HOOK") && Minecraft.func_71410_x().field_71439_g.field_71104_cf != null) {
                grappleCooldownMillisRemaining = ItemCooldowns.getGrappleCooldownWithArmor();
            }
        }
    }

    public static long getTreecapCooldownWithPet() {
        if (!NotEnoughUpdates.INSTANCE.config.itemOverlays.enableCooldownInItemDurability) {
            return 0L;
        }
        PetInfoOverlay.Pet pet = PetInfoOverlay.getCurrentPet();
        if (NotEnoughUpdates.INSTANCE.config.itemOverlays.enableMonkeyCheck && pet != null && pet.petLevel != null && pet.petType.equalsIgnoreCase("monkey") && pet.rarity.equals((Object)PetInfoOverlay.Rarity.LEGENDARY)) {
            return 2000 - (int)(2000.0 * (0.005 * (double)pet.petLevel.getCurrentLevel()));
        }
        return 2000L;
    }

    public static long getGrappleCooldownWithArmor() {
        if (!NotEnoughUpdates.INSTANCE.config.itemOverlays.enableGrappleOverlay) {
            return 0L;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack armorPiece = Minecraft.func_71410_x().field_71439_g.func_82169_q(i);
            String internal = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(armorPiece).resolveInternalName();
            if (internal != null) {
                if (grappleSetIds.contains(internal)) continue;
                return grappleCooldown;
            }
            return grappleCooldown;
        }
        return 0L;
    }

    public static void blockClicked(BlockPos pos) {
        long currentTime = System.currentTimeMillis();
        blocksClicked.put(currentTime, new BlockData(pos));
    }

    public static void processBlockChangePacket(S23PacketBlockChange packetIn) {
        BlockPos pos = packetIn.func_179827_b();
        ItemCooldowns.checkForBlockChange(pos, packetIn.field_148883_d);
    }

    public static void checkForBlockChange(BlockPos pos, IBlockState blockState) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            IBlockState oldState;
            BlockData oldBlockData = null;
            for (BlockData value : blocksClicked.values()) {
                if (!value.blockPos.equals((Object)pos)) continue;
                oldBlockData = value;
            }
            if (oldBlockData != null && ((oldState = oldBlockData.blockState).func_177230_c() == Blocks.field_150364_r || oldState.func_177230_c() == Blocks.field_150363_s) && blockState.func_177230_c() == Blocks.field_150350_a) {
                ItemCooldowns.onBlockMined();
            }
        });
    }

    public static void onBlockMined() {
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        String internalname = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(held).resolveInternalName();
        if (internalname != null && treecapitatorCooldownMillisRemaining < 0L && (internalname.equals("TREECAPITATOR_AXE") || internalname.equals("JUNGLE_AXE"))) {
            treecapitatorCooldownMillisRemaining = ItemCooldowns.getTreecapCooldownWithPet();
        }
    }

    private static boolean isPickaxe(String internalname) {
        if (internalname == null) {
            return false;
        }
        if (internalname.endsWith("_PICKAXE")) {
            return true;
        }
        if (internalname.contains("_DRILL_")) {
            char lastChar = internalname.charAt(internalname.length() - 1);
            return lastChar >= '0' && lastChar <= '9';
        }
        return internalname.equals("GEMSTONE_GAUNTLET") || internalname.equals("PICKONIMBUS") || internalname.equals("DIVAN_DRILL") || internalname.equals("BINGONIMBUS_2000");
    }

    @SubscribeEvent
    public void onChatMessage(ClientChatReceivedEvent event) {
        if (pickaxeCooldown != 0L && PICKAXE_ABILITY_ACTIVATION.matcher(event.message.func_150254_d()).matches()) {
            ItemCooldowns.findCooldownInTooltip(Item.PICKAXES);
            pickaxeUseCooldownMillisRemaining = pickaxeCooldown * 1000L;
        }
        if (NotEnoughUpdates.INSTANCE.config.itemOverlays.bonzoAbility && bonzoMaskCooldown != 0L && BONZO_ABILITY_ACTIVATION.matcher(event.message.func_150254_d()).matches()) {
            ItemCooldowns.findCooldownInTooltip(Item.BONZO_MASK);
            bonzomaskCooldownMillisRemaining = bonzoMaskCooldown * 1000L;
        }
        if (NotEnoughUpdates.INSTANCE.config.itemOverlays.spiritAbility && spiritMaskCooldown != 0L && SPIRIT_ABILITY_ACTIVATION.matcher(event.message.func_150254_d()).matches()) {
            ItemCooldowns.findCooldownInTooltip(Item.SPIRIT_MASK);
            spiritMaskCooldownMillisRemaining = spiritMaskCooldown * 1000L;
        }
        if (NotEnoughUpdates.INSTANCE.config.garden.sprayonatorCooldown && sprayonatorCooldown != 0L && SPRAYONATOR_ACTIVATION.matcher(event.message.func_150254_d()).matches()) {
            ItemCooldowns.findCooldownInTooltip(Item.SPIRIT_MASK);
            sprayonatorCooldownMillisRemaining = sprayonatorCooldown * 1000L;
        }
    }

    private static void findCooldownInTooltip(Item item) {
        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
            ItemCooldowns.setSpecificCooldown(stack, item);
        }
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70460_b[3];
        ItemCooldowns.setSpecificCooldown(stack, item);
    }

    private static void setSpecificCooldown(ItemStack stack, Item item) {
        String internalname;
        if (stack != null && stack.func_77942_o() && (internalname = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName()) != null) {
            switch (item) {
                case PICKAXES: {
                    if (!ItemCooldowns.isPickaxe(internalname)) break;
                    pickaxeCooldown = ItemCooldowns.setCooldown(stack);
                    break;
                }
                case BONZO_MASK: {
                    if (!internalname.equals("BONZO_MASK") && !internalname.equals("STARRED_BONZO_MASK")) break;
                    bonzoMaskCooldown = ItemCooldowns.setCooldown(stack);
                    break;
                }
                case SPIRIT_MASK: {
                    if (!internalname.equals("SPIRIT_MASK") && !internalname.equals("STARRED_SPIRIT_MASK")) break;
                    spiritMaskCooldown = ItemCooldowns.setCooldown(stack);
                    break;
                }
                case SPRAYONATOR: {
                    if (!internalname.equals("SPRAYONATOR")) break;
                    sprayonatorCooldown = ItemCooldowns.setCooldown(stack);
                }
            }
        }
    }

    private static int setCooldown(ItemStack stack) {
        for (String line : NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stack.func_77978_p())) {
            Matcher matcher = COOLDOWN_LORE.matcher(line);
            if (!matcher.find()) continue;
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static float getDurabilityOverride(ItemStack stack) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return -1.0f;
        }
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return -1.0f;
        }
        if (durabilityOverrideMap.containsKey(stack)) {
            return durabilityOverrideMap.get(stack).floatValue();
        }
        String internalname = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName();
        if (internalname == null) {
            durabilityOverrideMap.put(stack, Float.valueOf(-1.0f));
            return -1.0f;
        }
        if (ItemCooldowns.isPickaxe(internalname)) {
            ItemCooldowns.findCooldownInTooltip(Item.PICKAXES);
            if (NotEnoughUpdates.INSTANCE.config.itemOverlays.pickaxeAbility) {
                return ItemCooldowns.durabilityOverride(pickaxeUseCooldownMillisRemaining, pickaxeCooldown, stack);
            }
            return -1.0f;
        }
        if (internalname.equals("TREECAPITATOR_AXE") || internalname.equals("JUNGLE_AXE")) {
            if (treecapitatorCooldownMillisRemaining < 0L) {
                durabilityOverrideMap.put(stack, Float.valueOf(-1.0f));
                return -1.0f;
            }
            if (treecapitatorCooldownMillisRemaining > ItemCooldowns.getTreecapCooldownWithPet()) {
                return stack.func_77952_i();
            }
            float durability = (float)treecapitatorCooldownMillisRemaining / (float)ItemCooldowns.getTreecapCooldownWithPet();
            durabilityOverrideMap.put(stack, Float.valueOf(durability));
            return durability;
        }
        if (internalname.equals("GRAPPLING_HOOK")) {
            return (float)grappleCooldownMillisRemaining / 2000.0f;
        }
        if (NotEnoughUpdates.INSTANCE.config.itemOverlays.bonzoAbility && (internalname.equals("BONZO_MASK") || internalname.equals("STARRED_BONZO_MASK"))) {
            ItemCooldowns.findCooldownInTooltip(Item.BONZO_MASK);
            return ItemCooldowns.durabilityOverride(bonzomaskCooldownMillisRemaining, bonzoMaskCooldown, stack);
        }
        if (NotEnoughUpdates.INSTANCE.config.itemOverlays.spiritAbility && (internalname.equals("SPIRIT_MASK") || internalname.equals("STARRED_SPIRIT_MASK"))) {
            ItemCooldowns.findCooldownInTooltip(Item.SPIRIT_MASK);
            return ItemCooldowns.durabilityOverride(spiritMaskCooldownMillisRemaining, spiritMaskCooldown, stack);
        }
        if (NotEnoughUpdates.INSTANCE.config.garden.sprayonatorCooldown && internalname.equals("SPRAYONATOR")) {
            ItemCooldowns.findCooldownInTooltip(Item.SPRAYONATOR);
            return ItemCooldowns.durabilityOverride(sprayonatorCooldownMillisRemaining, sprayonatorCooldown, stack);
        }
        durabilityOverrideMap.put(stack, Float.valueOf(-1.0f));
        return -1.0f;
    }

    private static float durabilityOverride(float millisRemaining, long cooldown, ItemStack stack) {
        if (millisRemaining < 0.0f) {
            durabilityOverrideMap.put(stack, Float.valueOf(-1.0f));
            return -1.0f;
        }
        if (millisRemaining > (float)(cooldown * 1000L)) {
            return stack.func_77952_i();
        }
        float durability = (float)((double)millisRemaining / ((double)cooldown * 1000.0));
        durabilityOverrideMap.put(stack, Float.valueOf(durability));
        return durability;
    }

    static enum Item {
        PICKAXES,
        BONZO_MASK,
        SPIRIT_MASK,
        SPRAYONATOR;

    }

    public static class BlockData {
        public BlockPos blockPos;
        public IBlockState blockState;

        public BlockData(BlockPos pos) {
            this.blockPos = pos;
            this.blockState = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
        }
    }
}

