/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.ChromaColour;
import io.github.moulberry.notenoughupdates.events.SpawnParticleEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class FishingHelper {
    private static final FishingHelper INSTANCE = new FishingHelper();
    public PlayerWarningState warningState = PlayerWarningState.NOTHING;
    private int hookedWarningStateTicks = 0;
    public final HashMap<Integer, EntityFishHook> hookEntities = new HashMap();
    public final HashMap<WakeChain, List<Integer>> chains = new HashMap();
    private long lastCastRodMillis = 0L;
    private int pingDelayTicks = 0;
    private final List<Integer> pingDelayList = new ArrayList<Integer>();
    private int buildupSoundDelay = 0;
    private boolean playedSound = false;
    private static final ResourceLocation FISHING_WARNING_EXCLAM = new ResourceLocation("notenoughupdates:fishing_warning_exclam.png");
    private int tickCounter = 0;
    public static EnumParticleTypes type = EnumParticleTypes.BARRIER;
    private static final float ZERO_PITCH = 1.0f;
    private static final float MAX_PITCH = 0.1f;
    private static final float MAX_DISTANCE = 5.0f;

    public static FishingHelper getInstance() {
        return INSTANCE;
    }

    public boolean renderWarning() {
        if (this.warningState == PlayerWarningState.NOTHING) {
            return false;
        }
        if (!NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarning && this.warningState == PlayerWarningState.FISH_INCOMING) {
            return false;
        }
        if (!NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarningR && this.warningState == PlayerWarningState.FISH_HOOKED) {
            return false;
        }
        float offset = this.warningState == PlayerWarningState.FISH_HOOKED ? 0.5f : 0.0f;
        float centerOffset = 0.0625f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(FISHING_WARNING_EXCLAM);
        Utils.drawTexturedRect(centerOffset - 0.5f, -2.5f, 1.0f, 2.0f, 0.0f + offset, 0.5f + offset, 0.0f, 1.0f, 9728);
        return true;
    }

    public void onRenderBobber(EntityFishHook hook2) {
        if (Minecraft.func_71410_x().field_71439_g.field_71104_cf != hook2) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GL11.glDepthFunc((int)519);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        boolean isExclamationMarkPresent = this.renderWarning();
        GlStateManager.func_179139_a((double)0.1, (double)0.1, (double)1.0);
        this.drawFishingTimer(hook2, isExclamationMarkPresent);
        GL11.glDepthFunc((int)515);
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private void drawFishingTimer(EntityFishHook hook2, boolean isExclamationMarkPresent) {
        int color;
        if (!NotEnoughUpdates.INSTANCE.config.fishing.fishingTimer) {
            return;
        }
        float baseHeight = isExclamationMarkPresent ? 20.0f : 0.0f;
        int ticksExisted = hook2.field_70173_aa;
        float seconds = (float)ticksExisted / 20.0f;
        float maxSlugTime = 20.0f;
        PetInfoOverlay.Pet pet = PetInfoOverlay.getCurrentPet();
        if (NotEnoughUpdates.INSTANCE.config.fishing.enableSlugCheck && pet != null && pet.petLevel != null && pet.petType.equalsIgnoreCase("slug")) {
            double slugFactor = 0.005 * (double)pet.petLevel.getCurrentLevel();
            maxSlugTime = (float)((double)maxSlugTime * (1.0 - slugFactor));
        }
        if (seconds >= maxSlugTime) {
            color = ChromaColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.fishing.fishingTimerColor30SecPlus);
            if (NotEnoughUpdates.INSTANCE.config.fishing.fishingSound30Sec && !this.playedSound) {
                PositionedSound sound = new PositionedSound(new ResourceLocation("random.orb")){
                    {
                        this.field_147662_b = 50.0f;
                        this.field_147663_c = 2.0f;
                        this.field_147659_g = false;
                        this.field_147665_h = 0;
                        this.field_147666_i = ISound.AttenuationType.NONE;
                    }
                };
                float oldLevel = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.RECORDS);
                Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.RECORDS, 1.0f);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.RECORDS, oldLevel);
                this.playedSound = true;
            }
        } else {
            color = ChromaColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.fishing.fishingTimerColor);
            this.playedSound = false;
        }
        Utils.drawStringCentered(String.format("%.02fs", Float.valueOf(seconds)), 0.0f, -baseHeight - (float)Minecraft.func_71410_x().field_71466_p.field_78288_b, false, color);
    }

    public void addEntity(int entityId, Entity entity) {
        if (entity instanceof EntityFishHook) {
            long currentTime;
            long delay;
            this.hookEntities.put(entityId, (EntityFishHook)entity);
            if (((EntityFishHook)entity).field_146042_b == Minecraft.func_71410_x().field_71439_g && (delay = (currentTime = System.currentTimeMillis()) - this.lastCastRodMillis) > 0L && delay < 500L) {
                if (delay > 300L) {
                    delay = 300L;
                }
                this.pingDelayList.add(0, (int)delay);
            }
        }
    }

    public void removeEntity(int entityId) {
        this.hookEntities.remove(entityId);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.hookEntities.clear();
        this.chains.clear();
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        long currentTime;
        ItemStack heldItem;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR && event.entityPlayer == Minecraft.func_71410_x().field_71439_g && (heldItem = event.entityPlayer.func_70694_bm()) != null && heldItem.func_77973_b() == Items.field_151112_aM && (currentTime = System.currentTimeMillis()) - this.lastCastRodMillis > 500L) {
            this.lastCastRodMillis = currentTime;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && event.phase == TickEvent.Phase.END) {
            if (this.buildupSoundDelay > 0) {
                --this.buildupSoundDelay;
            }
            if (NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarning || NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarningR) {
                if (Minecraft.func_71410_x().field_71439_g.field_71104_cf != null && !this.pingDelayList.isEmpty()) {
                    while (this.pingDelayList.size() > 5) {
                        this.pingDelayList.remove(this.pingDelayList.size() - 1);
                    }
                    int totalMS = 0;
                    for (int delay : this.pingDelayList) {
                        totalMS += delay;
                    }
                    int averageMS = totalMS / this.pingDelayList.size();
                    this.pingDelayTicks = (int)Math.floor((float)averageMS / 50.0f);
                }
                if (this.hookedWarningStateTicks > 0) {
                    --this.hookedWarningStateTicks;
                    this.warningState = PlayerWarningState.FISH_HOOKED;
                } else {
                    this.warningState = PlayerWarningState.NOTHING;
                    if (Minecraft.func_71410_x().field_71439_g.field_71104_cf != null) {
                        int fishEntityId = Minecraft.func_71410_x().field_71439_g.field_71104_cf.func_145782_y();
                        for (Map.Entry<WakeChain, List<Integer>> entry : this.chains.entrySet()) {
                            if (entry.getKey().particleNum < 3 || !entry.getValue().contains(fishEntityId)) continue;
                            this.warningState = PlayerWarningState.FISH_INCOMING;
                            break;
                        }
                    }
                }
            }
            if (this.tickCounter++ >= 20) {
                long currentTime = System.currentTimeMillis();
                this.tickCounter = 0;
                HashSet<Integer> toRemoveEnt = new HashSet<Integer>();
                for (Map.Entry<Integer, EntityFishHook> entry : this.hookEntities.entrySet()) {
                    if (!entry.getValue().field_70128_L) continue;
                    toRemoveEnt.add(entry.getKey());
                }
                this.hookEntities.keySet().removeAll(toRemoveEnt);
                HashSet<WakeChain> toRemoveChain = new HashSet<WakeChain>();
                for (Map.Entry<WakeChain, List<Integer>> entry : this.chains.entrySet()) {
                    if (currentTime - entry.getKey().lastUpdate <= 200L && !entry.getValue().isEmpty() && !Collections.disjoint((Collection)entry.getValue(), this.hookEntities.keySet())) continue;
                    toRemoveChain.add(entry.getKey());
                }
                this.chains.keySet().removeAll(toRemoveChain);
            }
        }
    }

    private double calculateAngleFromOffsets(double xOffset, double zOffset) {
        double dist;
        double angleX = Math.toDegrees(Math.acos(xOffset / (double)0.04f));
        double angleZ = Math.toDegrees(Math.asin(zOffset / (double)0.04f));
        if (xOffset < 0.0) {
            angleZ = 180.0 - angleZ;
        }
        if (zOffset < 0.0) {
            angleX = 360.0 - angleX;
        }
        angleX %= 360.0;
        angleZ %= 360.0;
        if (angleX < 0.0) {
            angleX += 360.0;
        }
        if (angleZ < 0.0) {
            angleZ += 360.0;
        }
        if ((dist = angleX - angleZ) < -180.0) {
            dist += 360.0;
        }
        if (dist > 180.0) {
            dist -= 360.0;
        }
        return angleZ + dist / 2.0;
    }

    private boolean checkAngleWithinRange(double angle1, double angle2, double range) {
        double dist = Math.abs(angle1 - angle2);
        if (dist > 180.0) {
            dist = 360.0 - dist;
        }
        return dist <= range;
    }

    private HookPossibleRet isHookPossible(EntityFishHook hook2, double particleX, double particleY, double particleZ, double angle1, double angle2) {
        double dY = particleY - hook2.field_70163_u;
        double tolerance = 0.5;
        if (hook2.field_70170_p != null) {
            for (int i = -2; i < 2; ++i) {
                IBlockState state = hook2.field_70170_p.func_180495_p(new BlockPos(particleX, particleY + (double)i, particleZ));
                if (state == null || state.func_177230_c() != Blocks.field_150356_k && state.func_177230_c() != Blocks.field_150358_i && state.func_177230_c() != Blocks.field_150353_l) continue;
                tolerance = 2.0;
            }
        }
        if (Math.abs(dY) > tolerance) {
            return HookPossibleRet.NOT_POSSIBLE;
        }
        double dX = particleX - hook2.field_70165_t;
        double dZ = particleZ - hook2.field_70161_v;
        double dist = Math.sqrt(dX * dX + dZ * dZ);
        if (dist < 0.2) {
            return HookPossibleRet.EITHER;
        }
        float angleAllowance = (float)Math.toDegrees(Math.atan2(0.03125, dist)) * 1.5f;
        float angleHook = (float)Math.toDegrees(Math.atan2(dX, dZ));
        if ((angleHook %= 360.0f) < 0.0f) {
            angleHook += 360.0f;
        }
        if (this.checkAngleWithinRange(angle1, angleHook, angleAllowance)) {
            return HookPossibleRet.ANGLE1;
        }
        if (this.checkAngleWithinRange(angle2, angleHook, angleAllowance)) {
            return HookPossibleRet.ANGLE2;
        }
        return HookPossibleRet.NOT_POSSIBLE;
    }

    private float calculatePitchFromDistance(float d) {
        if (d < 0.1f) {
            d = 0.1f;
        }
        if (d > 5.0f) {
            d = 5.0f;
        }
        return 1.0f / (d + 1.1111112f) * (1.0f - d / 5.0f) + 0.1f;
    }

    @SubscribeEvent
    public void onSpawnParticle(SpawnParticleEvent event) {
        EnumParticleTypes particleType = event.getParticleTypes();
        double x = event.getXCoord();
        double y = event.getYCoord();
        double z = event.getZCoord();
        double xOffset = event.getXOffset();
        double yOffset = event.getYOffset();
        double zOffset = event.getZOffset();
        if (!(NotEnoughUpdates.INSTANCE.config.fishing.hideOtherPlayerAll || NotEnoughUpdates.INSTANCE.config.fishing.enableCustomParticles || NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarning || NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarningR)) {
            return;
        }
        if (this.hookEntities.isEmpty()) {
            return;
        }
        if ((particleType == EnumParticleTypes.WATER_WAKE || particleType == EnumParticleTypes.SMOKE_NORMAL || particleType == EnumParticleTypes.FLAME) && Math.abs(yOffset - (double)0.01f) < (double)0.001f) {
            double angle1 = this.calculateAngleFromOffsets(xOffset, -zOffset);
            double angle2 = this.calculateAngleFromOffsets(-xOffset, zOffset);
            ArrayList<Integer> possibleHooks1 = new ArrayList<Integer>();
            ArrayList<Integer> possibleHooks2 = new ArrayList<Integer>();
            for (EntityFishHook hook2 : this.hookEntities.values()) {
                if (hook2.field_70128_L || possibleHooks1.contains(hook2.func_145782_y()) || possibleHooks2.contains(hook2.func_145782_y())) continue;
                HookPossibleRet ret = this.isHookPossible(hook2, x, y, z, angle1, angle2);
                if (ret == HookPossibleRet.ANGLE1) {
                    possibleHooks1.add(hook2.func_145782_y());
                    continue;
                }
                if (ret == HookPossibleRet.ANGLE2) {
                    possibleHooks2.add(hook2.func_145782_y());
                    continue;
                }
                if (ret != HookPossibleRet.EITHER) continue;
                possibleHooks1.add(hook2.func_145782_y());
                possibleHooks2.add(hook2.func_145782_y());
            }
            if (!possibleHooks1.isEmpty() || !possibleHooks2.isEmpty()) {
                String particleCustomColour;
                int particleTypeI;
                long currentTime = System.currentTimeMillis();
                boolean isMainPlayer = false;
                boolean foundChain = false;
                for (Map.Entry<WakeChain, List<Integer>> entry : this.chains.entrySet()) {
                    double updateAngle;
                    ArrayList<Integer> possibleHooks;
                    WakeChain chain = entry.getKey();
                    if (currentTime - chain.lastUpdate > 200L) continue;
                    if (this.checkAngleWithinRange(chain.currentAngle, angle1, 16.0)) {
                        possibleHooks = possibleHooks1;
                        updateAngle = angle1;
                    } else {
                        if (!this.checkAngleWithinRange(chain.currentAngle, angle2, 16.0)) continue;
                        possibleHooks = possibleHooks2;
                        updateAngle = angle2;
                    }
                    if (Collections.disjoint((Collection)entry.getValue(), possibleHooks)) continue;
                    HashSet<Integer> newHooks = new HashSet<Integer>();
                    Iterator<Object> iterator = possibleHooks.iterator();
                    while (iterator.hasNext()) {
                        EntityFishHook entity;
                        int hookEntityId = (Integer)iterator.next();
                        if (!entry.getValue().contains(hookEntityId) || !chain.distances.containsKey(hookEntityId) || (entity = this.hookEntities.get(hookEntityId)) == null || entity.field_70128_L) continue;
                        double oldDistance = chain.distances.get(hookEntityId);
                        double dX = entity.field_70165_t - x;
                        double dZ = entity.field_70161_v - z;
                        final double newDistance = Math.sqrt(dX * dX + dZ * dZ);
                        double delta = oldDistance - newDistance;
                        if (!(newDistance < 0.2) && (!(delta > -0.1) || !(delta < 0.3))) continue;
                        if ((NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarning || NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarningR) && Minecraft.func_71410_x().field_71439_g.field_71104_cf != null && Minecraft.func_71410_x().field_71439_g.field_71104_cf.func_145782_y() == hookEntityId && chain.particleNum > 3) {
                            float oldLevel;
                            PositionedSound sound;
                            float volF;
                            float vol;
                            float lavaOffset = 0.1f;
                            if (particleType == EnumParticleTypes.SMOKE_NORMAL) {
                                lavaOffset = 0.03f;
                            } else if (particleType == EnumParticleTypes.WATER_WAKE) {
                                lavaOffset = 0.1f;
                            }
                            if (newDistance <= (double)(0.2f + lavaOffset * (float)this.pingDelayTicks) && NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarningR) {
                                if (NotEnoughUpdates.INSTANCE.config.fishing.incomingFishHookedSounds && this.hookedWarningStateTicks <= 0 && (vol = NotEnoughUpdates.INSTANCE.config.fishing.incomingFishHookedSoundsVol / 100.0f) > 0.0f) {
                                    if (vol > 1.0f) {
                                        vol = 1.0f;
                                    }
                                    volF = vol;
                                    sound = new PositionedSound(new ResourceLocation("note.pling")){
                                        {
                                            super(x0);
                                            this.field_147662_b = volF;
                                            this.field_147663_c = 2.0f;
                                            this.field_147659_g = false;
                                            this.field_147665_h = 0;
                                            this.field_147666_i = ISound.AttenuationType.NONE;
                                        }
                                    };
                                    oldLevel = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.RECORDS);
                                    Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.RECORDS, 1.0f);
                                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                                    Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.RECORDS, oldLevel);
                                }
                                this.hookedWarningStateTicks = 12;
                            } else if (newDistance >= (double)(0.4f + 0.1f * (float)this.pingDelayTicks) && NotEnoughUpdates.INSTANCE.config.fishing.incomingFishWarning && NotEnoughUpdates.INSTANCE.config.fishing.incomingFishIncSounds && this.buildupSoundDelay <= 0 && (vol = NotEnoughUpdates.INSTANCE.config.fishing.incomingFishIncSoundsVol / 100.0f) > 0.0f) {
                                if (vol > 1.0f) {
                                    vol = 1.0f;
                                }
                                volF = vol;
                                sound = new PositionedSound(new ResourceLocation("note.pling")){
                                    {
                                        super(x0);
                                        this.field_147662_b = volF;
                                        this.field_147663_c = FishingHelper.this.calculatePitchFromDistance((float)newDistance - (0.3f + 0.1f * (float)FishingHelper.this.pingDelayTicks));
                                        this.field_147659_g = false;
                                        this.field_147665_h = 0;
                                        this.field_147666_i = ISound.AttenuationType.NONE;
                                    }
                                };
                                oldLevel = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.RECORDS);
                                Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.RECORDS, 1.0f);
                                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                                Minecraft.func_71410_x().field_71474_y.func_151439_a(SoundCategory.RECORDS, oldLevel);
                                this.buildupSoundDelay = 4;
                            }
                        }
                        chain.distances.put(hookEntityId, newDistance);
                        newHooks.add(hookEntityId);
                    }
                    if (newHooks.isEmpty()) continue;
                    entry.getValue().retainAll(newHooks);
                    chain.distances.keySet().retainAll(newHooks);
                    iterator = entry.getValue().iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        EntityFishHook hook3 = this.hookEntities.get(i);
                        if (hook3 == null || hook3.field_146042_b != Minecraft.func_71410_x().field_71439_g) continue;
                        isMainPlayer = true;
                        break;
                    }
                    chain.lastUpdate = currentTime;
                    ++chain.particleNum;
                    chain.currentAngle = updateAngle;
                    foundChain = true;
                }
                if (!foundChain) {
                    double dX;
                    Iterator i2;
                    Object chain;
                    EntityFishHook hook4;
                    possibleHooks1.removeAll(possibleHooks2);
                    if (!possibleHooks1.isEmpty()) {
                        Iterator<Map.Entry<WakeChain, List<Integer>>> iterator = possibleHooks1.iterator();
                        while (iterator.hasNext()) {
                            int i2 = (Integer)((Object)iterator.next());
                            hook4 = this.hookEntities.get(i2);
                            if (hook4 == null || hook4.field_146042_b != Minecraft.func_71410_x().field_71439_g) continue;
                            isMainPlayer = true;
                            break;
                        }
                        chain = new WakeChain(currentTime, angle1, x, z);
                        i2 = possibleHooks1.iterator();
                        while (i2.hasNext()) {
                            int hookEntityId = (Integer)i2.next();
                            EntityFishHook entity = this.hookEntities.get(hookEntityId);
                            if (entity == null || entity.field_70128_L) continue;
                            dX = entity.field_70165_t - x;
                            double dZ = entity.field_70161_v - z;
                            double newDistance = Math.sqrt(dX * dX + dZ * dZ);
                            ((WakeChain)chain).distances.put(hookEntityId, newDistance);
                        }
                        this.chains.put((WakeChain)chain, possibleHooks1);
                    } else if (!possibleHooks2.isEmpty()) {
                        chain = possibleHooks2.iterator();
                        while (chain.hasNext()) {
                            int i3 = (Integer)chain.next();
                            hook4 = this.hookEntities.get(i3);
                            if (hook4 == null || hook4.field_146042_b != Minecraft.func_71410_x().field_71439_g) continue;
                            isMainPlayer = true;
                            break;
                        }
                        chain = new WakeChain(currentTime, angle2, x, z);
                        i2 = possibleHooks2.iterator();
                        while (i2.hasNext()) {
                            int hookEntityId = (Integer)i2.next();
                            EntityFishHook entity = this.hookEntities.get(hookEntityId);
                            if (entity == null || entity.field_70128_L) continue;
                            dX = entity.field_70165_t - x;
                            double dZ = entity.field_70161_v - z;
                            double newDistance = Math.sqrt(dX * dX + dZ * dZ);
                            ((WakeChain)chain).distances.put(hookEntityId, newDistance);
                        }
                        this.chains.put((WakeChain)chain, possibleHooks2);
                    }
                }
                if (isMainPlayer) {
                    particleTypeI = NotEnoughUpdates.INSTANCE.config.fishing.yourParticleType;
                    particleCustomColour = NotEnoughUpdates.INSTANCE.config.fishing.yourParticleColour;
                } else {
                    if (NotEnoughUpdates.INSTANCE.config.fishing.hideOtherPlayerAll) {
                        event.cancel();
                        return;
                    }
                    particleTypeI = NotEnoughUpdates.INSTANCE.config.fishing.otherParticleType;
                    particleCustomColour = NotEnoughUpdates.INSTANCE.config.fishing.otherParticleColour;
                }
                if (!NotEnoughUpdates.INSTANCE.config.fishing.enableCustomParticles) {
                    return;
                }
                int argb = SpecialColour.specialToChromaRGB(particleCustomColour);
                if (particleTypeI == 0) {
                    return;
                }
                if (particleTypeI == 1) {
                    event.cancel();
                    return;
                }
                if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_175606_aa() != null && Minecraft.func_71410_x().field_71452_i != null) {
                    int i = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
                    if (i == 1 && Minecraft.func_71410_x().field_71441_e.field_73012_v.nextInt(3) == 0) {
                        event.cancel();
                        return;
                    }
                    if (i >= 2) {
                        event.cancel();
                        return;
                    }
                    double xDist = Minecraft.func_71410_x().func_175606_aa().field_70165_t - x;
                    double yDist = Minecraft.func_71410_x().func_175606_aa().field_70163_u - y;
                    double zDist = Minecraft.func_71410_x().func_175606_aa().field_70161_v - z;
                    double distSq = xDist * xDist + yDist * yDist + zDist * zDist;
                    if (distSq < 1024.0) {
                        boolean customColour = false;
                        double yVel = 0.0;
                        switch (particleTypeI) {
                            case 2: {
                                particleType = EnumParticleTypes.FIREWORKS_SPARK;
                                customColour = true;
                                yVel = 0.05;
                                break;
                            }
                            case 3: {
                                particleType = EnumParticleTypes.SPELL_MOB;
                                customColour = true;
                                break;
                            }
                            case 4: {
                                particleType = EnumParticleTypes.REDSTONE;
                                customColour = true;
                                break;
                            }
                            case 5: {
                                particleType = EnumParticleTypes.FLAME;
                                yVel = 0.015;
                                break;
                            }
                            case 6: {
                                particleType = EnumParticleTypes.CRIT;
                                yVel = 0.05;
                                break;
                            }
                            case 7: {
                                particleType = EnumParticleTypes.CRIT_MAGIC;
                                yVel = 0.05;
                            }
                        }
                        if (customColour && (argb >> 24 & 0xFF) < 10) {
                            event.cancel();
                            return;
                        }
                        EntityFX fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(particleType.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[0]);
                        fx.field_70159_w = Math.random() * 0.02 - 0.01;
                        fx.field_70181_x = yVel;
                        fx.field_70179_y = Math.random() * 0.02 - 0.01;
                        if (customColour) {
                            float red = (float)(argb >> 16 & 0xFF) / 255.0f;
                            float green = (float)(argb >> 8 & 0xFF) / 255.0f;
                            float blue = (float)(argb & 0xFF) / 255.0f;
                            float alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
                            fx.func_70538_b(red, green, blue);
                            fx.func_82338_g(alpha);
                        }
                    }
                }
                event.cancel();
                return;
            }
        }
    }

    private static enum HookPossibleRet {
        NOT_POSSIBLE,
        EITHER,
        ANGLE1,
        ANGLE2;

    }

    public static enum PlayerWarningState {
        NOTHING,
        FISH_INCOMING,
        FISH_HOOKED;

    }

    public static class WakeChain {
        public int particleNum = 0;
        public long lastUpdate;
        public double currentAngle;
        public double currentX;
        public double currentZ;
        public final HashMap<Integer, Double> distances = new HashMap();

        public WakeChain(long lastUpdate, double currentAngle, double currentX, double currentZ) {
            this.lastUpdate = lastUpdate;
            this.currentAngle = currentAngle;
            this.currentX = currentX;
            this.currentZ = currentZ;
        }
    }
}

