/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.ConfigUtil;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FairySouls {
    private static FairySouls instance = null;
    private static final String unknownProfile = "unknown";
    private boolean trackSouls;
    private boolean showSouls;
    private HashMap<String, HashMap<String, Set<Integer>>> allProfilesFoundSouls = new HashMap();
    private List<BlockPos> allSoulsInCurrentLocation;
    private Set<Integer> foundSoulsInLocation;
    private TreeMap<Double, BlockPos> missingSoulsDistanceSqMap;
    private List<BlockPos> closestMissingSouls;
    private String currentLocation;
    private BlockPos lastPlayerPos;

    public static FairySouls getInstance() {
        if (instance == null) {
            instance = new FairySouls();
        }
        return instance;
    }

    public boolean isTrackSouls() {
        return this.trackSouls;
    }

    public boolean isShowSouls() {
        return this.showSouls;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.currentLocation = null;
        this.trackSouls = NotEnoughUpdates.INSTANCE.config.misc.trackFairySouls;
        this.showSouls = NotEnoughUpdates.INSTANCE.config.misc.fariySoul;
    }

    public void initializeLocation() {
        if (!this.trackSouls || this.currentLocation == null) {
            return;
        }
        this.foundSoulsInLocation = null;
        this.closestMissingSouls = new ArrayList<BlockPos>();
        this.missingSoulsDistanceSqMap = new TreeMap();
        this.lastPlayerPos = BlockPos.field_177992_a;
        this.allSoulsInCurrentLocation = FairySouls.loadLocationFairySoulsFromConfig(this.currentLocation);
        if (this.allSoulsInCurrentLocation == null) {
            return;
        }
        this.foundSoulsInLocation = this.getFoundSoulsForProfile().computeIfAbsent(this.currentLocation, k -> new HashSet());
        this.refreshMissingSoulInfo(true);
    }

    private void refreshMissingSoulInfo(boolean force) {
        if (this.allSoulsInCurrentLocation == null) {
            return;
        }
        BlockPos currentPlayerPos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        if (this.lastPlayerPos.equals((Object)currentPlayerPos) && !force) {
            return;
        }
        this.lastPlayerPos = currentPlayerPos;
        this.missingSoulsDistanceSqMap.clear();
        for (int i = 0; i < this.allSoulsInCurrentLocation.size(); ++i) {
            if (this.foundSoulsInLocation.contains(i)) continue;
            BlockPos pos = this.allSoulsInCurrentLocation.get(i);
            double distSq = pos.func_177951_i((Vec3i)this.lastPlayerPos);
            this.missingSoulsDistanceSqMap.put(distSq, pos);
        }
        this.closestMissingSouls.clear();
        if (this.missingSoulsDistanceSqMap.isEmpty()) {
            return;
        }
        int maxSouls = 15;
        int souls = 0;
        for (BlockPos pos : this.missingSoulsDistanceSqMap.values()) {
            this.closestMissingSouls.add(pos);
            if (++souls < maxSouls) continue;
            break;
        }
    }

    private int interpolateColors(int color1, int color2, double factor) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r3 = r1 + (int)Math.round(factor * (double)(r2 - r1));
        int g3 = g1 + (int)Math.round(factor * (double)(g2 - g1));
        int b3 = b1 + (int)Math.round(factor * (double)(b2 - b1));
        return (r3 & 0xFF) << 16 | (g3 & 0xFF) << 8 | b3 & 0xFF;
    }

    private double normalize(double value, double min2, double max2) {
        return (value - min2) / (max2 - min2);
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (!this.showSouls || !this.trackSouls || this.currentLocation == null || this.closestMissingSouls.isEmpty()) {
            return;
        }
        int closeColor = 7809425;
        int farColor = 13546705;
        double farSoulDistSq = this.lastPlayerPos.func_177951_i((Vec3i)this.closestMissingSouls.get(this.closestMissingSouls.size() - 1));
        for (BlockPos currentSoul : this.closestMissingSouls) {
            double currentDistSq = this.lastPlayerPos.func_177951_i((Vec3i)currentSoul);
            double factor = this.normalize(currentDistSq, 0.0, farSoulDistSq);
            int rgb = this.interpolateColors(closeColor, farColor, Math.min(0.4, factor));
            RenderUtils.renderBeaconBeamOrBoundingBox(currentSoul, rgb |= 0x66000000, 1.0f, event.partialTicks);
            if (!NotEnoughUpdates.INSTANCE.config.misc.fairySoulWaypointDistance) continue;
            RenderUtils.renderWayPoint((Vec3i)currentSoul, event.partialTicks);
        }
    }

    public void setShowFairySouls(boolean enabled) {
        NotEnoughUpdates.INSTANCE.config.misc.fariySoul = enabled;
        this.showSouls = enabled;
    }

    public void setTrackFairySouls(boolean enabled) {
        NotEnoughUpdates.INSTANCE.config.misc.trackFairySouls = enabled;
        this.trackSouls = enabled;
    }

    public void markClosestSoulFound() {
        if (!this.trackSouls || this.allSoulsInCurrentLocation == null || this.allSoulsInCurrentLocation.isEmpty()) {
            return;
        }
        int closestIndex = -1;
        double closestDistSq = 100.0;
        for (int i = 0; i < this.allSoulsInCurrentLocation.size(); ++i) {
            BlockPos pos = this.allSoulsInCurrentLocation.get(i);
            double distSq = pos.func_177951_i((Vec3i)Minecraft.func_71410_x().field_71439_g.func_180425_c());
            if (!(distSq < closestDistSq)) continue;
            closestDistSq = distSq;
            closestIndex = i;
        }
        if (closestIndex != -1 && this.foundSoulsInLocation != null) {
            this.foundSoulsInLocation.add(closestIndex);
            this.refreshMissingSoulInfo(true);
        }
    }

    public void markAllAsFound() {
        if (!this.trackSouls) {
            FairySouls.print(EnumChatFormatting.RED + "Fairy soul tracking is turned off, turn it on using /neu");
            return;
        }
        if (this.allSoulsInCurrentLocation == null) {
            FairySouls.print(EnumChatFormatting.RED + "No fairy souls found in your current world");
            return;
        }
        for (int i = 0; i < this.allSoulsInCurrentLocation.size(); ++i) {
            this.foundSoulsInLocation.add(i);
        }
        this.refreshMissingSoulInfo(true);
        FairySouls.print(EnumChatFormatting.DARK_PURPLE + "Marked all fairy souls as found");
    }

    public void markAllAsMissing() {
        if (!this.trackSouls) {
            FairySouls.print(EnumChatFormatting.RED + "Fairy soul tracking is turned off, turn it on using /neu");
            return;
        }
        if (this.allSoulsInCurrentLocation == null) {
            FairySouls.print(EnumChatFormatting.RED + "No fairy souls found in your current world");
            return;
        }
        this.foundSoulsInLocation.clear();
        this.refreshMissingSoulInfo(true);
        FairySouls.print(EnumChatFormatting.DARK_PURPLE + "Marked all fairy souls as not found");
    }

    private HashMap<String, Set<Integer>> getFoundSoulsForProfile() {
        String profile = SBInfo.getInstance().currentProfile;
        if (profile == null) {
            if (this.allProfilesFoundSouls.containsKey(unknownProfile)) {
                return this.allProfilesFoundSouls.get(unknownProfile);
            }
        } else {
            profile = profile.toLowerCase(Locale.getDefault());
            if (this.allProfilesFoundSouls.containsKey(unknownProfile)) {
                HashMap<String, Set<Integer>> unknownProfileData = this.allProfilesFoundSouls.remove(unknownProfile);
                this.allProfilesFoundSouls.put(profile, unknownProfileData);
                return unknownProfileData;
            }
            if (this.allProfilesFoundSouls.containsKey(profile)) {
                return this.allProfilesFoundSouls.get(profile);
            }
            HashMap<String, Set<Integer>> profileData = new HashMap<String, Set<Integer>>();
            this.allProfilesFoundSouls.put(profile, profileData);
            return profileData;
        }
        return new HashMap<String, Set<Integer>>();
    }

    private static List<BlockPos> loadLocationFairySoulsFromConfig(String currentLocation) {
        JsonObject fairySoulList = Constants.FAIRYSOULS;
        if (fairySoulList == null) {
            return null;
        }
        if (!fairySoulList.has(currentLocation) || !fairySoulList.get(currentLocation).isJsonArray()) {
            return null;
        }
        JsonArray locations = fairySoulList.get(currentLocation).getAsJsonArray();
        ArrayList<BlockPos> locationSouls = new ArrayList<BlockPos>();
        for (int i = 0; i < locations.size(); ++i) {
            try {
                String coord = locations.get(i).getAsString();
                String[] split = coord.split(",");
                if (split.length != 3) continue;
                String xS = split[0];
                String yS = split[1];
                String zS = split[2];
                int x = Integer.parseInt(xS);
                int y = Integer.parseInt(yS);
                int z = Integer.parseInt(zS);
                locationSouls.add(new BlockPos(x, y, z));
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        }
        if (locationSouls.size() == 0) {
            return null;
        }
        return locationSouls;
    }

    public void loadFoundSoulsForAllProfiles(File file, Gson gson) {
        String fileContent;
        this.allProfilesFoundSouls = new HashMap();
        try (BufferedReader br = Files.newBufferedReader(file.toPath());){
            fileContent = br.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e2) {
            return;
        }
        try {
            Type multiProfileSoulsType = new TypeToken<HashMap<String, HashMap<String, Set<Integer>>>>(){}.getType();
            this.allProfilesFoundSouls = (HashMap)gson.fromJson(fileContent, multiProfileSoulsType);
            if (this.allProfilesFoundSouls == null) {
                this.allProfilesFoundSouls = new HashMap();
            }
        }
        catch (JsonSyntaxException e3) {
            try {
                Type singleProfileSoulsType = new TypeToken<HashMap<String, Set<Integer>>>(){}.getType();
                this.allProfilesFoundSouls.put(unknownProfile, (HashMap<String, Set<Integer>>)gson.fromJson(fileContent, singleProfileSoulsType));
            }
            catch (JsonSyntaxException e2) {
                System.err.println("Can't read file containing collected fairy souls, resetting.");
            }
        }
    }

    public void saveFoundSoulsForAllProfiles(File file, Gson gson) {
        ConfigUtil.saveConfig(this.allProfilesFoundSouls, file, gson);
    }

    public void tick() {
        if (!this.trackSouls) {
            return;
        }
        String location = SBInfo.getInstance().getLocation();
        if (location == null || location.isEmpty()) {
            return;
        }
        if (!location.equals(this.currentLocation)) {
            this.currentLocation = location;
            this.initializeLocation();
        }
        this.refreshMissingSoulInfo(false);
    }

    private static void print(String s) {
        Utils.addChatMessage(s);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (!this.trackSouls || event.type == 2) {
            return;
        }
        String cleanString = StringUtils.cleanColour(event.message.func_150260_c());
        if (cleanString.equals("You have already found that Fairy Soul!") || cleanString.equals("SOUL! You found a Fairy Soul!")) {
            this.markClosestSoulFound();
        }
    }
}

