/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.listener;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemTooltipEssenceShopListener {
    private final NotEnoughUpdates neu;
    private final Pattern ESSENCE_PATTERN = Pattern.compile("\u00a75\u00a7o\u00a7d([\\d,]+) (.+) Essence");

    public ItemTooltipEssenceShopListener(NotEnoughUpdates neu) {
        this.neu = neu;
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!this.neu.isOnSkyblock()) {
            return;
        }
        if (event.toolTip == null) {
            return;
        }
        if (!Utils.getOpenChestName().endsWith(" Essence Shop")) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.tooltipTweaks.essencePriceInEssenceShop) {
            return;
        }
        ArrayList<String> newToolTip = new ArrayList<String>();
        boolean next2 = false;
        for (String line : event.toolTip) {
            if (next2) {
                next2 = false;
                Matcher matcher = this.ESSENCE_PATTERN.matcher(line);
                if (matcher.matches()) {
                    String rawNumber = matcher.group(1).replace(",", "");
                    int amount = Integer.parseInt(rawNumber);
                    String type2 = matcher.group(2);
                    String essenceName = "ESSENCE_" + type2.toUpperCase(Locale.ROOT);
                    JsonObject bazaarInfo = this.neu.manager.auctionManager.getBazaarInfo(essenceName);
                    if (bazaarInfo != null && bazaarInfo.has("curr_sell")) {
                        float bazaarPrice = bazaarInfo.get("curr_sell").getAsFloat();
                        double price = bazaarPrice * (float)amount;
                        String format2 = StringUtils.shortNumberFormat(price);
                        newToolTip.add(line + " \u00a77(\u00a76" + format2 + " coins\u00a77)");
                        continue;
                    }
                }
            }
            if (line.contains("Cost")) {
                next2 = true;
            }
            newToolTip.add(line);
        }
        event.toolTip.clear();
        event.toolTip.addAll(newToolTip);
    }
}

