/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.itemeditor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingInteger;
import io.github.moulberry.notenoughupdates.itemeditor.GuiElement;
import io.github.moulberry.notenoughupdates.itemeditor.GuiElementButton;
import io.github.moulberry.notenoughupdates.itemeditor.GuiElementText;
import io.github.moulberry.notenoughupdates.itemeditor.GuiElementTextField;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class NEUItemEditor
extends GuiScreen {
    private final List<GuiElement> options = new ArrayList<GuiElement>();
    private final List<GuiElement> rightOptions = new ArrayList<GuiElement>();
    private JsonObject item;
    private final JsonObject savedRepoItem;
    private static final int PADDING = 10;
    private static final int SCROLL_AMOUNT = 20;
    private final LerpingInteger scrollHeight = new LerpingInteger(0);
    private final Supplier<String> internalName;
    private final Supplier<String> itemId;
    private final Supplier<String> displayName;
    private final Supplier<String> lore;
    private final Supplier<String> craftText;
    private final Supplier<String> infoType;
    private final Supplier<String> info;
    private final Supplier<String> clickCommand;
    private final Supplier<String> damage;
    private NBTTagCompound nbtTag;
    private int saved = 0;

    public NEUItemEditor(String internalName, JsonObject item) {
        String displayName;
        this.item = item;
        if (item.has("nbttag")) {
            try {
                this.nbtTag = JsonToNBT.func_180713_a((String)item.get("nbttag").getAsString());
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        NBTTagCompound extraAttributes = this.nbtTag.func_74775_l("ExtraAttributes");
        extraAttributes.func_82580_o("uuid");
        extraAttributes.func_82580_o("timestamp");
        if (extraAttributes.func_74764_b("petInfo")) {
            String petInfo = extraAttributes.func_74779_i("petInfo");
            JsonObject jsonObject = NotEnoughUpdates.INSTANCE.manager.gson.fromJson(petInfo, JsonObject.class);
            jsonObject.remove("heldItem");
            jsonObject.add("exp", new JsonPrimitive(0));
            jsonObject.add("candyUsed", new JsonPrimitive(0));
            extraAttributes.func_74778_a("petInfo", jsonObject.toString());
        }
        this.savedRepoItem = NotEnoughUpdates.INSTANCE.manager.getItemInformation().getOrDefault(internalName, null);
        internalName = internalName == null ? "" : internalName;
        this.options.add(new GuiElementText("Internal Name: ", Color.WHITE.getRGB()));
        this.internalName = this.addTextFieldWithSupplier(internalName, 12);
        this.options.add(new GuiElementText("Item ID: ", Color.WHITE.getRGB()));
        String itemid = item.has("itemid") ? item.get("itemid").getAsString() : "";
        this.itemId = this.addTextFieldWithSupplier(itemid, 8);
        this.options.add(new GuiElementText("Display name: ", Color.WHITE.getRGB()));
        String string = displayName = item.has("displayname") ? item.get("displayname").getAsString() : "";
        if (displayName.startsWith("\u00a7f\u00a7f")) {
            displayName = displayName.substring(4);
        }
        this.displayName = this.addTextFieldWithSupplier(displayName, 2);
        this.options.add(new GuiElementText("Lore: ", Color.WHITE.getRGB()));
        JsonElement loreElement = this.getItemInfo("lore");
        JsonArray lore = loreElement != null ? loreElement.getAsJsonArray() : new JsonArray();
        CharSequence[] loreA = new String[lore.size()];
        for (int i = 0; i < lore.size(); ++i) {
            loreA[i] = lore.get(i).getAsString();
        }
        this.lore = this.addTextFieldWithSupplier(String.join((CharSequence)"\n", loreA), 3);
        this.options.add(new GuiElementText("Craft text: ", Color.WHITE.getRGB()));
        JsonElement craftTextElement = this.getItemInfo("crafttext");
        String craftText = craftTextElement != null ? craftTextElement.getAsString() : "";
        this.craftText = this.addTextFieldWithSupplier(craftText, 2);
        this.options.add(new GuiElementText("Info type: ", Color.WHITE.getRGB()));
        JsonElement infoTypeElement = this.getItemInfo("infoType");
        String infoType = infoTypeElement != null ? infoTypeElement.getAsString() : "";
        this.infoType = this.addTextFieldWithSupplier(infoType, 12);
        this.options.add(new GuiElementText("Additional information: ", Color.WHITE.getRGB()));
        JsonElement infoElement = this.getItemInfo("info");
        JsonArray info = infoElement != null ? infoElement.getAsJsonArray() : new JsonArray();
        CharSequence[] infoA = new String[info.size()];
        for (int i = 0; i < info.size(); ++i) {
            infoA[i] = info.get(i).getAsString();
        }
        this.info = this.addTextFieldWithSupplier(String.join((CharSequence)"\n", infoA), 3);
        this.options.add(new GuiElementText("Click-command (viewrecipe or viewpotion): ", Color.WHITE.getRGB()));
        JsonElement clickCommandElement = this.getItemInfo("clickcommand");
        String clickCommand = clickCommandElement != null ? clickCommandElement.getAsString() : "";
        this.clickCommand = this.addTextFieldWithSupplier(clickCommand, 8);
        this.options.add(new GuiElementText("Damage: ", Color.WHITE.getRGB()));
        JsonElement damageElement = this.getItemInfo("damage");
        String damage = damageElement != null ? damageElement.getAsString() : "";
        this.damage = this.addTextFieldWithSupplier(damage, 24);
        this.rightOptions.add(new GuiElementButton("Close (discards changes)", Color.LIGHT_GRAY.getRGB(), () -> Minecraft.func_71410_x().func_147108_a(null)));
        this.rightOptions.add(new GuiElementText("", Color.WHITE.getRGB()));
        GuiElementButton button = new Object(){
            final GuiElementButton b = new GuiElementButton("Save to local disk", Color.GREEN.getRGB(), new Runnable(){

                @Override
                public void run() {
                    if (NEUItemEditor.this.save()) {
                        b.setText(NEUItemEditor.this.saved == 0 ? "Saved" : "Saved (" + NEUItemEditor.this.saved + ")");
                        NEUItemEditor.this.saved++;
                    } else {
                        b.setText("Saving FAILED!");
                    }
                }
            });
        }.b;
        this.rightOptions.add(button);
        this.rightOptions.add(new GuiElementButton("Remove enchants", Color.RED.getRGB(), () -> {
            this.nbtTag.func_82580_o("ench");
            extraAttributes.func_82580_o("enchantments");
        }));
        this.rightOptions.add(new GuiElementButton("Add enchant glint", Color.ORANGE.getRGB(), () -> this.nbtTag.func_74782_a("ench", (NBTBase)new NBTTagList())));
        this.resetScrollToTop();
        this.item = this.savedRepoItem != null ? this.savedRepoItem : item;
    }

    public static boolean saveOnly(String internalName, JsonObject item) {
        NEUItemEditor editor = new NEUItemEditor(internalName, item);
        return editor.save();
    }

    private JsonElement getItemInfo(String key) {
        if (this.item.has(key)) {
            return this.item.get(key);
        }
        if (this.savedRepoItem != null && this.savedRepoItem.has(key)) {
            return this.savedRepoItem.get(key);
        }
        return null;
    }

    public boolean save() {
        int damageI = 0;
        try {
            damageI = Integer.parseInt(this.damage.get());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.resyncNbttag();
        String[] infoA = this.info.get().trim().split("\n");
        if (infoA.length == 0 || infoA[0].isEmpty()) {
            infoA = new String[]{};
        }
        NotEnoughUpdates.INSTANCE.manager.removeItemFromCache(this.internalName.get());
        return NotEnoughUpdates.INSTANCE.manager.writeItemJson(this.item, this.internalName.get(), this.itemId.get(), this.displayName.get(), this.lore.get().split("\n"), this.craftText.get(), this.infoType.get(), infoA, this.clickCommand.get(), damageI, this.nbtTag);
    }

    public Supplier<String> addTextFieldWithSupplier(String initialText, int options) {
        GuiElementTextField textField = new GuiElementTextField(initialText, options);
        this.options.add(textField);
        return textField::toString;
    }

    public void resyncNbttag() {
        if (this.nbtTag == null) {
            this.nbtTag = new NBTTagCompound();
        }
        NBTTagList list = new NBTTagList();
        for (String lore : this.lore.get().split("\n")) {
            list.func_74742_a((NBTBase)new NBTTagString(lore));
        }
        NBTTagCompound display = this.nbtTag.func_74775_l("display");
        display.func_74782_a("Lore", (NBTBase)list);
        display.func_74778_a("Name", this.displayName.get());
        this.nbtTag.func_74782_a("display", (NBTBase)display);
        NBTTagCompound ea = this.nbtTag.func_74775_l("ExtraAttributes");
        ea.func_74778_a("id", this.internalName.get());
        this.nbtTag.func_74782_a("ExtraAttributes", (NBTBase)ea);
    }

    public void resetScrollToTop() {
        int totalHeight = 10;
        for (GuiElement gui : this.options) {
            totalHeight += gui.getHeight();
        }
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int height = scaledresolution.func_78328_b();
        this.scrollHeight.setValue(totalHeight - height + 10);
    }

    public int calculateYScroll() {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int height = scaledresolution.func_78328_b();
        int totalHeight = 10;
        for (GuiElement gui : this.options) {
            totalHeight += gui.getHeight();
        }
        if (this.scrollHeight.getValue() < 0) {
            this.scrollHeight.setValue(0);
        }
        int yScroll = 0;
        if (totalHeight > height - 10) {
            yScroll = totalHeight - height + 10 - this.scrollHeight.getValue();
        } else {
            this.scrollHeight.setValue(0);
        }
        if (yScroll < 0) {
            yScroll = 0;
            this.scrollHeight.setValue(totalHeight - height + 10);
        }
        return yScroll;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.scrollHeight.tick();
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        GlStateManager.func_179140_f();
        Color backgroundColour = new Color(10, 10, 10, 240);
        NEUItemEditor.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)backgroundColour.getRGB());
        int yScroll = this.calculateYScroll();
        int currentY = 10 - yScroll;
        for (GuiElement gui : this.options) {
            gui.render(10, currentY);
            currentY += gui.getHeight();
        }
        currentY = 10;
        for (GuiElement gui : this.rightOptions) {
            gui.render(width - 10 - gui.getWidth(), currentY);
            currentY += gui.getHeight();
        }
        int itemX = 424;
        int itemY = 32;
        int itemSize = 128;
        Color itemBorder = new Color(100, 50, 150, 255);
        Color itemBackground = new Color(120, 120, 120, 255);
        NEUItemEditor.func_73734_a((int)(itemX - 10), (int)(itemY - 10), (int)(itemX + itemSize + 10), (int)(itemY + itemSize + 10), (int)Color.DARK_GRAY.getRGB());
        NEUItemEditor.func_73734_a((int)(itemX - 9), (int)(itemY - 9), (int)(itemX + itemSize + 9), (int)(itemY + itemSize + 9), (int)itemBorder.getRGB());
        NEUItemEditor.func_73734_a((int)(itemX - 6), (int)(itemY - 6), (int)(itemX + itemSize + 6), (int)(itemY + itemSize + 6), (int)Color.DARK_GRAY.getRGB());
        NEUItemEditor.func_73734_a((int)(itemX - 5), (int)(itemY - 5), (int)(itemX + itemSize + 5), (int)(itemY + itemSize + 5), (int)itemBackground.getRGB());
        ItemStack stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.itemId.get())));
        if (stack.func_77973_b() != null) {
            try {
                stack.func_77964_b(Integer.parseInt(this.damage.get()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.resyncNbttag();
            stack.func_77982_d(this.nbtTag);
            int scaleFactor = itemSize / 16;
            GL11.glPushMatrix();
            GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)1.0f);
            this.drawItemStack(stack, itemX / scaleFactor, itemY / scaleFactor);
            GL11.glPopMatrix();
        }
        ArrayList<String> text = new ArrayList<String>();
        text.add(this.displayName.get());
        text.addAll(Arrays.asList(this.lore.get().split("\n")));
        Utils.drawHoveringText(text, itemX - 20, itemY + itemSize + 28, width, height, -1);
        GlStateManager.func_179140_f();
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        boolean hasChanges = false;
        if (keyCode == 1 && !hasChanges) {
            Minecraft.func_71410_x().func_147108_a(null);
            return;
        }
        for (GuiElement gui : this.options) {
            gui.keyTyped(typedChar, keyCode);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledresolution.func_78326_a();
        int yScroll = this.calculateYScroll();
        int currentY = 10 - yScroll;
        for (GuiElement gui : this.options) {
            if (mouseY > currentY && mouseY < currentY + gui.getHeight() && mouseX < gui.getWidth()) {
                gui.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
                return;
            }
            currentY += gui.getHeight();
        }
        currentY = 10;
        for (GuiElement gui : this.rightOptions) {
            if (mouseY > currentY && mouseY < currentY + gui.getHeight() && mouseX > width - 10 - gui.getWidth()) {
                gui.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
                return;
            }
            currentY += gui.getHeight();
        }
    }

    public void func_146274_d() throws IOException {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int maxWidth = 0;
        for (GuiElement gui : this.options) {
            if (gui.getWidth() <= maxWidth) continue;
            maxWidth = gui.getWidth();
        }
        if (Mouse.getX() < maxWidth * scaledresolution.func_78325_e()) {
            int dWheel = Mouse.getEventDWheel();
            if (dWheel < 0) {
                this.scrollHeight.setTarget(this.scrollHeight.getTarget() - 20);
                this.scrollHeight.resetTimer();
            } else if (dWheel > 0) {
                this.scrollHeight.setTarget(this.scrollHeight.getTarget() + 20);
                this.scrollHeight.resetTimer();
            }
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledresolution.func_78326_a();
        int yScroll = this.calculateYScroll();
        int currentY = 10 - yScroll;
        for (GuiElement gui : this.options) {
            if (mouseY > currentY && mouseY < currentY + gui.getHeight() && mouseX < gui.getWidth()) {
                gui.mouseClicked(mouseX, mouseY, mouseButton);
                for (GuiElement gui2 : this.options) {
                    if (gui2 == gui) continue;
                    gui2.otherComponentClick();
                }
                for (GuiElement gui2 : this.rightOptions) {
                    if (gui2 == gui) continue;
                    gui2.otherComponentClick();
                }
                return;
            }
            currentY += gui.getHeight();
        }
        currentY = 10;
        for (GuiElement gui : this.rightOptions) {
            if (mouseY > currentY && mouseY < currentY + gui.getHeight() && mouseX > width - 10 - gui.getWidth()) {
                gui.mouseClicked(mouseX, mouseY, mouseButton);
                for (GuiElement gui2 : this.options) {
                    if (gui2 == gui) continue;
                    gui2.otherComponentClick();
                }
                for (GuiElement gui2 : this.rightOptions) {
                    if (gui2 == gui) continue;
                    gui2.otherComponentClick();
                }
                return;
            }
            currentY += gui.getHeight();
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderHelper.func_74520_c();
        itemRender.func_180450_b(stack, x, y);
        RenderHelper.func_74518_a();
        itemRender.func_180453_a(font, stack, x, y, null);
    }
}

