/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.dungeons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.GuiElementColour;
import io.github.moulberry.notenoughupdates.core.config.GuiPositionEditorButForTheDungeonMap;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.core.util.render.TextRenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorSlider;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigOption;
import io.github.moulberry.notenoughupdates.dungeons.DungeonMap;
import io.github.moulberry.notenoughupdates.itemeditor.GuiElementTextField;
import io.github.moulberry.notenoughupdates.options.separatesections.DungeonMapConfig;
import io.github.moulberry.notenoughupdates.util.GuiTextures;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec4b;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class GuiDungeonMapEditor
extends GuiScreen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("notenoughupdates:dungeon_map/editor/background.png");
    public static final ResourceLocation BUTTON = new ResourceLocation("notenoughupdates:dungeon_map/editor/button.png");
    private static final DungeonMap demoMap = new DungeonMap();
    private int sizeX;
    private int sizeY;
    private int guiLeft;
    private int guiTop;
    private final List<Button> buttons = new ArrayList<Button>();
    private final GuiElementTextField blurField = new GuiElementTextField("", 24);
    private GuiElementColour activeColourEditor = null;
    private Field clickedSlider;
    private Runnable closedCallback;
    Shader blurShaderHorz = null;
    Framebuffer blurOutputHorz = null;
    Shader blurShaderVert = null;
    Framebuffer blurOutputVert = null;
    private double lastBgBlurFactor = -1.0;

    public GuiDungeonMapEditor(Runnable closedCallback) {
        String strVal;
        if (NotEnoughUpdates.INSTANCE.colourMap == null) {
            try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("notenoughupdates:maps/F1Full.json")).func_110527_b(), StandardCharsets.UTF_8));){
                JsonObject json = NotEnoughUpdates.INSTANCE.manager.gson.fromJson((Reader)reader2, JsonObject.class);
                NotEnoughUpdates.INSTANCE.colourMap = new Color[128][128];
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        NotEnoughUpdates.INSTANCE.colourMap[x][y] = new Color(0, 0, 0, 0);
                    }
                }
                for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
                    int x = Integer.parseInt(entry.getKey().split(":")[0]);
                    int y = Integer.parseInt(entry.getKey().split(":")[1]);
                    NotEnoughUpdates.INSTANCE.colourMap[x][y] = new Color(entry.getValue().getAsInt(), true);
                }
            }
            catch (Exception reader2) {
                // empty catch block
            }
        }
        this.buttons.add(new Button(6, 6, 127, "None"));
        this.buttons.add(new Button(7, 52, 127, "Custom"));
        this.buttons.add(new Button(8, 98, 127, "Stone"));
        this.buttons.add(new Button(9, 6, 146, "Wood"));
        this.buttons.add(new Button(10, 52, 146, "Rustic(S)"));
        this.buttons.add(new Button(11, 98, 146, "Rustic(C)"));
        this.buttons.add(new Button(12, 6, 165, "Fade"));
        this.buttons.add(new Button(13, 52, 165, "Ribbons"));
        this.buttons.add(new Button(14, 98, 165, "Paper"));
        this.buttons.add(new Button(15, 6, 184, "Crimson"));
        this.buttons.add(new Button(16, 52, 184, "Ornate"));
        this.buttons.add(new Button(17, 98, 184, "Dragon"));
        try {
            this.buttons.add(new Button(18, 159, 36, "Yes/No", DungeonMapConfig.class.getDeclaredField("dmEnable")));
            this.buttons.add(new Button(19, 223, 36, "Player/Map", DungeonMapConfig.class.getDeclaredField("dmCenterPlayer")));
            this.buttons.add(new Button(20, 159, 65, "Player/No Rotate", DungeonMapConfig.class.getDeclaredField("dmRotatePlayer")));
            this.buttons.add(new Button(21, 223, 65, "Default/Heads", DungeonMapConfig.class.getDeclaredField("dmPlayerHeads")));
            this.buttons.add(new Button(22, 159, 94, "Normal/Reorient", DungeonMapConfig.class.getDeclaredField("dmOrientCheck")));
            this.buttons.add(new Button(23, 223, 94, "Yes/No", DungeonMapConfig.class.getDeclaredField("dmCenterCheck")));
            this.buttons.add(new Button(24, 159, 123, "Yes/No", DungeonMapConfig.class.getDeclaredField("dmPlayerInterp")));
            this.buttons.add(new Button(25, 223, 123, "Normal/No SHD/No FB/SHD", DungeonMapConfig.class.getDeclaredField("dmCompat")));
            this.buttons.add(new Button(26, 159, 152, "", DungeonMapConfig.class.getDeclaredField("dmBackgroundColour")));
            this.buttons.add(new Button(27, 223, 152, "", DungeonMapConfig.class.getDeclaredField("dmBorderColour")));
            this.buttons.add(new Button(28, 223, 181, "Normal/Scroll", DungeonMapConfig.class.getDeclaredField("dmChromaBorder")));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        double val = NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBackgroundBlur;
        if (val % 1.0 == 0.0) {
            strVal = Integer.toString((int)val);
        } else {
            strVal = Double.toString(val);
            strVal = strVal.replaceAll("(\\.\\d\\d\\d)(?:\\d)+", "$1");
            strVal = strVal.replaceAll("0+$", "");
        }
        this.blurField.setText(strVal);
        this.closedCallback = closedCallback;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ScaledResolution scaledResolution = Utils.pushGuiScale(2);
        this.field_146294_l = scaledResolution.func_78326_a();
        this.field_146295_m = scaledResolution.func_78328_b();
        mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        List<String> tooltipToDisplay = null;
        for (Button button : this.buttons) {
            if (mouseX < this.guiLeft + button.x || mouseX > this.guiLeft + button.x + 48 || mouseY < this.guiTop + button.y - 13 || mouseY > this.guiTop + button.y + 16) continue;
            if (button.id >= 6 && button.id <= 17) {
                String mapDesc = null;
                String mapCredit = null;
                int id = button.id;
                switch (id) {
                    case 6: {
                        mapDesc = "No Border";
                        break;
                    }
                    case 7: {
                        mapDesc = "Used by custom Resource Packs";
                        break;
                    }
                    case 8: {
                        mapDesc = "Simple gray border";
                        mapCredit = "Lucy";
                        break;
                    }
                    case 9: {
                        mapDesc = "Viney wood border";
                        mapCredit = "iDevil4Hell";
                        break;
                    }
                    case 10: {
                        mapDesc = "Steampunk-inspired square border";
                        mapCredit = "ThatGravyBoat";
                        break;
                    }
                    case 11: {
                        mapDesc = "Steampunk-inspired circular border";
                        mapCredit = "ThatGravyBoat";
                        break;
                    }
                    case 12: {
                        mapDesc = "Light fade border";
                        mapCredit = "Qwiken";
                        break;
                    }
                    case 13: {
                        mapDesc = "Simple gray border with red ribbons";
                        mapCredit = "Sai";
                        break;
                    }
                    case 14: {
                        mapDesc = "Paper border";
                        mapCredit = "KingJames02st";
                        break;
                    }
                    case 15: {
                        mapDesc = "Nether-inspired border";
                        mapCredit = "DTRW191";
                        break;
                    }
                    case 16: {
                        mapDesc = "Golden ornate border";
                        mapCredit = "iDevil4Hell";
                        break;
                    }
                    case 17: {
                        mapDesc = "Stone dragon border";
                        mapCredit = "ImperiaL";
                    }
                }
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(EnumChatFormatting.YELLOW + "Border Style");
                tooltip.add(EnumChatFormatting.AQUA + "Customize the look of the dungeon border");
                tooltip.add("");
                if (mapDesc != null) {
                    tooltip.add(EnumChatFormatting.YELLOW + "Set to: " + EnumChatFormatting.AQUA + mapDesc);
                }
                if (mapCredit != null) {
                    tooltip.add(EnumChatFormatting.YELLOW + "Artist: " + EnumChatFormatting.GOLD + mapCredit);
                }
                tooltipToDisplay = tooltip;
                break;
            }
            tooltipToDisplay = button.getTooltip();
            break;
        }
        this.sizeX = 431;
        this.sizeY = 237;
        this.guiLeft = (this.field_146294_l - this.sizeX) / 2;
        this.guiTop = (this.field_146295_m - this.sizeY) / 2;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_146276_q_();
        this.blurBackground();
        this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, this.guiLeft + 2, this.guiTop + 2, this.sizeX - 4, this.sizeY - 4);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, this.sizeX, this.sizeY, 9728);
        Minecraft.func_71410_x().field_71466_p.func_78276_b("NEU Dungeon Map Editor", this.guiLeft + 8, this.guiTop + 6, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Border Size", this.guiLeft + 76, this.guiTop + 30, false, 137, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Rooms Size", this.guiLeft + 76, this.guiTop + 60, false, 137, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Icon Scale", this.guiLeft + 76, this.guiTop + 90, false, 137, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Border Style", this.guiLeft + 76, this.guiTop + 120, false, 137, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Dungeon Map", this.guiLeft + 44 + 139, this.guiTop + 30, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Center", this.guiLeft + 108 + 139, this.guiTop + 30, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Rotate", this.guiLeft + 44 + 139, this.guiTop + 59, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Icon Style", this.guiLeft + 108 + 139, this.guiTop + 59, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Check Orient", this.guiLeft + 44 + 139, this.guiTop + 88, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Check Center", this.guiLeft + 108 + 139, this.guiTop + 88, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Interpolation", this.guiLeft + 44 + 139, this.guiTop + 117, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Compatibility", this.guiLeft + 108 + 139, this.guiTop + 117, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Background", this.guiLeft + 44 + 139, this.guiTop + 146, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Border", this.guiLeft + 108 + 139, this.guiTop + 146, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("BG Blur", this.guiLeft + 44 + 139, this.guiTop + 175, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Chroma Type", this.guiLeft + 108 + 139, this.guiTop + 175, false, 60, -4934476);
        Utils.drawStringCenteredScaledMaxWidth("Edit Map Position", this.guiLeft + 76, this.guiTop + 209, false, 200, -4934476);
        try {
            this.drawSlider(DungeonMapConfig.class.getDeclaredField("dmBorderSize"), this.guiLeft + 76, this.guiTop + 45);
            this.drawSlider(DungeonMapConfig.class.getDeclaredField("dmRoomSize"), this.guiLeft + 76, this.guiTop + 75);
            this.drawSlider(DungeonMapConfig.class.getDeclaredField("dmIconScale"), this.guiLeft + 76, this.guiTop + 105);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        DungeonMapConfig options = NotEnoughUpdates.INSTANCE.config.dungeonMap;
        this.buttons.get(12).text = options.dmEnable ? "Enabled" : "Disabled";
        this.buttons.get(13).text = options.dmCenterPlayer ? "Player" : "Map";
        this.buttons.get(14).text = options.dmRotatePlayer ? "Player" : "Vertical";
        this.buttons.get(15).text = options.dmPlayerHeads <= 0 ? "Default" : (options.dmPlayerHeads == 1 ? "Heads" : "Heads w/ Border");
        this.buttons.get(16).text = options.dmOrientCheck ? "Orient" : "Off";
        this.buttons.get(17).text = options.dmCenterCheck ? "Center" : "Off";
        this.buttons.get(18).text = options.dmPlayerInterp ? "Interp" : "No Interp";
        this.buttons.get(19).text = options.dmCompat <= 0 ? "Normal" : (options.dmCompat >= 2 ? "No FB/SHD" : "No SHD");
        this.buttons.get(20).colour = new Color(SpecialColour.specialToChromaRGB(options.dmBackgroundColour));
        this.buttons.get(21).colour = new Color(SpecialColour.specialToChromaRGB(options.dmBorderColour));
        this.buttons.get(22).text = options.dmChromaBorder ? "Scroll" : "Normal";
        this.blurField.setSize(48, 16);
        this.blurField.render(this.guiLeft + 20 + 139, this.guiTop + 181);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.button_tex);
        RenderUtils.drawTexturedRect(this.guiLeft + 52, this.guiTop + 215, 48.0f, 16.0f);
        TextRenderUtils.drawStringCenteredScaledMaxWidth("Edit", this.guiLeft + 76, this.guiTop + 223, false, 48, -13619152);
        HashMap<String, Vec4b> decorations = new HashMap<String, Vec4b>();
        Vec4b vec4b = new Vec4b(3, -28, -48, 2);
        decorations.put(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), vec4b);
        HashSet<String> players = new HashSet<String>();
        players.add(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        demoMap.renderMap(this.guiLeft + 357, this.guiTop + 125, NotEnoughUpdates.INSTANCE.colourMap, decorations, 0, players, false, partialTicks);
        for (Button button : this.buttons) {
            button.render();
        }
        if (tooltipToDisplay != null) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, this.field_146294_l, this.field_146295_m, 200);
        }
        Utils.pushGuiScale(-1);
        if (this.activeColourEditor != null) {
            this.activeColourEditor.render();
        }
    }

    public void drawSlider(Field option, int centerX, int centerY) {
        float maxValue;
        float minValue;
        float value;
        try {
            value = ((Number)option.get(NotEnoughUpdates.INSTANCE.config.dungeonMap)).floatValue();
            ConfigEditorSlider sliderAnnotation = option.getAnnotation(ConfigEditorSlider.class);
            minValue = sliderAnnotation.minValue();
            maxValue = sliderAnnotation.maxValue();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
        float sliderAmount = Math.max(0.0f, Math.min(1.0f, (value - minValue) / (maxValue - minValue)));
        int sliderAmountI = (int)(96.0f * sliderAmount);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.slider_on_large);
        Utils.drawTexturedRect(centerX - 48, centerY - 8, sliderAmountI, 16.0f, 0.0f, sliderAmount, 0.0f, 1.0f, 9728);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.slider_off_large);
        Utils.drawTexturedRect(centerX - 48 + sliderAmountI, centerY - 8, 96 - sliderAmountI, 16.0f, sliderAmount, 1.0f, 0.0f, 1.0f, 9728);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.slider_button);
        Utils.drawTexturedRect(centerX - 48 + sliderAmountI - 4, centerY - 8, 8.0f, 16.0f, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.clickedSlider != null) {
            float maxValue;
            float minValue;
            try {
                ConfigEditorSlider sliderAnnotation = this.clickedSlider.getAnnotation(ConfigEditorSlider.class);
                minValue = sliderAnnotation.minValue();
                maxValue = sliderAnnotation.maxValue();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return;
            }
            float sliderAmount = (float)(mouseX - (this.guiLeft + 76 - 48)) / 96.0f;
            double val = minValue + (maxValue - minValue) * sliderAmount;
            if (Keyboard.isKeyDown((int)42)) {
                val = Math.round(val);
            }
            float value = (float)Math.max((double)minValue, Math.min((double)maxValue, val));
            try {
                if (this.clickedSlider.getType() == Integer.TYPE) {
                    this.clickedSlider.set(NotEnoughUpdates.INSTANCE.config.dungeonMap, Math.round(value));
                } else {
                    this.clickedSlider.set(NotEnoughUpdates.INSTANCE.config.dungeonMap, Float.valueOf(value));
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        for (Button button : this.buttons) {
            if (mouseX < this.guiLeft + button.x || mouseX > this.guiLeft + button.x + 48 || mouseY < this.guiTop + button.y || mouseY > this.guiTop + button.y + 16) continue;
            this.buttonClicked(mouseX, mouseY, button.id);
            this.blurField.otherComponentClick();
            return;
        }
        this.clickedSlider = null;
        if (mouseX >= this.guiLeft + 76 - 48 && mouseX <= this.guiLeft + 76 + 48) {
            try {
                if (mouseY > this.guiTop + 45 - 8 && mouseY < this.guiTop + 45 + 8) {
                    this.clickedSlider = DungeonMapConfig.class.getDeclaredField("dmBorderSize");
                    return;
                }
                if (mouseY > this.guiTop + 75 - 8 && mouseY < this.guiTop + 75 + 8) {
                    this.clickedSlider = DungeonMapConfig.class.getDeclaredField("dmRoomSize");
                    return;
                }
                if (mouseY > this.guiTop + 105 - 8 && mouseY < this.guiTop + 105 + 8) {
                    this.clickedSlider = DungeonMapConfig.class.getDeclaredField("dmIconScale");
                    return;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (mouseY > this.guiTop + 181 && mouseY < this.guiTop + 181 + 16) {
            if (mouseX > this.guiLeft + 20 + 139 && mouseX < this.guiLeft + 20 + 139 + 48) {
                this.blurField.mouseClicked(mouseX, mouseY, mouseButton);
                return;
            }
        } else if (mouseY > this.guiTop + 215 && mouseY < this.guiTop + 215 + 16 && mouseX > this.guiLeft + 52 && mouseX < this.guiLeft + 100) {
            int size = 80 + Math.round(40.0f * NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBorderSize);
            HashMap<String, Vec4b> decorations = new HashMap<String, Vec4b>();
            Vec4b vec4b = new Vec4b(3, -28, -48, 2);
            decorations.put(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), vec4b);
            HashSet<String> players = new HashSet<String>();
            players.add(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Runnable runnable = this.closedCallback;
            this.closedCallback = null;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPositionEditorButForTheDungeonMap(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmPosition, size, size, () -> {
                ScaledResolution scaledResolution = Utils.pushGuiScale(2);
                demoMap.renderMap(NotEnoughUpdates.INSTANCE.config.dungeonMap.dmPosition.getAbsX(scaledResolution, size) + size / 2, NotEnoughUpdates.INSTANCE.config.dungeonMap.dmPosition.getAbsY(scaledResolution, size) + size / 2, NotEnoughUpdates.INSTANCE.colourMap, decorations, 0, players, false, 0.0f);
                Utils.pushGuiScale(-1);
            }, () -> {}, () -> {
                NotEnoughUpdates.INSTANCE.openGui = new GuiDungeonMapEditor(runnable);
            }).withScale(2));
            return;
        }
        this.blurField.otherComponentClick();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.activeColourEditor != null) {
            ScaledResolution realRes = new ScaledResolution(Minecraft.func_71410_x());
            int mouseX = Mouse.getEventX() * realRes.func_78326_a() / this.field_146297_k.field_71443_c;
            int mouseY = realRes.func_78328_b() - Mouse.getEventY() * realRes.func_78328_b() / this.field_146297_k.field_71440_d - 1;
            this.activeColourEditor.mouseInput(mouseX, mouseY);
        }
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        if (this.activeColourEditor != null) {
            this.activeColourEditor.keyboardInput();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.blurField.getFocus()) {
            this.blurField.keyTyped(typedChar, keyCode);
            try {
                this.blurField.setCustomBorderColour(-1);
                NotEnoughUpdates.INSTANCE.config.dungeonMap.dmBackgroundBlur = Float.parseFloat(this.blurField.getText());
            }
            catch (Exception e2) {
                this.blurField.setCustomBorderColour(Color.RED.getRGB());
            }
        }
    }

    private void buttonClicked(int mouseX, int mouseY, int id) {
        DungeonMapConfig options = NotEnoughUpdates.INSTANCE.config.dungeonMap;
        switch (id) {
            case 0: {
                options.dmBorderSize = 0.0f;
                break;
            }
            case 1: {
                options.dmBorderSize = 1.0f;
                break;
            }
            case 2: {
                options.dmBorderSize = 2.0f;
                break;
            }
            case 30: {
                options.dmBorderSize = 3.0f;
                break;
            }
            case 3: {
                options.dmRoomSize = 0.0f;
                break;
            }
            case 4: {
                options.dmRoomSize = 1.0f;
                break;
            }
            case 5: {
                options.dmRoomSize = 2.0f;
                break;
            }
            case 29: {
                options.dmRoomSize = 3.0f;
                break;
            }
            case 18: {
                options.dmEnable = !options.dmEnable;
                break;
            }
            case 19: {
                options.dmCenterPlayer = !options.dmCenterPlayer;
                break;
            }
            case 20: {
                options.dmRotatePlayer = !options.dmRotatePlayer;
                break;
            }
            case 21: {
                ++options.dmPlayerHeads;
                if (options.dmPlayerHeads <= 2) break;
                options.dmPlayerHeads = 0;
                break;
            }
            case 22: {
                options.dmOrientCheck = !options.dmOrientCheck;
                break;
            }
            case 23: {
                options.dmCenterCheck = !options.dmCenterCheck;
                break;
            }
            case 24: {
                options.dmPlayerInterp = !options.dmPlayerInterp;
                break;
            }
            case 25: {
                ++options.dmCompat;
                if (options.dmCompat <= 2) break;
                options.dmCompat = 0;
                break;
            }
            case 26: {
                ScaledResolution realRes = new ScaledResolution(Minecraft.func_71410_x());
                mouseX = Mouse.getEventX() * realRes.func_78326_a() / this.field_146297_k.field_71443_c;
                mouseY = realRes.func_78328_b() - Mouse.getEventY() * realRes.func_78328_b() / this.field_146297_k.field_71440_d - 1;
                this.activeColourEditor = new GuiElementColour(mouseX, mouseY, () -> options.dmBackgroundColour, col -> {
                    options.dmBackgroundColour = col;
                }, () -> {
                    this.activeColourEditor = null;
                });
                break;
            }
            case 27: {
                ScaledResolution realRes = new ScaledResolution(Minecraft.func_71410_x());
                mouseX = Mouse.getEventX() * realRes.func_78326_a() / this.field_146297_k.field_71443_c;
                mouseY = realRes.func_78328_b() - Mouse.getEventY() * realRes.func_78328_b() / this.field_146297_k.field_71440_d - 1;
                this.activeColourEditor = new GuiElementColour(mouseX, mouseY, () -> options.dmBorderColour, col -> {
                    options.dmBorderColour = col;
                }, () -> {
                    this.activeColourEditor = null;
                });
                break;
            }
            case 28: {
                options.dmChromaBorder = !options.dmChromaBorder;
                break;
            }
            default: {
                if (id < 6 || id > 17) break;
                options.dmBorderStyle = id - 6;
            }
        }
    }

    private boolean isButtonPressed(int id) {
        DungeonMapConfig options = NotEnoughUpdates.INSTANCE.config.dungeonMap;
        if (id >= 0 && id <= 2) {
            return options.dmBorderSize == (float)id;
        }
        if (id >= 3 && id <= 5) {
            return options.dmRoomSize == (float)(id - 3);
        }
        if (id >= 6 && id <= 17) {
            return options.dmBorderStyle == id - 6;
        }
        if (id == 29) {
            return options.dmRoomSize == 3.0f;
        }
        if (id == 30) {
            return options.dmBorderSize == 3.0f;
        }
        return false;
    }

    private net.minecraft.util.Matrix4f createProjectionMatrix(int width, int height) {
        net.minecraft.util.Matrix4f projMatrix = new net.minecraft.util.Matrix4f();
        projMatrix.setIdentity();
        projMatrix.m00 = 2.0f / (float)width;
        projMatrix.m11 = 2.0f / (float)(-height);
        projMatrix.m22 = -0.0020001999f;
        projMatrix.m33 = 1.0f;
        projMatrix.m03 = -1.0f;
        projMatrix.m13 = 1.0f;
        projMatrix.m23 = -1.0001999f;
        return projMatrix;
    }

    private void blurBackground() {
        if (!OpenGlHelper.func_148822_b()) {
            return;
        }
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        if (this.blurOutputHorz == null) {
            this.blurOutputHorz = new Framebuffer(width, height, false);
            this.blurOutputHorz.func_147607_a(9728);
        }
        if (this.blurOutputVert == null) {
            this.blurOutputVert = new Framebuffer(width, height, false);
            this.blurOutputVert.func_147607_a(9728);
        }
        if (this.blurOutputHorz.field_147621_c != width || this.blurOutputHorz.field_147618_d != height) {
            this.blurOutputHorz.func_147613_a(width, height);
            this.blurShaderHorz.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
        if (this.blurOutputVert.field_147621_c != width || this.blurOutputVert.field_147618_d != height) {
            this.blurOutputVert.func_147613_a(width, height);
            this.blurShaderVert.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
        if (this.blurShaderHorz == null) {
            try {
                this.blurShaderHorz = new Shader(Minecraft.func_71410_x().func_110442_L(), "blur", Minecraft.func_71410_x().func_147110_a(), this.blurOutputHorz);
                this.blurShaderHorz.func_148043_c().func_147991_a("BlurDir").func_148087_a(1.0f, 0.0f);
                this.blurShaderHorz.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.blurShaderVert == null) {
            try {
                this.blurShaderVert = new Shader(Minecraft.func_71410_x().func_110442_L(), "blur", this.blurOutputHorz, this.blurOutputVert);
                this.blurShaderVert.func_148043_c().func_147991_a("BlurDir").func_148087_a(0.0f, 1.0f);
                this.blurShaderVert.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.blurShaderHorz != null && this.blurShaderVert != null) {
            if (15.0 != this.lastBgBlurFactor) {
                this.blurShaderHorz.func_148043_c().func_147991_a("Radius").func_148090_a(15.0f);
                this.blurShaderVert.func_148043_c().func_147991_a("Radius").func_148090_a(15.0f);
                this.lastBgBlurFactor = 15.0;
            }
            GL11.glPushMatrix();
            this.blurShaderHorz.func_148042_a(0.0f);
            this.blurShaderVert.func_148042_a(0.0f);
            GlStateManager.func_179126_j();
            GL11.glPopMatrix();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    }

    public void renderBlurredBackground(int width, int height, int x, int y, int blurWidth, int blurHeight) {
        if (!OpenGlHelper.func_148822_b()) {
            return;
        }
        float uMin = (float)x / (float)width;
        float uMax = (float)(x + blurWidth) / (float)width;
        float vMin = (float)(height - y) / (float)height;
        float vMax = (float)(height - y - blurHeight) / (float)height;
        this.blurOutputVert.func_147612_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(x, y, blurWidth, blurHeight, uMin, uMax, vMin, vMax);
        this.blurOutputVert.func_147606_d();
    }

    public void func_146281_b() {
        if (this.closedCallback != null) {
            this.closedCallback.run();
        }
    }

    class Button {
        private final int id;
        private final int x;
        private final int y;
        private String text;
        private Color colour = new Color(-1, true);
        private final Field option;
        private String displayName;
        private String desc;

        public Button(int id, int x, int y, String text) {
            this(id, x, y, text, null);
        }

        public Button(int id, int x, int y, String text, Field option) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.text = text;
            this.option = option;
            if (option != null) {
                ConfigOption optionAnnotation = option.getAnnotation(ConfigOption.class);
                this.displayName = optionAnnotation.name();
                this.desc = optionAnnotation.desc();
            }
        }

        public List<String> getTooltip() {
            if (this.option == null) {
                return null;
            }
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(EnumChatFormatting.YELLOW + this.displayName);
            for (String line : this.desc.split("\n")) {
                tooltip.add(EnumChatFormatting.AQUA + line);
            }
            return tooltip;
        }

        public void render() {
            if (this.text == null) {
                return;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BUTTON);
            if (GuiDungeonMapEditor.this.isButtonPressed(this.id)) {
                GlStateManager.func_179131_c((float)((float)this.colour.getRed() * 0.85f / 255.0f), (float)((float)this.colour.getGreen() * 0.85f / 255.0f), (float)((float)this.colour.getBlue() * 0.85f / 255.0f), (float)1.0f);
                Utils.drawTexturedRect(GuiDungeonMapEditor.this.guiLeft + this.x, GuiDungeonMapEditor.this.guiTop + this.y, 48.0f, 16.0f, 1.0f, 0.0f, 1.0f, 0.0f, 9728);
            } else {
                GlStateManager.func_179131_c((float)((float)this.colour.getRed() / 255.0f), (float)((float)this.colour.getGreen() / 255.0f), (float)((float)this.colour.getBlue() / 255.0f), (float)1.0f);
                Utils.drawTexturedRect(GuiDungeonMapEditor.this.guiLeft + this.x, GuiDungeonMapEditor.this.guiTop + this.y, 48.0f, 16.0f, 9728);
            }
            if (this.text.length() > 0) {
                Utils.drawStringCenteredScaledMaxWidth(this.text, GuiDungeonMapEditor.this.guiLeft + this.x + 24, GuiDungeonMapEditor.this.guiTop + this.y + 8, false, 39, -16777216);
            }
        }
    }
}

