/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.moe.nea.lisp;

import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.TestFramework;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/TestResultFormatter;", "", "writer", "Ljavax/xml/stream/XMLStreamWriter;", "(Ljavax/xml/stream/XMLStreamWriter;)V", "writeAll", "", "testResults", "", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/TestFramework$TestSuite;", "writeFailure", "fail", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/TestFramework$TestFailure;", "writeSkipped", "writeTestCase", "test", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/TestFramework$TestResult;", "writeTestSuite", "testSuite", "Companion", "nealisp"})
public final class TestResultFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XMLStreamWriter writer;
    @NotNull
    private static final SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");

    public TestResultFormatter(@NotNull XMLStreamWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.writer = writer;
    }

    public final void writeTestSuite(@NotNull TestFramework.TestSuite testSuite) {
        int n;
        TestFramework.TestResult it;
        int count$iv;
        int n2;
        Iterable $this$count$iv;
        Intrinsics.checkNotNullParameter((Object)testSuite, (String)"testSuite");
        this.writer.writeStartElement("testsuite");
        this.writer.writeAttribute("name", testSuite.getName());
        this.writer.writeAttribute("tests", String.valueOf(testSuite.getAllTests().size()));
        Iterable iterable = testSuite.getAllTests();
        String string = "skipped";
        XMLStreamWriter xMLStreamWriter = this.writer;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (TestFramework.TestResult)element$iv;
                boolean bl = false;
                if (!it.getWasSkipped() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int n3 = n2;
        xMLStreamWriter.writeAttribute(string, String.valueOf(n3));
        $this$count$iv = testSuite.getAllTests();
        string = "failures";
        xMLStreamWriter = this.writer;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (TestFramework.TestResult)element$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)it.getFailures()).isEmpty();
                if (!bl2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        n3 = n;
        xMLStreamWriter.writeAttribute(string, String.valueOf(n3));
        this.writer.writeAttribute("errors", "0");
        this.writer.writeAttribute("timestamp", timestampFormatter.format(Date.from(testSuite.getStartTime())));
        this.writer.writeStartElement("properties");
        this.writer.writeEndElement();
        Iterable $this$forEach$iv = testSuite.getAllTests();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestFramework.TestResult it2 = (TestFramework.TestResult)element$iv;
            boolean bl = false;
            this.writeTestCase(it2);
        }
        this.writer.writeStartElement("system-out");
        this.writer.writeCData(testSuite.getOtherOutput());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    public final void writeTestCase(@NotNull TestFramework.TestResult test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        this.writer.writeStartElement("testcase");
        this.writer.writeAttribute("name", test.getName());
        this.writer.writeAttribute("time", "0.0");
        if (test.getWasSkipped()) {
            this.writeSkipped();
        }
        for (TestFramework.TestFailure fail : test.getFailures()) {
            this.writeFailure(fail);
        }
        this.writer.writeStartElement("system-out");
        this.writer.writeCData(test.getStdout());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    public final void writeSkipped() {
        this.writer.writeStartElement("skipped");
        this.writer.writeEndElement();
    }

    public final void writeFailure(@NotNull TestFramework.TestFailure fail) {
        Intrinsics.checkNotNullParameter((Object)fail, (String)"fail");
        this.writer.writeStartElement("failure");
        this.writer.writeAttribute("message", fail.getMessage());
        this.writer.writeCData(fail.getCallsite().toSource());
        this.writer.writeEndElement();
    }

    public final void writeAll(@NotNull List<TestFramework.TestSuite> testResults) {
        Intrinsics.checkNotNullParameter(testResults, (String)"testResults");
        this.writer.writeStartDocument();
        this.writer.writeStartElement("testsuites");
        Iterable $this$forEach$iv = testResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestFramework.TestSuite it = (TestFramework.TestSuite)element$iv;
            boolean bl = false;
            this.writeTestSuite(it);
        }
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/TestResultFormatter$Companion;", "", "()V", "timestampFormatter", "Ljava/text/SimpleDateFormat;", "write", "", "writer", "Ljavax/xml/stream/XMLStreamWriter;", "testResults", "", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/TestFramework$TestSuite;", "nealisp"})
    public static final class Companion {
        private Companion() {
        }

        public final void write(@NotNull XMLStreamWriter writer, @NotNull List<TestFramework.TestSuite> testResults) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter(testResults, (String)"testResults");
            new TestResultFormatter(writer).writeAll(testResults);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

