/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.component;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IFontRenderer;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IMinecraft;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.KeyboardConstants;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiComponent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiImmediateContext;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.KeyboardEvent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.MouseEvent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.ClipboardUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.observer.GetSetter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u0000 ?2\u00020\u0001:\u0001?B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010&\u001a\u00020\u0006H\u0016J\u0018\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010.\u001a\u00020$2\u0006\u0010*\u001a\u00020+2\u0006\u0010/\u001a\u00020\u0006H\u0016J\u0010\u00100\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u00101\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u00102\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u00103\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u00104\u001a\u00020$2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0018\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0006H\u0002J \u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0006H\u0002J\b\u00109\u001a\u00020$H\u0016J\u0018\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u0006H\u0002J\b\u0010<\u001a\u00020$H\u0016J\u000e\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u00020\u0004R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0011R\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000f\"\u0004\b\u001b\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\"R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/component/TextFieldComponent;", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/GuiComponent;", "text", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/observer/GetSetter;", "", "width", "", "editable", "", "suggestion", "font", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/common/IFontRenderer;", "(Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/observer/GetSetter;ILio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/observer/GetSetter;Ljava/lang/String;Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/common/IFontRenderer;)V", "cursor", "getCursor", "()I", "setCursor", "(I)V", "getEditable", "()Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/observer/GetSetter;", "getFont", "()Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/common/IFontRenderer;", "scrollOffset", "getScrollOffset", "setScrollOffset", "selection", "getSelection", "setSelection", "getSuggestion", "()Ljava/lang/String;", "getText", "visibleText", "getVisibleText", "setVisibleText", "(Ljava/lang/String;)V", "checkScrollOffset", "", "getHeight", "getWidth", "keyboardEvent", "event", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/KeyboardEvent;", "context", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/GuiImmediateContext;", "mouseEvent", "Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/MouseEvent;", "onDirectionalKey", "i", "render", "renderBox", "renderCursor", "renderSelection", "renderText", "safeSubString", "str", "startIndex", "endIndex", "scrollCursorIntoView", "skipCharacters", "skipWords", "validateCursor", "writeText", "s", "Companion", "common"})
public class TextFieldComponent
extends GuiComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GetSetter<String> text;
    private final int width;
    @NotNull
    private final GetSetter<Boolean> editable;
    @NotNull
    private final String suggestion;
    @NotNull
    private final IFontRenderer font;
    private int cursor;
    private int selection;
    private int scrollOffset;
    @Nullable
    private String visibleText;
    private static final int TEXT_PADDING_X = 2;
    private static final int BACKGROUND_COLOR = -16777216;
    private static final int BORDER_COLOR_SELECTED = -96;
    private static final int BORDER_COLOR_UNSELECTED = -6250336;
    private static final int ENABLED_COLOR = -2039584;
    private static final int SUGGESTION_COLOR = -8355712;
    private static final int DISABLED_COLOR = -9408400;
    private static final int CURSOR_COLOR = -3092272;
    private static final int TEXT_PADDING_Y = 2;

    public TextFieldComponent(@NotNull GetSetter<String> text, int width, @NotNull GetSetter<Boolean> editable, @NotNull String suggestion, @NotNull IFontRenderer font) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Intrinsics.checkNotNullParameter(editable, (String)"editable");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.text = text;
        this.width = width;
        this.editable = editable;
        this.suggestion = suggestion;
        this.font = font;
        this.selection = -1;
    }

    public /* synthetic */ TextFieldComponent(GetSetter getSetter, int n, GetSetter getSetter2, String string, IFontRenderer iFontRenderer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            GetSetter<Boolean> getSetter3 = GetSetter.constant(true);
            Intrinsics.checkNotNullExpressionValue(getSetter3, (String)"constant(true)");
            getSetter2 = getSetter3;
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        if ((n2 & 0x10) != 0) {
            iFontRenderer = IMinecraft.instance.getDefaultFontRenderer();
        }
        this(getSetter, n, getSetter2, string, iFontRenderer);
    }

    @NotNull
    public final GetSetter<String> getText() {
        return this.text;
    }

    @NotNull
    public final GetSetter<Boolean> getEditable() {
        return this.editable;
    }

    @NotNull
    public final String getSuggestion() {
        return this.suggestion;
    }

    @NotNull
    public final IFontRenderer getFont() {
        return this.font;
    }

    public final int getCursor() {
        return this.cursor;
    }

    public final void setCursor(int n) {
        this.cursor = n;
    }

    public final int getSelection() {
        return this.selection;
    }

    public final void setSelection(int n) {
        this.selection = n;
    }

    public final int getScrollOffset() {
        return this.scrollOffset;
    }

    public final void setScrollOffset(int n) {
        this.scrollOffset = n;
    }

    @Nullable
    public final String getVisibleText() {
        return this.visibleText;
    }

    public final void setVisibleText(@Nullable String string) {
        this.visibleText = string;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 14;
    }

    public void scrollCursorIntoView() {
        this.validateCursor();
        if (this.scrollOffset > this.cursor) {
            this.scrollOffset = this.cursor;
        }
        if (this.scrollOffset < this.cursor) {
            String string = this.text.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.get()");
            if (this.font.trimStringToWidth(this.safeSubString(string, this.scrollOffset), this.width - 4).length() + this.scrollOffset < this.cursor) {
                this.scrollOffset = this.cursor;
            }
        }
        this.checkScrollOffset();
    }

    public void checkScrollOffset() {
        String text = this.text.get();
        int n = text.length();
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        int rightMostScrollOffset = n - this.font.trimStringToWidth(text, this.width - 4, true).length();
        this.scrollOffset = Math.max(0, Math.min(rightMostScrollOffset, this.scrollOffset));
    }

    @Override
    public void render(@NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.validateCursor();
        this.checkScrollOffset();
        String string = this.text.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.get()");
        this.visibleText = this.font.trimStringToWidth(this.safeSubString(string, this.scrollOffset), this.width - 4);
        this.renderBox(context);
        String string2 = this.visibleText;
        Intrinsics.checkNotNull((Object)string2);
        this.renderText(context, string2);
        String string3 = this.text.get();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text.get()");
        if (((CharSequence)string3).length() == 0 && !this.isFocused()) {
            context.getRenderContext().drawString(this.font, this.suggestion, 2, 2, -8355712, false);
        }
        if (this.isFocused()) {
            this.renderCursor(context);
        }
        this.renderSelection(context);
    }

    public void validateCursor() {
        this.cursor = Math.max(0, Math.min(this.text.get().length(), this.cursor));
    }

    private final void renderSelection(GuiImmediateContext context) {
        int right;
        int left;
        block5: {
            block4: {
                if (this.selection == this.cursor || this.selection == -1) {
                    return;
                }
                left = Math.min(this.cursor, this.selection);
                right = Math.max(this.cursor, this.selection);
                if (right < this.scrollOffset) break block4;
                String string = this.visibleText;
                Intrinsics.checkNotNull((Object)string);
                if (left <= this.scrollOffset + string.length()) break block5;
            }
            return;
        }
        int normalizedLeft = Math.max(this.scrollOffset, left) - this.scrollOffset;
        String string = this.visibleText;
        Intrinsics.checkNotNull((Object)string);
        int normalizedRight = Math.min(this.scrollOffset + string.length(), right) - this.scrollOffset;
        String string2 = this.visibleText;
        Intrinsics.checkNotNull((Object)string2);
        int leftPos = this.font.getStringWidth(this.safeSubString(string2, 0, normalizedLeft));
        String string3 = this.visibleText;
        Intrinsics.checkNotNull((Object)string3);
        int rightPos = leftPos + this.font.getStringWidth(this.safeSubString(string3, normalizedLeft, normalizedRight));
        context.getRenderContext().invertedRect(2 + leftPos, 2.0f, 2 + rightPos, this.getHeight() - 2);
    }

    private final void renderCursor(GuiImmediateContext context) {
        if (System.currentTimeMillis() / (long)1000 % (long)2 == 0L) {
            return;
        }
        if (this.cursor < this.scrollOffset) {
            return;
        }
        String string = this.visibleText;
        Intrinsics.checkNotNull((Object)string);
        if (this.cursor > this.scrollOffset + string.length()) {
            return;
        }
        String string2 = this.visibleText;
        Intrinsics.checkNotNull((Object)string2);
        int cursorOffset = this.font.getStringWidth(this.safeSubString(string2, 0, this.cursor - this.scrollOffset));
        context.getRenderContext().drawColoredRect(2 + cursorOffset, 2.0f, 2 + cursorOffset + 1, this.getHeight() - 2, -3092272);
    }

    private final void renderText(GuiImmediateContext context, String visibleText) {
        Boolean bl = this.editable.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"editable.get()");
        int textColor = bl != false ? -2039584 : -9408400;
        context.getRenderContext().drawString(this.font, visibleText, 2, 2, textColor, true);
    }

    private final void renderBox(GuiImmediateContext context) {
        int borderColor = this.isFocused() ? -96 : -6250336;
        context.getRenderContext().drawColoredRect(0.0f, 0.0f, this.width, this.getHeight(), borderColor);
        context.getRenderContext().drawColoredRect(1.0f, 1.0f, this.width - 1, this.getHeight() - 1, -16777216);
    }

    @Override
    public void keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context) {
        char it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.editable.get().booleanValue()) {
            return;
        }
        if (!this.isFocused()) {
            return;
        }
        if (event instanceof KeyboardEvent.KeyPressed && ((KeyboardEvent.KeyPressed)event).getPressed()) {
            int n = ((KeyboardEvent.KeyPressed)event).getKeycode();
            if (n == KeyboardConstants.INSTANCE.getLeft()) {
                this.onDirectionalKey(context, -1);
                return;
            }
            if (n == KeyboardConstants.INSTANCE.getRight()) {
                this.onDirectionalKey(context, 1);
                return;
            }
            if (n == KeyboardConstants.INSTANCE.getHome() ? true : n == KeyboardConstants.INSTANCE.getUp()) {
                if (context.getRenderContext().isShiftDown()) {
                    if (this.selection == -1) {
                        this.selection = this.cursor;
                    }
                } else {
                    this.selection = -1;
                }
                this.cursor = 0;
                this.scrollCursorIntoView();
                return;
            }
            if (n == KeyboardConstants.INSTANCE.getDown() ? true : n == KeyboardConstants.INSTANCE.getEnd()) {
                if (context.getRenderContext().isShiftDown()) {
                    if (this.selection == -1) {
                        this.selection = this.cursor;
                    }
                } else {
                    this.selection = -1;
                }
                this.cursor = this.text.get().length();
                this.scrollCursorIntoView();
                return;
            }
            if (n == KeyboardConstants.INSTANCE.getBackSpace()) {
                if (this.selection == -1) {
                    this.selection = this.skipCharacters(context.getRenderContext().isCtrlDown(), -1);
                }
                this.writeText("");
                return;
            }
            if (n == KeyboardConstants.INSTANCE.getDelete()) {
                if (this.selection == -1) {
                    this.selection = this.skipCharacters(context.getRenderContext().isCtrlDown(), 1);
                }
                this.writeText("");
                return;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyC()) {
                if (context.getRenderContext().isCtrlDown()) {
                    ClipboardUtils.copyToClipboard(this.getSelection());
                    return;
                }
            } else if (n == KeyboardConstants.INSTANCE.getKeyX()) {
                if (context.getRenderContext().isCtrlDown()) {
                    ClipboardUtils.copyToClipboard(this.getSelection());
                    this.writeText("");
                    return;
                }
            } else if (n == KeyboardConstants.INSTANCE.getKeyV()) {
                if (context.getRenderContext().isCtrlDown()) {
                    String string = ClipboardUtils.getClipboardContent();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClipboardContent()");
                    this.writeText(string);
                    return;
                }
            } else if (n == KeyboardConstants.INSTANCE.getKeyA() && context.getRenderContext().isCtrlDown()) {
                this.cursor = this.text.get().length();
                this.selection = 0;
                this.scrollCursorIntoView();
                return;
            }
        } else if (event instanceof KeyboardEvent.CharTyped && Intrinsics.compare((int)(it = ((KeyboardEvent.CharTyped)event).getChar()), (int)32) >= 0 && it != '\u00a7' && it != '\u007f') {
            char c = it;
            String string = "";
            this.writeText(c + string);
        }
    }

    private final String getSelection() {
        if (this.selection == -1) {
            return "";
        }
        int l = Math.min(this.cursor, this.selection);
        int r = Math.max(this.cursor, this.selection);
        String string = this.text.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.get()");
        return this.safeSubString(string, l, r);
    }

    @Override
    public void mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.mouseEvent(mouseEvent, context);
        if (context.isHovered() && mouseEvent instanceof MouseEvent.Click) {
            int mouseButton = ((MouseEvent.Click)mouseEvent).component1();
            boolean mouseState = ((MouseEvent.Click)mouseEvent).component2();
            if (mouseState && mouseButton == 0) {
                this.requestFocus();
            }
        }
    }

    private final String safeSubString(String str, int startIndex) {
        String string = str.substring(Math.min(startIndex, str.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }

    private final String safeSubString(String str, int startIndex, int endIndex) {
        String string = str.substring(Math.min(startIndex, str.length()), Math.min(Math.max(startIndex, endIndex), str.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final void writeText(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String t = this.text.get();
        if (this.selection == -1) {
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
            this.text.set(stringBuilder.append(this.safeSubString(t, 0, this.cursor)).append(s).append(this.safeSubString(t, this.cursor)).toString());
            this.cursor += s.length();
        } else {
            int l = Math.min(this.cursor, this.selection);
            int r = Math.max(this.cursor, this.selection);
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
            this.text.set(stringBuilder.append(this.safeSubString(t, 0, l)).append(s).append(this.safeSubString(t, r)).toString());
            this.cursor = l + s.length();
            this.selection = -1;
        }
        this.scrollCursorIntoView();
    }

    public void onDirectionalKey(@NotNull GuiImmediateContext context, int i) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getRenderContext().isShiftDown()) {
            if (this.selection == -1) {
                this.selection = this.cursor;
            }
            this.cursor = this.skipCharacters(context.getRenderContext().isCtrlDown(), i);
        } else if (this.selection != -1) {
            this.cursor = i < 0 ? Math.min(this.cursor, this.selection) : Math.max(this.cursor, this.selection);
            this.selection = -1;
        } else {
            this.cursor = this.skipCharacters(context.getRenderContext().isCtrlDown(), i);
        }
        this.scrollCursorIntoView();
    }

    private final int skipCharacters(boolean skipWords, int i) {
        if (i != -1 && i != 1) {
            return this.cursor;
        }
        int position = this.cursor;
        do {
            if ((position += i) < 0) {
                return 0;
            }
            if (position > this.text.get().length()) {
                return this.text.get().length();
            }
            if (skipWords) continue;
            return position;
        } while (position >= this.text.get().length() || !Character.isWhitespace(this.text.get().charAt(position)));
        return position;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/moulberry/notenoughupdates/deps/io/github/moulberry/moulconfig/gui/component/TextFieldComponent$Companion;", "", "()V", "BACKGROUND_COLOR", "", "BORDER_COLOR_SELECTED", "BORDER_COLOR_UNSELECTED", "CURSOR_COLOR", "DISABLED_COLOR", "ENABLED_COLOR", "SUGGESTION_COLOR", "TEXT_PADDING_X", "TEXT_PADDING_Y", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

