/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.component;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiComponent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiImmediateContext;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.KeyboardEvent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class ColumnComponent
extends GuiComponent {
    final List<GuiComponent> children;

    public ColumnComponent(List<GuiComponent> children) {
        this.children = children;
    }

    public ColumnComponent(GuiComponent ... children) {
        this(Arrays.asList(children));
    }

    @Override
    public int getWidth() {
        return this.foldChildren(0, (child, width) -> Math.max(child.getWidth(), width));
    }

    @Override
    public int getHeight() {
        return this.foldChildren(0, (child, height) -> child.getHeight() + height);
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        for (GuiComponent child : this.children) {
            initial = visitor.apply(child, (GuiComponent)initial);
        }
        return initial;
    }

    public void foldWithContext(GuiImmediateContext context, BiConsumer<GuiComponent, GuiImmediateContext> visitor) {
        int width = this.getWidth();
        this.foldChildren(0, (child, position) -> {
            visitor.accept((GuiComponent)child, context.translated(0, (int)position, width, child.getHeight()));
            return child.getHeight() + position;
        });
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        this.foldWithContext(context, (child, childContext) -> {
            child.render((GuiImmediateContext)childContext);
            context.getRenderContext().translate(0.0f, child.getHeight(), 0.0f);
        });
        context.getRenderContext().popMatrix();
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        this.foldWithContext(context, (component, context1) -> component.mouseEvent(mouseEvent, (GuiImmediateContext)context1));
    }

    @Override
    public void keyboardEvent(KeyboardEvent event, GuiImmediateContext context) {
        this.foldWithContext(context, (guiComponent, guiImmediateContext) -> guiComponent.keyboardEvent(event, (GuiImmediateContext)guiImmediateContext));
    }

    public String toString() {
        return "ColumnComponent(children=" + this.children + ")";
    }
}

