/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.cosmetics;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.GuiElementTextField;
import io.github.moulberry.notenoughupdates.cosmetics.CapeManager;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.GuiTextures;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.Matrix4f;

public class GuiCosmetics
extends GuiScreen {
    public static final ResourceLocation cosmetics_fg = new ResourceLocation("notenoughupdates:cosmetics_fg.png");
    private final GuiElementTextField unlockTextField = new GuiElementTextField("", 32);
    private CosmeticsPage currentPage = CosmeticsPage.CAPES;
    private int sizeX;
    private int sizeY;
    private int guiLeft;
    private int guiTop;
    private String wantToEquipCape = null;
    private long lastCapeEquip = 0L;
    private List<String> cosmeticsInfoTooltip = null;
    private final HashMap<String, ResourceLocation> capesLocation = new HashMap();
    private float scroll = 0.0f;
    private int scrollClickedX = -1;
    Shader blurShaderHorz = null;
    Framebuffer blurOutputHorz = null;
    Shader blurShaderVert = null;
    Framebuffer blurOutputVert = null;
    private double lastBgBlurFactor = -1.0;

    public GuiCosmetics() {
        Gson gson = new Gson();
        JsonElement cosmeticHelpTextElement = Utils.getElement(Constants.MISC, "cosmeticsinfo.lore");
        if (cosmeticHelpTextElement.isJsonArray()) {
            this.cosmeticsInfoTooltip = (List)gson.fromJson(cosmeticHelpTextElement, new TypeToken<List<String>>(){}.getType());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.sizeX = 431;
        this.sizeY = 202;
        this.guiLeft = (this.field_146294_l - this.sizeX) / 2;
        this.guiTop = (this.field_146295_m - this.sizeY) / 2;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_146276_q_();
        this.blurBackground();
        this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, this.guiLeft + 2, this.guiTop + 2, this.sizeX - 4, this.sizeY - 4);
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        this.renderTabs(true);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-3.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
        this.renderTabs(false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_bg);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, this.sizeX, this.sizeY, 9728);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.currentPage) {
            case CAPES: {
                this.drawCapesPage(mouseX, mouseY, partialTicks);
            }
        }
        int helpX = this.guiLeft + this.sizeX - 20;
        if (mouseX >= helpX && mouseX <= helpX + 20 && mouseY >= this.guiTop - 20 && mouseY <= this.guiTop && this.cosmeticsInfoTooltip != null) {
            ArrayList<String> grayTooltip = new ArrayList<String>(this.cosmeticsInfoTooltip.size());
            for (String line : this.cosmeticsInfoTooltip) {
                grayTooltip.add(EnumChatFormatting.GRAY + line);
            }
            Utils.drawHoveringText(grayTooltip, mouseX, mouseY, this.field_146294_l, this.field_146295_m, -1);
        }
        StringBuilder statusMsg = new StringBuilder("Last Sync: ");
        if (CapeManager.INSTANCE.lastCapeSynced == 0L) {
            statusMsg.append("Not Synced");
        } else {
            statusMsg.append((System.currentTimeMillis() - CapeManager.INSTANCE.lastCapeSynced) / 1000L).append("s ago");
        }
        statusMsg.append(" - Next Sync: ");
        if (CapeManager.INSTANCE.lastCapeUpdate == 0L) {
            statusMsg.append("ASAP");
        } else {
            statusMsg.append(60L - (System.currentTimeMillis() - CapeManager.INSTANCE.lastCapeUpdate) / 1000L).append("s");
        }
        Minecraft.func_71410_x().field_71466_p.func_175065_a(EnumChatFormatting.AQUA + statusMsg.toString(), (float)(this.guiLeft + this.sizeX - Minecraft.func_71410_x().field_71466_p.func_78256_a(statusMsg.toString()) - 20), (float)(this.guiTop - 12), 0, true);
        if (this.currentPage == CosmeticsPage.CAPES) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_dropdown);
            Utils.drawTexturedRect((float)this.guiLeft + (float)this.sizeX / 2.0f - 50.0f, this.guiTop + this.sizeY + 5, 100.0f, 20.0f, 0.0f, 0.5f, 0.0f, 0.10810811f, 9728);
            String equipMsg = this.wantToEquipCape != null ? EnumChatFormatting.GREEN + "Equip Cape" : EnumChatFormatting.GREEN + "Unequip";
            if (System.currentTimeMillis() - this.lastCapeEquip < 20000L) {
                equipMsg = equipMsg + " - " + (20L - (System.currentTimeMillis() - this.lastCapeEquip) / 1000L) + "s";
            }
            Utils.drawStringCenteredScaledMaxWidth(equipMsg, (float)this.guiLeft + (float)this.sizeX / 2.0f, this.guiTop + this.sizeY + 5 + 10, false, 90, 0);
        }
        if (this.unlockTextField.getFocus() || !this.unlockTextField.getText().isEmpty()) {
            this.unlockTextField.setPrependText("");
        } else {
            this.unlockTextField.setPrependText("\u00a77Creator Code");
        }
        this.unlockTextField.setSize(80, 20);
        this.unlockTextField.render(this.guiLeft + this.sizeX - 80, this.guiTop + this.sizeY + 2);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.help);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(helpX, this.guiTop - 20, 20.0f, 20.0f, 9729);
    }

    private void renderTabs(boolean renderPressed) {
        int ignoredTabs = 0;
        for (int i = 0; i < CosmeticsPage.values().length; ++i) {
            boolean pressed;
            CosmeticsPage page = CosmeticsPage.values()[i];
            if (page.stack == null) {
                ++ignoredTabs;
                continue;
            }
            boolean bl = pressed = page == this.currentPage;
            if (pressed != renderPressed) continue;
            this.renderTab(page.stack, i - ignoredTabs, pressed);
        }
    }

    private void renderTab(ItemStack stack, int xIndex, boolean pressed) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        int x = this.guiLeft + xIndex * 28;
        int y = this.guiTop - 28;
        float uMin = 0.0f;
        float uMax = 0.109375f;
        float vMin = 0.078125f;
        float vMax = 0.19921875f;
        if (pressed) {
            vMin = 0.203125f;
            vMax = 0.328125f;
            if (xIndex != 0) {
                uMin = 0.109375f;
                uMax = 0.21875f;
            }
            this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, x + 2, y + 2, 24, 24);
        } else {
            this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, x + 2, y + 4, 24, 24);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
        Utils.drawTexturedRect(x, y, 28.0f, pressed ? 32.0f : 31.0f, uMin, uMax, vMin, vMax, 9728);
        GlStateManager.func_179126_j();
        Utils.drawItemStack(stack, x + 6, y + 9);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.unlockTextField.getFocus()) {
            if (keyCode == 1 || keyCode == 28) {
                CapeManager.INSTANCE.tryUnlockCape(this.unlockTextField.getText().trim());
                this.unlockTextField.setText("");
                this.unlockTextField.setFocus(false);
            } else {
                this.unlockTextField.keyTyped(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (mouseX > this.guiLeft + this.sizeX - 140 & mouseX < this.guiLeft + this.sizeX && mouseY > this.guiTop + this.sizeY && mouseY < this.guiTop + this.sizeY + 22) {
            this.unlockTextField.mouseClicked(mouseX, mouseY, mouseButton);
        }
        for (int i = 0; i < CosmeticsPage.values().length; ++i) {
            CapeManager.CapeData[] page = CosmeticsPage.values()[i];
            int x = this.guiLeft + i * 28;
            int y = this.guiTop - 28;
            if (mouseX <= x || mouseX >= x + 28 || mouseY <= y || mouseY >= y + 32) continue;
            if (this.currentPage != page) {
                Utils.playPressSound();
            }
            this.currentPage = page;
            return;
        }
        if (mouseY > this.guiTop + 177 && mouseY < this.guiTop + 177 + 12 && (float)mouseX > (float)(this.guiLeft + 15) + 371.0f * this.scroll && (float)mouseX < (float)(this.guiLeft + 15) + 371.0f * this.scroll + 32.0f) {
            this.scrollClickedX = mouseX - (int)((float)(this.guiLeft + 15) + 371.0f * this.scroll);
            return;
        }
        int displayingCapes = 0;
        for (CapeManager.CapeData cape : CapeManager.INSTANCE.getCapes()) {
            boolean equipable;
            boolean bl = equipable = CapeManager.INSTANCE.getAvailableCapes() == null || CapeManager.INSTANCE.getAvailableCapes().contains(cape.capeName);
            if (!cape.canShow() && !equipable) continue;
            ++displayingCapes;
        }
        float totalNeeded = 91 * displayingCapes;
        float totalAvail = this.sizeX - 20;
        float xOffset = this.scroll * (totalNeeded - totalAvail);
        int displayIndex = 0;
        for (CapeManager.CapeData cape : CapeManager.INSTANCE.getCapes()) {
            boolean equipable;
            boolean bl = equipable = CapeManager.INSTANCE.getAvailableCapes() == null || CapeManager.INSTANCE.getAvailableCapes().contains(cape.capeName);
            if (!cape.canShow() && !equipable) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect((float)(this.guiLeft + 20 + 91 * displayIndex) - xOffset, this.guiTop + 123, 81.0f, 20.0f, 0.0f, 0.31640625f, 0.84375f, 0.921875f, 9728);
            if ((float)mouseX > (float)(this.guiLeft + 20 + 91 * displayIndex) - xOffset && (float)mouseX < (float)(this.guiLeft + 20 + 91 * displayIndex) - xOffset + 81.0f) {
                if (mouseY > this.guiTop + 123 && mouseY < this.guiTop + 123 + 20) {
                    if (CapeManager.INSTANCE.localCape != null && ((String)CapeManager.INSTANCE.localCape.getRight()).equals(cape.capeName)) {
                        CapeManager.INSTANCE.setCape(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", ""), "null", true);
                    } else {
                        CapeManager.INSTANCE.setCape(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", ""), cape.capeName, true);
                    }
                    return;
                }
                if (equipable && mouseY > this.guiTop + 149 && mouseY < this.guiTop + 149 + 20) {
                    this.wantToEquipCape = cape.capeName.equals(this.wantToEquipCape) ? null : cape.capeName;
                    return;
                }
            }
            ++displayIndex;
        }
        if (this.currentPage == CosmeticsPage.CAPES) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_dropdown);
            Utils.drawTexturedRect((float)this.guiLeft + (float)this.sizeX / 2.0f - 50.0f, this.guiTop + this.sizeY + 5, 100.0f, 20.0f, 0.0f, 0.5f, 0.0f, 0.10810811f, 9728);
            if ((float)mouseX > (float)this.guiLeft + (float)this.sizeX / 2.0f - 50.0f && (float)mouseX < (float)this.guiLeft + (float)this.sizeX / 2.0f + 50.0f && mouseY > this.guiTop + this.sizeY + 5 && mouseY < this.guiTop + this.sizeY + 25 && System.currentTimeMillis() - this.lastCapeEquip > 20000L) {
                CapeManager.INSTANCE.setCape(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", ""), this.wantToEquipCape, true);
                this.lastCapeEquip = System.currentTimeMillis();
                try {
                    String userName = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
                    String accessToken = Minecraft.func_71410_x().func_110432_I().func_148254_d();
                    Random r1 = new Random();
                    Random r2 = new Random(System.identityHashCode(new Object()));
                    BigInteger random1Bi = new BigInteger(128, r1);
                    BigInteger random2Bi = new BigInteger(128, r2);
                    BigInteger serverBi = random1Bi.xor(random2Bi);
                    String serverId = serverBi.toString(16);
                    Minecraft.func_71410_x().func_152347_ac().joinServer(Minecraft.func_71410_x().func_110432_I().func_148256_e(), accessToken, serverId);
                    String toEquipName = this.wantToEquipCape == null ? "null" : this.wantToEquipCape;
                    NotEnoughUpdates.INSTANCE.manager.apiUtils.newMoulberryRequest("cgi-bin/changecape.py").queryArgument("capeType", toEquipName).queryArgument("serverId", serverId).queryArgument("username", userName).requestString().thenAccept(System.out::println);
                }
                catch (Exception e2) {
                    System.out.println("Exception while generating mojang shared secret");
                    e2.printStackTrace();
                }
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.scrollClickedX = -1;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.scrollClickedX >= 0) {
            float scrollStartX = mouseX - this.scrollClickedX;
            this.scroll = (scrollStartX - (float)(this.guiLeft + 15)) / 371.0f;
            this.scroll = Math.max(0.0f, Math.min(1.0f, this.scroll));
        }
    }

    private void drawCapesPage(int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(cosmetics_fg);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, this.sizeX, this.sizeY, 9728);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
        Utils.drawTexturedRect((float)(this.guiLeft + 15) + 371.0f * this.scroll, this.guiTop + 177, 32.0f, 12.0f, 0.0f, 0.125f, 0.75f, 0.796875f, 9728);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(Minecraft.func_71410_x().field_71443_c * (this.guiLeft + 3) / this.field_146294_l), (int)0, (int)(Minecraft.func_71410_x().field_71443_c * (this.sizeX - 6) / this.field_146294_l), (int)Minecraft.func_71410_x().field_71440_d);
        int displayingCapes = 0;
        for (CapeManager.CapeData capeData : CapeManager.INSTANCE.getCapes()) {
            boolean equipable;
            boolean bl = equipable = CapeManager.INSTANCE.getAvailableCapes() == null || CapeManager.INSTANCE.getAvailableCapes().contains(capeData.capeName);
            if (!capeData.canShow() && !equipable) continue;
            ++displayingCapes;
        }
        float totalNeeded = 91 * displayingCapes;
        float totalAvail = this.sizeX - 20;
        float xOffset = this.scroll * (totalNeeded - totalAvail);
        int displayIndex = 0;
        for (CapeManager.CapeData capeData : CapeManager.INSTANCE.getCapes()) {
            boolean equipable;
            boolean bl = equipable = CapeManager.INSTANCE.getAvailableCapes() == null || CapeManager.INSTANCE.getAvailableCapes().contains(capeData.capeName);
            if (!capeData.canShow() && !equipable) continue;
            if (capeData.capeName.equals(CapeManager.INSTANCE.getCape(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", "")))) {
                GlStateManager.func_179131_c((float)0.98039216f, (float)0.78431374f, (float)0.0f, (float)1.0f);
                Utils.drawGradientRect(this.guiLeft + 20 + 91 * displayIndex - (int)xOffset, this.guiTop + 10, this.guiLeft + 20 + 91 * displayIndex - (int)xOffset + 81, this.guiTop + 10 + 108, new Color(150, 100, 0, 40).getRGB(), new Color(250, 200, 0, 40).getRGB());
            } else if (capeData.capeName.equals(this.wantToEquipCape)) {
                GlStateManager.func_179131_c((float)0.0f, (float)0.78431374f, (float)0.98039216f, (float)1.0f);
                Utils.drawGradientRect(this.guiLeft + 20 + 91 * displayIndex - (int)xOffset, this.guiTop + 10, this.guiLeft + 20 + 91 * displayIndex - (int)xOffset + 81, this.guiTop + 10 + 108, new Color(0, 100, 150, 40).getRGB(), new Color(0, 200, 250, 40).getRGB());
            } else if (CapeManager.INSTANCE.localCape != null && ((String)CapeManager.INSTANCE.localCape.getRight()).equals(capeData.capeName)) {
                GlStateManager.func_179131_c((float)0.39215687f, (float)0.98039216f, (float)0.5882353f, (float)1.0f);
                Utils.drawGradientRect(this.guiLeft + 20 + 91 * displayIndex - (int)xOffset, this.guiTop + 10, this.guiLeft + 20 + 91 * displayIndex - (int)xOffset + 81, this.guiTop + 10 + 108, new Color(50, 100, 75, 40).getRGB(), new Color(100, 250, 150, 40).getRGB());
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
            Utils.drawTexturedRect((float)(this.guiLeft + 20 + 91 * displayIndex) - xOffset, this.guiTop + 10, 81.0f, 108.0f, 0.0f, 0.31640625f, 0.328125f, 0.75f, 9728);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect((float)(this.guiLeft + 20 + 91 * displayIndex) - xOffset, this.guiTop + 123, 81.0f, 20.0f, 0.0f, 0.31640625f, 0.84375f, 0.921875f, 9728);
            boolean equipPressed = capeData.capeName.equals(this.wantToEquipCape);
            if (!equipable) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            Utils.drawTexturedRect((float)(this.guiLeft + 20 + 91 * displayIndex) - xOffset, this.guiTop + 149, 81.0f, 20.0f, equipPressed ? 0.31640625f : 0.0f, equipPressed ? 0.0f : 0.31640625f, equipPressed ? 0.921875f : 0.84375f, equipPressed ? 0.84375f : 0.921875f, 9728);
            Utils.drawStringCenteredScaledMaxWidth("Try it out", (float)(this.guiLeft + 20 + 91 * displayIndex) + 40.5f - xOffset, this.guiTop + 123 + 10, false, 75, new Color(100, 250, 150).getRGB());
            if (equipable) {
                Utils.drawStringCenteredScaledMaxWidth("Equip", (float)(this.guiLeft + 20 + 91 * displayIndex) + 40.5f - xOffset, this.guiTop + 149 + 10, false, 75, new Color(100, 250, 150).getRGB());
            } else {
                Utils.drawStringCenteredScaledMaxWidth("Not Unlocked", (float)(this.guiLeft + 20 + 91 * displayIndex) + 40.5f - xOffset, this.guiTop + 149 + 10, false, 75, new Color(200, 50, 50, 100).getRGB());
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ResourceLocation capeTexture = this.capesLocation.computeIfAbsent(capeData.capeName, k -> new ResourceLocation("notenoughupdates", "capes/" + capeData.capeName + "_preview.png"));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(capeTexture);
            Utils.drawTexturedRect((float)(this.guiLeft + 31 + 91 * displayIndex) - xOffset, this.guiTop + 24, 59.0f, 84.0f, 9728);
            ++displayIndex;
        }
        GL11.glScissor((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        GL11.glDisable((int)3089);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
    }

    private net.minecraft.util.Matrix4f createProjectionMatrix(int width, int height) {
        net.minecraft.util.Matrix4f projMatrix = new net.minecraft.util.Matrix4f();
        projMatrix.setIdentity();
        projMatrix.m00 = 2.0f / (float)width;
        projMatrix.m11 = 2.0f / (float)(-height);
        projMatrix.m22 = -0.0020001999f;
        projMatrix.m33 = 1.0f;
        projMatrix.m03 = -1.0f;
        projMatrix.m13 = 1.0f;
        projMatrix.m23 = -1.0001999f;
        return projMatrix;
    }

    private void blurBackground() {
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        if (this.blurOutputHorz == null) {
            this.blurOutputHorz = new Framebuffer(width, height, false);
            this.blurOutputHorz.func_147607_a(9728);
        }
        if (this.blurOutputVert == null) {
            this.blurOutputVert = new Framebuffer(width, height, false);
            this.blurOutputVert.func_147607_a(9728);
        }
        if (this.blurOutputHorz.field_147621_c != width || this.blurOutputHorz.field_147618_d != height) {
            this.blurOutputHorz.func_147613_a(width, height);
            this.blurShaderHorz.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
        if (this.blurOutputVert.field_147621_c != width || this.blurOutputVert.field_147618_d != height) {
            this.blurOutputVert.func_147613_a(width, height);
            this.blurShaderVert.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
        if (this.blurShaderHorz == null) {
            try {
                this.blurShaderHorz = new Shader(Minecraft.func_71410_x().func_110442_L(), "blur", Minecraft.func_71410_x().func_147110_a(), this.blurOutputHorz);
                this.blurShaderHorz.func_148043_c().func_147991_a("BlurDir").func_148087_a(1.0f, 0.0f);
                this.blurShaderHorz.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.blurShaderVert == null) {
            try {
                this.blurShaderVert = new Shader(Minecraft.func_71410_x().func_110442_L(), "blur", this.blurOutputHorz, this.blurOutputVert);
                this.blurShaderVert.func_148043_c().func_147991_a("BlurDir").func_148087_a(0.0f, 1.0f);
                this.blurShaderVert.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.blurShaderHorz != null && this.blurShaderVert != null) {
            if (15.0 != this.lastBgBlurFactor) {
                this.blurShaderHorz.func_148043_c().func_147991_a("Radius").func_148090_a(15.0f);
                this.blurShaderVert.func_148043_c().func_147991_a("Radius").func_148090_a(15.0f);
                this.lastBgBlurFactor = 15.0;
            }
            GL11.glPushMatrix();
            this.blurShaderHorz.func_148042_a(0.0f);
            this.blurShaderVert.func_148042_a(0.0f);
            GlStateManager.func_179126_j();
            GL11.glPopMatrix();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    }

    public void renderBlurredBackground(int width, int height, int x, int y, int blurWidth, int blurHeight) {
        float uMin = (float)x / (float)width;
        float uMax = (float)(x + blurWidth) / (float)width;
        float vMin = (float)(height - y) / (float)height;
        float vMax = (float)(height - y - blurHeight) / (float)height;
        this.blurOutputVert.func_147612_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(x, y, blurWidth, blurHeight, uMin, uMax, vMin, vMax);
        this.blurOutputVert.func_147606_d();
    }

    public static enum CosmeticsPage {
        CAPES(new ItemStack((Item)Items.field_151023_V));

        public final ItemStack stack;

        private CosmeticsPage(ItemStack stack) {
            this.stack = stack;
        }
    }
}

