/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.cosmetics;

import io.github.moulberry.notenoughupdates.cosmetics.NEUCape;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class CapeNode {
    private static final NEUCape.Direction[] cardinals = new NEUCape.Direction[]{NEUCape.Direction.UP, NEUCape.Direction.RIGHT, NEUCape.Direction.DOWN, NEUCape.Direction.LEFT};
    public Vector3f position;
    public Vector3f lastPosition = new Vector3f();
    public Vector3f renderPosition = new Vector3f();
    public final Vector3f[] oldRenderPosition = new Vector3f[5];
    public final Vector3f velocity = new Vector3f();
    public Vector3f normal = null;
    public Vector3f sideNormal = null;
    public boolean fixed = false;
    public static final int DRAW_MASK_FRONT = 1;
    public static final int DRAW_MASK_BACK = 2;
    public static final int DRAW_MASK_SIDES = 4;
    public HashMap<NEUCape.Offset, CapeNode> neighbors = new HashMap();
    public float texU = 0.0f;
    public float texV = 0.0f;
    public float horzDistMult = 2.0f;
    public float vertDistMult = 0.5f;
    public float horzSideTexU = 0.0f;
    public float horzSideTexVTop = 0.0f;
    public float vertSideTexU = 0.0f;
    public float vertSideTexVTop = 0.0f;
    public final float gravity = 0.1f;
    public final float resistance = 0.5f;
    public static final int FLOAT_NUM = 20;

    public CapeNode(float x, float y, float z) {
        this.position = new Vector3f(x, y, z);
    }

    private List<Vector2f> getConstaints() {
        ArrayList<Vector2f> constaints = new ArrayList<Vector2f>();
        for (NEUCape.Direction cardinal : cardinals) {
            for (int i = 1; i <= 2; ++i) {
                NEUCape.Offset offset = new NEUCape.Offset(cardinal, i);
                CapeNode other = this.neighbors.get(offset);
                if (other == null) continue;
                int iOffset = offset.getXOffset() + 6 * offset.getYOffset();
                constaints.add(new Vector2f((float)iOffset, (float)i * NEUCape.targetDist * (cardinal.yOff == 0 ? this.horzDistMult : this.vertDistMult)));
            }
        }
        return constaints;
    }

    public void loadIntoBuffer(FloatBuffer buffer) {
        this.loadVec3IntoBuffer(buffer, this.position);
        List<Vector2f> containts = this.getConstaints();
        buffer.put(containts.size());
        for (int i = 0; i < 8; ++i) {
            if (i < containts.size()) {
                this.loadVec2IntoBuffer(buffer, containts.get(i));
                continue;
            }
            this.loadVec2IntoBuffer(buffer, new Vector2f());
        }
    }

    public void readFromBuffer(FloatBuffer buffer) {
        this.readVec3FromBuffer(buffer, this.position);
        buffer.position(buffer.position() + 17);
    }

    private void readVec3FromBuffer(FloatBuffer buffer, Vector3f vec) {
        vec.x = buffer.get();
        vec.y = buffer.get();
        vec.z = buffer.get();
    }

    private void loadVec2IntoBuffer(FloatBuffer buffer, Vector2f vec) {
        buffer.put(vec.x);
        buffer.put(vec.y);
    }

    private void loadVec3IntoBuffer(FloatBuffer buffer, Vector3f vec) {
        buffer.put(vec.x);
        buffer.put(vec.y);
        buffer.put(vec.z);
    }

    public void update() {
        if (!this.fixed) {
            this.velocity.y -= 0.1f;
            float actualResistance = 0.5f;
            this.velocity.scale(1.0f - actualResistance);
            Vector3f.add((Vector3f)this.position, (Vector3f)this.velocity, (Vector3f)this.position);
        }
    }

    public final CapeNode getNeighbor(NEUCape.Offset offset) {
        return this.neighbors.get(offset);
    }

    public final void setNeighbor(NEUCape.Offset offset, CapeNode node) {
        this.neighbors.put(offset, node);
    }

    public void applyForce(float dX, float dY, float dZ) {
        this.velocity.x += dX;
        this.velocity.y += dY;
        this.velocity.z += dZ;
    }

    public void move(float dX, float dY, float dZ) {
        this.position.x += dX;
        this.position.y += dY;
        this.position.z += dZ;
        this.lastPosition.x = this.position.x;
        this.lastPosition.y = this.position.y;
        this.lastPosition.z = this.position.z;
    }

    public void resetNormal() {
        this.normal = null;
        this.sideNormal = null;
    }

    public void resolveAll(float horzDistMult, boolean opt) {
        this.resolveBend(horzDistMult, opt);
        this.resolveStruct(horzDistMult, opt);
    }

    public void resolve(CapeNode other, float targetDist, float strength, boolean opt) {
        double dX = this.position.x - other.position.x;
        double dY = this.position.y - other.position.y;
        double dZ = this.position.z - other.position.z;
        double distSq = dX * dX + dY * dY + dZ * dZ;
        double factor = (distSq - (double)(targetDist * targetDist)) / (40.0 * distSq) * (double)strength;
        factor = Math.max(-0.5, factor);
        dX *= factor;
        dY *= factor;
        dZ *= factor;
        if (this.fixed || other.fixed) {
            dX *= 2.0;
            dY *= 2.0;
            dZ *= 2.0;
        }
        if (!this.fixed) {
            this.position.x = (float)((double)this.position.x - dX);
            this.position.y = (float)((double)this.position.y - dY);
            this.position.z = (float)((double)this.position.z - dZ);
        }
        if (!other.fixed) {
            other.position.x = (float)((double)other.position.x + dX);
            other.position.y = (float)((double)other.position.y + dY);
            other.position.z = (float)((double)other.position.z + dZ);
        }
    }

    public void resolveStruct(float horzDistMult, boolean opt) {
        for (NEUCape.Direction cardinal : cardinals) {
            NEUCape.Offset offset = new NEUCape.Offset(cardinal, 1);
            CapeNode other = this.neighbors.get(offset);
            if (other == null) continue;
            this.resolve(other, NEUCape.targetDist * (cardinal.yOff == 0 ? horzDistMult : 1.0f), 15.0f, opt);
        }
    }

    public void resolveShear(float horzDistMult, boolean opt) {
        for (NEUCape.Direction d : new NEUCape.Direction[]{NEUCape.Direction.DOWNLEFT, NEUCape.Direction.UPLEFT, NEUCape.Direction.DOWNRIGHT, NEUCape.Direction.DOWNLEFT}) {
            NEUCape.Offset o = new NEUCape.Offset(d, 1);
            CapeNode neighbor = this.getNeighbor(o);
            if (neighbor == null) continue;
            this.resolve(neighbor, 1.0f * NEUCape.targetDist * (d.yOff == 0 ? horzDistMult : 1.0f), 3.75f, opt);
        }
    }

    public void resolveBend(float horzDistMult, boolean opt) {
        for (NEUCape.Direction cardinal : cardinals) {
            NEUCape.Offset offset = new NEUCape.Offset(cardinal, 2);
            CapeNode other = this.neighbors.get(offset);
            if (other == null) continue;
            this.resolve(other, 2.0f * NEUCape.targetDist * (cardinal.yOff == 0 ? horzDistMult : 1.0f), 7.5f, opt);
        }
    }

    public Vector3f normal() {
        if (this.normal != null) {
            return this.normal;
        }
        this.normal = new Vector3f();
        for (int i = 0; i < cardinals.length; ++i) {
            NEUCape.Direction dir1 = cardinals[i];
            NEUCape.Direction dir2 = cardinals[(i + 1) % cardinals.length];
            CapeNode node1 = this.getNeighbor(new NEUCape.Offset(dir1, 1));
            CapeNode node2 = this.getNeighbor(new NEUCape.Offset(dir2, 1));
            if (node1 == null || node2 == null) continue;
            Vector3f toCapeNode1 = Vector3f.sub((Vector3f)node1.renderPosition, (Vector3f)this.renderPosition, null);
            Vector3f toCapeNode2 = Vector3f.sub((Vector3f)node2.renderPosition, (Vector3f)this.renderPosition, null);
            Vector3f cross = Vector3f.cross((Vector3f)toCapeNode1, (Vector3f)toCapeNode2, null);
            Vector3f.add((Vector3f)this.normal, (Vector3f)cross.normalise(null), (Vector3f)this.normal);
        }
        float l = this.normal.length();
        if (l != 0.0f) {
            this.normal.scale(1.0f / l);
        }
        return this.normal;
    }

    public Vector3f sideNormal() {
        NEUCape.Direction[] cardinals;
        if (this.sideNormal != null) {
            return this.sideNormal;
        }
        this.sideNormal = new Vector3f();
        for (NEUCape.Direction cardinal : cardinals = new NEUCape.Direction[]{NEUCape.Direction.UP, NEUCape.Direction.RIGHT, NEUCape.Direction.DOWN, NEUCape.Direction.LEFT}) {
            Vector3f cross;
            Vector3f toOther;
            CapeNode nodeCardinal = this.getNeighbor(new NEUCape.Offset(cardinal, 1));
            if (nodeCardinal != null) continue;
            NEUCape.Direction dirLeft = cardinal.rotateLeft90();
            NEUCape.Direction dirRight = cardinal.rotateRight90();
            CapeNode nodeLeft = this.getNeighbor(new NEUCape.Offset(dirLeft, 1));
            CapeNode nodeRight = this.getNeighbor(new NEUCape.Offset(dirRight, 1));
            if (nodeRight != null) {
                toOther = Vector3f.sub((Vector3f)nodeRight.renderPosition, (Vector3f)this.renderPosition, null);
                cross = Vector3f.cross((Vector3f)this.normal(), (Vector3f)toOther, null);
                Vector3f.add((Vector3f)this.sideNormal, (Vector3f)cross.normalise(null), (Vector3f)this.sideNormal);
            }
            if (nodeLeft == null) continue;
            toOther = Vector3f.sub((Vector3f)nodeLeft.renderPosition, (Vector3f)this.renderPosition, null);
            cross = Vector3f.cross((Vector3f)toOther, (Vector3f)this.normal(), null);
            Vector3f.add((Vector3f)this.sideNormal, (Vector3f)cross.normalise(null), (Vector3f)this.sideNormal);
        }
        float l = this.sideNormal.length();
        if (l != 0.0f) {
            this.sideNormal.scale(0.05f / l);
        }
        return this.sideNormal;
    }

    public void renderNode() {
        this.renderNode(7);
    }

    public void renderNode(int mask) {
        CapeNode nodeLeft = this.getNeighbor(new NEUCape.Offset(NEUCape.Direction.LEFT, 1));
        CapeNode nodeUp = this.getNeighbor(new NEUCape.Offset(NEUCape.Direction.UP, 1));
        CapeNode nodeDown = this.getNeighbor(new NEUCape.Offset(NEUCape.Direction.DOWN, 1));
        CapeNode nodeRight = this.getNeighbor(new NEUCape.Offset(NEUCape.Direction.RIGHT, 1));
        CapeNode nodeDownRight = this.getNeighbor(new NEUCape.Offset(NEUCape.Direction.DOWNRIGHT, 1));
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        if (nodeDown != null && nodeRight != null && nodeDownRight != null) {
            Vector3f nodeNorm;
            if ((mask & 2) != 0) {
                worldrenderer.func_181668_a(5, DefaultVertexFormats.field_181710_j);
                for (CapeNode node : new CapeNode[]{this, nodeDown, nodeRight, nodeDownRight}) {
                    nodeNorm = node.normal();
                    worldrenderer.func_181662_b((double)node.renderPosition.x, (double)node.renderPosition.y, (double)node.renderPosition.z).func_181673_a((double)(1.0f - node.texU), (double)node.texV).func_181663_c(-nodeNorm.x, -nodeNorm.y, -nodeNorm.z).func_181675_d();
                }
                tessellator.func_78381_a();
            }
            if ((mask & 1) != 0) {
                worldrenderer.func_181668_a(5, DefaultVertexFormats.field_181710_j);
                for (CapeNode node : new CapeNode[]{nodeDownRight, nodeDown, nodeRight, this}) {
                    nodeNorm = node.normal();
                    worldrenderer.func_181662_b((double)(node.renderPosition.x + nodeNorm.x * 0.05f), (double)(node.renderPosition.y + nodeNorm.y * 0.05f), (double)(node.renderPosition.z + nodeNorm.z * 0.05f)).func_181673_a((double)node.texU, (double)node.texV).func_181663_c(nodeNorm.x, nodeNorm.y, nodeNorm.z).func_181675_d();
                }
                tessellator.func_78381_a();
            }
        }
        if ((mask & 4) != 0) {
            if ((nodeLeft == null || nodeRight == null) && nodeDown != null) {
                this.renderEdge(nodeDown, true);
            }
            if ((nodeUp == null || nodeDown == null) && nodeRight != null) {
                this.renderEdge(nodeRight, false);
            }
        }
    }

    public void renderEdge(CapeNode other, boolean lr) {
        float thisTexU = lr ? this.horzSideTexU : this.vertSideTexU;
        float thisTexV = lr ? this.horzSideTexVTop : this.vertSideTexVTop;
        float otherTexU = lr ? other.horzSideTexU : other.vertSideTexU;
        float otherTexV = lr ? other.horzSideTexVTop : other.vertSideTexVTop;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        Vector3f thisNorm = this.normal();
        Vector3f otherNorm = other.normal();
        Vector3f thisSideNorm = this.sideNormal();
        Vector3f otherSideNorm = other.sideNormal();
        worldrenderer.func_181668_a(5, DefaultVertexFormats.field_181710_j);
        worldrenderer.func_181662_b((double)this.renderPosition.x, (double)this.renderPosition.y, (double)this.renderPosition.z).func_181673_a((double)thisTexU, (double)(thisTexV + 0.01953125f)).func_181663_c(thisSideNorm.x, thisSideNorm.y, thisSideNorm.z).func_181675_d();
        worldrenderer.func_181662_b((double)other.renderPosition.x, (double)other.renderPosition.y, (double)other.renderPosition.z).func_181673_a((double)otherTexU, (double)(otherTexV + 0.01953125f)).func_181663_c(otherSideNorm.x, otherSideNorm.y, otherSideNorm.z).func_181675_d();
        worldrenderer.func_181662_b((double)(this.renderPosition.x + thisNorm.x * 0.05f), (double)(this.renderPosition.y + thisNorm.y * 0.05f), (double)(this.renderPosition.z + thisNorm.z * 0.05f)).func_181673_a((double)thisTexU, (double)thisTexV).func_181663_c(thisSideNorm.x, thisSideNorm.y, thisSideNorm.z).func_181675_d();
        worldrenderer.func_181662_b((double)(other.renderPosition.x + otherNorm.x * 0.05f), (double)(other.renderPosition.y + otherNorm.y * 0.05f), (double)(other.renderPosition.z + otherNorm.z * 0.05f)).func_181673_a((double)otherTexU, (double)otherTexV).func_181663_c(otherSideNorm.x, otherSideNorm.y, otherSideNorm.z).func_181675_d();
        tessellator.func_78381_a();
    }
}

