/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.compat.oneconfig;

import cc.polyfrost.oneconfig.config.core.ConfigUtils;
import cc.polyfrost.oneconfig.config.data.InfoType;
import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.config.elements.OptionSubcategory;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigButton;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigDropdown;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigInfo;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigSwitch;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigTextBox;
import io.github.moulberry.notenoughupdates.compat.oneconfig.OneFancyColor;
import io.github.moulberry.notenoughupdates.compat.oneconfig.OneFancyKeybind;
import io.github.moulberry.notenoughupdates.compat.oneconfig.WrappedConfigDropdown;
import io.github.moulberry.notenoughupdates.compat.oneconfig.WrappedConfigSlider;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.Config;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.Category;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorBoolean;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorButton;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorColour;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorDraggableList;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorDropdown;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorInfoText;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorKeybind;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorSlider;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorText;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigOption;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.observer.Property;
import java.lang.reflect.Field;
import java.util.Arrays;

public class OneMoulConfig
extends cc.polyfrost.oneconfig.config.Config {
    final Config moulConfig;

    public OneMoulConfig(Mod modData, Config moulConfig) {
        super(modData, "_SHOULD_NOT_BE_WRITTEN.json");
        if (moulConfig == null) {
            throw new IllegalArgumentException("mfw no moulconfig");
        }
        this.moulConfig = moulConfig;
        this.initialize();
    }

    public void initialize() {
        this.mod.config = this;
        try {
            this.processMoulConfig();
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        cc.polyfrost.oneconfig.config.Config.register((Mod)this.mod);
    }

    private void processMoulConfig() throws IllegalAccessException {
        for (Field categoryField : this.moulConfig.getClass().getDeclaredFields()) {
            Category annotation = categoryField.getAnnotation(Category.class);
            if (annotation == null) continue;
            Object categoryInstance = categoryField.get(this.moulConfig);
            OptionSubcategory subCategory = ConfigUtils.getSubCategory((OptionPage)this.mod.defaultPage, (String)annotation.name(), (String)"");
            this.createPageForCategory(subCategory, categoryInstance);
        }
    }

    private void createPageForCategory(OptionSubcategory category, Object categoryInstance) {
        for (Field optionField : categoryInstance.getClass().getDeclaredFields()) {
            ConfigEditorInfoText configEditorFSR;
            ConfigEditorDraggableList configEditorDraggableList;
            ConfigEditorDropdown configEditorDropdown;
            ConfigEditorButton configEditorButton;
            ConfigEditorSlider configEditorSlider;
            ConfigEditorColour configEditorColour;
            ConfigEditorKeybind configEditorKeybind;
            ConfigEditorText configEditorText;
            ConfigOption annotation = optionField.getAnnotation(ConfigOption.class);
            if (annotation == null) continue;
            String cat = category.getName();
            String subcategory = "";
            String annotationName = StringUtils.cleanColour(annotation.name());
            String annotationDesc = StringUtils.cleanColour(annotation.desc());
            ConfigEditorBoolean configEditorBoolean = optionField.getAnnotation(ConfigEditorBoolean.class);
            if (configEditorBoolean != null) {
                category.options.add(new ConfigSwitch(optionField, categoryInstance, annotationName, annotationDesc, cat, subcategory, 2));
            }
            if ((configEditorText = optionField.getAnnotation(ConfigEditorText.class)) != null) {
                category.options.add(new ConfigTextBox(optionField, categoryInstance, annotationName, annotationDesc, cat, subcategory, 2, annotationName, false, false));
            }
            if ((configEditorKeybind = optionField.getAnnotation(ConfigEditorKeybind.class)) != null) {
                category.options.add(new OneFancyKeybind(optionField, categoryInstance, annotationName, annotationDesc, cat, subcategory, 2));
            }
            if ((configEditorColour = optionField.getAnnotation(ConfigEditorColour.class)) != null) {
                category.options.add(new OneFancyColor(optionField, categoryInstance, annotationName, annotationDesc, cat, subcategory, 2, true));
            }
            if ((configEditorSlider = optionField.getAnnotation(ConfigEditorSlider.class)) != null) {
                category.options.add(new WrappedConfigSlider(optionField, categoryInstance, annotationName, annotationDesc, cat, subcategory, configEditorSlider.minValue(), configEditorSlider.maxValue(), (int)configEditorSlider.minStep()));
            }
            if ((configEditorButton = optionField.getAnnotation(ConfigEditorButton.class)) != null) {
                category.options.add(new ConfigButton(() -> this.moulConfig.executeRunnable(configEditorButton.runnableId()), categoryInstance, annotationName, annotationDesc, cat, subcategory, 2, configEditorButton.buttonText()));
            }
            if ((configEditorDropdown = optionField.getAnnotation(ConfigEditorDropdown.class)) != null) {
                if (optionField.getType() == Property.class) {
                    try {
                        Property property = (Property)optionField.get(categoryInstance);
                        Object value = property.get();
                        if (value instanceof Enum) {
                            category.options.add(new WrappedConfigDropdown(optionField, categoryInstance, annotationName, annotationDesc, cat, subcategory, 2, (String[])Arrays.stream(value.getClass().getEnumConstants()).map(Object::toString).toArray(String[]::new)));
                        } else if (value instanceof Integer) {
                            category.options.add(new ConfigDropdown(optionField, categoryInstance, annotationName, annotationDesc, cat, subcategory, 2, configEditorDropdown.values()));
                        }
                    }
                    catch (IllegalAccessException e2) {
                        e2.printStackTrace();
                    }
                } else {
                    category.options.add(new ConfigDropdown(optionField, categoryInstance, annotationName, annotationDesc, cat, subcategory, 2, configEditorDropdown.values()));
                }
            }
            if ((configEditorDraggableList = optionField.getAnnotation(ConfigEditorDraggableList.class)) != null) {
                category.options.add(new ConfigInfo(optionField, categoryInstance, "This option (" + annotationName + ") is not available via the oneconfig gui", cat, subcategory, 2, InfoType.ERROR));
            }
            if ((configEditorFSR = optionField.getAnnotation(ConfigEditorInfoText.class)) == null) continue;
            category.options.add(new ConfigInfo(optionField, categoryInstance, annotationDesc, cat, subcategory, 2, InfoType.WARNING));
        }
    }

    public void save() {
        this.moulConfig.saveNow();
    }

    public void load() {
    }

    public boolean supportsProfiles() {
        return false;
    }
}

