/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.compat.oneconfig;

import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigColorElement;
import io.github.moulberry.notenoughupdates.core.ChromaColour;
import java.awt.Color;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;

public class OneFancyColor
extends ConfigColorElement {
    private static MethodHandle hsbaAccessor;
    private static MethodHandle databitAccessor;

    public OneFancyColor(Field field, Object parent, String name, String description, String category, String subcategory, int size, boolean allowAlpha) {
        super(field, parent, name, description, category, subcategory, size, allowAlpha);
    }

    public Object get() throws IllegalAccessException {
        String chromaString = (String)super.get();
        int[] decompose = ChromaColour.decompose(chromaString);
        int r = decompose[2];
        int g = decompose[1];
        int b = decompose[0];
        int a = decompose[3];
        int chr = decompose[4];
        short[] hsba = OneColor.ARGBtoHSBA((int)new Color(r, g, b, a).getRGB());
        if (chr > 0) {
            return new OneColor((int)hsba[0], (int)hsba[1], (int)hsba[2], (int)hsba[3], (int)ChromaColour.getSecondsForSpeed(chr));
        }
        return new OneColor(r, g, b, a);
    }

    private static short[] getHsba(OneColor color) {
        try {
            return hsbaAccessor.invokeExact(color);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }

    private static int getDataBit(OneColor color) {
        try {
            return databitAccessor.invokeExact(color);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void set(Object object) throws IllegalAccessException {
        OneColor color = (OneColor)object;
        float dataBit = (float)OneFancyColor.getDataBit(color) / 1000.0f;
        short[] hsba = OneFancyColor.getHsba(color);
        int argb = OneColor.HSBAtoARGB((float)hsba[0], (float)hsba[1], (float)hsba[2], (int)hsba[3]);
        Color color1 = new Color(argb, true);
        super.set((Object)ChromaColour.special(dataBit > 0.0f ? ChromaColour.getSpeedForSeconds(dataBit) : 0, color1.getAlpha(), color1.getRed(), color1.getGreen(), color1.getBlue()));
    }

    static {
        try {
            Field f = OneColor.class.getDeclaredField("hsba");
            Field f2 = OneColor.class.getDeclaredField("dataBit");
            f.setAccessible(true);
            f2.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            hsbaAccessor = lookup.unreflectGetter(f);
            databitAccessor = lookup.unreflectGetter(f2);
        }
        catch (IllegalAccessException | NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
    }
}

