/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.CustomItems;
import io.github.moulberry.notenoughupdates.ItemPriceInformation;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.commands.help.SettingsCommand;
import io.github.moulberry.notenoughupdates.core.BackgroundBlur;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingInteger;
import io.github.moulberry.notenoughupdates.infopanes.DevInfoPane;
import io.github.moulberry.notenoughupdates.infopanes.InfoPane;
import io.github.moulberry.notenoughupdates.infopanes.TextInfoPane;
import io.github.moulberry.notenoughupdates.itemeditor.NEUItemEditor;
import io.github.moulberry.notenoughupdates.mbgui.MBAnchorPoint;
import io.github.moulberry.notenoughupdates.mbgui.MBGuiElement;
import io.github.moulberry.notenoughupdates.mbgui.MBGuiGroupAligned;
import io.github.moulberry.notenoughupdates.mbgui.MBGuiGroupFloating;
import io.github.moulberry.notenoughupdates.miscfeatures.AhBzKeybind;
import io.github.moulberry.notenoughupdates.miscfeatures.EnchantingSolvers;
import io.github.moulberry.notenoughupdates.miscfeatures.SunTzu;
import io.github.moulberry.notenoughupdates.miscgui.NeuSearchCalculator;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.GuiItemCustomize;
import io.github.moulberry.notenoughupdates.miscgui.pricegraph.GuiPriceGraph;
import io.github.moulberry.notenoughupdates.options.separatesections.ApiData;
import io.github.moulberry.notenoughupdates.recipes.CraftingRecipe;
import io.github.moulberry.notenoughupdates.util.Calculator;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.GuiTextures;
import io.github.moulberry.notenoughupdates.util.LerpingFloat;
import io.github.moulberry.notenoughupdates.util.NotificationHandler;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.StreamExtL;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.awt.HeadlessException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Matrix4f;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.Vector2f;

public class NEUOverlay
extends Gui {
    private static final ResourceLocation SUPERGEHEIMNISVERMOGEN = new ResourceLocation("notenoughupdates:supersecretassets/bald.png");
    private static final ResourceLocation ATMOULBERRYWHYISMYLUNARCLIENTBUGGING = new ResourceLocation("notenoughupdates:supersecretassets/lunar.png");
    private static final ResourceLocation SEARCH_BAR = new ResourceLocation("notenoughupdates:search_bar.png");
    private static final ResourceLocation SEARCH_BAR_GOLD = new ResourceLocation("notenoughupdates:search_bar_gold.png");
    private static final ResourceLocation SEARCH_MODE_BUTTON = new ResourceLocation("notenoughupdates:search_mode_button.png");
    private final NEUManager manager;
    private final String mobRegex = ".*?((_MONSTER)|(_NPC)|(_ANIMAL)|(_MINIBOSS)|(_BOSS)|(_SC))$";
    private final String petRegex = ".*?;[0-5]$";
    private final ResourceLocation[] sortIcons = new ResourceLocation[]{GuiTextures.sort_all, GuiTextures.sort_mob, GuiTextures.sort_pet, GuiTextures.sort_tool, GuiTextures.sort_armor, GuiTextures.sort_accessory};
    private final ResourceLocation[] sortIconsActive = new ResourceLocation[]{GuiTextures.sort_all_active, GuiTextures.sort_mob_active, GuiTextures.sort_pet_active, GuiTextures.sort_tool_active, GuiTextures.sort_armor_active, GuiTextures.sort_accessory_active};
    private final ResourceLocation[] orderIcons = new ResourceLocation[]{GuiTextures.order_alphabetical, GuiTextures.order_rarity, GuiTextures.order_value};
    private final ResourceLocation[] orderIconsActive = new ResourceLocation[]{GuiTextures.order_alphabetical_active, GuiTextures.order_rarity_active, GuiTextures.order_value_active};
    private final int searchBarYOffset = 10;
    private final int searchBarPadding = 2;
    private long lastSearchMode = 0L;
    private float oldWidthMult = 0.0f;
    public static final int ITEM_PADDING = 4;
    public static final int ITEM_SIZE = 16;
    private Color bg = new Color(90, 90, 140, 50);
    private Color fg = new Color(100, 100, 100, 255);
    private InfoPane activeInfoPane = null;
    private TreeSet<JsonObject> searchedItems = null;
    private final List<JsonObject> searchedItemsArr = new ArrayList<JsonObject>();
    private HashMap<String, List<String>> searchedItemsSubgroup = new HashMap();
    private long selectedItemMillis = 0L;
    private int selectedItemGroupX = -1;
    private int selectedItemGroupY = -1;
    private List<JsonObject> selectedItemGroup = null;
    private boolean itemPaneOpen = false;
    private long itemPaneShouldOpen = -1L;
    private int page = 0;
    private final LerpingFloat itemPaneOffsetFactor = new LerpingFloat(1);
    private final LerpingInteger itemPaneTabOffset = new LerpingInteger(20, 50);
    private final LerpingFloat infoPaneOffsetFactor = new LerpingFloat(0);
    public boolean searchMode = false;
    private long millisLastLeftClick = 0L;
    private long millisLastMouseMove = 0L;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    public static final int overlayColourDark = new Color(0, 0, 0, 120).getRGB();
    public static final int overlayColourLight = new Color(255, 255, 255, 120).getRGB();
    boolean mouseDown = false;
    private boolean redrawItems = false;
    public static boolean searchBarHasFocus = false;
    private static final GuiTextField textField = new GuiTextField(0, null, 0, 0, 0, 0);
    private static final int COMPARE_MODE_ALPHABETICAL = 0;
    private static final int COMPARE_MODE_RARITY = 1;
    private static final int COMPARE_MODE_VALUE = 2;
    private static final int SORT_MODE_ALL = 0;
    private static final int SORT_MODE_MOB = 1;
    private static final int SORT_MODE_PET = 2;
    private static final int SORT_MODE_TOOL = 3;
    private static final int SORT_MODE_ARMOR = 4;
    private static final int SORT_MODE_ACCESSORY = 5;
    private boolean disabled = false;
    private int lastScreenWidth;
    private int lastScreenHeight;
    private int lastScale;
    private CompletableFuture<Void> infoPaneLoadingJob = CompletableFuture.completedFuture(null);
    private List<String> textToDisplay = null;
    public MBGuiGroupFloating guiGroup = null;
    private final HashMap<String, JsonObject> parentMap = new HashMap();
    private final ExecutorService searchES = Executors.newSingleThreadExecutor();
    public float yaw = 0.0f;
    public float pitch = 20.0f;
    Shader blurShaderHorz = null;
    Framebuffer blurOutputHorz = null;
    Shader blurShaderVert = null;
    Framebuffer blurOutputVert = null;
    int guiScaleLast = 0;
    private boolean showVanillaLast = false;
    private final Framebuffer[] itemFramebuffers = new Framebuffer[2];
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    float itemRenderOffset = 7.5001f;

    public NEUOverlay(NEUManager manager) {
        this.manager = manager;
        textField.func_146195_b(true);
        textField.func_146205_d(false);
        textField.func_146203_f(50);
        this.guiGroup = this.createGuiGroup();
    }

    private MBGuiElement createSearchBar() {
        return new MBGuiElement(){

            @Override
            public int getWidth() {
                int paddingUnscaled = NEUOverlay.this.getPaddingUnscaled();
                return NEUOverlay.this.getSearchBarXSize() + 2 * paddingUnscaled;
            }

            @Override
            public int getHeight() {
                int paddingUnscaled = NEUOverlay.this.getPaddingUnscaled();
                return NEUOverlay.this.getSearchBarYSize() + 2 * paddingUnscaled;
            }

            @Override
            public void mouseClick(float x, float y, int mouseX, int mouseY) {
                if (!NotEnoughUpdates.INSTANCE.config.toolbar.searchBar) {
                    return;
                }
                if (Mouse.getEventButtonState()) {
                    NEUOverlay.this.setSearchBarFocus(true);
                    if (Mouse.getEventButton() == 1) {
                        textField.func_146180_a("");
                        NEUOverlay.this.updateSearch();
                    } else {
                        if (System.currentTimeMillis() - NEUOverlay.this.millisLastLeftClick < 300L) {
                            NEUOverlay.this.searchMode = !NEUOverlay.this.searchMode;
                            NEUOverlay.this.itemPaneShouldOpen = -1L;
                            NEUOverlay.this.lastSearchMode = System.currentTimeMillis();
                            if (NEUOverlay.this.searchMode && NotEnoughUpdates.INSTANCE.config.hidden.firstTimeSearchFocus) {
                                NotificationHandler.displayNotification(Lists.newArrayList((Object[])new String[]{"\u00a7eSearch Highlight", "\u00a77In this mode NEU will gray out non matching items in", "\u00a77your inventory or chests.", "\u00a77This allows you easily find items as the item will stand out.", "\u00a77To toggle this please double click on the search bar in your inventory.", "\u00a77", "\u00a77Press X on your keyboard to close this notification"}), true, true);
                                NotEnoughUpdates.INSTANCE.config.hidden.firstTimeSearchFocus = false;
                            }
                        }
                        textField.func_146190_e(NEUOverlay.this.getClickedIndex(mouseX, mouseY));
                        NEUOverlay.this.millisLastLeftClick = System.currentTimeMillis();
                        if (NEUOverlay.this.searchMode) {
                            NEUOverlay.this.lastSearchMode = System.currentTimeMillis();
                        }
                    }
                }
            }

            @Override
            public void mouseClickOutside() {
                NEUOverlay.this.setSearchBarFocus(false);
            }

            @Override
            public void render(float x, float y) {
                String selectedText;
                if (!NotEnoughUpdates.INSTANCE.config.toolbar.searchBar) {
                    return;
                }
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                int paddingUnscaled = NEUOverlay.this.getPaddingUnscaled();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(NEUOverlay.this.searchMode ? SEARCH_BAR_GOLD : SEARCH_BAR);
                int w = this.getWidth();
                int h = this.getHeight();
                for (int yIndex = 0; yIndex <= 2; ++yIndex) {
                    for (int xIndex = 0; xIndex <= 2; ++xIndex) {
                        float uMin = 0.0f;
                        float uMax = 0.2f;
                        int partX = (int)x;
                        int partW = 4;
                        if (xIndex == 1) {
                            partX += 4;
                            uMin = 0.2f;
                            uMax = 0.8f;
                            partW = w - 8;
                        } else if (xIndex == 2) {
                            partX += w - 4;
                            uMin = 0.8f;
                            uMax = 1.0f;
                        }
                        float vMin = 0.0f;
                        float vMax = 0.2f;
                        int partY = (int)y;
                        int partH = 4;
                        if (yIndex == 1) {
                            partY += 4;
                            vMin = 0.2f;
                            vMax = 0.8f;
                            partH = h - 8;
                        } else if (yIndex == 2) {
                            partY += h - 4;
                            vMin = 0.8f;
                            vMax = 1.0f;
                        }
                        Utils.drawTexturedRect(partX, partY, partW, partH, uMin, uMax, vMin, vMax, 9728);
                    }
                }
                fr.func_78276_b(NeuSearchCalculator.format(textField.func_146179_b()), (int)x + 5, (int)y - 4 + this.getHeight() / 2, Color.WHITE.getRGB());
                if (searchBarHasFocus && System.currentTimeMillis() % 1000L > 500L) {
                    String textBeforeCursor = textField.func_146179_b().substring(0, textField.func_146198_h());
                    int textBeforeCursorWidth = fr.func_78256_a(textBeforeCursor);
                    Gui.func_73734_a((int)((int)x + 5 + textBeforeCursorWidth), (int)((int)y - 5 + this.getHeight() / 2), (int)((int)x + 5 + textBeforeCursorWidth + 1), (int)((int)y - 4 + 9 + this.getHeight() / 2), (int)Color.WHITE.getRGB());
                }
                if (!(selectedText = textField.func_146207_c()).isEmpty()) {
                    int selectionWidth = fr.func_78256_a(selectedText);
                    int leftIndex = Math.min(textField.func_146198_h(), textField.func_146186_n());
                    String textBeforeSelection = textField.func_146179_b().substring(0, leftIndex);
                    int textBeforeSelectionWidth = fr.func_78256_a(textBeforeSelection);
                    Gui.func_73734_a((int)((int)x + 5 + textBeforeSelectionWidth), (int)((int)y - 5 + this.getHeight() / 2), (int)((int)x + 5 + textBeforeSelectionWidth + selectionWidth), (int)((int)y - 4 + 9 + this.getHeight() / 2), (int)Color.LIGHT_GRAY.getRGB());
                    fr.func_78276_b(selectedText, (int)x + 5 + textBeforeSelectionWidth, (int)y - 4 + this.getHeight() / 2, Color.BLACK.getRGB());
                }
            }

            @Override
            public void recalculate() {
            }
        };
    }

    private MBGuiElement createSettingsButton(NEUOverlay overlay) {
        return new MBGuiElement(){

            @Override
            public int getWidth() {
                return NEUOverlay.this.getSearchBarYSize() + NEUOverlay.this.getPaddingUnscaled() * 2;
            }

            @Override
            public int getHeight() {
                return this.getWidth();
            }

            @Override
            public void recalculate() {
            }

            @Override
            public void mouseClick(float x, float y, int mouseX, int mouseY) {
                if (!NotEnoughUpdates.INSTANCE.config.toolbar.enableSettingsButton) {
                    return;
                }
                if (Mouse.getEventButtonState()) {
                    NotEnoughUpdates.INSTANCE.openGui = SettingsCommand.INSTANCE.createConfigScreen("");
                }
            }

            @Override
            public void mouseClickOutside() {
            }

            @Override
            public void render(float x, float y) {
                int paddingUnscaled = NEUOverlay.this.getPaddingUnscaled();
                int searchYSize = NEUOverlay.this.getSearchBarYSize();
                if (!NotEnoughUpdates.INSTANCE.config.toolbar.enableSettingsButton) {
                    return;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.quickcommand_background);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(x, y, searchYSize + paddingUnscaled * 2, searchYSize + paddingUnscaled * 2, 9728);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.settings);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect((int)x + paddingUnscaled, (int)y + paddingUnscaled, searchYSize, searchYSize);
                GlStateManager.func_179144_i((int)0);
            }
        };
    }

    private MBGuiElement createSearchModeButton() {
        return new MBGuiElement(){

            @Override
            public int getWidth() {
                return NEUOverlay.this.getSearchBarYSize() + NEUOverlay.this.getPaddingUnscaled() * 2;
            }

            @Override
            public int getHeight() {
                return this.getWidth();
            }

            @Override
            public void recalculate() {
            }

            @Override
            public void mouseClick(float x, float y, int mouseX, int mouseY) {
                if (!NotEnoughUpdates.INSTANCE.config.toolbar.enableSearchModeButton) {
                    return;
                }
                if (Mouse.getEventButtonState()) {
                    NEUOverlay.this.searchMode = !NEUOverlay.this.searchMode;
                    NEUOverlay.this.lastSearchMode = System.currentTimeMillis();
                    Utils.playPressSound();
                }
            }

            @Override
            public void mouseClickOutside() {
            }

            @Override
            public void render(float x, float y) {
                int paddingUnscaled = NEUOverlay.this.getPaddingUnscaled();
                int searchYSize = NEUOverlay.this.getSearchBarYSize();
                if (!NotEnoughUpdates.INSTANCE.config.toolbar.enableSearchModeButton) {
                    return;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.quickcommand_background);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(x, y, searchYSize + paddingUnscaled * 2, searchYSize + paddingUnscaled * 2, 9728);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(SEARCH_MODE_BUTTON);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect((int)x + paddingUnscaled, (int)y + paddingUnscaled, NEUOverlay.this.getSearchBarYSize(), NEUOverlay.this.getSearchBarYSize());
                GlStateManager.func_179144_i((int)0);
            }
        };
    }

    private MBGuiElement createQuickCommand(final String quickCommandStr) {
        return new MBGuiElement(){

            @Override
            public int getWidth() {
                return NEUOverlay.this.getSearchBarYSize() + NEUOverlay.this.getPaddingUnscaled() * 2;
            }

            @Override
            public int getHeight() {
                return this.getWidth();
            }

            @Override
            public void recalculate() {
            }

            @Override
            public void mouseClick(float x, float y, int mouseX, int mouseY) {
                if (!NotEnoughUpdates.INSTANCE.config.toolbar.quickCommands) {
                    return;
                }
                if (EnchantingSolvers.disableButtons()) {
                    return;
                }
                if ((NotEnoughUpdates.INSTANCE.config.toolbar.quickCommandsClickType != 0 && Mouse.getEventButtonState() || NotEnoughUpdates.INSTANCE.config.toolbar.quickCommandsClickType == 0 && !Mouse.getEventButtonState() && Mouse.getEventButton() != -1) && quickCommandStr.contains(":")) {
                    String command2 = quickCommandStr.split(":")[0].trim();
                    if (command2.startsWith("/")) {
                        NotEnoughUpdates.INSTANCE.sendChatMessage(command2);
                    } else {
                        ClientCommandHandler.instance.func_71556_a((ICommandSender)Minecraft.func_71410_x().field_71439_g, "/" + command2);
                    }
                    Utils.playPressSound();
                }
            }

            @Override
            public void mouseClickOutside() {
            }

            @Override
            public void render(float x, float y) {
                if (!NotEnoughUpdates.INSTANCE.config.toolbar.quickCommands) {
                    return;
                }
                if (EnchantingSolvers.disableButtons()) {
                    return;
                }
                int paddingUnscaled = NEUOverlay.this.getPaddingUnscaled();
                int bigItemSize = NEUOverlay.this.getSearchBarYSize();
                String[] quickCommandStrSplit = quickCommandStr.split(":");
                if (quickCommandStrSplit.length != 3) {
                    return;
                }
                String display = quickCommandStrSplit[2];
                ItemStack render = null;
                float extraScale = 1.0f;
                if (display.length() > 20) {
                    render = new ItemStack(Items.field_151144_bL, 1, 3);
                    NBTTagCompound nbt = new NBTTagCompound();
                    NBTTagCompound skullOwner = new NBTTagCompound();
                    NBTTagCompound properties = new NBTTagCompound();
                    NBTTagList textures = new NBTTagList();
                    NBTTagCompound textures_0 = new NBTTagCompound();
                    String uuid = UUID.nameUUIDFromBytes(display.getBytes()).toString();
                    skullOwner.func_74778_a("Id", uuid);
                    skullOwner.func_74778_a("Name", uuid);
                    textures_0.func_74778_a("Value", display);
                    textures.func_74742_a((NBTBase)textures_0);
                    properties.func_74782_a("textures", (NBTBase)textures);
                    skullOwner.func_74782_a("Properties", (NBTBase)properties);
                    nbt.func_74782_a("SkullOwner", (NBTBase)skullOwner);
                    render.func_77982_d(nbt);
                    extraScale = 1.3f;
                } else if (NEUOverlay.this.manager.getItemInformation().containsKey(display)) {
                    render = NEUOverlay.this.manager.jsonToStack(NEUOverlay.this.manager.getItemInformation().get(display), true, false);
                } else {
                    Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(display.toLowerCase(Locale.ROOT)));
                    if (item != null) {
                        render = new ItemStack(item);
                    }
                }
                if (render != null) {
                    NBTTagCompound tag = render.func_77978_p() != null ? render.func_77978_p() : new NBTTagCompound();
                    tag.func_74778_a("qc_id", quickCommandStrSplit[0].toLowerCase(Locale.ROOT).trim());
                    render.func_77982_d(tag);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.quickcommand_background);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Utils.drawTexturedRect(x, y, bigItemSize + paddingUnscaled * 2, bigItemSize + paddingUnscaled * 2, 9728);
                    int mouseX = Mouse.getX() * Utils.peekGuiScale().func_78326_a() / Minecraft.func_71410_x().field_71443_c;
                    int mouseY = Utils.peekGuiScale().func_78328_b() - Mouse.getY() * Utils.peekGuiScale().func_78328_b() / Minecraft.func_71410_x().field_71440_d - 1;
                    if ((float)mouseX > x && (float)mouseX < x + (float)bigItemSize && (float)mouseY > y && (float)mouseY < y + (float)bigItemSize) {
                        NEUOverlay.this.textToDisplay = new ArrayList();
                        NEUOverlay.this.textToDisplay.add(EnumChatFormatting.GRAY + quickCommandStrSplit[1]);
                    }
                    GlStateManager.func_179126_j();
                    float itemScale = (float)bigItemSize / 16.0f * extraScale;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)itemScale, (float)itemScale, (float)1.0f);
                    GlStateManager.func_179109_b((float)((x - (extraScale - 1.0f) * (float)bigItemSize / 2.0f + (float)paddingUnscaled) / itemScale), (float)((y - (extraScale - 1.0f) * (float)bigItemSize / 2.0f + (float)paddingUnscaled) / itemScale), (float)0.0f);
                    Utils.drawItemStack(render, 0, 0);
                    GlStateManager.func_179121_F();
                }
            }
        };
    }

    private MBGuiGroupAligned createQuickCommandGroup() {
        ArrayList<MBGuiElement> children = new ArrayList<MBGuiElement>();
        for (String quickCommand : NotEnoughUpdates.INSTANCE.config.hidden.quickCommands) {
            children.add(this.createQuickCommand(quickCommand));
        }
        return new MBGuiGroupAligned(children, false){

            @Override
            public int getPadding() {
                return NEUOverlay.this.getPaddingUnscaled() * 4;
            }
        };
    }

    private MBGuiGroupAligned createSearchBarGroup() {
        ArrayList children = Lists.newArrayList((Object[])new MBGuiElement[]{this.createSettingsButton(this), this.createSearchBar(), this.createSearchModeButton()});
        return new MBGuiGroupAligned(children, false){

            @Override
            public int getPadding() {
                return NEUOverlay.this.getPaddingUnscaled() * 4;
            }
        };
    }

    private MBGuiGroupFloating createGuiGroup() {
        LinkedHashMap<MBGuiElement, MBAnchorPoint> map2 = new LinkedHashMap<MBGuiElement, MBAnchorPoint>();
        MBAnchorPoint searchBarAnchor = MBAnchorPoint.createFromString(NotEnoughUpdates.INSTANCE.config.hidden.overlaySearchBar);
        MBAnchorPoint quickCommandAnchor = MBAnchorPoint.createFromString(NotEnoughUpdates.INSTANCE.config.hidden.overlayQuickCommand);
        searchBarAnchor = searchBarAnchor != null ? searchBarAnchor : new MBAnchorPoint(MBAnchorPoint.AnchorPoint.BOTMID, new Vector2f(0.0f, -10.0f));
        quickCommandAnchor = quickCommandAnchor != null ? quickCommandAnchor : new MBAnchorPoint(MBAnchorPoint.AnchorPoint.BOTMID, new Vector2f(0.0f, (float)(-10 - this.getSearchBarYSize() - this.getPaddingUnscaled() * 4)));
        map2.put(this.createSearchBarGroup(), searchBarAnchor);
        map2.put(this.createQuickCommandGroup(), quickCommandAnchor);
        return new MBGuiGroupFloating(Utils.peekGuiScale().func_78326_a(), Utils.peekGuiScale().func_78328_b(), map2);
    }

    public void resetAnchors(boolean onlyIfNull) {
        MBAnchorPoint searchBarAnchor = MBAnchorPoint.createFromString(NotEnoughUpdates.INSTANCE.config.hidden.overlaySearchBar);
        MBAnchorPoint quickCommandAnchor = MBAnchorPoint.createFromString(NotEnoughUpdates.INSTANCE.config.hidden.overlayQuickCommand);
        if (onlyIfNull) {
            searchBarAnchor = searchBarAnchor != null ? null : new MBAnchorPoint(MBAnchorPoint.AnchorPoint.BOTMID, new Vector2f(0.0f, -10.0f));
            quickCommandAnchor = quickCommandAnchor != null ? null : new MBAnchorPoint(MBAnchorPoint.AnchorPoint.BOTMID, new Vector2f(0.0f, (float)(-10 - this.getSearchBarYSize() - this.getPaddingUnscaled() * 4)));
        } else {
            searchBarAnchor = searchBarAnchor != null ? searchBarAnchor : new MBAnchorPoint(MBAnchorPoint.AnchorPoint.BOTMID, new Vector2f(0.0f, -10.0f));
            quickCommandAnchor = quickCommandAnchor != null ? quickCommandAnchor : new MBAnchorPoint(MBAnchorPoint.AnchorPoint.BOTMID, new Vector2f(0.0f, (float)(-10 - this.getSearchBarYSize() - this.getPaddingUnscaled() * 4)));
        }
        int index = 0;
        LinkedHashSet<MBGuiElement> set = new LinkedHashSet<MBGuiElement>(this.guiGroup.getChildrenMap().keySet());
        block4: for (MBGuiElement element : set) {
            switch (index) {
                case 0: {
                    if (searchBarAnchor == null) continue block4;
                    this.guiGroup.getChildrenMap().get((Object)element).anchorPoint = searchBarAnchor.anchorPoint;
                    this.guiGroup.getChildrenMap().get((Object)element).offset = searchBarAnchor.offset;
                    break;
                }
                case 1: {
                    if (quickCommandAnchor == null) continue block4;
                    this.guiGroup.getChildrenMap().get((Object)element).anchorPoint = quickCommandAnchor.anchorPoint;
                    this.guiGroup.getChildrenMap().get((Object)element).offset = quickCommandAnchor.offset;
                }
            }
            ++index;
        }
    }

    public void reset() {
        searchBarHasFocus = false;
        if (!(this.searchMode || NotEnoughUpdates.INSTANCE.config.itemlist.keepopen && this.itemPaneOpen)) {
            this.itemPaneOpen = false;
            this.displayInformationPane(null);
            this.itemPaneOffsetFactor.setValue(1.0f);
            this.itemPaneTabOffset.setValue(20);
        }
        if (this.activeInfoPane != null) {
            this.activeInfoPane.reset();
        }
        this.guiGroup.recalculate();
    }

    public void showInfo(JsonObject item) {
        if (item.has("info") && item.has("infoType")) {
            JsonArray lore = item.get("info").getAsJsonArray();
            String infoType = item.get("infoType").getAsString();
            String infoText = "";
            if (infoType.equals("WIKI_URL")) {
                for (JsonElement url : lore) {
                    infoText = url.getAsString();
                    if ((!url.getAsString().startsWith("https://wiki.hypixel.net/") || NotEnoughUpdates.INSTANCE.config.misc.wiki != 0) && (!url.getAsString().startsWith("https://hypixel-skyblock.fandom.com/") || NotEnoughUpdates.INSTANCE.config.misc.wiki != 1)) continue;
                    break;
                }
            } else {
                StringBuilder loreBuilder = new StringBuilder();
                for (int i = 0; i < lore.size(); ++i) {
                    loreBuilder.append(lore.get(i).getAsString());
                    if (i == lore.size() - 1) continue;
                    loreBuilder.append("\n");
                }
                infoText = loreBuilder.toString();
            }
            String internalname = item.get("internalname").getAsString();
            String name = item.get("displayname").getAsString();
            name = name.replace("[Lvl {LVL}] ", "");
            if (NotEnoughUpdates.INSTANCE.config.itemlist.wikiInBrowser) {
                Utils.openUrl(infoText);
                Utils.addChatMessage("\u00a7e[NEU] Opening webpage in browser.");
            } else {
                this.displayInformationPane(new TextInfoPane(this, this.manager, EnumChatFormatting.GRAY + "Loading", EnumChatFormatting.GRAY + "Loading your requested information about " + name + EnumChatFormatting.GRAY + "."));
                this.infoPaneLoadingJob = InfoPane.create(this, this.manager, infoType, name, internalname, infoText).thenAccept(this::displayInformationPane);
            }
        }
    }

    public void mouseInputInv() {
        ItemStack hover;
        Slot slot;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiContainer && Mouse.getEventButton() == this.manager.keybindItemSelect.func_151463_i() + 100 && NotEnoughUpdates.INSTANCE.config.toolbar.searchBar && (slot = Utils.getSlotUnderMouse((GuiContainer)Minecraft.func_71410_x().field_71462_r)) != null && (hover = slot.func_75211_c()) != null) {
            if (this.manager.getInternalNameForItem(hover) != null) {
                textField.func_146180_a("id:" + this.manager.getInternalNameForItem(hover));
            }
            this.itemPaneOpen = true;
            this.updateSearch();
        }
    }

    public synchronized boolean mouseInput() {
        if (this.disabled) {
            return false;
        }
        Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.itemlist.paneGuiScale);
        int width = Utils.peekGuiScale().func_78326_a();
        int height = Utils.peekGuiScale().func_78328_b();
        final int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        final int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (Mouse.getEventButtonState()) {
            this.mouseDown = true;
        } else if (Mouse.getEventButton() != -1) {
            this.mouseDown = false;
        }
        if (Mouse.getEventButtonState()) {
            this.setSearchBarFocus(false);
        }
        this.guiGroup.mouseClick(0.0f, 0.0f, mouseX, mouseY);
        if (this.selectedItemGroup != null) {
            int selectedX = Math.min(this.selectedItemGroupX, width - this.getBoxPadding() - 18 * this.selectedItemGroup.size());
            if (mouseY > this.selectedItemGroupY + 17 && mouseY < this.selectedItemGroupY + 35) {
                if (!Mouse.getEventButtonState()) {
                    Utils.pushGuiScale(-1);
                    return true;
                }
                for (int i = 0; i < this.selectedItemGroup.size(); ++i) {
                    if (mouseX < selectedX - 1 + 18 * i || mouseX > selectedX + 17 + 18 * i) continue;
                    JsonObject item = this.selectedItemGroup.get(i);
                    if (item != null) {
                        if (Mouse.getEventButton() == 0) {
                            this.manager.showRecipe(item);
                        } else if (Mouse.getEventButton() == 1) {
                            this.showInfo(item);
                        } else if (Mouse.getEventButton() == this.manager.keybindItemSelect.func_151463_i() + 100 && NotEnoughUpdates.INSTANCE.config.toolbar.searchBar) {
                            textField.func_146180_a("id:" + item.get("internalname").getAsString());
                            this.updateSearch();
                            this.searchMode = true;
                        }
                    }
                    Utils.pushGuiScale(-1);
                    return true;
                }
            }
        }
        if ((float)mouseX > (float)width * this.getItemPaneOffsetFactor()) {
            if (!Mouse.getEventButtonState()) {
                Utils.pushGuiScale(-1);
                return true;
            }
            final AtomicBoolean clickedItem = new AtomicBoolean(false);
            this.iterateItemSlots(new ItemSlotConsumer(){

                @Override
                public void consume(int x, int y, int id) {
                    if (mouseX >= x - 1 && mouseX <= x + 16 + 1 && mouseY >= y - 1 && mouseY <= y + 16 + 1) {
                        clickedItem.set(true);
                        JsonObject item = NEUOverlay.this.getSearchedItemPage(id);
                        if (item != null) {
                            if (Mouse.getEventButton() == 0) {
                                NEUOverlay.this.manager.showRecipe(item);
                            } else if (Mouse.getEventButton() == 1) {
                                NEUOverlay.this.showInfo(item);
                            } else if (Mouse.getEventButton() == ((NEUOverlay)NEUOverlay.this).manager.keybindItemSelect.func_151463_i() + 100 && NotEnoughUpdates.INSTANCE.config.toolbar.searchBar) {
                                textField.func_146180_a("id:" + item.get("internalname").getAsString());
                                NEUOverlay.this.updateSearch();
                                NEUOverlay.this.searchMode = true;
                            }
                        }
                    }
                }
            });
            if (!clickedItem.get()) {
                int paneWidth = (int)((float)(width / 3) * this.getWidthMult());
                int leftSide = (int)((float)width * this.getItemPaneOffsetFactor());
                int rightSide = leftSide + paneWidth - this.getBoxPadding() - this.getItemBoxXPadding();
                leftSide = leftSide + this.getBoxPadding() + this.getItemBoxXPadding();
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                int maxPages = this.getMaxPages();
                String name = Utils.peekGuiScale().func_78325_e() < 4 ? "Page: " : "";
                float maxStrLen = fr.func_78256_a(EnumChatFormatting.BOLD + name + maxPages + "/" + maxPages);
                float maxButtonXSize = ((float)(rightSide - leftSide + 2) - maxStrLen * 0.5f - 10.0f) / 2.0f;
                int buttonXSize = (int)Math.min(maxButtonXSize, (float)(this.getSearchBarYSize() * 480) / 160.0f);
                int ySize = (int)((float)buttonXSize / 480.0f * 160.0f);
                int yOffset = (int)((float)(this.getSearchBarYSize() - ySize) / 2.0f);
                int top = this.getBoxPadding() + yOffset;
                if (mouseY >= top && mouseY <= top + ySize) {
                    int leftNext;
                    int leftPrev = leftSide - 1;
                    if (mouseX > leftPrev && mouseX < leftPrev + buttonXSize) {
                        this.setPage(this.page - 1);
                        Utils.playPressSound();
                    }
                    if (mouseX > (leftNext = rightSide + 1 - buttonXSize) && mouseX < leftNext + buttonXSize) {
                        this.setPage(this.page + 1);
                        Utils.playPressSound();
                    }
                }
                float sortIconsMinX = (this.sortIcons.length + this.orderIcons.length) * 20 + 16;
                float availableX = rightSide - leftSide;
                float sortOrderScaleFactor = Math.min(1.0f, availableX / sortIconsMinX);
                int scaledITEM_SIZE = (int)(16.0f * sortOrderScaleFactor);
                int scaledItemPaddedSize = (int)(20.0f * sortOrderScaleFactor);
                int iconTop = height - this.getBoxPadding() - (16 + scaledITEM_SIZE) / 2 - 1;
                if (mouseY >= iconTop && mouseY <= iconTop + scaledITEM_SIZE) {
                    int i;
                    for (i = 0; i < this.orderIcons.length; ++i) {
                        int orderIconX = leftSide + i * scaledItemPaddedSize;
                        if (mouseX < orderIconX || mouseX > orderIconX + scaledITEM_SIZE) continue;
                        if (Mouse.getEventButton() == 0) {
                            NotEnoughUpdates.INSTANCE.config.hidden.compareMode = i;
                            this.updateSearch();
                            Utils.playPressSound();
                            continue;
                        }
                        if (Mouse.getEventButton() != 1) continue;
                        NotEnoughUpdates.INSTANCE.config.hidden.compareAscending.set(i, NotEnoughUpdates.INSTANCE.config.hidden.compareAscending.get(i) == false);
                        this.updateSearch();
                        Utils.playPressSound();
                    }
                    for (i = 0; i < this.sortIcons.length; ++i) {
                        int sortIconX = rightSide - scaledITEM_SIZE - i * scaledItemPaddedSize;
                        if (mouseX < sortIconX || mouseX > sortIconX + scaledITEM_SIZE) continue;
                        NotEnoughUpdates.INSTANCE.config.hidden.sortMode = i;
                        this.updateSearch();
                        Utils.playPressSound();
                    }
                }
            }
            Utils.pushGuiScale(-1);
            return true;
        }
        if ((float)mouseX > (float)width * this.getInfoPaneOffsetFactor() - (float)this.getBoxPadding() - 8.0f && (float)mouseX < (float)width * this.getInfoPaneOffsetFactor() - (float)this.getBoxPadding() + 8.0f && mouseY > this.getBoxPadding() - 8 && mouseY < this.getBoxPadding() + 8 && Mouse.getEventButtonState() && Mouse.getEventButton() < 2) {
            this.displayInformationPane(null);
            Utils.pushGuiScale(-1);
            return true;
        }
        if (this.activeInfoPane != null) {
            if ((float)mouseX < (float)width * this.getInfoPaneOffsetFactor()) {
                this.activeInfoPane.mouseInput(width, height, mouseX, mouseY, this.mouseDown);
                Utils.pushGuiScale(-1);
                return true;
            }
            if (Mouse.getEventButton() <= 1 && Mouse.getEventButtonState()) {
                this.activeInfoPane.mouseInputOutside();
            }
        }
        Utils.pushGuiScale(-1);
        return false;
    }

    public int getPaddingUnscaled() {
        int paddingUnscaled = 2 / Utils.peekGuiScale().func_78325_e();
        if (paddingUnscaled < 1) {
            paddingUnscaled = 1;
        }
        return paddingUnscaled;
    }

    public static GuiTextField getTextField() {
        return textField;
    }

    public int getSearchBarXSize() {
        int searchBarXSize = NotEnoughUpdates.INSTANCE.config.toolbar.searchBarWidth;
        if (Utils.peekGuiScale().func_78325_e() == 4) {
            return (int)((double)searchBarXSize * 0.8);
        }
        return searchBarXSize;
    }

    public void displayInformationPane(InfoPane pane) {
        this.infoPaneLoadingJob.cancel(false);
        if (pane == null) {
            this.infoPaneOffsetFactor.setTarget(0.0f);
        } else {
            this.infoPaneOffsetFactor.setTarget(0.33333334f);
        }
        this.infoPaneOffsetFactor.resetTimer();
        this.activeInfoPane = pane;
    }

    public InfoPane getActiveInfoPane() {
        return this.activeInfoPane;
    }

    public int getClickedIndex(int mouseX, int mouseY) {
        int width = Utils.peekGuiScale().func_78326_a();
        int height = Utils.peekGuiScale().func_78328_b();
        int xComp = mouseX - (width / 2 - this.getSearchBarXSize() / 2 + 5);
        String trimmed = Minecraft.func_71410_x().field_71466_p.func_78269_a(textField.func_146179_b(), xComp);
        int linePos = trimmed.length();
        if (linePos != textField.func_146179_b().length()) {
            int charWidth;
            char after = textField.func_146179_b().charAt(linePos);
            int trimmedWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(trimmed);
            if (trimmedWidth + (charWidth = Minecraft.func_71410_x().field_71466_p.func_78263_a(after)) / 2 < xComp - 5) {
                ++linePos;
            }
        }
        return linePos;
    }

    public void setSearchBarFocus(boolean focus) {
        if (focus) {
            this.itemPaneOpen = true;
        }
        searchBarHasFocus = focus;
    }

    public boolean keyboardInput(boolean hoverInv) {
        int keyPressed;
        if (Minecraft.func_71410_x().field_71462_r == null) {
            return false;
        }
        int n = keyPressed = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
        if (this.disabled) {
            if (Keyboard.getEventKeyState() && keyPressed == this.manager.keybindToggleDisplay.func_151463_i()) {
                this.disabled = !this.disabled;
            }
            return false;
        }
        if (NotEnoughUpdates.INSTANCE.config.hidden.dev && Keyboard.isKeyDown((int)21) && !Keyboard.isKeyDown((int)29) && !searchBarHasFocus) {
            DevInfoPane devInfoPane = new DevInfoPane(this, this.manager);
            if (devInfoPane.getText().isEmpty()) {
                Utils.addChatMessage(EnumChatFormatting.AQUA + "[NEU] No missing items!");
            } else {
                this.displayInformationPane(devInfoPane);
            }
        }
        if (Keyboard.getEventKeyState()) {
            if (!NotEnoughUpdates.INSTANCE.config.toolbar.searchBar) {
                searchBarHasFocus = false;
            }
            if (Keyboard.isKeyDown((int)29) && Keyboard.isKeyDown((int)33) && NotEnoughUpdates.INSTANCE.config.toolbar.searchBar && NotEnoughUpdates.INSTANCE.config.toolbar.ctrlF) {
                boolean bl = searchBarHasFocus = !searchBarHasFocus;
                if (searchBarHasFocus) {
                    this.itemPaneOpen = true;
                }
                return true;
            }
            if (Keyboard.getEventKey() == 28 && searchBarHasFocus) {
                try {
                    BigDecimal calculate = Calculator.calculate(textField.func_146179_b(), NeuSearchCalculator.PROVIDE_LOWEST_BIN);
                    textField.func_146180_a(calculate.toPlainString());
                    if (NotEnoughUpdates.INSTANCE.config.toolbar.copyToClipboardWhenGettingResult) {
                        Utils.copyToClipboard(calculate.toPlainString());
                    }
                }
                catch (Calculator.CalculatorException | HeadlessException | IllegalStateException calculate) {
                    // empty catch block
                }
            }
            if (searchBarHasFocus) {
                if (keyPressed == 1) {
                    searchBarHasFocus = false;
                } else if (textField.func_146201_a(Keyboard.getEventCharacter(), keyPressed)) {
                    this.updateSearch();
                }
            } else {
                int i;
                if (this.activeInfoPane != null && this.activeInfoPane.keyboardInput()) {
                    return true;
                }
                if (keyPressed == this.manager.keybindClosePanes.func_151463_i()) {
                    this.itemPaneOffsetFactor.setValue(1.0f);
                    this.itemPaneTabOffset.setValue(20);
                    this.itemPaneOpen = false;
                    this.displayInformationPane(null);
                }
                if (keyPressed == this.manager.keybindToggleDisplay.func_151463_i()) {
                    this.disabled = !this.disabled;
                    return true;
                }
                final AtomicReference<Object> internalname = new AtomicReference<Object>(null);
                AtomicReference<Object> itemstack = new AtomicReference<Object>(null);
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiContainer && Utils.getSlotUnderMouse((GuiContainer)Minecraft.func_71410_x().field_71462_r) != null) {
                    Slot slot = Utils.getSlotUnderMouse((GuiContainer)Minecraft.func_71410_x().field_71462_r);
                    ItemStack hover = slot.func_75211_c();
                    if (hover != null) {
                        internalname.set(this.manager.getInternalNameForItem(hover));
                        itemstack.set(hover);
                    }
                } else {
                    Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.itemlist.paneGuiScale);
                    int width = Utils.peekGuiScale().func_78326_a();
                    int height = Utils.peekGuiScale().func_78328_b();
                    final int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
                    final int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
                    if (this.selectedItemGroup != null) {
                        int selectedX = Math.min(this.selectedItemGroupX, width - this.getBoxPadding() - 18 * this.selectedItemGroup.size());
                        if (mouseY > this.selectedItemGroupY + 17 && mouseY < this.selectedItemGroupY + 35) {
                            for (i = 0; i < this.selectedItemGroup.size(); ++i) {
                                if (mouseX < selectedX - 1 + 18 * i || mouseX > selectedX + 17 + 18 * i) continue;
                                internalname.set(this.selectedItemGroup.get(i).get("internalname").getAsString());
                            }
                        }
                    } else {
                        this.iterateItemSlots(new ItemSlotConsumer(){

                            @Override
                            public void consume(int x, int y, int id) {
                                JsonObject json;
                                if (mouseX >= x - 1 && mouseX <= x + 16 + 1 && mouseY >= y - 1 && mouseY <= y + 16 + 1 && (json = NEUOverlay.this.getSearchedItemPage(id)) != null) {
                                    internalname.set(json.get("internalname").getAsString());
                                }
                            }
                        });
                    }
                    Utils.pushGuiScale(-1);
                }
                if (internalname.get() != null) {
                    JsonObject item;
                    ApiData apiData = NotEnoughUpdates.INSTANCE.config.apiData;
                    if (itemstack.get() != null) {
                        if (apiData.repositoryEditing && Keyboard.getEventKey() == apiData.repositoryEditingKeybind) {
                            Minecraft.func_71410_x().func_147108_a((GuiScreen)new NEUItemEditor(internalname.get(), this.manager.getJsonForItem(itemstack.get())));
                            return true;
                        }
                        if (apiData.repositoryEditing && Keyboard.getEventKey() == apiData.instantEditKeybind) {
                            if (NEUItemEditor.saveOnly(internalname.get(), this.manager.getJsonForItem(itemstack.get()))) {
                                Utils.addChatMessage("\u00a7aSaved " + (String)internalname.get() + " to repository.");
                            } else {
                                Utils.addChatMessage("\u00a7cFailed to save " + (String)internalname.get() + " to repository.");
                            }
                            return true;
                        }
                    }
                    if ((item = this.manager.getItemInformation().get(internalname.get())) != null) {
                        if (keyPressed == this.manager.keybindViewUsages.func_151463_i()) {
                            this.manager.displayGuiItemUsagesKeybind(internalname.get());
                            return true;
                        }
                        if (keyPressed == this.manager.keybindFavourite.func_151463_i()) {
                            this.toggleFavourite(internalname.get());
                            return true;
                        }
                        if (keyPressed == this.manager.keybindViewRecipe.func_151463_i()) {
                            this.manager.displayGuiItemRecipeKeybind(internalname.get());
                            return true;
                        }
                        if (keyPressed == NotEnoughUpdates.INSTANCE.config.misc.keybindWaypoint && NotEnoughUpdates.INSTANCE.navigation.isValidWaypoint(item)) {
                            NotEnoughUpdates.INSTANCE.navigation.trackWaypoint(item);
                        } else if (keyPressed == this.manager.keybindGive.func_151463_i()) {
                            if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                                Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70441_a(this.manager.jsonToStack(item));
                            }
                        } else {
                            if (apiData.repositoryEditing && keyPressed == 37) {
                                if (Keyboard.isKeyDown((int)42)) {
                                    String externalEditorCommand = NotEnoughUpdates.INSTANCE.config.hidden.externalEditor;
                                    if (externalEditorCommand == null) {
                                        Utils.addChatMessage("\u00a7e[NEU] \u00a73No external editor set! Run \u00a7b/neudevtest exteditor <editorcommand>\u00a73 to set your external editor. Optionally use {} as a placeholder for the filename.");
                                    } else {
                                        String externalFileName = this.manager.getItemFileForInternalName(internalname.get()).getAbsolutePath();
                                        externalEditorCommand = externalEditorCommand.contains("{}") ? externalEditorCommand.replace("{}", externalFileName) : externalEditorCommand + " " + externalFileName;
                                        try {
                                            Runtime.getRuntime().exec(externalEditorCommand);
                                        }
                                        catch (IOException e2) {
                                            Utils.addChatMessage("\u00a7e[NEU]\u00a74 Could not open external editor.");
                                            e2.printStackTrace();
                                        }
                                    }
                                } else {
                                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new NEUItemEditor(internalname.get(), item));
                                }
                                return true;
                            }
                            if (keyPressed == this.manager.keybindItemSelect.func_151463_i() && NotEnoughUpdates.INSTANCE.config.toolbar.searchBar) {
                                textField.func_146180_a("id:" + (String)internalname.get());
                                this.itemPaneOpen = true;
                                this.updateSearch();
                            } else {
                                if (keyPressed == NotEnoughUpdates.INSTANCE.config.ahGraph.graphKey && NotEnoughUpdates.INSTANCE.config.ahGraph.graphEnabled) {
                                    NotEnoughUpdates.INSTANCE.openGui = new GuiPriceGraph(internalname.get());
                                    return true;
                                }
                                if (keyPressed == NotEnoughUpdates.INSTANCE.config.misc.openAHKeybind) {
                                    String displayName = item.get("displayname").getAsString();
                                    JsonArray lore = item.getAsJsonArray("lore");
                                    ArrayList<String> loreList = new ArrayList<String>();
                                    for (i = 0; i < lore.size(); ++i) {
                                        loreList.add(lore.get(i).getAsString());
                                    }
                                    AhBzKeybind.onKeyPressed(displayName, loreList, internalname.get());
                                } else if (keyPressed == NotEnoughUpdates.INSTANCE.config.misc.openSkyBlockRecipeKeybind && !item.has("vanilla") && StreamExtL.filterIsInstance(this.manager.getAvailableRecipesFor(internalname.get()).stream(), CraftingRecipe.class).findAny().isPresent()) {
                                    String displayName = Utils.cleanColour(item.get("displayname").getAsString().replace("[Lvl {LVL}]", "").trim());
                                    NotEnoughUpdates.INSTANCE.trySendCommand("/recipe " + displayName);
                                } else if (keyPressed == NotEnoughUpdates.INSTANCE.config.misc.neuCustomizeKeybind && itemstack.get() != null) {
                                    String uuid = NEUManager.getUUIDFromNBT(((ItemStack)itemstack.get()).func_77978_p());
                                    if (uuid != null) {
                                        NotEnoughUpdates.INSTANCE.openGui = new GuiItemCustomize(itemstack.get(), uuid);
                                    } else {
                                        Utils.addChatMessage("\u00a7cThis item does not have an UUID, so it cannot be customized.");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return searchBarHasFocus;
    }

    public void toggleFavourite(String internalname) {
        if (this.getFavourites().contains(internalname)) {
            this.getFavourites().remove(internalname);
        } else {
            this.getFavourites().add(internalname);
        }
        this.updateSearch();
    }

    private int getCompareMode() {
        return NotEnoughUpdates.INSTANCE.config.hidden.compareMode;
    }

    private int getSortMode() {
        return NotEnoughUpdates.INSTANCE.config.hidden.sortMode;
    }

    private List<Boolean> getCompareAscending() {
        return NotEnoughUpdates.INSTANCE.config.hidden.compareAscending;
    }

    private List<String> getFavourites() {
        return NotEnoughUpdates.INSTANCE.config.hidden.favourites;
    }

    private Comparator<JsonObject> getItemComparator() {
        return (o1, o2) -> {
            int nameComp;
            int mult;
            if (this.getFavourites().contains(o1.get("internalname").getAsString()) && !this.getFavourites().contains(o2.get("internalname").getAsString())) {
                return -1;
            }
            if (!this.getFavourites().contains(o1.get("internalname").getAsString()) && this.getFavourites().contains(o2.get("internalname").getAsString())) {
                return 1;
            }
            int n = mult = this.getCompareAscending().get(this.getCompareMode()) != false ? 1 : -1;
            if (this.getCompareMode() == 1) {
                int rarity2;
                int rarity1 = Utils.getRarityFromLore(o1.get("lore").getAsJsonArray());
                if (rarity1 < (rarity2 = Utils.getRarityFromLore(o2.get("lore").getAsJsonArray()))) {
                    return mult;
                }
                if (rarity1 > rarity2) {
                    return -mult;
                }
            } else if (this.getCompareMode() == 2) {
                double cost2;
                String internal1 = o1.get("internalname").getAsString();
                String internal2 = o2.get("internalname").getAsString();
                double cost1 = this.manager.auctionManager.getBazaarOrBin(internal1, false);
                if (cost1 < (cost2 = this.manager.auctionManager.getBazaarOrBin(internal2, false))) {
                    return mult;
                }
                if (cost1 > cost2) {
                    return -mult;
                }
            }
            String i1 = o1.get("internalname").getAsString();
            String[] split1 = i1.split("_");
            String last1 = split1[split1.length - 1];
            String start1 = i1.substring(0, i1.length() - last1.length());
            String i2 = o2.get("internalname").getAsString();
            String[] split2 = i2.split("_");
            String last2 = split2[split2.length - 1];
            String start2 = i2.substring(0, i2.length() - last2.length());
            int n2 = mult = this.getCompareAscending().get(0) != false ? 1 : -1;
            if (start1.equals(start2)) {
                int type2;
                String[] order = new String[]{"HELMET", "CHESTPLATE", "LEGGINGS", "BOOTS"};
                int type1 = this.checkItemType(o1.get("lore").getAsJsonArray(), order);
                if (type1 < (type2 = this.checkItemType(o2.get("lore").getAsJsonArray(), order))) {
                    return -mult;
                }
                if (type1 > type2) {
                    return mult;
                }
            }
            if ((nameComp = mult * o1.get("displayname").getAsString().replaceAll("(?i)\\u00A7.", "").compareTo(o2.get("displayname").getAsString().replaceAll("(?i)\\u00A7.", ""))) != 0) {
                return nameComp;
            }
            return mult * o1.get("internalname").getAsString().compareTo(o2.get("internalname").getAsString());
        };
    }

    public int checkItemType(JsonArray lore, String ... typeMatches) {
        for (int i = lore.size() - 1; i >= 0; --i) {
            String line = lore.get(i).getAsString();
            for (String rarity : Utils.rarityArrC) {
                for (int j = 0; j < typeMatches.length; ++j) {
                    if (!line.trim().equals(rarity + " " + typeMatches[j])) continue;
                    return j;
                }
            }
        }
        return -1;
    }

    public boolean checkMatchesSort(String internalname, JsonObject item) {
        if (!NotEnoughUpdates.INSTANCE.config.itemlist.showVanillaItems && item.has("vanilla") && item.get("vanilla").getAsBoolean()) {
            return false;
        }
        if (this.getSortMode() == 0) {
            return NotEnoughUpdates.INSTANCE.config.itemlist.alwaysShowMonsters || !internalname.matches(".*?((_MONSTER)|(_NPC)|(_ANIMAL)|(_MINIBOSS)|(_BOSS)|(_SC))$");
        }
        if (this.getSortMode() == 1) {
            return internalname.matches(".*?((_MONSTER)|(_NPC)|(_ANIMAL)|(_MINIBOSS)|(_BOSS)|(_SC))$");
        }
        if (this.getSortMode() == 2) {
            return internalname.matches(".*?;[0-5]$") && item.get("displayname").getAsString().contains("[");
        }
        if (this.getSortMode() == 3) {
            return this.checkItemType(item.get("lore").getAsJsonArray(), "SWORD", "BOW", "AXE", "PICKAXE", "FISHING ROD", "WAND", "SHOVEL", "HOE", "DUNGEON SWORD", "DUNGEON BOW", "DRILL", "GAUNTLET", "LONGSWORD", "DUNGEON LONGSWORD", "DEPLOYABLE") >= 0;
        }
        if (this.getSortMode() == 4) {
            return this.checkItemType(item.get("lore").getAsJsonArray(), "HELMET", "CHESTPLATE", "LEGGINGS", "BOOTS", "DUNGEON HELMET", "DUNGEON CHESTPLATE", "DUNGEON LEGGINGS", "DUNGEON BOOTS", "BELT", "GLOVES", "CLOAK", "NECKLACE", "BRACELET", "DUNGEON BELT", "DUNGEON GLOVES", "DUNGEON CLOAK", "DUNGEON NECKLACE", "DUNGEON BRACELET", "CARNIVAL MASK") >= 0;
        }
        if (this.getSortMode() == 5) {
            return this.checkItemType(item.get("lore").getAsJsonArray(), "ACCESSORY", "HATCESSORY", "DUNGEON ACCESSORY") >= 0;
        }
        return true;
    }

    public void updateSearch() {
        SunTzu.randomizeQuote();
        if (this.searchedItems == null) {
            this.searchedItems = new TreeSet<JsonObject>(this.getItemComparator());
        }
        this.searchES.submit(() -> {
            void var6_25;
            TreeSet<JsonObject> searchedItems = new TreeSet<JsonObject>(this.getItemComparator());
            HashMap searchedItemsSubgroup = new HashMap();
            HashSet<JsonObject> removeChildItems = new HashSet<JsonObject>();
            Set<String> itemsMatch = this.manager.search(textField.func_146179_b(), true);
            for (String string : itemsMatch) {
                JsonObject item;
                if (!this.checkMatchesSort(string, item = this.manager.getItemInformation().get(string))) continue;
                if (Constants.PARENTS != null && Constants.PARENTS.has(string) && Constants.PARENTS.get(string).isJsonArray()) {
                    ArrayList<String> children = new ArrayList<String>();
                    for (JsonElement e2 : Constants.PARENTS.get(string).getAsJsonArray()) {
                        if (!e2.isJsonPrimitive()) continue;
                        children.add(e2.getAsString());
                    }
                    children.retainAll(itemsMatch);
                    for (String child : children) {
                        removeChildItems.add(this.manager.getItemInformation().get(child));
                    }
                    searchedItemsSubgroup.put(string, children);
                }
                searchedItems.add(item);
            }
            searchedItems.removeAll(removeChildItems);
            for (Map.Entry entry : searchedItemsSubgroup.entrySet()) {
                if (searchedItems.contains(this.manager.getItemInformation().get(entry.getKey()))) continue;
                for (String itemname : (List)entry.getValue()) {
                    JsonObject item = this.manager.getItemInformation().get(itemname);
                    if (item == null) continue;
                    searchedItems.add(item);
                }
            }
            List<JsonObject> list = textField.func_146179_b().toLowerCase(Locale.ROOT).trim();
            int n = -1;
            switch (((String)((Object)list)).hashCode()) {
                case -2001121357: {
                    if (!((String)((Object)list)).equals("nullzee")) break;
                    boolean bl = false;
                    break;
                }
                case 3512122: {
                    if (!((String)((Object)list)).equals("rune")) break;
                    boolean bl = true;
                    break;
                }
                case 1585394: {
                    if (!((String)((Object)list)).equals("2b2t")) break;
                    int n2 = 2;
                    break;
                }
                case 1891056868: {
                    if (!((String)((Object)list)).equals("ducttape")) break;
                    int n3 = 3;
                    break;
                }
                case -1895586442: {
                    if (!((String)((Object)list)).equals("ducttapedigger")) break;
                    int n4 = 4;
                    break;
                }
                case -1790181797: {
                    if (!((String)((Object)list)).equals("thirtyvirus")) break;
                    int n5 = 5;
                    break;
                }
                case 63268939: {
                    if (!((String)((Object)list)).equals("leocthl")) break;
                    int n6 = 6;
                    break;
                }
                case -2004450401: {
                    if (!((String)((Object)list)).equals("spinaxx")) break;
                    int n7 = 7;
                    break;
                }
                case 1028633754: {
                    if (!((String)((Object)list)).equals("credits")) break;
                    int n8 = 8;
                    break;
                }
                case -1352291591: {
                    if (!((String)((Object)list)).equals("credit")) break;
                    int n9 = 9;
                    break;
                }
                case 674062409: {
                    if (!((String)((Object)list)).equals("who made this mod")) break;
                    int n10 = 10;
                    break;
                }
                case -309523511: {
                    if (!((String)((Object)list)).equals("ironmoon")) break;
                    int n11 = 11;
                    break;
                }
                case -309586007: {
                    if (!((String)((Object)list)).equals("ironm00n")) break;
                    int n12 = 12;
                    break;
                }
                case 3387264: {
                    if (!((String)((Object)list)).equals("nopo")) break;
                    int n13 = 13;
                    break;
                }
                case 1225736303: {
                    if (!((String)((Object)list)).equals("nopothegamer")) break;
                    int n14 = 14;
                }
            }
            switch (var6_25) {
                case 0: {
                    searchedItems.add(CustomItems.NULLZEE);
                    break;
                }
                case 1: {
                    searchedItems.add(CustomItems.RUNE);
                    break;
                }
                case 2: {
                    searchedItems.add(CustomItems.TWOBEETWOTEE);
                    break;
                }
                case 3: 
                case 4: {
                    searchedItems.add(CustomItems.DUCTTAPE);
                    break;
                }
                case 5: {
                    searchedItems.add(this.manager.getItemInformation().get("SPIKED_BAIT"));
                    break;
                }
                case 6: {
                    searchedItems.add(CustomItems.LEOCTHL);
                    break;
                }
                case 7: {
                    searchedItems.add(CustomItems.SPINAXX);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    searchedItems.add(CustomItems.CREDITS);
                    break;
                }
                case 11: 
                case 12: {
                    searchedItems.add(CustomItems.IRONM00N);
                    break;
                }
                case 13: 
                case 14: {
                    searchedItems.add(CustomItems.NOPO);
                }
            }
            this.searchedItems = searchedItems;
            this.searchedItemsSubgroup = searchedItemsSubgroup;
            list = this.searchedItemsArr;
            synchronized (list) {
                this.searchedItemsArr.clear();
            }
            this.redrawItems = true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JsonObject> getSearchedItems() {
        if (this.searchedItems == null) {
            this.updateSearch();
            return new ArrayList<JsonObject>();
        }
        if (this.searchedItems.size() > 0 && this.searchedItemsArr.size() == 0) {
            List<JsonObject> list = this.searchedItemsArr;
            synchronized (list) {
                this.searchedItemsArr.addAll(this.searchedItems);
            }
        }
        return this.searchedItemsArr;
    }

    public JsonObject getSearchedItemPage(int index) {
        if (index < this.getSlotsXSize() * this.getSlotsYSize()) {
            int actualIndex = index + this.getSlotsXSize() * this.getSlotsYSize() * this.page;
            List<JsonObject> searchedItems = this.getSearchedItems();
            if (0 <= actualIndex && actualIndex < searchedItems.size()) {
                try {
                    return searchedItems.get(actualIndex);
                }
                catch (IndexOutOfBoundsException e2) {
                    System.out.println("searchedItems size: " + searchedItems.size());
                    System.out.println("actualIndex: " + actualIndex);
                    e2.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public int getItemBoxXPadding() {
        int width = Utils.peekGuiScale().func_78326_a();
        return (((int)((float)(width / 3) * this.getWidthMult()) - 2 * this.getBoxPadding()) % 20 + 4) / 2;
    }

    public int getBoxPadding() {
        double panePadding = Math.max(0, Math.min(20, NotEnoughUpdates.INSTANCE.config.itemlist.panePadding));
        return (int)(panePadding * 2.0 / (double)Utils.peekGuiScale().func_78325_e() + 5.0);
    }

    public void iterateItemSlots(ItemSlotConsumer itemSlotConsumer) {
        int width = Utils.peekGuiScale().func_78326_a();
        int itemBoxXPadding = this.getItemBoxXPadding();
        this.iterateItemSlots(itemSlotConsumer, (int)((float)width * this.getItemPaneOffsetFactor()) + this.getBoxPadding() + itemBoxXPadding);
    }

    public void iterateItemSlots(ItemSlotConsumer itemSlotConsumer, int xStart) {
        int width = Utils.peekGuiScale().func_78326_a();
        int height = Utils.peekGuiScale().func_78328_b();
        int paneWidth = (int)((float)(width / 3) * this.getWidthMult());
        int itemBoxYPadding = ((height - this.getSearchBarYSize() - 2 * this.getBoxPadding() - 16 - 2) % 20 + 4) / 2;
        int yStart = this.getBoxPadding() + this.getSearchBarYSize() + itemBoxYPadding;
        int itemBoxXPadding = this.getItemBoxXPadding();
        int xEnd = xStart + paneWidth - this.getBoxPadding() * 2 - 16 - itemBoxXPadding;
        int yEnd = height - this.getBoxPadding() - 16 - 2 - itemBoxYPadding;
        int id = 0;
        for (int y = yStart; y < yEnd; y += 20) {
            for (int x = xStart; x < xEnd; x += 20) {
                itemSlotConsumer.consume(x, y, id++);
            }
        }
    }

    public float getWidthMult() {
        float scaleFMult = 1.0f;
        if (Utils.peekGuiScale().func_78325_e() == 4) {
            scaleFMult *= 0.9f;
        }
        return (float)Math.max(0.5, Math.min(1.5, (double)NotEnoughUpdates.INSTANCE.config.itemlist.paneWidthMult)) * scaleFMult;
    }

    public int getSlotsXSize() {
        int width = Utils.peekGuiScale().func_78326_a();
        int paneWidth = (int)((float)(width / 3) * this.getWidthMult());
        int itemBoxXPadding = (((int)((float)width - (float)width * this.getItemPaneOffsetFactor()) - 2 * this.getBoxPadding()) % 20 + 4) / 2;
        int xStart = (int)((float)width * this.getItemPaneOffsetFactor()) + this.getBoxPadding() + itemBoxXPadding;
        int xEnd = (int)((float)width * this.getItemPaneOffsetFactor()) + paneWidth - this.getBoxPadding() - 16;
        return (int)Math.ceil((float)(xEnd - xStart) / 20.0f);
    }

    public int getSlotsYSize() {
        int height = Utils.peekGuiScale().func_78328_b();
        int itemBoxYPadding = ((height - this.getSearchBarYSize() - 2 * this.getBoxPadding() - 16 - 2) % 20 + 4) / 2;
        int yStart = this.getBoxPadding() + this.getSearchBarYSize() + itemBoxYPadding;
        int yEnd = height - this.getBoxPadding() - 16 - 2 - itemBoxYPadding;
        return (int)Math.ceil((float)(yEnd - yStart) / 20.0f);
    }

    public int getMaxPages() {
        if (this.getSearchedItems().size() == 0) {
            return 1;
        }
        return (int)Math.ceil((float)this.getSearchedItems().size() / (float)this.getSlotsYSize() / (float)this.getSlotsXSize());
    }

    public int getSearchBarYSize() {
        int searchBarYSize = NotEnoughUpdates.INSTANCE.config.toolbar.searchBarHeight;
        return Math.max(searchBarYSize / Utils.peekGuiScale().func_78325_e(), 16);
    }

    public void renderNavElement(int leftSide, int rightSide, int maxPages, int page, String name) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String pageText = EnumChatFormatting.BOLD + name + page + "/" + maxPages;
        float maxStrLen = fr.func_78256_a(EnumChatFormatting.BOLD + name + maxPages + "/" + maxPages);
        float maxButtonXSize = ((float)(rightSide - leftSide + 2) - maxStrLen * 0.5f - 10.0f) / 2.0f;
        int buttonXSize = (int)Math.min(maxButtonXSize, (float)(this.getSearchBarYSize() * 480) / 160.0f);
        int ySize = (int)((float)buttonXSize / 480.0f * 160.0f);
        int yOffset = (int)((float)(this.getSearchBarYSize() - ySize) / 2.0f);
        int top = this.getBoxPadding() + yOffset;
        int leftPressed = 0;
        int rightPressed = 0;
        if (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1)) {
            int width = Utils.peekGuiScale().func_78326_a();
            int height = Utils.peekGuiScale().func_78328_b();
            int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
            int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
            if (mouseY >= top && mouseY <= top + ySize) {
                int leftNext;
                int leftPrev = leftSide - 1;
                if (mouseX > leftPrev && mouseX < leftPrev + buttonXSize) {
                    leftPressed = 1;
                }
                if (mouseX > (leftNext = rightSide + 1 - buttonXSize) && mouseX < leftNext + buttonXSize) {
                    rightPressed = 1;
                }
            }
        }
        NEUOverlay.func_73734_a((int)(leftSide - 1), (int)top, (int)(leftSide - 1 + buttonXSize), (int)(top + ySize), (int)this.fg.getRGB());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.rightarrow);
        Utils.drawTexturedRect(leftSide - 1 + leftPressed, top + leftPressed, buttonXSize, ySize, 1.0f, 0.0f, 0.0f, 1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.rightarrow_overlay);
        Utils.drawTexturedRect(leftSide - 1, top, buttonXSize, ySize, 1 - leftPressed, leftPressed, 1 - leftPressed, leftPressed);
        GlStateManager.func_179144_i((int)0);
        Utils.drawStringCenteredScaled(EnumChatFormatting.BOLD + "Prev", (float)(leftSide - 1) + (float)(buttonXSize * 300) / 480.0f + (float)leftPressed, (float)top + (float)ySize / 2.0f + (float)leftPressed, false, (int)((float)(buttonXSize * 240) / 480.0f), Color.BLACK.getRGB());
        NEUOverlay.func_73734_a((int)(rightSide + 1 - buttonXSize), (int)top, (int)(rightSide + 1), (int)(top + ySize), (int)this.fg.getRGB());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.rightarrow);
        Utils.drawTexturedRect(rightSide + 1 - buttonXSize + rightPressed, top + rightPressed, buttonXSize, ySize);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.rightarrow_overlay);
        Utils.drawTexturedRect(rightSide + 1 - buttonXSize, top, buttonXSize, ySize, 1 - rightPressed, rightPressed, 1 - rightPressed, rightPressed);
        GlStateManager.func_179144_i((int)0);
        Utils.drawStringCenteredScaled(EnumChatFormatting.BOLD + "Next", (float)(rightSide + 1) - (float)(buttonXSize * 300) / 480.0f + (float)rightPressed, (float)top + (float)ySize / 2.0f + (float)rightPressed, false, (int)((float)(buttonXSize * 240) / 480.0f), Color.BLACK.getRGB());
        int strMaxLen = rightSide - leftSide - 2 * buttonXSize - 10;
        NEUOverlay.func_73734_a((int)(leftSide - 1 + buttonXSize + 3), (int)top, (int)(rightSide + 1 - buttonXSize - 3), (int)(top + ySize), (int)new Color(177, 177, 177).getRGB());
        NEUOverlay.func_73734_a((int)(leftSide + buttonXSize + 3), (int)(top + 1), (int)(rightSide + 1 - buttonXSize - 3), (int)(top + ySize), (int)new Color(50, 50, 50).getRGB());
        NEUOverlay.func_73734_a((int)(leftSide + buttonXSize + 3), (int)(top + 1), (int)(rightSide - buttonXSize - 3), (int)(top + ySize - 1), (int)this.fg.getRGB());
        Utils.drawStringCenteredScaledMaxWidth(pageText, (leftSide + rightSide) / 2, (float)top + (float)ySize / 2.0f, false, strMaxLen, Color.BLACK.getRGB());
    }

    private int limCol(int col) {
        return Math.min(255, Math.max(0, col));
    }

    public boolean isUsingMobsFilter() {
        return this.getSortMode() == 1;
    }

    private void renderEntity(float posX, float posY, float scale, String name, Class<? extends EntityLivingBase> ... classes) {
        EntityLivingBase[] entities = new EntityLivingBase[classes.length];
        try {
            EntityLivingBase last = null;
            for (int i = 0; i < classes.length; ++i) {
                Class<? extends EntityLivingBase> clazz = classes[i];
                if (clazz == null) continue;
                EntityLivingBase newEnt = clazz.getConstructor(World.class).newInstance(Minecraft.func_71410_x().field_71441_e);
                newEnt.field_70125_A = this.pitch;
                newEnt.func_96094_a(name);
                if (last != null) {
                    last.field_70153_n = newEnt;
                    newEnt.field_70154_o = last;
                    last.func_70043_V();
                }
                last = newEnt;
                entities[i] = newEnt;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            e2.printStackTrace();
            return;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        for (EntityLivingBase ent : entities) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (ent == null) continue;
            rendermanager.func_147940_a((Entity)ent, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 0.0f, 1.0f);
        }
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private Matrix4f createProjectionMatrix(int width, int height) {
        Matrix4f projMatrix = new Matrix4f();
        projMatrix.setIdentity();
        projMatrix.m00 = 2.0f / (float)width;
        projMatrix.m11 = 2.0f / (float)(-height);
        projMatrix.m22 = -0.0020001999f;
        projMatrix.m33 = 1.0f;
        projMatrix.m03 = -1.0f;
        projMatrix.m13 = 1.0f;
        projMatrix.m23 = -1.0001999f;
        return projMatrix;
    }

    public void updateGuiGroupSize() {
        Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.itemlist.paneGuiScale);
        int width = Utils.peekGuiScale().func_78326_a();
        int height = Utils.peekGuiScale().func_78328_b();
        if (this.lastScreenWidth != width || this.lastScreenHeight != height || Utils.peekGuiScale().func_78325_e() != this.lastScale) {
            this.guiGroup.width = width;
            this.guiGroup.height = height;
            this.resetAnchors(true);
            this.guiGroup.recalculate();
            this.lastScreenWidth = width;
            this.lastScreenHeight = height;
            this.lastScale = Utils.peekGuiScale().func_78325_e();
        }
        Utils.pushGuiScale(-1);
    }

    public void render(boolean hoverInv) {
        JsonObject json;
        if (this.disabled) {
            return;
        }
        GlStateManager.func_179126_j();
        Utils.resetGuiScale();
        Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.itemlist.paneGuiScale);
        int width = Utils.peekGuiScale().func_78326_a();
        int height = Utils.peekGuiScale().func_78328_b();
        final int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        final int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        if (this.showVanillaLast != NotEnoughUpdates.INSTANCE.config.itemlist.showVanillaItems) {
            this.showVanillaLast = NotEnoughUpdates.INSTANCE.config.itemlist.showVanillaItems;
            this.updateSearch();
        }
        if (textField.func_146179_b().toLowerCase(Locale.ROOT).contains("bald")) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(SUPERGEHEIMNISVERMOGEN);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect((float)(width - 64) / 2.0f, (float)(height - 64) / 2.0f - 114.0f, 64.0f, 64.0f, 9729);
            GlStateManager.func_179144_i((int)0);
        }
        if (textField.func_146179_b().toLowerCase(Locale.ROOT).contains("lunar")) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ATMOULBERRYWHYISMYLUNARCLIENTBUGGING);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
            Utils.drawTexturedRect((float)(width + 410) / 2.0f, (float)(height + 450) / 2.0f - 114.0f, 113.0f, 64.0f, 9729);
            GlStateManager.func_179144_i((int)0);
        }
        SunTzu.setEnabled(textField.func_146179_b().toLowerCase(Locale.ROOT).startsWith("potato"));
        this.updateGuiGroupSize();
        if (this.guiScaleLast != Utils.peekGuiScale().func_78325_e()) {
            this.guiScaleLast = Utils.peekGuiScale().func_78325_e();
            this.redrawItems = true;
        }
        if (this.oldWidthMult != this.getWidthMult()) {
            this.oldWidthMult = this.getWidthMult();
            this.redrawItems = true;
        }
        this.yaw += 1.0f;
        this.yaw %= 360.0f;
        this.bg = new Color(SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.itemlist.backgroundColour), true);
        this.fg = new Color(SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.itemlist.foregroundColour));
        Color fgCustomOpacity = new Color(SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.itemlist.foregroundColour), true);
        Color fgFavourite2 = new Color(SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.itemlist.favouriteColour), true);
        Color fgFavourite = new Color((int)((float)fgFavourite2.getRed() * 0.8f), (int)((float)fgFavourite2.getGreen() * 0.8f), (int)((float)fgFavourite2.getBlue() * 0.8f), fgFavourite2.getAlpha());
        if (!NotEnoughUpdates.INSTANCE.config.itemlist.openWhenSearching && this.searchMode) {
            this.itemPaneOpen = false;
        }
        if (this.itemPaneShouldOpen != -1L && System.currentTimeMillis() > this.itemPaneShouldOpen) {
            this.itemPaneOpen = true;
            this.itemPaneShouldOpen = -1L;
        }
        if (this.itemPaneOpen) {
            if (this.itemPaneTabOffset.getValue() == 0) {
                if (this.itemPaneOffsetFactor.getTarget() != 0.6666667f) {
                    this.itemPaneOffsetFactor.setTarget(0.6666667f);
                    this.itemPaneOffsetFactor.resetTimer();
                }
            } else if (this.itemPaneTabOffset.getTarget() != 0) {
                this.itemPaneTabOffset.setTarget(0);
                this.itemPaneTabOffset.resetTimer();
            }
        } else if (this.itemPaneOffsetFactor.getValue() == 1.0f) {
            if (this.itemPaneTabOffset.getTarget() != 20) {
                this.itemPaneTabOffset.setTarget(20);
                this.itemPaneTabOffset.resetTimer();
            }
        } else if (this.itemPaneOffsetFactor.getTarget() != 1.0f) {
            this.itemPaneOffsetFactor.setTarget(1.0f);
            this.itemPaneOffsetFactor.resetTimer();
        }
        this.itemPaneOffsetFactor.tick();
        this.itemPaneTabOffset.tick();
        this.infoPaneOffsetFactor.tick();
        if (this.page > this.getMaxPages() - 1) {
            this.setPage(this.getMaxPages() - 1);
        }
        if (this.page < 0) {
            this.setPage(0);
        }
        GlStateManager.func_179140_f();
        int paneWidth = (int)((float)(width / 3) * this.getWidthMult());
        int leftSide = (int)((float)width * this.getItemPaneOffsetFactor());
        int rightSide = leftSide + paneWidth - this.getBoxPadding() - this.getItemBoxXPadding();
        if (NotEnoughUpdates.INSTANCE.config.itemlist.tabOpen) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.itemPaneTabArrow);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            Utils.drawTexturedRect((float)width - (float)(this.itemPaneTabOffset.getValue() * 64) / 20.0f, (float)height / 2.0f - 32.0f, 64.0f, 64.0f);
            GlStateManager.func_179144_i((int)0);
            if (!this.itemPaneOpen && mouseX > width - this.itemPaneTabOffset.getValue() && mouseY > height / 2 - 32 && mouseY < height / 2 + 32) {
                this.itemPaneOpen = true;
            }
        }
        final AtomicReference<Object> tooltipToDisplay = new AtomicReference<Object>(null);
        if ((double)this.itemPaneOffsetFactor.getValue() < 0.99) {
            int selectedX;
            String text;
            int i;
            if ((double)NotEnoughUpdates.INSTANCE.config.itemlist.bgBlurFactor > 0.5) {
                BackgroundBlur.renderBlurredBackground(NotEnoughUpdates.INSTANCE.config.itemlist.bgBlurFactor, width, height, leftSide + this.getBoxPadding() - 5, this.getBoxPadding() - 5, paneWidth - this.getBoxPadding() * 2 + 10, height - this.getBoxPadding() * 2 + 10, (double)this.itemPaneOffsetFactor.getValue() > 0.01);
                Gui.func_73734_a((int)(leftSide + this.getBoxPadding() - 5), (int)(this.getBoxPadding() - 5), (int)(leftSide + this.getBoxPadding() - 5 + paneWidth - this.getBoxPadding() * 2 + 10), (int)(this.getBoxPadding() - 5 + height - this.getBoxPadding() * 2 + 10), (int)-938471408);
            }
            NEUOverlay.func_73734_a((int)(leftSide + this.getBoxPadding() - 5), (int)(this.getBoxPadding() - 5), (int)(leftSide + paneWidth - this.getBoxPadding() + 5), (int)(height - this.getBoxPadding() + 5), (int)this.bg.getRGB());
            this.renderNavElement(leftSide + this.getBoxPadding() + this.getItemBoxXPadding(), rightSide, this.getMaxPages(), this.page + 1, Utils.peekGuiScale().func_78325_e() < 4 ? "Page: " : "");
            NEUOverlay.func_73734_a((int)(leftSide + this.getBoxPadding() + this.getItemBoxXPadding() - 1), (int)(height - this.getBoxPadding() - 16 - 2), (int)(rightSide + 1), (int)(height - this.getBoxPadding()), (int)fgCustomOpacity.getRGB());
            float sortIconsMinX = (this.sortIcons.length + this.orderIcons.length) * 20 + 16;
            float availableX = rightSide - (leftSide + this.getBoxPadding() + this.getItemBoxXPadding());
            float sortOrderScaleFactor = Math.min(1.0f, availableX / sortIconsMinX);
            int scaledITEM_SIZE = (int)(16.0f * sortOrderScaleFactor);
            int scaledItemPaddedSize = (int)(20.0f * sortOrderScaleFactor);
            int iconTop = height - this.getBoxPadding() - (16 + scaledITEM_SIZE) / 2 - 1;
            boolean hoveredOverControl = false;
            for (i = 0; i < this.orderIcons.length; ++i) {
                int orderIconX = leftSide + this.getBoxPadding() + this.getItemBoxXPadding() + i * scaledItemPaddedSize;
                NEUOverlay.func_73734_a((int)orderIconX, (int)iconTop, (int)(scaledITEM_SIZE + orderIconX), (int)(iconTop + scaledITEM_SIZE), (int)this.fg.getRGB());
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getCompareMode() == i ? this.orderIconsActive[i] : this.orderIcons[i]);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(orderIconX, iconTop, scaledITEM_SIZE, scaledITEM_SIZE, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getCompareAscending().get(i) != false ? GuiTextures.ascending_overlay : GuiTextures.descending_overlay);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(orderIconX, iconTop, scaledITEM_SIZE, scaledITEM_SIZE, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
                GlStateManager.func_179144_i((int)0);
                if (mouseY <= iconTop || mouseY >= iconTop + scaledITEM_SIZE || mouseX <= orderIconX || mouseX >= orderIconX + scaledITEM_SIZE) continue;
                hoveredOverControl = true;
                if (System.currentTimeMillis() - this.millisLastMouseMove <= 400L) continue;
                text = EnumChatFormatting.GRAY + "Order ";
                text = i == 0 ? text + "Alphabetically" : (i == 1 ? text + "by Rarity" : (i == 2 ? text + "by Item Worth" : null));
                if (text == null) continue;
                this.textToDisplay = Utils.createList(text);
            }
            for (i = 0; i < this.sortIcons.length; ++i) {
                int sortIconX = rightSide - scaledITEM_SIZE - i * scaledItemPaddedSize;
                NEUOverlay.func_73734_a((int)sortIconX, (int)iconTop, (int)(scaledITEM_SIZE + sortIconX), (int)(iconTop + scaledITEM_SIZE), (int)this.fg.getRGB());
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getSortMode() == i ? this.sortIconsActive[i] : this.sortIcons[i]);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(sortIconX, iconTop, scaledITEM_SIZE, scaledITEM_SIZE, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
                GlStateManager.func_179144_i((int)0);
                if (mouseY <= iconTop || mouseY >= iconTop + scaledITEM_SIZE || mouseX <= sortIconX || mouseX >= sortIconX + scaledITEM_SIZE) continue;
                hoveredOverControl = true;
                if (System.currentTimeMillis() - this.millisLastMouseMove <= 400L) continue;
                text = EnumChatFormatting.GRAY + "Filter ";
                text = i == 0 ? EnumChatFormatting.GRAY + "No Filter" : (i == 1 ? text + "Mobs" : (i == 2 ? text + "Pets" : (i == 3 ? text + "Tools" : (i == 4 ? text + "Armor" : (i == 5 ? text + "Accessories" : null)))));
                if (text == null) continue;
                this.textToDisplay = Utils.createList(text);
            }
            if (!hoveredOverControl) {
                this.millisLastMouseMove = System.currentTimeMillis();
            }
            if (!(this.selectedItemGroup == null || mouseX >= this.selectedItemGroupX - 1 && mouseX <= this.selectedItemGroupX + 17 && mouseY >= this.selectedItemGroupY - 1 && mouseY <= this.selectedItemGroupY + 17 || mouseX >= (selectedX = Math.min(this.selectedItemGroupX, width - this.getBoxPadding() - 18 * this.selectedItemGroup.size())) - 1 && mouseX <= selectedX - 1 + 18 * this.selectedItemGroup.size() && mouseY >= this.selectedItemGroupY + 17 && mouseY <= this.selectedItemGroupY + 35)) {
                this.selectedItemGroup = null;
                this.selectedItemMillis = -1L;
            }
            if (!hoverInv) {
                this.iterateItemSlots(new ItemSlotConsumer(){

                    @Override
                    public void consume(int x, int y, int id) {
                        JsonObject json = NEUOverlay.this.getSearchedItemPage(id);
                        if (json == null) {
                            return;
                        }
                        if (mouseX > x - 1 && mouseX < x + 16 + 1 && mouseY > y - 1 && mouseY < y + 16 + 1) {
                            String internalname = json.get("internalname").getAsString();
                            if (NEUOverlay.this.searchedItemsSubgroup.containsKey(internalname)) {
                                if (NEUOverlay.this.selectedItemMillis == -1L) {
                                    NEUOverlay.this.selectedItemMillis = System.currentTimeMillis();
                                }
                                if (System.currentTimeMillis() - NEUOverlay.this.selectedItemMillis > 200L && (NEUOverlay.this.selectedItemGroup == null || NEUOverlay.this.selectedItemGroup.isEmpty())) {
                                    ArrayList<JsonObject> children = new ArrayList<JsonObject>();
                                    children.add(json);
                                    for (String itemname : (List)NEUOverlay.this.searchedItemsSubgroup.get(internalname)) {
                                        children.add(NEUOverlay.this.manager.getItemInformation().get(itemname));
                                    }
                                    NEUOverlay.this.selectedItemGroup = children;
                                    NEUOverlay.this.selectedItemGroupX = x;
                                    NEUOverlay.this.selectedItemGroupY = y;
                                }
                            } else {
                                tooltipToDisplay.set(json);
                            }
                        }
                    }
                });
            }
            int itemBoxXPadding = this.getItemBoxXPadding();
            int xStart = (int)((float)width * this.getItemPaneOffsetFactor()) + this.getBoxPadding() + itemBoxXPadding;
            if (OpenGlHelper.func_148822_b()) {
                this.renderItemsFromImage(xStart, width, height);
                this.renderEnchOverlay();
                this.checkFramebufferSizes(width, height);
                if (this.redrawItems || !NotEnoughUpdates.INSTANCE.config.hidden.cacheRenderedItempane) {
                    this.renderItemsToImage(width, height, fgFavourite2, fgFavourite, fgCustomOpacity, true, true);
                    this.redrawItems = false;
                }
            } else {
                this.renderItems(xStart, true, true, true);
            }
            if (this.selectedItemGroup != null) {
                int i2;
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)10.0f);
                int selectedX2 = Math.min(this.selectedItemGroupX, width - this.getBoxPadding() - 18 * this.selectedItemGroup.size());
                GlStateManager.func_179126_j();
                GlStateManager.func_179143_c((int)513);
                NEUOverlay.func_73734_a((int)selectedX2, (int)(this.selectedItemGroupY + 18), (int)(selectedX2 - 2 + 18 * this.selectedItemGroup.size()), (int)(this.selectedItemGroupY + 34), (int)fgCustomOpacity.getRGB());
                NEUOverlay.func_73734_a((int)(selectedX2 - 1), (int)(this.selectedItemGroupY + 17), (int)(selectedX2 - 2 + 18 * this.selectedItemGroup.size()), (int)(this.selectedItemGroupY + 34), (int)new Color(180, 180, 180).getRGB());
                NEUOverlay.func_73734_a((int)selectedX2, (int)(this.selectedItemGroupY + 18), (int)(selectedX2 - 1 + 18 * this.selectedItemGroup.size()), (int)(this.selectedItemGroupY + 35), (int)new Color(30, 30, 30).getRGB());
                NEUOverlay.func_73734_a((int)(selectedX2 - 1 + 2), (int)(this.selectedItemGroupY + 17 + 2), (int)(selectedX2 - 1 + 18 * this.selectedItemGroup.size() + 2), (int)(this.selectedItemGroupY + 35 + 2), (int)-1610612736);
                GlStateManager.func_179143_c((int)515);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)10.0f);
                tooltipToDisplay.set(null);
                if (mouseY > this.selectedItemGroupY + 17 && mouseY < this.selectedItemGroupY + 35) {
                    for (i2 = 0; i2 < this.selectedItemGroup.size(); ++i2) {
                        if (mouseX < selectedX2 - 1 + 18 * i2 || mouseX > selectedX2 + 17 + 18 * i2) continue;
                        tooltipToDisplay.set(this.selectedItemGroup.get(i2));
                    }
                }
                for (i2 = 0; i2 < this.selectedItemGroup.size(); ++i2) {
                    JsonObject item = this.selectedItemGroup.get(i2);
                    Utils.drawItemStack(this.manager.jsonToStack(item), selectedX2 + 18 * i2, this.selectedItemGroupY + 18);
                }
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-20.0f);
            }
            GlStateManager.func_179147_l();
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179140_f();
        }
        this.guiGroup.render(0.0f, 0.0f);
        this.resetAnchors(true);
        rightSide = (int)((float)width * this.getInfoPaneOffsetFactor());
        leftSide = rightSide - paneWidth;
        if (this.activeInfoPane != null) {
            this.activeInfoPane.tick();
            this.activeInfoPane.render(width, height, this.bg, this.fg, Utils.peekGuiScale(), mouseX, mouseY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.close);
            Utils.drawTexturedRect(rightSide - this.getBoxPadding() - 8, this.getBoxPadding() - 8, 16.0f, 16.0f);
            GL11.glBindTexture((int)3553, (int)0);
        }
        if ((json = (JsonObject)tooltipToDisplay.get()) != null) {
            ItemStack stack = this.manager.jsonToStack(json, false, true);
            NBTTagCompound tag = stack.func_77978_p();
            tag.func_74757_a("DisablePetExp", true);
            stack.func_77982_d(tag);
            List text = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            String internalname = json.get("internalname").getAsString();
            if (!NotEnoughUpdates.INSTANCE.config.tooltipTweaks.showPriceInfoInvItem) {
                ItemPriceInformation.addToTooltip(text, internalname, stack);
            }
            boolean hasClick = json.has("clickcommand") && !json.get("clickcommand").getAsString().isEmpty() || !this.manager.getAvailableRecipesFor(internalname).isEmpty();
            boolean hasInfo = json.has("info") && json.get("info").getAsJsonArray().size() > 0;
            boolean hasWaypoint = NotEnoughUpdates.INSTANCE.navigation.isValidWaypoint(json);
            if (hasClick || hasInfo) {
                text.add("");
            }
            if (hasClick) {
                text.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "LMB/R : View recipe!");
            }
            if (hasInfo) {
                text.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "RMB : View additional information!");
            }
            if (hasWaypoint) {
                text.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + Keyboard.getKeyName((int)NotEnoughUpdates.INSTANCE.config.misc.keybindWaypoint) + " : Set waypoint!");
            }
            this.textToDisplay = text;
        }
        if (this.textToDisplay != null) {
            Utils.drawHoveringText(this.textToDisplay, mouseX, mouseY, width, height, -1);
            this.textToDisplay = null;
        }
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179140_f();
        Utils.pushGuiScale(-1);
        if (System.currentTimeMillis() - this.lastSearchMode > 120000L && NotEnoughUpdates.INSTANCE.config.toolbar.autoTurnOffSearchMode || !NotEnoughUpdates.INSTANCE.config.toolbar.searchBar) {
            this.searchMode = false;
        }
    }

    public void redrawItems() {
        this.redrawItems = true;
    }

    public void setPage(int page) {
        this.page = page;
        this.redrawItems = true;
    }

    private void checkFramebufferSizes(int width, int height) {
        int sw = width * Utils.peekGuiScale().func_78325_e();
        int sh = height * Utils.peekGuiScale().func_78325_e();
        for (int i = 0; i < this.itemFramebuffers.length; ++i) {
            if (this.itemFramebuffers[i] != null && this.itemFramebuffers[i].field_147621_c == sw && this.itemFramebuffers[i].field_147618_d == sh) continue;
            if (this.itemFramebuffers[i] == null) {
                this.itemFramebuffers[i] = new Framebuffer(sw, sh, true);
            } else {
                this.itemFramebuffers[i].func_147613_a(sw, sh);
            }
            this.itemFramebuffers[i].func_147607_a(9728);
            this.redrawItems = true;
        }
    }

    private void prepareFramebuffer(Framebuffer buffer, int sw, int sh) {
        buffer.func_147614_f();
        buffer.func_147610_a(false);
        GL11.glViewport((int)0, (int)0, (int)sw, (int)sh);
    }

    private void cleanupFramebuffer(Framebuffer buffer, int sw, int sh) {
        buffer.func_147609_e();
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
    }

    private void renderItemsToImage(int width, int height, Color fgFavourite2, Color fgFavourite, Color fgCustomOpacity, boolean items2, boolean entities) {
        int sw = width * Utils.peekGuiScale().func_78325_e();
        int sh = height * Utils.peekGuiScale().func_78325_e();
        GL11.glPushMatrix();
        this.prepareFramebuffer(this.itemFramebuffers[0], sw, sh);
        this.renderItems(10, items2, entities, false);
        this.cleanupFramebuffer(this.itemFramebuffers[0], sw, sh);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.prepareFramebuffer(this.itemFramebuffers[1], sw, sh);
        this.renderItemBackgrounds(fgFavourite2, fgFavourite, fgCustomOpacity);
        this.cleanupFramebuffer(this.itemFramebuffers[1], sw, sh);
        GL11.glPopMatrix();
    }

    private void renderItemsFromImage(int xOffset, int width, int height) {
        if (this.itemFramebuffers[0] != null && this.itemFramebuffers[1] != null) {
            this.itemFramebuffers[1].func_147612_c();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(xOffset - 10, 0.0f, width, height, 0.0f, 1.0f, 1.0f, 0.0f);
            this.itemFramebuffers[1].func_147606_d();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)this.itemRenderOffset);
            this.itemFramebuffers[0].func_147612_c();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(xOffset - 10, 0.0f, width, height, 0.0f, 1.0f, 1.0f, 0.0f);
            this.itemFramebuffers[0].func_147606_d();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-this.itemRenderOffset));
        }
    }

    private void renderEnchOverlay() {
        ItemStack stack = new ItemStack(Items.field_151034_e);
        final IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        final float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        final float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_ITEM_GLINT);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-7.5001f + this.itemRenderOffset));
        this.iterateItemSlots(new ItemSlotConsumer(){

            @Override
            public void consume(int x, int y, int id) {
                String jsonString;
                JsonObject json = NEUOverlay.this.getSearchedItemPage(id);
                if (json == null) {
                    return;
                }
                boolean hasEnch = false;
                if (json.has("nbttag") && ((jsonString = json.get("nbttag").getAsJsonPrimitive().getAsString()).contains("ench:[") || jsonString.contains("CustomPotionEffects:["))) {
                    hasEnch = true;
                }
                if (!hasEnch) {
                    return;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179091_B();
                GlStateManager.func_179141_d();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179147_l();
                GlStateManager.func_179140_f();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179143_c((int)514);
                GlStateManager.func_179112_b((int)768, (int)1);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                NEUOverlay.this.renderModel(model, -8372020, null);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                NEUOverlay.this.renderModel(model, -8372020, null);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179143_c((int)515);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179121_F();
            }
        });
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(7.5001f - this.itemRenderOffset));
        GL11.glPopMatrix();
        GlStateManager.func_179144_i((int)0);
    }

    private void renderModel(IBakedModel model, int color, ItemStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(worldrenderer, model.func_177551_a(enumfacing), color);
        }
        this.renderQuads(worldrenderer, model.func_177550_a(), color);
        tessellator.func_78381_a();
    }

    private void renderQuads(WorldRenderer renderer, List<BakedQuad> quads, int color) {
        if (quads == null) {
            return;
        }
        for (BakedQuad quad : quads) {
            renderer.func_178981_a(quad.func_178209_a());
            renderer.func_178968_d(color);
        }
    }

    private void renderItemBackgrounds(final Color fgFavourite2, final Color fgFavourite, final Color fgCustomOpacity) {
        if (fgCustomOpacity.getAlpha() == 0) {
            return;
        }
        this.iterateItemSlots(new ItemSlotConsumer(){

            @Override
            public void consume(int x, int y, int id) {
                JsonObject json = NEUOverlay.this.getSearchedItemPage(id);
                if (json == null) {
                    return;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.item_mask);
                if (NEUOverlay.this.getFavourites().contains(json.get("internalname").getAsString())) {
                    if (NotEnoughUpdates.INSTANCE.config.itemlist.itemStyle == 0) {
                        GlStateManager.func_179131_c((float)((float)fgFavourite2.getRed() / 255.0f), (float)((float)fgFavourite2.getGreen() / 255.0f), (float)((float)fgFavourite2.getBlue() / 255.0f), (float)((float)fgFavourite2.getAlpha() / 255.0f));
                        Utils.drawTexturedRect(x - 1, y - 1, 18.0f, 18.0f, 9728);
                        GlStateManager.func_179131_c((float)((float)fgFavourite.getRed() / 255.0f), (float)((float)fgFavourite.getGreen() / 255.0f), (float)((float)fgFavourite.getBlue() / 255.0f), (float)((float)fgFavourite.getAlpha() / 255.0f));
                        Utils.drawTexturedRect(x, y, 16.0f, 16.0f, 9728);
                    } else {
                        Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 16 + 1), (int)(y + 16 + 1), (int)fgFavourite2.getRGB());
                        Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)fgFavourite.getRGB());
                    }
                } else if (NotEnoughUpdates.INSTANCE.config.itemlist.itemStyle == 0) {
                    GlStateManager.func_179131_c((float)((float)fgCustomOpacity.getRed() / 255.0f), (float)((float)fgCustomOpacity.getGreen() / 255.0f), (float)((float)fgCustomOpacity.getBlue() / 255.0f), (float)((float)fgCustomOpacity.getAlpha() / 255.0f));
                    Utils.drawTexturedRect(x - 1, y - 1, 18.0f, 18.0f, 9728);
                } else {
                    Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 16 + 1), (int)(y + 16 + 1), (int)fgCustomOpacity.getRGB());
                }
                GlStateManager.func_179144_i((int)0);
            }
        }, 10);
    }

    private void renderItems(int xStart, final boolean items2, final boolean entities, final boolean glint) {
        this.iterateItemSlots(new ItemSlotConsumer(){

            @Override
            public void consume(int x, int y, int id) {
                JsonObject json = NEUOverlay.this.getSearchedItemPage(id);
                if (json == null) {
                    return;
                }
                if (json.has("entityrender")) {
                    Class clazz;
                    if (!entities) {
                        return;
                    }
                    String name = json.get("displayname").getAsString();
                    String[] split = name.split(" \\(");
                    name = name.substring(0, name.length() - split[split.length - 1].length() - 2);
                    Class[] entities2 = new Class[1];
                    if (json.get("entityrender").isJsonArray()) {
                        JsonArray entityrender = json.get("entityrender").getAsJsonArray();
                        entities2 = new Class[entityrender.size()];
                        for (int i = 0; i < entityrender.size(); ++i) {
                            Class clazz2 = (Class)EntityList.field_75625_b.get(entityrender.get(i).getAsString());
                            if (clazz2 == null || !EntityLivingBase.class.isAssignableFrom(clazz2)) continue;
                            entities2[i] = clazz2;
                        }
                    } else if (json.get("entityrender").isJsonPrimitive() && (clazz = (Class)EntityList.field_75625_b.get(json.get("entityrender").getAsString())) != null && EntityLivingBase.class.isAssignableFrom(clazz)) {
                        entities2[0] = clazz;
                    }
                    float scale = 8.0f;
                    if (json.has("entityscale")) {
                        scale *= json.get("entityscale").getAsFloat();
                    }
                    NEUOverlay.this.renderEntity(x + 8, y + 16, scale, name, entities2);
                } else {
                    if (!items2) {
                        return;
                    }
                    ItemStack stack = NEUOverlay.this.manager.jsonToStack(json, true, false, false);
                    if (stack != null) {
                        if (glint) {
                            Utils.drawItemStack(stack, x, y);
                        } else {
                            Utils.drawItemStackWithoutGlint(stack, x, y);
                        }
                    }
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
                if (NEUOverlay.this.searchedItemsSubgroup.containsKey(json.get("internalname").getAsString())) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.item_haschild);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Utils.drawTexturedRect(x - 1, y - 1, 18.0f, 18.0f, 9728);
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-50.0f);
            }
        }, xStart);
    }

    public float getItemPaneOffsetFactor() {
        return this.itemPaneOffsetFactor.getValue() * this.getWidthMult() + (1.0f - this.getWidthMult());
    }

    public float getInfoPaneOffsetFactor() {
        return this.infoPaneOffsetFactor.getValue() * this.getWidthMult();
    }

    private static abstract class ItemSlotConsumer {
        private ItemSlotConsumer() {
        }

        public abstract void consume(int var1, int var2, int var3);
    }
}

