/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BuildFlags {
    private static final Properties properties = new Properties();
    public static final boolean ENABLE_PRONOUNS_IN_PV_BY_DEFAULT;
    public static final boolean ENABLE_ONECONFIG_COMPAT_LAYER;

    private static boolean getBuildFlag(String flag) {
        return Boolean.parseBoolean(properties.getProperty("neu.buildflags." + flag));
    }

    public static Map<String, Boolean> getAllFlags() {
        return Holder.ALL_FLAGS;
    }

    static {
        try {
            properties.load(BuildFlags.class.getResourceAsStream("/buildflags.properties"));
        }
        catch (IOException | NullPointerException e2) {
            System.out.println("Failed to load build properties: " + e2);
        }
        ENABLE_PRONOUNS_IN_PV_BY_DEFAULT = BuildFlags.getBuildFlag("pronouns");
        ENABLE_ONECONFIG_COMPAT_LAYER = BuildFlags.getBuildFlag("oneconfig");
    }

    private static class Holder {
        static Map<String, Boolean> ALL_FLAGS = new HashMap<String, Boolean>();

        private Holder() {
        }

        static {
            for (Field declaredField : BuildFlags.class.getDeclaredFields()) {
                if (!Boolean.TYPE.equals(declaredField.getType()) || (declaredField.getModifiers() & 8) == 0) continue;
                try {
                    declaredField.setAccessible(true);
                    ALL_FLAGS.put(declaredField.getName(), (Boolean)declaredField.get(null));
                }
                catch (ClassCastException | IllegalAccessException | SecurityException e2) {
                    System.err.println("Failed to access BuildFlag: " + e2);
                }
            }
        }
    }
}

