/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.expr.util;

import info.bliki.wiki.template.expr.operator.ASTNodeFactory;
import info.bliki.wiki.template.expr.operator.DivideOperator;
import info.bliki.wiki.template.expr.operator.InfixOperator;
import info.bliki.wiki.template.expr.operator.Operator;
import info.bliki.wiki.template.expr.operator.PostfixOperator;
import info.bliki.wiki.template.expr.operator.PreMinusOperator;
import info.bliki.wiki.template.expr.operator.PrePlusOperator;
import info.bliki.wiki.template.expr.operator.PrefixOperator;
import info.bliki.wiki.template.expr.operator.SubtractOperator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class GenerateOperatorArrays {
    public static void main(String[] args) {
        InputStream operatorDefinitions = null;
        try {
            operatorDefinitions = args.length >= 1 ? new FileInputStream(args[0]) : GenerateOperatorArrays.class.getResourceAsStream("/operators.txt");
            HashMap<String, Operator> operatorMap = new HashMap<String, Operator>();
            HashMap<String, ArrayList<Operator>> operatorTokenStartSet = new HashMap<String, ArrayList<Operator>>();
            GenerateOperatorArrays.generateOperatorTable(operatorDefinitions, operatorMap, operatorTokenStartSet);
            Iterator<String> i1 = operatorMap.keySet().iterator();
            System.out.println("public static final String[] HEADER_STRINGS = {");
            while (i1.hasNext()) {
                String headStr = i1.next();
                System.out.println("    \"" + headStr + "\",");
            }
            System.out.println("};");
            Iterator<String> i2 = operatorMap.keySet().iterator();
            System.out.println("public static final String[] OPERATOR_STRINGS = {");
            while (i2.hasNext()) {
                String headStr = i2.next();
                Operator oper = operatorMap.get(headStr);
                if (oper == null) {
                    System.out.println("    \" null-value-in-operator-map \",");
                    continue;
                }
                System.out.println("    \"" + oper.getOperatorString() + "\",");
            }
            System.out.println("};");
            Iterator<String> i3 = operatorMap.keySet().iterator();
            System.out.println("public static final Operator[] OPERATORS = {");
            while (i3.hasNext()) {
                String grouping;
                InfixOperator iOper;
                String headStr = i3.next();
                Operator oper = operatorMap.get(headStr);
                if (oper instanceof DivideOperator) {
                    iOper = (DivideOperator)oper;
                    grouping = null;
                    if (iOper.getGrouping() == 0) {
                        grouping = "InfixOperator.NONE";
                    } else if (iOper.getGrouping() == 2) {
                        grouping = "InfixOperator.LEFT_ASSOCIATIVE";
                    } else if (iOper.getGrouping() == 1) {
                        grouping = "InfixOperator.RIGHT_ASSOCIATIVE";
                    }
                    System.out.println("    new DivideOperator(\"" + iOper.getOperatorString() + "\", \"" + iOper.getFunctionName() + "\", " + iOper.getPrecedence() + ", " + grouping + "),");
                    continue;
                }
                if (oper instanceof SubtractOperator) {
                    iOper = (SubtractOperator)oper;
                    grouping = null;
                    if (iOper.getGrouping() == 0) {
                        grouping = "InfixOperator.NONE";
                    } else if (iOper.getGrouping() == 2) {
                        grouping = "InfixOperator.LEFT_ASSOCIATIVE";
                    } else if (iOper.getGrouping() == 1) {
                        grouping = "InfixOperator.RIGHT_ASSOCIATIVE";
                    }
                    System.out.println("    new SubtractOperator(\"" + iOper.getOperatorString() + "\", \"" + iOper.getFunctionName() + "\", " + iOper.getPrecedence() + ", " + grouping + "),");
                    continue;
                }
                if (oper instanceof InfixOperator) {
                    iOper = (InfixOperator)oper;
                    grouping = null;
                    if (iOper.getGrouping() == 0) {
                        grouping = "InfixOperator.NONE";
                    } else if (iOper.getGrouping() == 2) {
                        grouping = "InfixOperator.LEFT_ASSOCIATIVE";
                    } else if (iOper.getGrouping() == 1) {
                        grouping = "InfixOperator.RIGHT_ASSOCIATIVE";
                    }
                    System.out.println("    new InfixOperator(\"" + iOper.getOperatorString() + "\", \"" + iOper.getFunctionName() + "\", " + iOper.getPrecedence() + ", " + grouping + "),");
                    continue;
                }
                if (oper instanceof PostfixOperator) {
                    System.out.println("    new PostfixOperator(\"" + oper.getOperatorString() + "\", \"" + oper.getFunctionName() + "\", " + oper.getPrecedence() + "),");
                    continue;
                }
                if (oper instanceof PreMinusOperator) {
                    System.out.println("    new PreMinusOperator(\"" + oper.getOperatorString() + "\", \"" + oper.getFunctionName() + "\", " + oper.getPrecedence() + "),");
                    continue;
                }
                if (oper instanceof PrePlusOperator) {
                    System.out.println("    new PrePlusOperator(\"" + oper.getOperatorString() + "\", \"" + oper.getFunctionName() + "\", " + oper.getPrecedence() + "),");
                    continue;
                }
                if (!(oper instanceof PrefixOperator)) continue;
                System.out.println("    new PrefixOperator(\"" + oper.getOperatorString() + "\", \"" + oper.getFunctionName() + "\", " + oper.getPrecedence() + "),");
            }
            System.out.println("};");
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
    }

    public static void generateOperatorTable(InputStream is, HashMap<String, Operator> operatorMap, HashMap<String, ArrayList<Operator>> operatorTokenStartSet) {
        String record = null;
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        Operator oper = null;
        try {
            while ((record = r.readLine()) != null) {
                if (record.charAt(0) == '#') continue;
                StringTokenizer tokenizer = new StringTokenizer(record, ",");
                String typeStr = ((String)tokenizer.nextElement()).trim();
                String operatorStr = ((String)tokenizer.nextElement()).trim();
                String headStr = ((String)tokenizer.nextElement()).trim();
                String precedenceStr = ((String)tokenizer.nextElement()).trim();
                int precedence = Integer.valueOf(precedenceStr);
                oper = null;
                if (typeStr.equalsIgnoreCase("in")) {
                    try {
                        String groupingStr = ((String)tokenizer.nextElement()).trim();
                        int grouping = 0;
                        if (groupingStr.equalsIgnoreCase("left")) {
                            grouping = 2;
                        } else if (groupingStr.equalsIgnoreCase("right")) {
                            grouping = 1;
                        }
                        oper = ASTNodeFactory.createInfixOperator(operatorStr, headStr, precedence, grouping);
                    }
                    catch (NoSuchElementException nsee) {
                        oper = new InfixOperator(operatorStr, headStr, precedence, 0);
                    }
                } else if (typeStr.equalsIgnoreCase("pre")) {
                    oper = ASTNodeFactory.createPrefixOperator(operatorStr, headStr, precedence);
                } else if (typeStr.equalsIgnoreCase("post")) {
                    oper = ASTNodeFactory.createPostfixOperator(operatorStr, headStr, precedence);
                } else {
                    throw new ParseException("Wrong operator type: " + typeStr, 0);
                }
                ASTNodeFactory.addOperator(operatorMap, operatorTokenStartSet, operatorStr, headStr, oper);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

