/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.AbstractCodeFormatter;
import java.util.HashMap;

public abstract class AbstractCPPBasedCodeFilter
extends AbstractCodeFormatter {
    protected int appendIdentifier(String input, int identifierStart, int currentPosition, HashMap<String, String> keyWords, HashMap<String, String> objectWords, StringBuilder result2) {
        String keywordValue;
        String originalIdent;
        String keywordIdent = originalIdent = input.substring(identifierStart, --currentPosition);
        if (!this.isKeywordCaseSensitive()) {
            keywordIdent = keywordIdent.toLowerCase();
        }
        if ((keywordValue = keyWords.get(keywordIdent)) != null) {
            result2.append(keywordValue);
        } else {
            if (objectWords == null) {
                result2.append(originalIdent);
                return currentPosition;
            }
            String objectValue = objectWords.get(keywordIdent);
            if (objectValue != null) {
                result2.append(objectValue);
            } else {
                result2.append(originalIdent);
            }
        }
        return currentPosition;
    }

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashMap<String, String> objectsSet = this.getObjectSet();
        StringBuilder result2 = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar == '_' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result2);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\"') {
                    result2.append("<span style=\"color:#2A00FF; \">");
                    AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                            continue;
                        }
                        if (currentChar != 34) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '\'') {
                    result2.append("<span style=\"color:#2A00FF; \">");
                    AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                            continue;
                        }
                        if (currentChar != 39) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '/') {
                    result2.append("<span style=\"color:#3F7F5F; \">");
                    AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                    AbstractCPPBasedCodeFilter.appendChar(result2, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                        if (currentChar != 10) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '*') {
                    if (currentPosition < input.length() - 1 && source[currentPosition + 1] == '*') {
                        result2.append("<span style=\"color:#3F5FBF; \">");
                    } else {
                        result2.append("<span style=\"color:#3F7F5F; \">");
                    }
                    AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                    AbstractCPPBasedCodeFilter.appendChar(result2, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
                        if (currentChar != 47 || source[currentPosition - 2] != '*') continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '<' && this.isPHPTag() && currentPosition + 3 < input.length() && source[currentPosition] == '?' && source[currentPosition + 1] == 'p' && source[currentPosition + 2] == 'h' && source[currentPosition + 3] == 'p') {
                    currentPosition += 4;
                    result2.append("<span style=\"color:#7F0055; font-weight: bold; \">&#60;?php</span>");
                    continue;
                }
                if (currentChar == '?' && this.isPHPTag() && currentPosition < input.length() && source[currentPosition] == '>') {
                    ++currentPosition;
                    result2.append("<span style=\"color:#7F0055; font-weight: bold; \">?&#62;</span>");
                    continue;
                }
                AbstractCPPBasedCodeFilter.appendChar(result2, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e2) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result2);
            }
            return result2.toString();
        }
    }

    public boolean isKeywordCaseSensitive() {
        return true;
    }

    public boolean isPHPTag() {
        return false;
    }
}

