/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.engine.lua.interfaces;

import info.bliki.extensions.scribunto.engine.lua.ScribuntoLuaEngine;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwInterface;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.namespaces.INamespace;
import info.bliki.wiki.namespaces.Namespace;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;

public class MwSite
implements MwInterface {
    private final IWikiModel wikiModel;

    public MwSite(IWikiModel wikiModel) {
        assert (wikiModel != null);
        this.wikiModel = wikiModel;
    }

    @Override
    public String name() {
        return "mw.site";
    }

    @Override
    public LuaTable getInterface() {
        LuaTable table = new LuaTable();
        table.set("getNsIndex", this.getNsIndex());
        table.set("pagesInCategory", this.pagesInCategory());
        table.set("pagesInNamespace", this.pagesInNamespace());
        table.set("usersInGroup", this.usersInGroup());
        table.set("interwikiMap", this.interwikiMap());
        return table;
    }

    private LuaValue interwikiMap() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue luaValue) {
                if (luaValue.isnil() || "string".equals(luaValue.typename())) {
                    return new LuaTable();
                }
                throw new LuaError("bad argument #1 to 'interwikiMap' (string expected, got " + luaValue.typename() + ")");
            }
        };
    }

    private LuaValue usersInGroup() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue group) {
                return LuaValue.valueOf(0);
            }
        };
    }

    private LuaValue pagesInNamespace() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue ns) {
                return LuaValue.valueOf(0);
            }
        };
    }

    private LuaValue pagesInCategory() {
        return new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue category, LuaValue which) {
                return LuaValue.valueOf(0);
            }
        };
    }

    private LuaValue getNsIndex() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue name) {
                INamespace.INamespaceValue ns = MwSite.this.wikiModel.getNamespace().getNamespace(name.tojstring());
                if (ns != null) {
                    return LuaValue.valueOf(ns.getCode().code);
                }
                return FALSE;
            }
        };
    }

    @Override
    public LuaValue getSetupOptions() {
        LuaTable table = new LuaTable();
        table.set("siteName", "test");
        table.set("server", "server");
        table.set("scriptPath", "");
        table.set("stylePath", "");
        table.set("currentVersion", "1.0");
        table.set("stats", (LuaValue)this.stats());
        table.set("namespaces", (LuaValue)this.namespaces());
        return table;
    }

    private LuaTable stats() {
        LuaTable stats = new LuaTable();
        stats.set("pages", 0);
        stats.set("articles", 0);
        stats.set("files", 0);
        stats.set("edits", 0);
        stats.set("views", LuaValue.NIL);
        stats.set("users", 0);
        stats.set("activeUsers", 0);
        stats.set("admins", 0);
        return stats;
    }

    private LuaTable namespaces() {
        LuaTable table = new LuaTable();
        for (INamespace.NamespaceCode code : INamespace.NamespaceCode.values()) {
            INamespace.INamespaceValue namespaceValue = this.wikiModel.getNamespace().getNamespaceByNumber(code);
            table.set((int)code.code, (LuaValue)this.luaDataForNamespace(namespaceValue));
        }
        return table;
    }

    private LuaTable luaDataForNamespace(INamespace.INamespaceValue namespaceValue) {
        LuaTable ns = new LuaTable();
        ns.set("id", namespaceValue.getCode().code);
        ns.set("name", namespaceValue.getPrimaryText().replace('_', ' '));
        ns.set("canonicalName", namespaceValue.getCanonicalName().replace('_', ' '));
        ns.set("hasSubpages", (LuaValue)LuaValue.valueOf(namespaceValue.hasSubpages()));
        ns.set("hasGenderDistinction", (LuaValue)LuaValue.valueOf(namespaceValue.hasGenderDistinction()));
        ns.set("isCapitalized", (LuaValue)LuaValue.valueOf(namespaceValue.isCapitalized()));
        ns.set("isContent", (LuaValue)LuaValue.valueOf(namespaceValue.isContent()));
        ns.set("isIncludable", (LuaValue)LuaValue.valueOf(namespaceValue.isIncludable()));
        ns.set("isMovable", (LuaValue)LuaValue.valueOf(namespaceValue.isMovable()));
        ns.set("isSubject", (LuaValue)LuaValue.valueOf(namespaceValue.isSubject()));
        ns.set("isTalk", (LuaValue)LuaValue.valueOf(namespaceValue.isTalk()));
        ns.set("defaultContentModel", LuaValue.NIL);
        LuaValue[] aliases = new LuaValue[namespaceValue.getTexts().size() - 1];
        for (int i = 0; i < namespaceValue.getTexts().size() - 1; ++i) {
            aliases[i] = ScribuntoLuaEngine.toLuaString(namespaceValue.getTexts().get(i + 1));
        }
        ns.set("aliases", (LuaValue)LuaValue.listOf(aliases));
        if (namespaceValue.getCode().code >= INamespace.NamespaceCode.MAIN_NAMESPACE_KEY.code) {
            if (namespaceValue.getContentspace() != null) {
                ns.set("subject", namespaceValue.getContentspace().getCode().code);
            }
            ns.set("talk", namespaceValue.getTalkspace().getCode().code);
            Namespace.NamespaceValue associated = namespaceValue.getAssociatedspace();
            if (associated != null) {
                ns.set("associated", associated.getCode().code);
            } else {
                ns.set("associated", LuaValue.NIL);
            }
        } else {
            ns.set("subject", namespaceValue.getCode().code);
        }
        return ns;
    }
}

