/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import java.awt.Color;

public class SpecialColor {
    private static final int RADIX = 10;
    private static final int MIN_CHROMA_SECS = 1;
    private static final int MAX_CHROMA_SECS = 60;
    public static long startTime = -1L;

    private static int[] decompose(String csv) {
        String[] split = csv.split(":");
        int[] arr = new int[split.length];
        for (int i2 = 0; i2 < split.length; ++i2) {
            arr[i2] = Integer.parseInt(split[split.length - 1 - i2], 10);
        }
        return arr;
    }

    public static int getSpeed(String special) {
        return SpecialColor.decompose(special)[4];
    }

    public static float getSecondsForSpeed(int speed) {
        return (float)(255 - speed) / 254.0f * 59.0f + 1.0f;
    }

    @Deprecated
    public static int specialToChromaRGB(String special) {
        if (startTime < 0L) {
            startTime = System.currentTimeMillis();
        }
        int[] d = SpecialColor.decompose(special);
        int chr = d[4];
        int a = d[3];
        int r = d[2];
        int g = d[1];
        int b = d[0];
        float[] hsv = Color.RGBtoHSB(r, g, b, null);
        if (chr > 0) {
            float seconds = SpecialColor.getSecondsForSpeed(chr);
            hsv[0] = hsv[0] + (float)(System.currentTimeMillis() - startTime) / 1000.0f / seconds;
            hsv[0] = hsv[0] % 1.0f;
            if (hsv[0] < 0.0f) {
                hsv[0] = hsv[0] + 1.0f;
            }
        }
        return (a & 0xFF) << 24 | Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]) & 0xFFFFFF;
    }

    public static int rotateHue(int argb, int degrees) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float[] hsv = Color.RGBtoHSB(r, g, b, null);
        hsv[0] = hsv[0] + (float)degrees / 360.0f;
        hsv[0] = hsv[0] % 1.0f;
        return (a & 0xFF) << 24 | Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]) & 0xFFFFFF;
    }
}

