/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\u0004\n\u0002\b\f\b\u0086\b\u0018\u0000 \u0081\u00012\u00020\u0001:\u0002\u0081\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0015J%\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0015\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0015J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u001e\u0010 J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b!\u0010\u001cJ\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b!\u0010\u001fJ+\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010#J+\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\t2\b\b\u0002\u0010\u0004\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\"\u0010$J\u000f\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b)\u0010\u001fJ\u0017\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b)\u0010 J\u0017\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b)\u0010\u001cJ\u0015\u0010+\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b+\u0010\u0015J\u0015\u0010,\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b,\u0010\u0015J\u0015\u0010-\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b-\u0010\u0015J\u0015\u0010.\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b.\u0010\u0015J\u0017\u0010\"\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\"\u0010\u001cJ\u0017\u0010/\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b/\u0010\u001cJ\r\u00100\u001a\u00020\u0000\u00a2\u0006\u0004\b0\u00101J\r\u00102\u001a\u00020\u0000\u00a2\u0006\u0004\b2\u00101J\r\u00103\u001a\u00020\u0002\u00a2\u0006\u0004\b3\u00104J\r\u00105\u001a\u00020\u0002\u00a2\u0006\u0004\b5\u00104J\u0015\u00106\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b6\u0010\u001cJ\u0015\u00107\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b7\u0010\u001cJ\u001f\u0010:\u001a\u00020%2\u0006\u00108\u001a\u00020\t2\b\b\u0002\u00109\u001a\u00020%\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010=\u001a\u00020%2\b\b\u0002\u0010<\u001a\u00020%\u00a2\u0006\u0004\b=\u0010>J\r\u0010?\u001a\u00020\u0002\u00a2\u0006\u0004\b?\u00104J\r\u0010@\u001a\u00020\u0002\u00a2\u0006\u0004\b@\u00104J\u0017\u0010C\u001a\u00020B2\b\b\u0002\u0010A\u001a\u00020\u0002\u00a2\u0006\u0004\bC\u0010DJ\r\u0010E\u001a\u00020B\u00a2\u0006\u0004\bE\u0010FJ\r\u0010G\u001a\u00020\u0000\u00a2\u0006\u0004\bG\u00101J\u0013\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00020H\u00a2\u0006\u0004\bI\u0010JJ\u0013\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000b0H\u00a2\u0006\u0004\bK\u0010LJ\u0015\u0010M\u001a\u00020B2\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\bM\u0010NJ\u001a\u0010O\u001a\u00020B2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\bO\u0010PJ\u000f\u0010Q\u001a\u00020\tH\u0016\u00a2\u0006\u0004\bQ\u0010RJ\u0017\u0010T\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\tH\u0007\u00a2\u0006\u0004\bT\u0010 J\u0015\u0010U\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\t\u00a2\u0006\u0004\bU\u0010 J\r\u0010V\u001a\u00020\u0000\u00a2\u0006\u0004\bV\u00101J\u001d\u0010X\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u0002\u00a2\u0006\u0004\bX\u0010YJ\r\u0010Z\u001a\u00020\u0000\u00a2\u0006\u0004\bZ\u00101J%\u0010_\u001a\u00020^2\u0006\u0010[\u001a\u00020\u00022\u0006\u0010\\\u001a\u00020\u00022\u0006\u0010]\u001a\u00020\u0002\u00a2\u0006\u0004\b_\u0010`J\u0015\u0010b\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u0002\u00a2\u0006\u0004\bb\u0010\u001fJ\r\u0010d\u001a\u00020c\u00a2\u0006\u0004\bd\u0010\bJ\u0015\u0010e\u001a\u00020^2\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\be\u0010fJ\u0015\u0010h\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\u0002\u00a2\u0006\u0004\bh\u0010\u001fJ\u001d\u0010i\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u0002\u00a2\u0006\u0004\bi\u0010YJ\r\u0010j\u001a\u00020\u0000\u00a2\u0006\u0004\bj\u00101J\u0015\u0010l\u001a\u00020\u00002\u0006\u0010k\u001a\u00020\u0002\u00a2\u0006\u0004\bl\u0010\u001fJ\u0015\u0010m\u001a\u00020\u00002\u0006\u0010k\u001a\u00020\u0002\u00a2\u0006\u0004\bm\u0010\u001fJ\u0015\u0010n\u001a\u00020\u00002\u0006\u0010k\u001a\u00020\u0002\u00a2\u0006\u0004\bn\u0010\u001fJ\u001d\u0010q\u001a\u00020\u00002\u0006\u0010o\u001a\u00020\u00002\u0006\u0010p\u001a\u00020\u0000\u00a2\u0006\u0004\bq\u0010rJ\u001d\u0010s\u001a\u00020\u00022\u0006\u0010o\u001a\u00020\u00002\u0006\u0010p\u001a\u00020\u0000\u00a2\u0006\u0004\bs\u0010tJ\u0015\u0010u\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\bu\u0010\u001cJ\u0018\u0010!\u001a\u00020\u00002\u0006\u0010w\u001a\u00020vH\u0082\u0002\u00a2\u0006\u0004\b!\u0010xJ\u0010\u0010y\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\by\u00104J\u0010\u0010z\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\bz\u00104J\u0010\u0010{\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b{\u00104J.\u0010|\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b|\u0010#R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010}\u001a\u0004\b~\u00104R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010}\u001a\u0004\b\u007f\u00104R\u0018\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\r\n\u0004\b\u0005\u0010}\u001a\u0005\b\u0080\u0001\u00104\u00a8\u0006\u0082\u0001"}, d2={"Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "", "x", "y", "z", "<init>", "(DDD)V", "()V", "", "(III)V", "", "(FFF)V", "Lnet/minecraft/util/BlockPos;", "toBlockPos", "()Lnet/minecraft/util/BlockPos;", "Lnet/minecraft/util/Vec3;", "toVec3", "()Lnet/minecraft/util/Vec3;", "other", "distanceIgnoreY", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "distance", "distanceSq", "(DDD)D", "distanceChebyshevIgnoreY", "distanceSqIgnoreY", "plus", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "minus", "times", "(D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "(I)Lat/hannibal2/skyhanni/utils/LorenzVec;", "div", "add", "(DDD)Lat/hannibal2/skyhanni/utils/LorenzVec;", "(III)Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "toString", "()Ljava/lang/String;", "d", "multiply", "v", "dotProduct", "angleAsCos", "angleInRad", "angleInDeg", "subtract", "normalize", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "inverse", "min", "()D", "max", "minOfEachElement", "maxOfEachElement", "accuracy", "splitChar", "printWithAccuracy", "(ILjava/lang/String;)Ljava/lang/String;", "separator", "toCleanString", "(Ljava/lang/String;)Ljava/lang/String;", "lengthSquared", "length", "tolerance", "", "isNormalized", "(D)Z", "isZero", "()Z", "clone", "", "toDoubleArray", "()[Ljava/lang/Double;", "toFloatArray", "()[Ljava/lang/Float;", "equalsIgnoreY", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "precision", "round", "roundTo", "roundLocationToBlock", "factor", "slope", "(Lat/hannibal2/skyhanni/utils/LorenzVec;D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "roundLocation", "offX", "offY", "offZ", "Lnet/minecraft/util/AxisAlignedBB;", "boundingToOffset", "(DDD)Lnet/minecraft/util/AxisAlignedBB;", "scalar", "scale", "", "applyTranslationToGL", "axisAlignedTo", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lnet/minecraft/util/AxisAlignedBB;", "offset", "up", "interpolate", "negated", "theta", "rotateXY", "rotateXZ", "rotateYZ", "startPos", "endPos", "nearestPointOnLine", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "distanceToLine", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "middle", "", "i", "(Ljava/lang/Number;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "component1", "component2", "component3", "copy", "D", "getX", "getY", "getZ", "Companion", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nLorenzVec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LorenzVec.kt\nat/hannibal2/skyhanni/utils/LorenzVec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1#2:275\n*E\n"})
public final class LorenzVec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    @NotNull
    private static final LorenzVec expandVector = new LorenzVec((double)0.002f, (double)0.002f, (double)0.002f);

    public LorenzVec(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public LorenzVec() {
        this(0.0, 0.0, 0.0);
    }

    public LorenzVec(int x, int y, int z) {
        this((double)x, (double)y, (double)z);
    }

    public LorenzVec(float x, float y, float z) {
        this((double)x, (double)y, (double)z);
    }

    @NotNull
    public final BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    @NotNull
    public final Vec3 toVec3() {
        return new Vec3(this.x, this.y, this.z);
    }

    public final double distanceIgnoreY(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.pow(this.distanceSqIgnoreY(other), 0.5);
    }

    public final double distance(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.pow(this.distanceSq(other), 0.5);
    }

    public final double distanceSq(double x, double y, double z) {
        return this.distanceSq(new LorenzVec(x, y, z));
    }

    public final double distance(double x, double y, double z) {
        return this.distance(new LorenzVec(x, y, z));
    }

    public final double distanceChebyshevIgnoreY(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.max(Math.abs(this.x - other.x), Math.abs(this.z - other.z));
    }

    public final double distanceSq(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double dz = other.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final double distanceSqIgnoreY(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dz = other.z - this.z;
        return dx * dx + dz * dz;
    }

    @NotNull
    public final LorenzVec plus(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LorenzVec(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public final LorenzVec minus(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LorenzVec(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    @NotNull
    public final LorenzVec times(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LorenzVec(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    @NotNull
    public final LorenzVec times(double other) {
        return new LorenzVec(this.x * other, this.y * other, this.z * other);
    }

    @NotNull
    public final LorenzVec times(int other) {
        return new LorenzVec(this.x * (double)other, this.y * (double)other, this.z * (double)other);
    }

    @NotNull
    public final LorenzVec div(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LorenzVec(this.x / other.x, this.y / other.y, this.z / other.z);
    }

    @NotNull
    public final LorenzVec div(double other) {
        return new LorenzVec(this.x / other, this.y / other, this.z / other);
    }

    @NotNull
    public final LorenzVec add(double x, double y, double z) {
        return new LorenzVec(this.x + x, this.y + y, this.z + z);
    }

    public static /* synthetic */ LorenzVec add$default(LorenzVec lorenzVec, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        return lorenzVec.add(d, d2, d3);
    }

    @NotNull
    public final LorenzVec add(int x, int y, int z) {
        return new LorenzVec(this.x + (double)x, this.y + (double)y, this.z + (double)z);
    }

    public static /* synthetic */ LorenzVec add$default(LorenzVec lorenzVec, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return lorenzVec.add(n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "LorenzVec{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }

    @Deprecated(message="Use operator fun times instead", replaceWith=@ReplaceWith(expression="this * d", imports={}))
    @NotNull
    public final LorenzVec multiply(double d) {
        return new LorenzVec(this.x * d, this.y * d, this.z * d);
    }

    @Deprecated(message="Use operator fun times instead", replaceWith=@ReplaceWith(expression="this * d", imports={}))
    @NotNull
    public final LorenzVec multiply(int d) {
        return new LorenzVec(this.x * (double)d, this.y * (double)d, this.z * (double)d);
    }

    @Deprecated(message="Use operator fun times instead", replaceWith=@ReplaceWith(expression="this * v", imports={}))
    @NotNull
    public final LorenzVec multiply(@NotNull LorenzVec v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new LorenzVec(this.x * v.x, this.y * v.y, this.z * v.z);
    }

    public final double dotProduct(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public final double angleAsCos(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.normalize().dotProduct(other.normalize());
    }

    public final double angleInRad(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.acos(this.angleAsCos(other));
    }

    public final double angleInDeg(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.toDegrees(this.angleInRad(other));
    }

    @Deprecated(message="Use operator fun plus instead", replaceWith=@ReplaceWith(expression="this + other", imports={}))
    @NotNull
    public final LorenzVec add(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LorenzVec(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @Deprecated(message="Use operator fun minus instead", replaceWith=@ReplaceWith(expression="this - other", imports={}))
    @NotNull
    public final LorenzVec subtract(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LorenzVec(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    @NotNull
    public final LorenzVec normalize() {
        double it = this.length();
        boolean bl = false;
        return new LorenzVec(this.x / it, this.y / it, this.z / it);
    }

    @NotNull
    public final LorenzVec inverse() {
        return new LorenzVec(1.0 / this.x, 1.0 / this.y, 1.0 / this.z);
    }

    public final double min() {
        return Math.min(this.x, Math.min(this.y, this.z));
    }

    public final double max() {
        return Math.max(this.x, Math.max(this.y, this.z));
    }

    @NotNull
    public final LorenzVec minOfEachElement(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LorenzVec(Math.min(this.x, other.x), Math.min(this.y, other.y), Math.min(this.z, other.z));
    }

    @NotNull
    public final LorenzVec maxOfEachElement(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LorenzVec(Math.max(this.x, other.x), Math.max(this.y, other.y), Math.max(this.z, other.z));
    }

    @NotNull
    public final String printWithAccuracy(int accuracy, @NotNull String splitChar) {
        String string2;
        Intrinsics.checkNotNullParameter(splitChar, "splitChar");
        if (accuracy == 0) {
            int x = (int)Math.rint(this.x);
            int y = (int)Math.rint(this.y);
            int z = (int)Math.rint(this.z);
            string2 = x + splitChar + y + splitChar + z;
        } else {
            double x = Math.rint(this.x * (double)accuracy) / (double)accuracy;
            double y = Math.rint(this.y * (double)accuracy) / (double)accuracy;
            double z = Math.rint(this.z * (double)accuracy) / (double)accuracy;
            string2 = x + splitChar + y + splitChar + z;
        }
        return string2;
    }

    public static /* synthetic */ String printWithAccuracy$default(LorenzVec lorenzVec, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = " ";
        }
        return lorenzVec.printWithAccuracy(n, string2);
    }

    @NotNull
    public final String toCleanString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter(separator, "separator");
        Double[] doubleArray = new Double[]{this.x, this.y, this.z};
        return CollectionsKt.joinToString$default(CollectionsKt.listOf(doubleArray), separator, null, null, 0, null, null, 62, null);
    }

    public static /* synthetic */ String toCleanString$default(LorenzVec lorenzVec, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = ", ";
        }
        return lorenzVec.toCleanString(string2);
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final boolean isNormalized(double tolerance) {
        return Math.abs(this.lengthSquared() - 1.0) < tolerance;
    }

    public static /* synthetic */ boolean isNormalized$default(LorenzVec lorenzVec, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.01;
        }
        return lorenzVec.isNormalized(d);
    }

    public final boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    @NotNull
    public final LorenzVec clone() {
        return new LorenzVec(this.x, this.y, this.z);
    }

    @NotNull
    public final Double[] toDoubleArray() {
        Double[] doubleArray = new Double[]{this.x, this.y, this.z};
        return doubleArray;
    }

    @NotNull
    public final Float[] toFloatArray() {
        Float[] floatArray = new Float[]{Float.valueOf((float)this.x), Float.valueOf((float)this.y), Float.valueOf((float)this.z)};
        return floatArray;
    }

    public final boolean equalsIgnoreY(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.x == other.x && this.z == other.z;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            return true;
        }
        LorenzVec lorenzVec = other instanceof LorenzVec ? (LorenzVec)other : null;
        if (lorenzVec != null) {
            LorenzVec it = lorenzVec;
            boolean bl2 = false;
            bl = this.x == it.x && this.y == it.y && this.z == it.z;
        } else {
            bl = super.equals(other);
        }
        return bl;
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.x);
        result2 = 31 * result2 + Double.hashCode(this.y);
        result2 = 31 * result2 + Double.hashCode(this.z);
        return result2;
    }

    @Deprecated(message="Use roundTo instead", replaceWith=@ReplaceWith(expression="this.roundTo(precision)", imports={}))
    @NotNull
    public final LorenzVec round(int precision) {
        return this.roundTo(precision);
    }

    @NotNull
    public final LorenzVec roundTo(int precision) {
        return new LorenzVec(NumberUtil.INSTANCE.roundTo(this.x, precision), NumberUtil.INSTANCE.roundTo(this.y, precision), NumberUtil.INSTANCE.roundTo(this.z, precision));
    }

    @NotNull
    public final LorenzVec roundLocationToBlock() {
        double x = NumberUtil.INSTANCE.roundTo(this.x - 0.499999, 0);
        double y = NumberUtil.INSTANCE.roundTo(this.y - 0.499999, 0);
        double z = NumberUtil.INSTANCE.roundTo(this.z - 0.499999, 0);
        return new LorenzVec(x, y, z);
    }

    @NotNull
    public final LorenzVec slope(@NotNull LorenzVec other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.plus(other.minus(this).scale(factor));
    }

    @NotNull
    public final LorenzVec roundLocation() {
        int x = this.x < 0.0 ? (int)this.x - 1 : (int)this.x;
        int y = (int)this.y - 1;
        int z = this.z < 0.0 ? (int)this.z - 1 : (int)this.z;
        return new LorenzVec(x, y, z);
    }

    @NotNull
    public final AxisAlignedBB boundingToOffset(double offX, double offY, double offZ) {
        return new AxisAlignedBB(this.x, this.y, this.z, this.x + offX, this.y + offY, this.z + offZ);
    }

    @NotNull
    public final LorenzVec scale(double scalar) {
        return new LorenzVec(scalar * this.x, scalar * this.y, scalar * this.z);
    }

    public final void applyTranslationToGL() {
        GlStateManager.func_179137_b((double)this.x, (double)this.y, (double)this.z);
    }

    @NotNull
    public final AxisAlignedBB axisAlignedTo(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new AxisAlignedBB(this.x, this.y, this.z, other.x, other.y, other.z);
    }

    @NotNull
    public final LorenzVec up(double offset) {
        return LorenzVec.copy$default(this, 0.0, this.y + offset, 0.0, 5, null);
    }

    @NotNull
    public final LorenzVec interpolate(@NotNull LorenzVec other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (!(0.0 <= factor ? factor <= 1.0 : false)) {
            boolean bl = false;
            String string2 = "Percentage must be between 0 and 1: " + factor;
            throw new IllegalArgumentException(string2.toString());
        }
        double x = (1.0 - factor) * this.x + factor * other.x;
        double y = (1.0 - factor) * this.y + factor * other.y;
        double z = (1.0 - factor) * this.z + factor * other.z;
        return new LorenzVec(x, y, z);
    }

    @NotNull
    public final LorenzVec negated() {
        return new LorenzVec(-this.x, -this.y, -this.z);
    }

    @NotNull
    public final LorenzVec rotateXY(double theta) {
        return new LorenzVec(this.x * Math.cos(theta) - this.y * Math.sin(theta), this.x * Math.sin(theta) + this.y * Math.cos(theta), this.z);
    }

    @NotNull
    public final LorenzVec rotateXZ(double theta) {
        return new LorenzVec(this.x * Math.cos(theta) + this.z * Math.sin(theta), this.y, -this.x * Math.sin(theta) + this.z * Math.cos(theta));
    }

    @NotNull
    public final LorenzVec rotateYZ(double theta) {
        return new LorenzVec(this.x, this.y * Math.cos(theta) - this.z * Math.sin(theta), this.y * Math.sin(theta) + this.z * Math.cos(theta));
    }

    @NotNull
    public final LorenzVec nearestPointOnLine(@NotNull LorenzVec startPos, @NotNull LorenzVec endPos) {
        Intrinsics.checkNotNullParameter(startPos, "startPos");
        Intrinsics.checkNotNullParameter(endPos, "endPos");
        LorenzVec d = endPos.minus(startPos);
        LorenzVec w = this.minus(startPos);
        double dp = d.lengthSquared();
        double dt = 0.0;
        if (!(dp == dt)) {
            dt = RangesKt.coerceIn(w.dotProduct(d) / dp, 0.0, 1.0);
        }
        d = d.times(dt);
        d = d.plus(startPos);
        return d;
    }

    public final double distanceToLine(@NotNull LorenzVec startPos, @NotNull LorenzVec endPos) {
        Intrinsics.checkNotNullParameter(startPos, "startPos");
        Intrinsics.checkNotNullParameter(endPos, "endPos");
        return this.nearestPointOnLine(startPos, endPos).minus(this).lengthSquared();
    }

    @NotNull
    public final LorenzVec middle(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.plus(other.minus(this).div((Number)2));
    }

    private final LorenzVec div(Number i2) {
        return new LorenzVec(this.x / i2.doubleValue(), this.y / i2.doubleValue(), this.z / i2.doubleValue());
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final LorenzVec copy(double x, double y, double z) {
        return new LorenzVec(x, y, z);
    }

    public static /* synthetic */ LorenzVec copy$default(LorenzVec lorenzVec, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = lorenzVec.x;
        }
        if ((n & 2) != 0) {
            d2 = lorenzVec.y;
        }
        if ((n & 4) != 0) {
            d3 = lorenzVec.z;
        }
        return lorenzVec.copy(d, d2, d3);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lat/hannibal2/skyhanni/utils/LorenzVec$Companion;", "", "<init>", "()V", "", "yaw", "pitch", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getFromYawPitch", "(DD)Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "string", "decodeFromString", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "getBlockBelowPlayer", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "expandVector", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getExpandVector", "1.8.9"})
    @SourceDebugExtension(value={"SMAP\nLorenzVec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LorenzVec.kt\nat/hannibal2/skyhanni/utils/LorenzVec$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n1557#2:275\n1628#2,3:276\n*S KotlinDebug\n*F\n+ 1 LorenzVec.kt\nat/hannibal2/skyhanni/utils/LorenzVec$Companion\n*L\n243#1:275\n243#1:276,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LorenzVec getFromYawPitch(double yaw, double pitch) {
            double yaw2 = (yaw + (double)90) * Math.PI / (double)180;
            double pitch2 = (pitch + (double)90) * Math.PI / (double)180;
            double x = Math.sin(pitch2) * Math.cos(yaw2);
            double y = Math.sin(pitch2) * Math.sin(yaw2);
            double z = Math.cos(pitch2);
            return new LorenzVec(x, z, y);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LorenzVec decodeFromString(@NotNull String string2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(string2, "string");
            String[] stringArray = new String[]{":"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Double.parseDouble((String)it));
            }
            List list = (List)destination$iv$iv;
            double x = ((Number)list.get(0)).doubleValue();
            double y = ((Number)list.get(1)).doubleValue();
            double z = ((Number)list.get(2)).doubleValue();
            return new LorenzVec(x, y, z);
        }

        @NotNull
        public final LorenzVec getBlockBelowPlayer() {
            return LorenzVec.add$default(LocationUtils.INSTANCE.playerLocation().roundLocationToBlock(), 0.0, -1.0, 0.0, 5, null);
        }

        @NotNull
        public final LorenzVec getExpandVector() {
            return expandVector;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

