/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test.command;

import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J-\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/test/command/CopyItemCommand;", "", "<init>", "()V", "", "command", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "", "text", "", "list", "recurseTag", "(Lnet/minecraft/nbt/NBTTagCompound;Ljava/lang/String;Ljava/util/List;)V", "Lnet/minecraft/item/ItemStack;", "itemStack", "copyItemToClipboard", "(Lnet/minecraft/item/ItemStack;)V", "1.8.9"})
public final class CopyItemCommand {
    @NotNull
    public static final CopyItemCommand INSTANCE = new CopyItemCommand();

    private CopyItemCommand() {
    }

    public final void command() {
        ItemStack itemStack2 = InventoryUtils.INSTANCE.getItemInHand();
        if (itemStack2 == null) {
            ChatUtils.INSTANCE.userError("No item in hand!");
            return;
        }
        this.copyItemToClipboard(itemStack2);
    }

    private final void recurseTag(NBTTagCompound compound, String text, List<String> list) {
        for (String s : compound.func_150296_c()) {
            if (Intrinsics.areEqual(s, "Lore")) continue;
            NBTBase tag = compound.func_74781_a(s);
            if (!(tag instanceof NBTTagCompound)) {
                list.add(text + s + ": " + tag);
                continue;
            }
            NBTTagCompound element = compound.func_74775_l(s);
            list.add(text + s + ':');
            Intrinsics.checkNotNull(element);
            this.recurseTag(element, text + "  ", list);
        }
    }

    public final void copyItemToClipboard(@NotNull ItemStack itemStack2) {
        Intrinsics.checkNotNullParameter(itemStack2, "itemStack");
        List resultList = new ArrayList();
        resultList.add(ItemUtils.INSTANCE.getInternalName(itemStack2).toString());
        resultList.add("display name: '" + itemStack2.func_82833_r() + '\'');
        resultList.add("minecraft id: '" + SkyBlockItemModifierUtils.INSTANCE.getMinecraftId(itemStack2) + '\'');
        resultList.add("lore:");
        for (String line : ItemUtils.INSTANCE.getLore(itemStack2)) {
            resultList.add(" '" + line + '\'');
        }
        resultList.add("");
        resultList.add("getTagCompound");
        if (itemStack2.func_77942_o()) {
            NBTTagCompound tagCompound = itemStack2.func_77978_p();
            Intrinsics.checkNotNull(tagCompound);
            this.recurseTag(tagCompound, "  ", resultList);
        }
        String string2 = CollectionsKt.joinToString$default(resultList, "\n", null, null, 0, null, null, 62, null);
        OSUtils.INSTANCE.copyToClipboard(string2);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Item info copied into the clipboard!", false, null, 6, null);
    }
}

