/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.features.misc.visualwords.ModifyVisualWords;
import at.hannibal2.skyhanni.mixins.hooks.FontRendererHook;
import net.minecraft.client.gui.FontRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={FontRenderer.class})
public abstract class MixinFontRenderer {
    @Inject(method={"renderStringAtPos"}, at={@At(value="HEAD")})
    public void beginRenderString(String text, boolean shadow, CallbackInfo ci) {
        FontRendererHook.beginChromaRendering(text, shadow);
    }

    @ModifyConstant(method={"renderStringAtPos"}, constant={@Constant(stringValue="0123456789abcdefklmnor")})
    public String insertZColorCode(String constant) {
        return FontRendererHook.insertZColorCode(constant);
    }

    @Inject(method={"renderStringAtPos"}, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/gui/FontRenderer;italicStyle:Z", ordinal=0, shift=At.Shift.AFTER), @At(value="FIELD", opcode=181, target="Lnet/minecraft/client/gui/FontRenderer;italicStyle:Z", ordinal=2, shift=At.Shift.AFTER)})
    public void insertRestoreChromaState(CallbackInfo ci) {
        FontRendererHook.restoreChromaState();
    }

    @Shadow
    protected abstract void func_78265_b();

    @Inject(method={"renderStringAtPos"}, at={@At(value="INVOKE", target="Ljava/lang/String;indexOf(I)I", ordinal=0, shift=At.Shift.BY, by=2)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void toggleChromaCondition(String text, boolean shadow, CallbackInfo ci, int i2, char c0, int i1) {
        if (FontRendererHook.toggleChromaAndResetStyle(i1)) {
            this.func_78265_b();
        }
    }

    @ModifyVariable(method={"renderStringAtPos"}, at=@At(value="INVOKE", target="Ljava/lang/String;indexOf(I)I", ordinal=0, shift=At.Shift.BY, by=2), ordinal=1)
    public int forceWhiteColorCode(int i1) {
        return FontRendererHook.forceWhiteColorCode(i1);
    }

    @Inject(method={"renderStringAtPos"}, at={@At(value="RETURN")})
    public void insertEndOfString(String text, boolean shadow, CallbackInfo ci) {
        FontRendererHook.endChromaRendering();
    }

    @ModifyVariable(method={"renderStringAtPos"}, at=@At(value="HEAD"), argsOnly=true)
    private String renderStringAtPos(String text) {
        return ModifyVisualWords.INSTANCE.modifyText(text);
    }

    @ModifyVariable(method={"getStringWidth(Ljava/lang/String;)I"}, at=@At(value="HEAD"), argsOnly=true)
    private String getStringWidth(String text) {
        return ModifyVisualWords.INSTANCE.modifyText(text);
    }
}

