/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.slayer.SlayerConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.SlayerAPI;
import at.hannibal2.skyhanni.events.EntityHealthUpdateEvent;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.ScoreboardUpdateEvent;
import at.hannibal2.skyhanni.features.event.diana.DianaAPI;
import at.hannibal2.skyhanni.features.rift.RiftAPI;
import at.hannibal2.skyhanni.features.slayer.SlayerType;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u000e\u001a\u00020\r*\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\r*\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\r*\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0013\u0010\u0012\u001a\u00020\r*\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\u001f\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u001f\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0016J\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010#\u001a\u00020\r2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'R\u001c\u0010,\u001a\n )*\u0004\u0018\u00010(0(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0016\u0010.\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00103\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00102R\u0014\u00104\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00106\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00105R\u0016\u00107\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u00109\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010/R\u0016\u0010:\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;\u00a8\u0006="}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ScoreboardUpdateEvent;", "event", "", "onScoreboardChange", "(Lat/hannibal2/skyhanni/events/ScoreboardUpdateEvent;)V", "Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning$SlayerData;", "getSlayerData", "()Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning$SlayerData;", "", "", "inCombat", "(Ljava/lang/String;)Z", "inBoss", "bossSlain", "noSlayer", "old", "new", "change", "(Ljava/lang/String;Ljava/lang/String;)V", "reason", "needNewQuest", "(Ljava/lang/String;)V", "tryWarn", "titleMessage", "chatMessage", "warn", "Lat/hannibal2/skyhanni/events/EntityHealthUpdateEvent;", "onEntityHealthUpdate", "(Lat/hannibal2/skyhanni/events/EntityHealthUpdateEvent;)V", "Lnet/minecraft/entity/EntityLivingBase;", "entity", "isSlayerMob", "(Lnet/minecraft/entity/EntityLivingBase;)Z", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "onItemClick", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastWeaponUse", "J", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "voidItem", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "endItem", "outsideRiftData", "Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning$SlayerData;", "insideRiftData", "needSlayerQuest", "Z", "lastWarning", "currentReason", "Ljava/lang/String;", "SlayerData", "1.8.9"})
public final class SlayerQuestWarning {
    @NotNull
    public static final SlayerQuestWarning INSTANCE = new SlayerQuestWarning();
    private static long lastWeaponUse = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final NEUInternalName voidItem = NEUInternalName.Companion.asInternalName("ASPECT_OF_THE_VOID");
    @NotNull
    private static final NEUInternalName endItem = NEUInternalName.Companion.asInternalName("ASPECT_OF_THE_END");
    @NotNull
    private static final SlayerData outsideRiftData = new SlayerData();
    @NotNull
    private static final SlayerData insideRiftData = new SlayerData();
    private static boolean needSlayerQuest;
    private static long lastWarning;
    @NotNull
    private static String currentReason;

    private SlayerQuestWarning() {
    }

    private final SlayerConfig getConfig() {
        return SkyHanniMod.feature.slayer;
    }

    @SubscribeEvent
    public final void onScoreboardChange(@NotNull ScoreboardUpdateEvent event) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            String slayerType = CollectionUtils.nextAfter$default(CollectionUtils.INSTANCE, event.getScoreboard(), "Slayer Quest", 0, 2, null);
            String string2 = CollectionUtils.INSTANCE.nextAfter(event.getScoreboard(), "Slayer Quest", 2);
            if (string2 == null) {
                string2 = "no slayer";
            }
            String slayerProgress = string2;
            String string3 = StringUtils.removeColor$default(StringUtils.INSTANCE, slayerProgress, false, 1, null);
            SlayerData slayerData = this.getSlayerData();
            if (Intrinsics.areEqual(slayerData.getCurrentSlayerState(), string3)) {
                return;
            }
            String string4 = slayerData.getCurrentSlayerState();
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                INSTANCE.change(it, string3);
            }
            slayerData.setCurrentSlayerState(string3);
            String string5 = slayerType;
            if (string5 == null) break block3;
            String it = string5;
            boolean bl = false;
            slayerData.setLastSlayerType(SlayerType.Companion.getByName(it));
        }
    }

    private final SlayerData getSlayerData() {
        return RiftAPI.INSTANCE.inRift() ? outsideRiftData : insideRiftData;
    }

    private final boolean inCombat(String $this$inCombat) {
        return StringsKt.contains$default((CharSequence)$this$inCombat, "Combat", false, 2, null) || StringsKt.contains$default((CharSequence)$this$inCombat, "Kills", false, 2, null);
    }

    private final boolean inBoss(String $this$inBoss) {
        return Intrinsics.areEqual($this$inBoss, "Slay the boss!");
    }

    private final boolean bossSlain(String $this$bossSlain) {
        return Intrinsics.areEqual($this$bossSlain, "Boss slain!");
    }

    private final boolean noSlayer(String $this$noSlayer) {
        return Intrinsics.areEqual($this$noSlayer, "no slayer");
    }

    private final void change(String old, String string2) {
        if (!this.inCombat(old) && this.inCombat(string2)) {
            needSlayerQuest = false;
        }
        if (this.inBoss(old) && this.noSlayer(string2)) {
            this.needNewQuest("The old slayer quest has failed!");
        }
        if (this.bossSlain(string2)) {
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(2, DurationUnit.SECONDS), SlayerQuestWarning::change$lambda$2);
        }
    }

    private final void needNewQuest(String reason) {
        currentReason = reason;
        needSlayerQuest = true;
    }

    private final void tryWarn() {
        if (!needSlayerQuest) {
            return;
        }
        this.warn("New Slayer Quest!", "Start a new slayer quest! " + currentReason);
    }

    private final void warn(String titleMessage, String chatMessage) {
        if (!this.getConfig().questWarning) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastWarning), DurationKt.toDuration(10, DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (DianaAPI.INSTANCE.isDoingDiana()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastWeaponUse), DurationKt.toDuration(500, DurationUnit.MILLISECONDS)) > 0) {
            return;
        }
        lastWarning = SimpleTimeMark.Companion.now-uFjCsEo();
        ChatUtils.chat$default(ChatUtils.INSTANCE, chatMessage, false, null, 6, null);
        if (this.getConfig().questWarningTitle) {
            LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7e" + titleMessage, DurationKt.toDuration(2, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        }
    }

    @SubscribeEvent
    public final void onEntityHealthUpdate(@NotNull EntityHealthUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        EntityLivingBase entity = event.getEntity();
        if (LocationUtils.INSTANCE.distanceToPlayer(LorenzVecKt.getLorenzVec((Entity)entity)) < 6.0 && this.isSlayerMob(entity)) {
            this.tryWarn();
        }
    }

    private final boolean isSlayerMob(EntityLivingBase entity) {
        SlayerType slayerType;
        block5: {
            SlayerType slayerType2 = SlayerAPI.INSTANCE.getSlayerTypeForCurrentArea();
            if (slayerType2 == null) {
                return false;
            }
            slayerType = slayerType2;
            if (Intrinsics.areEqual(entity.func_70005_c_(), "Oubliette Guard")) {
                return false;
            }
            if (Intrinsics.areEqual(LorenzUtils.INSTANCE.getSkyBlockArea(), "Stronghold") && Intrinsics.areEqual(entity.func_70005_c_(), "Skeleton")) {
                return false;
            }
            boolean isSlayer = slayerType.getClazz().isInstance(entity);
            if (!isSlayer) {
                return false;
            }
            SlayerType slayerType3 = SlayerAPI.INSTANCE.getActiveSlayer();
            if (slayerType3 == null) break block5;
            SlayerType it = slayerType3;
            boolean bl = false;
            if (slayerType != it) {
                String activeSlayerName = it.getDisplayName();
                String slayerName = slayerType.getDisplayName();
                SlayerAPI.INSTANCE.setLatestWrongAreaWarning-gJLAdNM(SimpleTimeMark.Companion.now-uFjCsEo());
                INSTANCE.warn("Wrong Slayer!", "Wrong slayer selected! You have " + activeSlayerName + " selected and you are in an " + slayerName + " area!");
            }
        }
        return this.getSlayerData().getLastSlayerType() == slayerType;
    }

    @SubscribeEvent
    public final void onItemClick(@NotNull ItemClickEvent event) {
        NEUInternalName internalName;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ItemStack itemStack2 = event.getItemInHand();
        NEUInternalName nEUInternalName = internalName = itemStack2 != null ? ItemUtils.INSTANCE.getInternalNameOrNull(itemStack2) : null;
        if (event.getClickType() == ClickType.RIGHT_CLICK) {
            if (Intrinsics.areEqual(internalName, voidItem) || Intrinsics.areEqual(internalName, endItem)) {
                return;
            }
            if (internalName == null) {
                return;
            }
        }
        lastWeaponUse = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    private static final Unit change$lambda$2() {
        if (INSTANCE.bossSlain(INSTANCE.getSlayerData().getCurrentSlayerState())) {
            INSTANCE.needNewQuest("You have no Auto-Slayer active!");
        }
        return Unit.INSTANCE;
    }

    static {
        lastWarning = SimpleTimeMark.Companion.farPast();
        currentReason = "";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning$SlayerData;", "", "<init>", "()V", "", "currentSlayerState", "Ljava/lang/String;", "getCurrentSlayerState", "()Ljava/lang/String;", "setCurrentSlayerState", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "lastSlayerType", "Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "getLastSlayerType", "()Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "setLastSlayerType", "(Lat/hannibal2/skyhanni/features/slayer/SlayerType;)V", "1.8.9"})
    public static final class SlayerData {
        @Nullable
        private String currentSlayerState;
        @Nullable
        private SlayerType lastSlayerType;

        @Nullable
        public final String getCurrentSlayerState() {
            return this.currentSlayerState;
        }

        public final void setCurrentSlayerState(@Nullable String string2) {
            this.currentSlayerState = string2;
        }

        @Nullable
        public final SlayerType getLastSlayerType() {
            return this.lastSlayerType;
        }

        public final void setLastSlayerType(@Nullable SlayerType slayerType) {
            this.lastSlayerType = slayerType;
        }
    }
}

