/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether.reputationhelper.miniboss;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.crimsonisle.ReputationHelperConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ReputationQuest;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.features.combat.damageindicator.DamageIndicatorManager;
import at.hannibal2.skyhanni.features.nether.reputationhelper.CrimsonIsleReputationHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.DailyQuestHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.MiniBossQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.Quest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.QuestState;
import at.hannibal2.skyhanni.features.nether.reputationhelper.miniboss.CrimsonMiniBoss;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0018\u001a\u00020\b2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00160\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\b\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010$\u001a\u00020\b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0004\b$\u0010%J\u0015\u0010&\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b&\u0010\u001fJ\u0019\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010'\u001a\u00020!H\u0002\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b*\u0010+R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010,R\u001d\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00158\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u001c\u00105\u001a\n 2*\u0004\u0018\u000101018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00066"}, d2={"Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/DailyMiniBossHelper;", "", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/CrimsonIsleReputationHelper;", "reputationHelper", "<init>", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/CrimsonIsleReputationHelper;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/CrimsonMiniBoss;", "miniBoss", "", "needMiniBossQuest", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/CrimsonMiniBoss;)Z", "finished", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/CrimsonMiniBoss;)V", "", "", "display", "render", "(Ljava/util/List;)V", "reset", "()V", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;", "storage", "saveConfig", "(Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;)V", "", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/ReputationQuest;", "data", "onRepoReload", "(Ljava/util/Map;)V", "loadData", "name", "getByDisplayName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/CrimsonMiniBoss;", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/CrimsonIsleReputationHelper;", "miniBosses", "Ljava/util/List;", "getMiniBosses", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "config", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDailyMiniBossHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DailyMiniBossHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/DailyMiniBossHelper\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 DailyQuestHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/DailyQuestHelper\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n8#2:121\n1#3:122\n158#4:123\n808#5,11:124\n1782#5,4:135\n774#5:139\n865#5,2:140\n1863#5,2:142\n295#5,2:144\n*S KotlinDebug\n*F\n+ 1 DailyMiniBossHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/DailyMiniBossHelper\n*L\n34#1:121\n34#1:122\n57#1:123\n57#1:124,11\n68#1:135,4\n96#1:139\n96#1:140,2\n97#1:142,2\n117#1:144,2\n*E\n"})
public final class DailyMiniBossHelper {
    @NotNull
    private final CrimsonIsleReputationHelper reputationHelper;
    @NotNull
    private final List<CrimsonMiniBoss> miniBosses;

    public DailyMiniBossHelper(@NotNull CrimsonIsleReputationHelper reputationHelper) {
        Intrinsics.checkNotNullParameter(reputationHelper, "reputationHelper");
        this.reputationHelper = reputationHelper;
        this.miniBosses = new ArrayList();
    }

    @NotNull
    public final List<CrimsonMiniBoss> getMiniBosses() {
        return this.miniBosses;
    }

    private final ReputationHelperConfig getConfig() {
        return SkyHanniMod.feature.crimsonIsle.reputationHelper;
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        String message = event.getMessage();
        for (CrimsonMiniBoss miniBoss : this.miniBosses) {
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = miniBoss.getPattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(message);
            boolean bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            this.finished(miniBoss);
        }
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.reputationHelper.showLocations()) {
            return;
        }
        LorenzVec playerLocation = LocationUtils.INSTANCE.playerLocation();
        for (CrimsonMiniBoss miniBoss : this.miniBosses) {
            LorenzVec location;
            if (miniBoss.getDoneToday() && !this.needMiniBossQuest(miniBoss) || miniBoss.getLocation() == null || DamageIndicatorManager.INSTANCE.getNearestDistanceTo(location) < 40.0 && playerLocation.distance(location) < 40.0) continue;
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, location, LorenzColor.WHITE.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, location, miniBoss.getDisplayName(), 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean needMiniBossQuest(CrimsonMiniBoss miniBoss) {
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv$iv;
        DailyQuestHelper this_$iv = this.reputationHelper.getQuestHelper();
        boolean $i$f$getQuest = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getQuests();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof MiniBossQuest)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        MiniBossQuest miniBossQuest = (MiniBossQuest)((Quest)CollectionsKt.firstOrNull((List)destination$iv$iv$iv));
        if (miniBossQuest != null) {
            MiniBossQuest it = miniBossQuest;
            boolean bl2 = false;
            bl = Intrinsics.areEqual(it.getMiniBoss(), miniBoss) && it.getState() == QuestState.ACCEPTED;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void finished(CrimsonMiniBoss miniBoss) {
        this.reputationHelper.getQuestHelper().finishMiniBoss(miniBoss);
        miniBoss.setDoneToday(true);
        this.reputationHelper.update();
    }

    public final void render(@NotNull List<List<Object>> display2) {
        int n;
        Intrinsics.checkNotNullParameter(display2, "display");
        Iterable $this$count$iv = this.miniBosses;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CrimsonMiniBoss it = (CrimsonMiniBoss)element$iv;
                boolean bl = false;
                if (!it.getDoneToday() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int done = n;
        CollectionUtils.INSTANCE.addAsSingletonList(display2, "");
        CollectionUtils.INSTANCE.addAsSingletonList(display2, "\u00a77Daily Bosses (\u00a7e" + done + "\u00a78/\u00a7e5 killed\u00a77)");
        if (done != 5) {
            for (CrimsonMiniBoss miniBoss : this.miniBosses) {
                if (((Boolean)this.getConfig().hideComplete.get()).booleanValue() && miniBoss.getDoneToday()) continue;
                String result2 = miniBoss.getDoneToday() ? "\u00a7aDone" : "\u00a7bTodo";
                String displayName = miniBoss.getDisplayName();
                NEUInternalName displayItem = miniBoss.getDisplayItem();
                List lineList = new ArrayList();
                lineList.add(" ");
                lineList.add(NEUItems.INSTANCE.getItemStack(displayItem));
                lineList.add("\u00a75" + displayName + "\u00a77: " + result2);
                display2.add(lineList);
            }
        }
    }

    public final void reset() {
        for (CrimsonMiniBoss miniBoss : this.miniBosses) {
            miniBoss.setDoneToday(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveConfig(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(storage2, "storage");
        storage2.miniBossesDoneToday.clear();
        Iterable $this$filter$iv = this.miniBosses;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CrimsonMiniBoss it = (CrimsonMiniBoss)element$iv$iv;
            boolean bl = false;
            if (!it.getDoneToday()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CrimsonMiniBoss it = (CrimsonMiniBoss)element$iv;
            boolean bl = false;
            storage2.miniBossesDoneToday.add(it.getDisplayName());
        }
    }

    public final void onRepoReload(@NotNull Map<String, ReputationQuest> data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this.miniBosses.clear();
        for (Map.Entry<String, ReputationQuest> entry : data2.entrySet()) {
            Pattern pattern;
            String displayName = entry.getKey();
            ReputationQuest quest = entry.getValue();
            NEUInternalName displayItem = quest.getItem();
            StringBuilder stringBuilder = new StringBuilder().append("\u00a7f *\u00a7r\u00a76\u00a7l");
            String string2 = displayName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            String string3 = stringBuilder.append(string2).append(" DOWN!").toString();
            int n = 0;
            Intrinsics.checkNotNullExpressionValue(Pattern.compile(string3, n), "compile(...)");
            LorenzVec location = this.reputationHelper.readLocationData(quest.getLocation());
            this.miniBosses.add(new CrimsonMiniBoss(displayName, displayItem, location, pattern, false, 16, null));
        }
    }

    public final void loadData(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage2) {
        Intrinsics.checkNotNullParameter(storage2, "storage");
        if (this.miniBosses.isEmpty()) {
            return;
        }
        for (String name2 : storage2.miniBossesDoneToday) {
            Intrinsics.checkNotNull(name2);
            CrimsonMiniBoss crimsonMiniBoss = this.getByDisplayName(name2);
            Intrinsics.checkNotNull(crimsonMiniBoss);
            crimsonMiniBoss.setDoneToday(true);
        }
    }

    private final CrimsonMiniBoss getByDisplayName(String name2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.miniBosses;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CrimsonMiniBoss it = (CrimsonMiniBoss)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getDisplayName(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.CRIMSON_ISLE) && (Boolean)this.getConfig().enabled.get() != false;
    }
}

