/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether.reputationhelper.kuudra;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.crimsonisle.ReputationHelperConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ReputationQuest;
import at.hannibal2.skyhanni.events.KuudraCompleteEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraTier;
import at.hannibal2.skyhanni.features.nether.reputationhelper.CrimsonIsleReputationHelper;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0011\u001a\u00020\b2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f0\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u001d\u001a\u00020\b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001f\u0010\u0018J\u000f\u0010 \u001a\u00020\bH\u0002\u00a2\u0006\u0004\b \u0010\u0014J\u0019\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010!\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010'\u001a\u0004\u0018\u00010\"2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b'\u0010(R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010)R\u001d\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0\u000e8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0018\u0010/\u001a\u0004\u0018\u00010.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00102\u001a\u0002018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u001c\u00108\u001a\n 5*\u0004\u0018\u000104048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u00069"}, d2={"Lat/hannibal2/skyhanni/features/nether/reputationhelper/kuudra/DailyKuudraBossHelper;", "", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/CrimsonIsleReputationHelper;", "reputationHelper", "<init>", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/CrimsonIsleReputationHelper;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "event", "", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/KuudraCompleteEvent;", "onKuudraDone", "(Lat/hannibal2/skyhanni/events/KuudraCompleteEvent;)V", "", "", "display", "render", "(Ljava/util/List;)V", "reset", "()V", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;", "storage", "saveConfig", "(Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;)V", "", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/ReputationQuest;", "data", "onRepoReload", "(Ljava/util/Map;)V", "loadData", "updateAllKuudraDone", "name", "Lat/hannibal2/skyhanni/features/nether/kuudra/KuudraTier;", "getByDisplayName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/nether/kuudra/KuudraTier;", "", "number", "getByTier", "(I)Lat/hannibal2/skyhanni/features/nether/kuudra/KuudraTier;", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/CrimsonIsleReputationHelper;", "kuudraTiers", "Ljava/util/List;", "getKuudraTiers", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "kuudraLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "allKuudraDone", "Z", "Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "config", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDailyKuudraBossHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DailyKuudraBossHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/kuudra/DailyKuudraBossHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1782#2,4:119\n774#2:123\n865#2,2:124\n1863#2,2:126\n1755#2,3:128\n295#2,2:131\n295#2,2:133\n*S KotlinDebug\n*F\n+ 1 DailyKuudraBossHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/kuudra/DailyKuudraBossHelper\n*L\n55#1:119,4\n83#1:123\n83#1:124,2\n84#1:126,2\n111#1:128,3\n114#1:131,2\n116#1:133,2\n*E\n"})
public final class DailyKuudraBossHelper {
    @NotNull
    private final CrimsonIsleReputationHelper reputationHelper;
    @NotNull
    private final List<KuudraTier> kuudraTiers;
    @Nullable
    private LorenzVec kuudraLocation;
    private boolean allKuudraDone;

    public DailyKuudraBossHelper(@NotNull CrimsonIsleReputationHelper reputationHelper) {
        Intrinsics.checkNotNullParameter(reputationHelper, "reputationHelper");
        this.reputationHelper = reputationHelper;
        this.kuudraTiers = new ArrayList();
        this.allKuudraDone = true;
    }

    @NotNull
    public final List<KuudraTier> getKuudraTiers() {
        return this.kuudraTiers;
    }

    private final ReputationHelperConfig getConfig() {
        return SkyHanniMod.feature.crimsonIsle.reputationHelper;
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!LorenzUtils.INSTANCE.isInIsland(IslandType.CRIMSON_ISLE)) {
                return;
            }
            if (!((Boolean)this.getConfig().enabled.get()).booleanValue()) {
                return;
            }
            if (!this.reputationHelper.showLocations()) {
                return;
            }
            if (this.allKuudraDone) {
                return;
            }
            LorenzVec lorenzVec = this.kuudraLocation;
            if (lorenzVec == null) break block4;
            LorenzVec it = lorenzVec;
            boolean bl = false;
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, it, LorenzColor.WHITE.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, it, "Kuudra", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    @SubscribeEvent
    public final void onKuudraDone(@NotNull KuudraCompleteEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        int tier = event.getKuudraTier();
        KuudraTier kuudraTier = this.getByTier(tier);
        if (kuudraTier == null) {
            return;
        }
        KuudraTier kuudraTier2 = kuudraTier;
        ChatUtils.INSTANCE.debug("Detected kuudra tier done: " + kuudraTier2.getDisplayName());
        this.reputationHelper.getQuestHelper().finishKuudra(kuudraTier2);
        kuudraTier2.setDoneToday(true);
        this.updateAllKuudraDone();
        this.reputationHelper.update();
    }

    public final void render(@NotNull List<List<Object>> display2) {
        int n;
        Intrinsics.checkNotNullParameter(display2, "display");
        Iterable $this$count$iv = this.kuudraTiers;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KuudraTier it = (KuudraTier)element$iv;
                boolean bl = false;
                if (!it.getDoneToday() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int done = n;
        CollectionUtils.INSTANCE.addAsSingletonList(display2, "");
        CollectionUtils.INSTANCE.addAsSingletonList(display2, "\u00a77Daily Kuudra (\u00a7e" + done + "\u00a78/\u00a7e5 killed\u00a77)");
        if (done < 5) {
            for (KuudraTier tier : this.kuudraTiers) {
                if (((Boolean)this.getConfig().hideComplete.get()).booleanValue() && tier.getDoneToday()) continue;
                String result2 = tier.getDoneToday() ? "\u00a7aDone" : "\u00a7bTodo";
                String displayName = tier.getDisplayName();
                NEUInternalName displayItem = tier.getDisplayItem();
                List lineList = new ArrayList();
                lineList.add(" ");
                lineList.add(NEUItems.INSTANCE.getItemStack(displayItem));
                lineList.add(displayName + ": " + result2);
                display2.add(lineList);
            }
        }
    }

    public final void reset() {
        for (KuudraTier miniBoss : this.kuudraTiers) {
            miniBoss.setDoneToday(false);
        }
        this.updateAllKuudraDone();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveConfig(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(storage2, "storage");
        storage2.kuudraTiersDone.clear();
        Iterable $this$filter$iv = this.kuudraTiers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KuudraTier it = (KuudraTier)element$iv$iv;
            boolean bl = false;
            if (!it.getDoneToday()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KuudraTier it = (KuudraTier)element$iv;
            boolean bl = false;
            storage2.kuudraTiersDone.add(it.getName());
        }
    }

    public final void onRepoReload(@NotNull Map<String, ReputationQuest> data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this.kuudraTiers.clear();
        int tier = 1;
        for (Map.Entry<String, ReputationQuest> entry : data2.entrySet()) {
            String displayName = entry.getKey();
            ReputationQuest kuudraTier = entry.getValue();
            NEUInternalName displayItem = kuudraTier.getItem();
            LorenzVec location = this.reputationHelper.readLocationData(kuudraTier.getLocation());
            if (location != null) {
                this.kuudraLocation = location;
            }
            this.kuudraTiers.add(new KuudraTier(displayName, displayItem, location, tier, false, 16, null));
            ++tier;
        }
    }

    public final void loadData(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage2) {
        Intrinsics.checkNotNullParameter(storage2, "storage");
        if (this.kuudraTiers.isEmpty()) {
            return;
        }
        for (String name2 : storage2.kuudraTiersDone) {
            Intrinsics.checkNotNull(name2);
            KuudraTier kuudraTier = this.getByDisplayName(name2);
            if (kuudraTier == null) continue;
            kuudraTier.setDoneToday(true);
        }
        this.updateAllKuudraDone();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAllKuudraDone() {
        boolean bl;
        block3: {
            void $this$any$iv;
            Iterable iterable = this.kuudraTiers;
            DailyKuudraBossHelper dailyKuudraBossHelper = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KuudraTier it = (KuudraTier)element$iv;
                    boolean bl2 = false;
                    if (!(!it.getDoneToday())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        dailyKuudraBossHelper.allKuudraDone = !bl3;
    }

    private final KuudraTier getByDisplayName(String name2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.kuudraTiers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KuudraTier it = (KuudraTier)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final KuudraTier getByTier(int number) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.kuudraTiers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KuudraTier it = (KuudraTier)element$iv;
                boolean bl = false;
                if (!(it.getTierNumber() == number)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

