/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.crimsonisle.SulphurSkitterBoxConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.features.fishing.FishingAPI;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SpecialColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001c\u0010\"\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0018\u0010&\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lat/hannibal2/skyhanni/features/nether/SulphurSkitterBox;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "event", "", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lnet/minecraft/util/BlockPos;", "getClosestBlockToPlayer", "()Lnet/minecraft/util/BlockPos;", "Lnet/minecraft/util/AxisAlignedBB;", "axis", "", "partialTicks", "drawBox", "(Lnet/minecraft/util/AxisAlignedBB;F)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/crimsonisle/SulphurSkitterBoxConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/crimsonisle/SulphurSkitterBoxConfig;", "config", "", "spongeBlocks", "Ljava/util/List;", "closestBlock", "Lnet/minecraft/util/BlockPos;", "", "RADIUS", "I", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSulphurSkitterBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SulphurSkitterBox.kt\nat/hannibal2/skyhanni/features/nether/SulphurSkitterBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n774#2:111\n865#2,2:112\n774#2:114\n865#2:115\n1755#2,3:116\n866#2:119\n2341#2,14:120\n*S KotlinDebug\n*F\n+ 1 SulphurSkitterBox.kt\nat/hannibal2/skyhanni/features/nether/SulphurSkitterBox\n*L\n45#1:111\n45#1:112,2\n48#1:114\n48#1:115\n51#1:116,3\n48#1:119\n77#1:120,14\n*E\n"})
public final class SulphurSkitterBox {
    @NotNull
    public static final SulphurSkitterBox INSTANCE = new SulphurSkitterBox();
    @NotNull
    private static List<? extends BlockPos> spongeBlocks = CollectionsKt.emptyList();
    @Nullable
    private static BlockPos closestBlock;
    private static final int RADIUS = 8;

    private SulphurSkitterBox() {
    }

    private final SulphurSkitterBoxConfig getConfig() {
        return SkyHanniMod.feature.fishing.trophyFishing.sulphurSkitterBox;
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (LorenzTickEvent.isMod$default(event, 5, 0, 2, null)) {
            closestBlock = this.getClosestBlockToPlayer();
        }
        if (LorenzTickEvent.repeatSeconds$default(event, 1, 0, 2, null)) {
            BlockPos it;
            Iterable $this$filterTo$iv$iv;
            LorenzVec location = LocationUtils.INSTANCE.playerLocation();
            BlockPos from = location.add(-20, -20, -20).toBlockPos();
            BlockPos to = location.add(20, 20, 20).toBlockPos();
            Iterable iterable = BlockPos.func_177980_a((BlockPos)from, (BlockPos)to);
            Intrinsics.checkNotNullExpressionValue(iterable, "getAllInBox(...)");
            Iterable $this$filter$iv = iterable;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BlockPos)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                LorenzVec loc = LorenzVecKt.toLorenzVec(it);
                if (!(Intrinsics.areEqual(BlockUtils.INSTANCE.getBlockAt(loc), Blocks.field_150360_v) && LocationUtils.INSTANCE.distanceToPlayer(loc) <= 15.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block8: {
                    Iterable $this$any$iv;
                    it = (BlockPos)element$iv$iv;
                    boolean bl2 = false;
                    BlockPos pos1 = it.func_177982_a(-8, -8, -8);
                    BlockPos pos2 = it.func_177982_a(8, 8, 8);
                    Intrinsics.checkNotNullExpressionValue(BlockPos.func_177980_a((BlockPos)pos1, (BlockPos)pos2), "getAllInBox(...)");
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            BlockPos pos = (BlockPos)element$iv;
                            boolean bl3 = false;
                            Iterable iterable3 = FishingAPI.INSTANCE.getLavaBlocks();
                            Intrinsics.checkNotNull(pos);
                            if (!CollectionsKt.contains(iterable3, BlockUtils.INSTANCE.getBlockAt(LorenzVecKt.toLorenzVec(pos)))) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            spongeBlocks = (List)destination$iv$iv;
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        spongeBlocks = CollectionsKt.emptyList();
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            BlockPos blockPos = closestBlock;
            if (blockPos == null) break block2;
            BlockPos it = blockPos;
            boolean bl = false;
            if (LocationUtils.INSTANCE.distanceToPlayer(LorenzVecKt.toLorenzVec(it)) >= 50.0) {
                return;
            }
            BlockPos pos1 = it.func_177982_a(-8, -8, -8);
            BlockPos pos2 = it.func_177982_a(8, 8, 8);
            AxisAlignedBB axis = RenderUtils.expandBlock$default(RenderUtils.INSTANCE, new AxisAlignedBB(pos1, pos2), 0, 1, null);
            INSTANCE.drawBox(axis, event.getPartialTicks());
        }
    }

    private final BlockPos getClosestBlockToPlayer() {
        Object v0;
        Iterable $this$minByOrNull$iv = spongeBlocks;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BlockPos it = (BlockPos)minElem$iv;
                boolean bl = false;
                double minValue$iv = LocationUtils.INSTANCE.distanceToPlayer(LorenzVecKt.toLorenzVec(it));
                do {
                    Object e$iv = iterator$iv.next();
                    BlockPos it2 = (BlockPos)e$iv;
                    $i$a$-minByOrNull-SulphurSkitterBox$getClosestBlockToPlayer$1 = false;
                    double v$iv = LocationUtils.INSTANCE.distanceToPlayer(LorenzVecKt.toLorenzVec(it2));
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private final void drawBox(AxisAlignedBB axis, float partialTicks) {
        Color color = new Color(SpecialColor.specialToChromaRGB(this.getConfig().boxColor), true);
        SulphurSkitterBoxConfig.BoxType boxType = this.getConfig().boxType;
        switch (boxType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[boxType.ordinal()]) {
            case 1: {
                RenderUtils.drawFilledBoundingBox_nea$default(RenderUtils.INSTANCE, axis, color, 0.0f, false, false, partialTicks, 20, null);
                break;
            }
            case 2: {
                RenderUtils.INSTANCE.drawWireframeBoundingBox_nea(axis, color, partialTicks);
                break;
            }
            default: {
                RenderUtils.INSTANCE.drawWireframeBoundingBox_nea(axis, color, partialTicks);
            }
        }
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.CRIMSON_ISLE) && this.getConfig().enabled && (!this.getConfig().onlyWithRods || FishingAPI.INSTANCE.getHoldingLavaRod());
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 24, "crimsonIsle.sulphurSkitterBoxConfig", "fishing.trophyFishing.sulphurSkitterBox", null, 8, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SulphurSkitterBoxConfig.BoxType.values().length];
            try {
                nArray[SulphurSkitterBoxConfig.BoxType.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SulphurSkitterBoxConfig.BoxType.WIREFRAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

