/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.trevor;

import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobData;
import at.hannibal2.skyhanni.features.misc.trevor.TrapperMobArea;
import at.hannibal2.skyhanni.features.misc.trevor.TrevorMob;
import at.hannibal2.skyhanni.features.misc.trevor.TrevorTracker;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0003R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u0004\u0018\u00010\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010\u001d\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/features/misc/trevor/TrevorSolver;", "", "<init>", "()V", "", "height", "", "above", "", "findMobHeight", "(IZ)V", "findMob", "Lat/hannibal2/skyhanni/data/mob/Mob;", "mob", "isTrevorMob", "(Lat/hannibal2/skyhanni/data/mob/Mob;)Z", "resetLocation", "", "animalHealths", "Ljava/util/Set;", "Lat/hannibal2/skyhanni/features/misc/trevor/TrevorMob;", "currentMob", "Lat/hannibal2/skyhanni/features/misc/trevor/TrevorMob;", "getCurrentMob", "()Lat/hannibal2/skyhanni/features/misc/trevor/TrevorMob;", "setCurrentMob", "(Lat/hannibal2/skyhanni/features/misc/trevor/TrevorMob;)V", "", "maxHeight", "D", "minHeight", "foundID", "I", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "mobCoordinates", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getMobCoordinates", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "setMobCoordinates", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "Lat/hannibal2/skyhanni/features/misc/trevor/TrapperMobArea;", "mobLocation", "Lat/hannibal2/skyhanni/features/misc/trevor/TrapperMobArea;", "getMobLocation", "()Lat/hannibal2/skyhanni/features/misc/trevor/TrapperMobArea;", "setMobLocation", "(Lat/hannibal2/skyhanni/features/misc/trevor/TrapperMobArea;)V", "averageHeight", "getAverageHeight", "()D", "setAverageHeight", "(D)V", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nTrevorSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrevorSolver.kt\nat/hannibal2/skyhanni/features/misc/trevor/TrevorSolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n295#3,2:98\n1755#3,3:100\n1755#3,3:103\n*S KotlinDebug\n*F\n+ 1 TrevorSolver.kt\nat/hannibal2/skyhanni/features/misc/trevor/TrevorSolver\n*L\n58#1:98,2\n59#1:100,3\n85#1:103,3\n*E\n"})
public final class TrevorSolver {
    @NotNull
    public static final TrevorSolver INSTANCE = new TrevorSolver();
    @NotNull
    private static final Set<Integer> animalHealths;
    @Nullable
    private static TrevorMob currentMob;
    private static double maxHeight;
    private static double minHeight;
    private static int foundID;
    @NotNull
    private static LorenzVec mobCoordinates;
    @NotNull
    private static TrapperMobArea mobLocation;
    private static double averageHeight;

    private TrevorSolver() {
    }

    @Nullable
    public final TrevorMob getCurrentMob() {
        return currentMob;
    }

    public final void setCurrentMob(@Nullable TrevorMob trevorMob) {
        currentMob = trevorMob;
    }

    @NotNull
    public final LorenzVec getMobCoordinates() {
        return mobCoordinates;
    }

    public final void setMobCoordinates(@NotNull LorenzVec lorenzVec) {
        Intrinsics.checkNotNullParameter(lorenzVec, "<set-?>");
        mobCoordinates = lorenzVec;
    }

    @NotNull
    public final TrapperMobArea getMobLocation() {
        return mobLocation;
    }

    public final void setMobLocation(@NotNull TrapperMobArea trapperMobArea) {
        Intrinsics.checkNotNullParameter((Object)trapperMobArea, "<set-?>");
        mobLocation = trapperMobArea;
    }

    public final double getAverageHeight() {
        return averageHeight;
    }

    public final void setAverageHeight(double d) {
        averageHeight = d;
    }

    public final void findMobHeight(int height, boolean above) {
        LorenzVec playerPosition = LocationUtils.INSTANCE.playerLocation().roundTo(2);
        double mobHeight = above ? playerPosition.getY() + (double)height : playerPosition.getY() - (double)height;
        if (maxHeight == 0.0) {
            maxHeight = mobHeight + 2.5;
            minHeight = mobHeight - 2.5;
        } else {
            double d = minHeight;
            double d2 = maxHeight;
            double d3 = mobHeight + 2.5;
            boolean bl = d <= d3 ? d3 <= d2 : false;
            if (bl) {
                maxHeight = mobHeight + 2.5;
            } else {
                d = minHeight;
                d2 = maxHeight;
                d3 = mobHeight - 2.5;
                boolean bl2 = d <= d3 ? d3 <= d2 : false;
                if (bl2) {
                    minHeight = mobHeight - 2.5;
                } else {
                    maxHeight = mobHeight + 2.5;
                    minHeight = mobHeight - 2.5;
                }
            }
        }
        averageHeight = (minHeight + maxHeight) / (double)2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void findMob() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        Iterator<Entity> iterator2 = EntityUtils.INSTANCE.getAllEntities().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            boolean isTrevor;
            Entity entity;
            block13: {
                Object v3;
                int entityHealth;
                block12: {
                    boolean bl2;
                    entity = iterator2.next();
                    if (entity instanceof EntityOtherPlayerMP) continue;
                    String name2 = entity.func_70005_c_();
                    Mob mob = MobData.INSTANCE.getEntityToMob().get(entity);
                    if (mob != null) {
                        Iterator it = mob;
                        boolean bl3 = false;
                        bl2 = !Intrinsics.areEqual(((Mob)((Object)it)).getName(), name2) && INSTANCE.isTrevorMob((Mob)((Object)it));
                    } else {
                        bl2 = false;
                    }
                    isTrevor = bl2;
                    entityHealth = entity instanceof EntityLivingBase ? LorenzUtils.INSTANCE.derpy(LorenzUtils.INSTANCE.getBaseMaxHealth((EntityLivingBase)entity)) : 0;
                    Iterable $this$firstOrNull$iv = TrevorMob.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        TrevorMob it = (TrevorMob)((Object)element$iv);
                        boolean bl4 = false;
                        CharSequence charSequence = it.getMobName();
                        Intrinsics.checkNotNull(name2);
                        if (!StringsKt.contains$default(charSequence, name2, false, 2, null)) continue;
                        v3 = element$iv;
                        break block12;
                    }
                    v3 = null;
                }
                currentMob = v3;
                Iterable $this$any$iv = animalHealths;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl5 = false;
                        if (!(it == entityHealth)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if ((!bl || currentMob == null) && !isTrevor) continue;
            if (foundID == entity.func_145782_y()) {
                boolean isOasisMob;
                BlockPos blockPos = entity.func_180425_c();
                Intrinsics.checkNotNullExpressionValue(blockPos, "getPosition(...)");
                double dist = LocationUtils.INSTANCE.distanceToPlayer(LorenzVecKt.toLorenzVec(blockPos));
                boolean bl6 = isOasisMob = currentMob == TrevorMob.RABBIT || currentMob == TrevorMob.SHEEP;
                if (isOasisMob && mobLocation == TrapperMobArea.OASIS && !isTrevor) {
                    return;
                }
                if (!EntityUtils.canBeSeen$default(EntityUtils.INSTANCE, entity, 0.0, 1, null)) return;
                TrevorMob trevorMob = currentMob;
                Intrinsics.checkNotNull((Object)trevorMob);
                if (!(dist < trevorMob.getRenderDistance())) return;
                boolean bl7 = true;
                boolean canSee = bl7;
                if (!canSee) return;
                if (mobLocation != TrapperMobArea.FOUND) {
                    StringBuilder stringBuilder = new StringBuilder().append("\u00a72Saw ");
                    TrevorMob trevorMob2 = currentMob;
                    Intrinsics.checkNotNull((Object)trevorMob2);
                    LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, stringBuilder.append(trevorMob2.getMobName()).append('!').toString(), DurationKt.toDuration(3, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
                }
                mobLocation = TrapperMobArea.FOUND;
                BlockPos blockPos2 = entity.func_180425_c();
                Intrinsics.checkNotNullExpressionValue(blockPos2, "getPosition(...)");
                mobCoordinates = LorenzVecKt.toLorenzVec(blockPos2);
                return;
            } else {
                foundID = entity.func_145782_y();
            }
            return;
        }
        if (foundID == -1) return;
        mobCoordinates = new LorenzVec(0.0, 0.0, 0.0);
        foundID = -1;
    }

    private final boolean isTrevorMob(Mob mob) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = TrevorTracker.TrapperMobRarity.getEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TrevorTracker.TrapperMobRarity it = (TrevorTracker.TrapperMobRarity)((Object)element$iv);
                    boolean bl2 = false;
                    if (!StringsKt.startsWith(mob.getName(), it.getFormattedName() + ' ', true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void resetLocation() {
        maxHeight = 0.0;
        minHeight = 0.0;
        averageHeight = (minHeight + maxHeight) / (double)2;
        foundID = -1;
        mobCoordinates = new LorenzVec(0.0, 0.0, 0.0);
    }

    static {
        Integer[] integerArray = new Integer[]{100, 200, 500, 1000, 2000, 5000, 10000, 30000};
        animalHealths = SetsKt.setOf(integerArray);
        foundID = -1;
        mobCoordinates = new LorenzVec(0.0, 0.0, 0.0);
        mobLocation = TrapperMobArea.NONE;
        averageHeight = (minHeight + maxHeight) / (double)2;
    }
}

