/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.items.enchants;

import at.hannibal2.skyhanni.features.misc.items.enchants.Enchant;
import at.hannibal2.skyhanni.utils.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001bR\u001a\u0010\u0007\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lat/hannibal2/skyhanni/features/misc/items/enchants/FormattedEnchant;", "", "Lat/hannibal2/skyhanni/features/misc/items/enchants/Enchant;", "enchant", "", "level", "", "stacking", "", "isRoman", "<init>", "(Lat/hannibal2/skyhanni/features/misc/items/enchants/Enchant;ILjava/lang/String;Z)V", "lineOfLore", "addLore", "(Ljava/lang/String;)Z", "", "getLore", "()Ljava/util/List;", "other", "compareTo", "(Lat/hannibal2/skyhanni/features/misc/items/enchants/FormattedEnchant;)I", "Lnet/minecraft/item/ItemStack;", "itemStack", "getFormattedString", "(Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/features/misc/items/enchants/Enchant;", "I", "Z", "Ljava/lang/String;", "getStacking", "()Ljava/lang/String;", "loreDescription", "Ljava/util/List;", "1.8.9"})
public final class FormattedEnchant
implements Comparable<FormattedEnchant> {
    @NotNull
    private final Enchant enchant;
    private final int level;
    private final boolean isRoman;
    @NotNull
    private final String stacking;
    @NotNull
    private final List<String> loreDescription;

    public FormattedEnchant(@NotNull Enchant enchant, int level, @NotNull String stacking, boolean isRoman) {
        Intrinsics.checkNotNullParameter(enchant, "enchant");
        Intrinsics.checkNotNullParameter(stacking, "stacking");
        this.enchant = enchant;
        this.level = level;
        this.isRoman = isRoman;
        this.stacking = stacking;
        this.loreDescription = new ArrayList();
    }

    private final String getStacking() {
        return "\u00a78" + this.stacking;
    }

    public final boolean addLore(@NotNull String lineOfLore) {
        Intrinsics.checkNotNullParameter(lineOfLore, "lineOfLore");
        return this.loreDescription.add(lineOfLore);
    }

    @NotNull
    public final List<String> getLore() {
        return this.loreDescription;
    }

    @Override
    public int compareTo(@NotNull FormattedEnchant other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.enchant.compareTo(other.enchant);
    }

    @NotNull
    public final String getFormattedString(@Nullable ItemStack itemStack2) {
        String string2;
        StringBuilder builder = new StringBuilder();
        builder.append(this.enchant.getFormattedName(this.level, itemStack2)).append(" ").append(this.isRoman ? NumberUtil.INSTANCE.toRoman(this.level) : Integer.valueOf(this.level));
        if (!StringsKt.contains$default((CharSequence)this.getStacking(), "empty", false, 2, null)) {
            String string3 = builder.append(this.getStacking()).toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        } else {
            String string4 = builder.toString();
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
        }
        return string2;
    }
}

