/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.compacttablist;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.misc.compacttablist.CompactTabListConfig;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.TabListUpdateEvent;
import at.hannibal2.skyhanni.features.misc.compacttablist.AdvancedPlayerList;
import at.hannibal2.skyhanni.features.misc.compacttablist.RenderColumn;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabColumn;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabSection;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabStringType;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TabListData;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b%\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00072\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0011\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0017\u001a\u0004\u0018\u00010\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\tJ%\u0010\u001c\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 R\u001c\u0010%\u001a\n \"*\u0004\u0018\u00010!0!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001b\u0010.\u001a\u00020)8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u001b\u00101\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010+\u001a\u0004\b0\u0010-R\u001b\u00104\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010+\u001a\u0004\b3\u0010-R\u001b\u00107\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010+\u001a\u0004\b6\u0010-R\u001b\u0010:\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010+\u001a\u0004\b9\u0010-R\u001b\u0010=\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010+\u001a\u0004\b<\u0010-R\u001b\u0010@\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010+\u001a\u0004\b?\u0010-R\u001b\u0010C\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010+\u001a\u0004\bB\u0010-R\"\u0010D\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001d\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f8\u0006\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\u00a8\u0006N"}, d2={"Lat/hannibal2/skyhanni/features/misc/compacttablist/TabListReader;", "", "<init>", "()V", "", "", "tablist", "", "updateTablistData", "(Ljava/util/List;)V", "Lat/hannibal2/skyhanni/events/TabListUpdateEvent;", "event", "onTabListUpdate", "(Lat/hannibal2/skyhanni/events/TabListUpdateEvent;)V", "original", "", "Lat/hannibal2/skyhanni/features/misc/compacttablist/TabColumn;", "parseColumns", "(Ljava/util/List;)Ljava/util/List;", "parseFooterAsColumn", "()Lat/hannibal2/skyhanni/features/misc/compacttablist/TabColumn;", "columns", "name", "getColumnFromName", "(Ljava/util/List;Ljava/lang/String;)Lat/hannibal2/skyhanni/features/misc/compacttablist/TabColumn;", "parseSections", "Lat/hannibal2/skyhanni/features/misc/compacttablist/RenderColumn;", "firstColumn", "combineColumnsToRender", "(Ljava/util/List;Lat/hannibal2/skyhanni/features/misc/compacttablist/RenderColumn;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/config/features/misc/compacttablist/CompactTabListConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/compacttablist/CompactTabListConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "usernamePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getUsernamePattern", "()Ljava/util/regex/Pattern;", "usernamePattern", "godPotPattern$delegate", "getGodPotPattern", "godPotPattern", "activeEffectPattern$delegate", "getActiveEffectPattern", "activeEffectPattern", "effectCountPattern$delegate", "getEffectCountPattern", "effectCountPattern", "cookiePattern$delegate", "getCookiePattern", "cookiePattern", "dungeonBuffPattern$delegate", "getDungeonBuffPattern", "dungeonBuffPattern", "upgradesPattern$delegate", "getUpgradesPattern", "upgradesPattern", "winterPowerUpsPattern$delegate", "getWinterPowerUpsPattern", "winterPowerUpsPattern", "hypixelAdvertisingString", "Ljava/lang/String;", "getHypixelAdvertisingString", "()Ljava/lang/String;", "setHypixelAdvertisingString", "(Ljava/lang/String;)V", "renderColumns", "Ljava/util/List;", "getRenderColumns", "()Ljava/util/List;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nTabListReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabListReader.kt\nat/hannibal2/skyhanni/features/misc/compacttablist/TabListReader\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n11#2:274\n11#2:276\n11#2:278\n11#2:280\n11#2:282\n8#2:284\n1#3:275\n1#3:277\n1#3:279\n1#3:281\n1#3:283\n1#3:285\n1#3:286\n1368#4:287\n1454#4,5:288\n*S KotlinDebug\n*F\n+ 1 TabListReader.kt\nat/hannibal2/skyhanni/features/misc/compacttablist/TabListReader\n*L\n124#1:274\n128#1:276\n133#1:278\n139#1:280\n145#1:282\n158#1:284\n124#1:275\n128#1:277\n133#1:279\n139#1:281\n145#1:283\n158#1:285\n209#1:287\n209#1:288,5\n*E\n"})
public final class TabListReader {
    @NotNull
    public static final TabListReader INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern usernamePattern$delegate;
    @NotNull
    private static final RepoPattern godPotPattern$delegate;
    @NotNull
    private static final RepoPattern activeEffectPattern$delegate;
    @NotNull
    private static final RepoPattern effectCountPattern$delegate;
    @NotNull
    private static final RepoPattern cookiePattern$delegate;
    @NotNull
    private static final RepoPattern dungeonBuffPattern$delegate;
    @NotNull
    private static final RepoPattern upgradesPattern$delegate;
    @NotNull
    private static final RepoPattern winterPowerUpsPattern$delegate;
    @NotNull
    private static String hypixelAdvertisingString;
    @NotNull
    private static final List<RenderColumn> renderColumns;

    private TabListReader() {
    }

    private final CompactTabListConfig getConfig() {
        return SkyHanniMod.feature.gui.compactTabList;
    }

    @NotNull
    public final Pattern getUsernamePattern() {
        return (Pattern)usernamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getGodPotPattern() {
        return (Pattern)godPotPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getActiveEffectPattern() {
        return (Pattern)activeEffectPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getEffectCountPattern() {
        return (Pattern)effectCountPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    private final Pattern getCookiePattern() {
        return (Pattern)cookiePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[4]);
    }

    private final Pattern getDungeonBuffPattern() {
        return (Pattern)dungeonBuffPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[5]);
    }

    private final Pattern getUpgradesPattern() {
        return (Pattern)upgradesPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[6]);
    }

    private final Pattern getWinterPowerUpsPattern() {
        return (Pattern)winterPowerUpsPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[7]);
    }

    @NotNull
    public final String getHypixelAdvertisingString() {
        return hypixelAdvertisingString;
    }

    public final void setHypixelAdvertisingString(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        hypixelAdvertisingString = string2;
    }

    @NotNull
    public final List<RenderColumn> getRenderColumns() {
        return renderColumns;
    }

    private final void updateTablistData(List<String> tablist) {
        List<String> tabLines;
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        List<String> list = tablist;
        if (list == null) {
            list = TabListData.INSTANCE.getTabList();
        }
        if ((tabLines = list).size() < 80) {
            return;
        }
        tabLines = tabLines.subList(0, 80);
        List<TabColumn> columns = this.parseColumns(tabLines);
        TabColumn footerColumn = this.parseFooterAsColumn();
        if (footerColumn != null) {
            columns.add(footerColumn);
        }
        this.parseSections(columns);
        renderColumns.clear();
        RenderColumn renderColumn = new RenderColumn(null, 1, null);
        renderColumns.add(renderColumn);
        this.combineColumnsToRender(columns, renderColumn);
    }

    static /* synthetic */ void updateTablistData$default(TabListReader tabListReader, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        tabListReader.updateTablistData(list);
    }

    @SubscribeEvent
    public final void onTabListUpdate(@NotNull TabListUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.updateTablistData(event.getTabList());
    }

    private final List<TabColumn> parseColumns(List<String> original) {
        List columns = new ArrayList();
        int entry = 0;
        List<String> fullTabList = AdvancedPlayerList.INSTANCE.newSorting(original);
        int n = ((Collection)fullTabList).size() + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement(0, n, 20);
        if (entry <= n2) {
            while (true) {
                String title;
                TabColumn column;
                if ((column = this.getColumnFromName(columns, title = StringUtils.INSTANCE.trimWhiteSpaceAndResets(fullTabList.get(entry)))) == null) {
                    column = new TabColumn(title);
                    columns.add(column);
                }
                int n3 = RangesKt.coerceAtMost(fullTabList.size(), entry + 20);
                for (int columnEntry = entry + 1; columnEntry < n3; ++columnEntry) {
                    column.addLine(fullTabList.get(columnEntry));
                }
                if (entry == n2) break;
                entry += 20;
            }
        }
        return columns;
    }

    /*
     * WARNING - void declaration
     */
    private final TabColumn parseFooterAsColumn() {
        Pattern $this$findMatcher$iv;
        String string2;
        void $this$findMatcher$iv2;
        Object footer = null;
        footer = StringUtils.INSTANCE.removeSFormattingCode(TabListData.INSTANCE.getFooter());
        if (((CharSequence)footer).length() == 0) {
            return null;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getGodPotPattern();
        String[] text$iv = footer;
        boolean $i$f$findMatcher = false;
        Object it$iv = $this$findMatcher$iv2.matcher((CharSequence)text$iv);
        boolean bl4 = false;
        if (((Matcher)it$iv).find()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$parseFooterAsColumn_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            string2 = INSTANCE.getActiveEffectPattern().matcher((CharSequence)footer).replaceAll("Active Effects:\n\u00a7cGod Potion\u00a7r: " + $this$parseFooterAsColumn_u24lambda_u240.group("timer"));
        } else {
            string2 = null;
        }
        String string3 = string2;
        if (string2 == null) {
            String string4;
            void $this$findMatcher$iv3;
            TabListReader $this$parseFooterAsColumn_u24lambda_u242 = this;
            boolean bl3 = false;
            it$iv = RegexUtils.INSTANCE;
            Pattern bl4 = $this$parseFooterAsColumn_u24lambda_u242.getEffectCountPattern();
            String[] text$iv2 = footer;
            boolean $i$f$findMatcher2 = false;
            Matcher it$iv2 = $this$findMatcher$iv3.matcher((CharSequence)text$iv2);
            boolean $i$a$-let-RegexUtils$findMatcher$1$iv2 = false;
            if (it$iv2.find()) {
                Intrinsics.checkNotNull(it$iv2);
                Matcher $this$parseFooterAsColumn_u24lambda_u242_u24lambda_u241 = it$iv2;
                boolean bl5 = false;
                string4 = $this$parseFooterAsColumn_u24lambda_u242.getActiveEffectPattern().matcher((CharSequence)footer).replaceAll("Active Effects: \u00a7r\u00a7e" + $this$parseFooterAsColumn_u24lambda_u242_u24lambda_u241.group("effectCount"));
            } else {
                string4 = null;
            }
            String string5 = string4;
            if (string4 == null) {
                string5 = $this$parseFooterAsColumn_u24lambda_u242.getActiveEffectPattern().matcher((CharSequence)footer).replaceAll("Active Effects: \u00a7r\u00a7e0");
            }
            string3 = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "run(...)");
        }
        footer = string3;
        RegexUtils regexUtils2 = RegexUtils.INSTANCE;
        Pattern this_$iv = this.getCookiePattern();
        String[] text$iv3 = footer;
        boolean $i$f$findMatcher3 = false;
        Object it$iv3 = $this$findMatcher$iv.matcher((CharSequence)text$iv3);
        boolean bl6 = false;
        if (((Matcher)it$iv3).find()) {
            Intrinsics.checkNotNull(it$iv3);
            Matcher $this$parseFooterAsColumn_u24lambda_u243 = it$iv3;
            boolean bl7 = false;
            String string6 = $this$parseFooterAsColumn_u24lambda_u243.group();
            Intrinsics.checkNotNullExpressionValue(string6, "group(...)");
            if (StringsKt.contains$default((CharSequence)string6, "Not active!", false, 2, null)) {
                footer = $this$parseFooterAsColumn_u24lambda_u243.replaceAll("Cookie Buff \n\u00a7r\u00a77Not Active");
            }
        }
        RegexUtils this_$iv2 = RegexUtils.INSTANCE;
        $this$findMatcher$iv = this.getDungeonBuffPattern();
        text$iv3 = footer;
        $i$f$findMatcher3 = false;
        it$iv3 = $this$findMatcher$iv.matcher((CharSequence)text$iv3);
        bl6 = false;
        if (((Matcher)it$iv3).find()) {
            Intrinsics.checkNotNull(it$iv3);
            Matcher $this$parseFooterAsColumn_u24lambda_u244 = it$iv3;
            boolean bl8 = false;
            String string7 = $this$parseFooterAsColumn_u24lambda_u244.group();
            Intrinsics.checkNotNullExpressionValue(string7, "group(...)");
            if (StringsKt.contains$default((CharSequence)string7, "No Buffs active.", false, 2, null)) {
                footer = $this$parseFooterAsColumn_u24lambda_u244.replaceAll("Dungeon Buffs \n\u00a7r\u00a77None Found");
            }
        }
        this_$iv2 = RegexUtils.INSTANCE;
        $this$findMatcher$iv = this.getWinterPowerUpsPattern();
        text$iv3 = footer;
        $i$f$findMatcher3 = false;
        it$iv3 = $this$findMatcher$iv.matcher((CharSequence)text$iv3);
        bl6 = false;
        if (((Matcher)it$iv3).find()) {
            Intrinsics.checkNotNull(it$iv3);
            Matcher $this$parseFooterAsColumn_u24lambda_u245 = it$iv3;
            boolean bl9 = false;
            String string8 = $this$parseFooterAsColumn_u24lambda_u245.group();
            Intrinsics.checkNotNullExpressionValue(string8, "group(...)");
            if (StringsKt.contains$default((CharSequence)string8, "No Power Ups active.", false, 2, null)) {
                footer = $this$parseFooterAsColumn_u24lambda_u245.replaceAll("Active Power Ups \n\u00a7r\u00a77None");
            }
        }
        TabColumn column = new TabColumn("\u00a72\u00a7lOther");
        text$iv3 = new String[]{"\n"};
        for (String line : StringsKt.split$default((CharSequence)footer, text$iv3, false, 0, 6, null)) {
            void $this$matchMatcher$iv;
            if (StringsKt.contains$default((CharSequence)line, hypixelAdvertisingString, false, 2, null)) continue;
            String newLine = null;
            newLine = line;
            it$iv3 = RegexUtils.INSTANCE;
            Pattern pattern2 = this.getUpgradesPattern();
            String text$iv4 = StringUtils.INSTANCE.removeResets(newLine);
            boolean $i$f$matchMatcher = false;
            Matcher it$iv4 = $this$matchMatcher$iv.matcher(text$iv4);
            boolean bl10 = false;
            if (it$iv4.matches()) {
                Intrinsics.checkNotNull(it$iv4);
                Matcher $this$parseFooterAsColumn_u24lambda_u246 = it$iv4;
                boolean bl11 = false;
                String string9 = $this$parseFooterAsColumn_u24lambda_u246.group("firstPart");
                Intrinsics.checkNotNullExpressionValue(string9, "group(...)");
                String firstPart = StringUtils.INSTANCE.trimWhiteSpaceAndResets(string9);
                if (!StringsKt.contains$default((CharSequence)firstPart, "\u00a7l", false, 2, null)) {
                    firstPart = ' ' + firstPart;
                }
                column.addLine(firstPart);
                newLine = $this$parseFooterAsColumn_u24lambda_u246.group("secondPart");
            }
            newLine = StringUtils.INSTANCE.trimWhiteSpaceAndResets(newLine);
            if (!StringsKt.contains$default((CharSequence)newLine, "\u00a7l", false, 2, null)) {
                newLine = ' ' + newLine;
            }
            column.addLine(newLine);
        }
        return column;
    }

    private final TabColumn getColumnFromName(List<TabColumn> columns, String name2) {
        for (TabColumn tabColumn : columns) {
            if (!Intrinsics.areEqual(name2, tabColumn.getColumnTitle())) continue;
            return tabColumn;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void parseSections(List<TabColumn> columns) {
        for (TabColumn column : columns) {
            TabSection currentTabSection = null;
            for (String line : column.getLines()) {
                if (((CharSequence)StringUtils.INSTANCE.trimWhiteSpaceAndResets(line)).length() == 0) {
                    currentTabSection = null;
                    continue;
                }
                if (currentTabSection == null) {
                    void it;
                    TabSection tabSection;
                    TabSection tabSection2 = tabSection = new TabSection(column);
                    TabColumn tabColumn = column;
                    boolean bl = false;
                    currentTabSection = it;
                    tabColumn.addSection(tabSection);
                }
                currentTabSection.addLine(line);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void combineColumnsToRender(List<TabColumn> columns, RenderColumn firstColumn) {
        Object list$iv$iv;
        TabColumn it;
        void $this$flatMapTo$iv$iv;
        Object firstColumnCopy = null;
        firstColumnCopy = firstColumn;
        String lastTitle = null;
        Iterable $this$flatMap$iv = columns;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (TabColumn)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getSections();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (TabSection section : (List)destination$iv$iv) {
            boolean bl2;
            List<RenderColumn> list;
            int sectionSize = section.size();
            boolean needsTitle = false;
            if (!Intrinsics.areEqual(lastTitle, section.getColumnValue().getColumnTitle())) {
                needsTitle = true;
                ++sectionSize;
            }
            int currentCount = ((RenderColumn)firstColumnCopy).size();
            if (sectionSize >= 11) {
                if (currentCount >= 22) {
                    RenderColumn renderColumn;
                    RenderColumn renderColumn2 = renderColumn = new RenderColumn(null, 1, null);
                    list = renderColumns;
                    bl2 = false;
                    firstColumnCopy = renderColumn2;
                    list.add(renderColumn);
                    currentCount = 1;
                } else if (((RenderColumn)firstColumnCopy).size() > 0) {
                    ((RenderColumn)firstColumnCopy).addLine(AdvancedPlayerList.INSTANCE.createTabLine("", TabStringType.TEXT));
                }
                if (needsTitle) {
                    lastTitle = section.getColumnValue().getColumnTitle();
                    ((RenderColumn)firstColumnCopy).addLine(AdvancedPlayerList.INSTANCE.createTabLine(lastTitle, TabStringType.TITLE));
                    ++currentCount;
                }
                for (String string2 : section.getLines()) {
                    if (currentCount >= 22) {
                        RenderColumn bl2 = new RenderColumn(null, 1, null);
                        list$iv$iv = bl2;
                        list = renderColumns;
                        boolean bl22 = false;
                        firstColumnCopy = it;
                        list.add(bl2);
                        currentCount = 1;
                    }
                    ((RenderColumn)firstColumnCopy).addLine(AdvancedPlayerList.INSTANCE.createTabLine(string2, TabStringType.Companion.fromLine(string2)));
                    ++currentCount;
                }
                continue;
            }
            if (currentCount + sectionSize > 22) {
                RenderColumn renderColumn;
                RenderColumn renderColumn3 = renderColumn = new RenderColumn(null, 1, null);
                list = renderColumns;
                bl2 = false;
                firstColumnCopy = renderColumn3;
                list.add(renderColumn);
            } else if (((RenderColumn)firstColumnCopy).size() > 0) {
                ((RenderColumn)firstColumnCopy).addLine(AdvancedPlayerList.INSTANCE.createTabLine("", TabStringType.TEXT));
            }
            if (needsTitle) {
                lastTitle = section.getColumnValue().getColumnTitle();
                ((RenderColumn)firstColumnCopy).addLine(AdvancedPlayerList.INSTANCE.createTabLine(lastTitle, TabStringType.TITLE));
            }
            for (String string3 : section.getLines()) {
                ((RenderColumn)firstColumnCopy).addLine(AdvancedPlayerList.INSTANCE.createTabLine(string3, TabStringType.Companion.fromLine(string3)));
            }
        }
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property[] propertyArray = new Property[]{this.getConfig().enabled};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, TabListReader::onConfigLoad$lambda$12);
    }

    private static final void onConfigLoad$lambda$12() {
        TabListReader.updateTablistData$default(INSTANCE, null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(TabListReader.class, "usernamePattern", "getUsernamePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(TabListReader.class, "godPotPattern", "getGodPotPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(TabListReader.class, "activeEffectPattern", "getActiveEffectPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(TabListReader.class, "effectCountPattern", "getEffectCountPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(TabListReader.class, "cookiePattern", "getCookiePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(TabListReader.class, "dungeonBuffPattern", "getDungeonBuffPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(TabListReader.class, "upgradesPattern", "getUpgradesPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(TabListReader.class, "winterPowerUpsPattern", "getWinterPowerUpsPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new TabListReader();
        patternGroup = RepoPattern.Companion.group("misc.compacttablist");
        usernamePattern$delegate = patternGroup.pattern("username", "^\\[(?<sblevel>\\d+)] (?:\\[\\w+] )?(?<username>\\w+)");
        godPotPattern$delegate = patternGroup.pattern("effects.godpot", "\u00a7r\u00a7r\u00a77You have a \u00a7r\u00a7cGod Potion \u00a7r\u00a77active! \u00a7r\u00a7d(?<timer>[\\w ]+)\u00a7r");
        activeEffectPattern$delegate = patternGroup.pattern("effects.active", "Active Effects(?:\u00a7.)*(?:\\n(?:\u00a7.)*\u00a77.+)*");
        effectCountPattern$delegate = patternGroup.pattern("effects.count", "You have (?:\u00a7.)*(?<effectCount>[0-9]+) (?:\u00a7.)*active effect");
        cookiePattern$delegate = patternGroup.pattern("cookie", "Cookie Buff(?:\u00a7.)*(?:\\n(\u00a7.)*\u00a77.+)*");
        dungeonBuffPattern$delegate = patternGroup.pattern("dungeonbuff", "Dungeon Buffs(?:\u00a7.)*(?:\\n(\u00a7.)*\u00a77.+)*");
        upgradesPattern$delegate = patternGroup.pattern("upgrades", "(?<firstPart>\u00a7e[A-Za-z ]+)(?<secondPart> \u00a7f[\\w ]+)");
        winterPowerUpsPattern$delegate = patternGroup.pattern("winterpowerups", "Active Power Ups(?:\u00a7.)*(?:\\n(\u00a7.)*\u00a77.+)*");
        hypixelAdvertisingString = "HYPIXEL.NET";
        renderColumns = new ArrayList();
    }
}

