/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.misc.KickDurationConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0017\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/features/misc/SkyBlockKickDuration;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "warn", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/misc/KickDurationConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/KickDurationConfig;", "config", "kickMessage", "Z", "showTime", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastKickTime", "J", "hasWarned", "1.8.9"})
public final class SkyBlockKickDuration {
    @NotNull
    public static final SkyBlockKickDuration INSTANCE = new SkyBlockKickDuration();
    private static boolean kickMessage;
    private static boolean showTime;
    private static long lastKickTime;
    private static boolean hasWarned;

    private SkyBlockKickDuration() {
    }

    private final KickDurationConfig getConfig() {
        return SkyHanniMod.feature.misc.kickDuration;
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (Intrinsics.areEqual(event.getMessage(), "\u00a7cYou were kicked while joining that server!")) {
            if (LorenzUtils.INSTANCE.getOnHypixel() && !LorenzUtils.INSTANCE.getInSkyBlock()) {
                kickMessage = false;
                showTime = true;
                lastKickTime = SimpleTimeMark.Companion.now-uFjCsEo();
            } else {
                kickMessage = true;
            }
        }
        if (Intrinsics.areEqual(event.getMessage(), "\u00a7cThere was a problem joining SkyBlock, try again in a moment!")) {
            kickMessage = false;
            showTime = true;
            lastKickTime = SimpleTimeMark.Companion.now-uFjCsEo();
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (kickMessage) {
            kickMessage = false;
            showTime = true;
            lastKickTime = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        hasWarned = false;
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!LorenzUtils.INSTANCE.getOnHypixel()) {
            return;
        }
        if (!showTime) {
            return;
        }
        if (LorenzUtils.INSTANCE.getInSkyBlock()) {
            showTime = false;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastKickTime), DurationKt.toDuration(5, DurationUnit.MINUTES)) > 0) {
            showTime = false;
        }
        long l = SimpleTimeMark.passedSince-UwyO8pc(lastKickTime);
        Object t = this.getConfig().warnTime.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        if (Duration.compareTo-LRDsOJo(l, DurationKt.toDuration(((Number)t).intValue(), DurationUnit.SECONDS)) > 0 && !hasWarned) {
            hasWarned = true;
            this.warn();
        }
        String format = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, SimpleTimeMark.passedSince-UwyO8pc(lastKickTime), null, false, false, 0, false, 31, null);
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, "\u00a7cLast kicked from SkyBlock \u00a7b" + format + " ago", 0, 0, "SkyBlock Kick Duration", 6, null);
    }

    private final void warn() {
        LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7eTry rejoining SkyBlock now!", DurationKt.toDuration(3, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        SoundUtils.INSTANCE.playBeepSound();
    }

    public final boolean isEnabled() {
        return this.getConfig().enabled;
    }

    static {
        lastKickTime = SimpleTimeMark.Companion.farPast();
    }
}

