/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonAPI;
import at.hannibal2.skyhanni.features.misc.ParticleHider$onReceiveParticle$;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/features/misc/ParticleHider;", "", "<init>", "()V", "", "inM7Boss", "()Z", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "event", "", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nParticleHider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleHider.kt\nat/hannibal2/skyhanni/features/misc/ParticleHider\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,55:1\n172#2:56\n477#3:57\n*S KotlinDebug\n*F\n+ 1 ParticleHider.kt\nat/hannibal2/skyhanni/features/misc/ParticleHider\n*L\n34#1:56\n34#1:57\n*E\n"})
public final class ParticleHider {
    @NotNull
    public static final ParticleHider INSTANCE = new ParticleHider();

    private ParticleHider() {
    }

    private final boolean inM7Boss() {
        return DungeonAPI.INSTANCE.inDungeon() && Intrinsics.areEqual(DungeonAPI.INSTANCE.getDungeonFloor(), "M7") && DungeonAPI.INSTANCE.getInBossRoom();
    }

    @SubscribeEvent
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        double distanceToPlayer = event.getDistanceToPlayer();
        if (SkyHanniMod.feature.misc.particleHiders.hideFarParticles && distanceToPlayer > 40.0 && !this.inM7Boss()) {
            event.cancel();
            return;
        }
        EnumParticleTypes type2 = event.getType();
        if (SkyHanniMod.feature.misc.particleHiders.hideCloseRedstoneParticles && type2 == EnumParticleTypes.REDSTONE && distanceToPlayer < 2.0) {
            event.cancel();
            return;
        }
        if (SkyHanniMod.feature.misc.particleHiders.hideFireballParticles && (type2 == EnumParticleTypes.SMOKE_NORMAL || type2 == EnumParticleTypes.SMOKE_LARGE)) {
            EntityUtils this_$iv = EntityUtils.INSTANCE;
            boolean $i$f$getEntities = false;
            Sequence<Entity> $this$filterIsInstance$iv$iv = this_$iv.getAllEntities();
            boolean $i$f$filterIsInstance = false;
            Sequence<Entity> sequence = SequencesKt.filter($this$filterIsInstance$iv$iv, onReceiveParticle$$inlined$getEntities$1.INSTANCE);
            Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Iterator<Entity> iterator2 = sequence.iterator();
            while (iterator2.hasNext()) {
                EntitySmallFireball entity = (EntitySmallFireball)iterator2.next();
                double distance = LorenzVecKt.getLorenzVec((Entity)entity).distance(event.getLocation());
                if (!(distance < 5.0)) continue;
                event.cancel();
                return;
            }
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.hideBlazeParticles", "misc.particleHiders.hideBlazeParticles", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.hideEndermanParticles", "misc.particleHiders.hideEndermanParticles", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.hideFarParticles", "misc.particleHiders.hideFarParticles", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.hideFireballParticles", "misc.particleHiders.hideFireballParticles", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.hideCloseRedstoneparticles", "misc.particleHiders.hideCloseRedstoneParticles", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.hideFireBlockParticles", "misc.particleHiders.hideFireBlockParticles", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.hideSmokeParticles", "misc.particleHiders.hideSmokeParticles", null, 8, null);
    }
}

