/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.misc.MiscConfig;
import at.hannibal2.skyhanni.config.storage.Storage;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.features.garden.SensitivityReducer;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0018\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u001c\u001a\n \u0015*\u0004\u0018\u00010\u00190\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/features/misc/LockMouseLook;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "event", "", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "toggleLock", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "autoDisable", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/Storage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/Storage;", "storage", "", "lockedMouse", "Z", "getLockedMouse", "()Z", "setLockedMouse", "(Z)V", "", "lockedPosition", "F", "1.8.9"})
public final class LockMouseLook {
    @NotNull
    public static final LockMouseLook INSTANCE = new LockMouseLook();
    private static boolean lockedMouse;
    private static final float lockedPosition = -0.33333334f;

    private LockMouseLook() {
    }

    private final MiscConfig getConfig() {
        return SkyHanniMod.feature.misc;
    }

    private final Storage getStorage() {
        return SkyHanniMod.feature.storage;
    }

    public final boolean getLockedMouse() {
        return lockedMouse;
    }

    public final void setLockedMouse(boolean bl) {
        lockedMouse = bl;
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (lockedMouse) {
            this.toggleLock();
        }
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (gameSettings.field_74341_c == -0.33333334f) {
            gameSettings.field_74341_c = this.getStorage().savedMouselockedSensitivity.floatValue();
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7bMouse rotation is now unlocked because you left it locked.", false, null, 6, null);
        }
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!StringsKt.startsWith$default(event.getMessage(), "\u00a7aTeleported you to \u00a7r\u00a7aPlot", false, 2, null)) {
            return;
        }
        if (lockedMouse) {
            this.toggleLock();
        }
    }

    public final void toggleLock() {
        lockedMouse = !lockedMouse;
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (gameSettings == null) {
            return;
        }
        GameSettings gameSettings2 = gameSettings;
        float mouseSensitivity = gameSettings2.field_74341_c;
        if (SensitivityReducer.INSTANCE.isEnabled()) {
            mouseSensitivity = SensitivityReducer.INSTANCE.doTheMath(mouseSensitivity, true);
        }
        if (lockedMouse) {
            this.getStorage().savedMouselockedSensitivity = Float.valueOf(mouseSensitivity);
            gameSettings2.field_74341_c = -0.33333334f;
            if (this.getConfig().lockMouseLookChatMessage) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7bMouse rotation is now locked. Type /shmouselock to unlock your rotation", false, null, 6, null);
            }
        } else {
            if (!SensitivityReducer.INSTANCE.isEnabled()) {
                gameSettings2.field_74341_c = this.getStorage().savedMouselockedSensitivity.floatValue();
            } else {
                Float f = this.getStorage().savedMouselockedSensitivity;
                Intrinsics.checkNotNullExpressionValue(f, "savedMouselockedSensitivity");
                gameSettings2.field_74341_c = SensitivityReducer.doTheMath$default(SensitivityReducer.INSTANCE, ((Number)f).floatValue(), false, 2, null);
            }
            if (this.getConfig().lockMouseLookChatMessage) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7bMouse rotation is now unlocked.", false, null, 6, null);
            }
        }
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!lockedMouse) {
            return;
        }
        Position position = this.getConfig().lockedMouseDisplay;
        Intrinsics.checkNotNullExpressionValue(position, "lockedMouseDisplay");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, "\u00a7eMouse Locked", 0, 0, "Mouse Locked", 6, null);
    }

    public final void autoDisable() {
        if (lockedMouse) {
            this.toggleLock();
        }
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Mouse Lock");
        if (!lockedMouse) {
            event.addIrrelevant("not enabled");
            return;
        }
        event.addData(LockMouseLook::onDebugDataCollect$lambda$0);
    }

    private static final Unit onDebugDataCollect$lambda$0(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("Stored Sensitivity: " + LockMouseLook.INSTANCE.getStorage().savedMouselockedSensitivity);
        return Unit.INSTANCE;
    }
}

